/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.expr.str;

import java.util.HashSet;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.symbolic.ConstraintTooLongException;
import org.evosuite.symbolic.DSEStats;
import org.evosuite.symbolic.expr.AbstractExpression;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.ExpressionVisitor;
import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.UnaryExpression;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.expr.str.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringUnaryExpression
extends AbstractExpression<String>
implements StringValue,
UnaryExpression<String> {
    private static final long serialVersionUID = -384874147850376188L;
    protected static final Logger log = LoggerFactory.getLogger(StringUnaryExpression.class);
    private final Operator op;
    private final Expression<String> expr;

    public StringUnaryExpression(Expression<String> param, Operator op2, String con) {
        super(con, 1 + param.getSize(), param.containsSymbolicVariable());
        this.expr = param;
        this.op = op2;
        if (this.getSize() > Properties.DSE_CONSTRAINT_LENGTH) {
            DSEStats.getInstance().reportConstraintTooLong(this.getSize());
            throw new ConstraintTooLongException(this.getSize());
        }
    }

    @Override
    public Operator getOperator() {
        return this.op;
    }

    @Override
    public Expression<String> getOperand() {
        return this.expr;
    }

    public String toString() {
        return this.expr + "." + this.op.toString().trim() + "()";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof StringUnaryExpression) {
            StringUnaryExpression other = (StringUnaryExpression)obj;
            return this.op.equals((Object)other.op) && this.expr.equals(other.expr);
        }
        return false;
    }

    public int hashCode() {
        return this.op.hashCode() + this.expr.hashCode();
    }

    @Override
    public Set<Variable<?>> getVariables() {
        HashSet variables = new HashSet(this.expr.getVariables());
        return variables;
    }

    @Override
    public Set<Object> getConstants() {
        return this.expr.getConstants();
    }

    @Override
    public <K, V> K accept(ExpressionVisitor<K, V> v, V arg) {
        return v.visit(this, arg);
    }
}

