/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.ConstraintEvaluator;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.expr.bv.IntegerVariable;
import org.evosuite.symbolic.expr.fp.RealVariable;
import org.evosuite.symbolic.expr.str.StringVariable;
import org.evosuite.symbolic.solver.SolverEmptyQueryException;
import org.evosuite.symbolic.solver.SolverErrorException;
import org.evosuite.symbolic.solver.SolverParseException;
import org.evosuite.symbolic.solver.SolverResult;
import org.evosuite.symbolic.solver.SolverTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Solver {
    private final boolean addMissingVariables;
    static Logger logger = LoggerFactory.getLogger(Solver.class);

    protected boolean addMissingVariables() {
        return this.addMissingVariables;
    }

    public Solver() {
        this.addMissingVariables = false;
    }

    public Solver(boolean addMissingVariables) {
        this.addMissingVariables = addMissingVariables;
    }

    public abstract SolverResult solve(Collection<Constraint<?>> var1) throws SolverTimeoutException, IOException, SolverParseException, SolverEmptyQueryException, SolverErrorException;

    protected static Map<String, Object> getConcreteValues(Set<Variable<?>> variables) {
        HashMap<String, Object> concrete_values = new HashMap<String, Object>();
        for (Variable<?> v : variables) {
            String var_name = v.getName();
            Object concrete_value = v.getConcreteValue();
            concrete_values.put(var_name, concrete_value);
        }
        return concrete_values;
    }

    protected static Set<Variable<?>> getVariables(Collection<Constraint<?>> constraints) {
        HashSet variables = new HashSet();
        for (Constraint<?> c : constraints) {
            variables.addAll(c.getLeftOperand().getVariables());
            variables.addAll(c.getRightOperand().getVariables());
        }
        return variables;
    }

    protected static void setConcreteValues(Set<Variable<?>> variables, Map<String, Object> concrete_values) {
        for (Variable<?> v : variables) {
            String var_name = v.getName();
            if (!concrete_values.containsKey(var_name)) continue;
            Object concreteValue = concrete_values.get(var_name);
            if (v instanceof StringVariable) {
                StringVariable sv = (StringVariable)v;
                String concreteString = (String)concreteValue;
                sv.setConcreteValue(concreteString);
                continue;
            }
            if (v instanceof IntegerVariable) {
                IntegerVariable iv = (IntegerVariable)v;
                Long concreteInteger = (Long)concreteValue;
                iv.setConcreteValue(concreteInteger);
                continue;
            }
            if (v instanceof RealVariable) {
                RealVariable ir = (RealVariable)v;
                Double concreteReal = (Double)concreteValue;
                ir.setConcreteValue(concreteReal);
                continue;
            }
            logger.warn("unknow variable type " + v.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean checkSAT(Collection<Constraint<?>> constraints, SolverResult satResult) {
        if (satResult == null) {
            throw new NullPointerException("satResult should be non-null");
        }
        if (!satResult.isSAT()) {
            throw new IllegalArgumentException("satResult should be SAT");
        }
        Set<Variable<?>> variables = Solver.getVariables(constraints);
        Map<String, Object> initialValues = Solver.getConcreteValues(variables);
        Map<String, Object> newValues = satResult.getModel();
        Solver.setConcreteValues(variables, newValues);
        try {
            ConstraintEvaluator evaluator = new ConstraintEvaluator();
            for (Constraint<?> constraint : constraints) {
                Boolean evaluation = (Boolean)constraint.accept(evaluator, null);
                if (evaluation == null) {
                    throw new NullPointerException();
                }
                if (evaluation.booleanValue()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Solver.setConcreteValues(variables, initialValues);
        }
    }
}

