/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class SolverResult
implements Serializable {
    private static final long serialVersionUID = -930589471876011035L;
    private final SolverResultType resultType;
    private final Map<String, Object> model;

    private SolverResult(SolverResultType t, Map<String, Object> model) {
        this.resultType = t;
        this.model = model;
    }

    public static SolverResult newUNSAT() {
        return new SolverResult(SolverResultType.UNSAT, null);
    }

    public static SolverResult newUnknown() {
        return new SolverResult(SolverResultType.UNKNOWN, null);
    }

    public static SolverResult newSAT(Map<String, Object> values) {
        return new SolverResult(SolverResultType.SAT, values);
    }

    public boolean isSAT() {
        return this.resultType.equals((Object)SolverResultType.SAT);
    }

    public boolean containsVariable(String var_name) {
        if (!this.resultType.equals((Object)SolverResultType.SAT)) {
            throw new IllegalStateException("This method should not be called with a non-SAT result");
        }
        return this.model.containsKey(var_name);
    }

    public Object getValue(String var_name) {
        if (!this.resultType.equals((Object)SolverResultType.SAT)) {
            throw new IllegalStateException("This method should not be called with a non-SAT result");
        }
        return this.model.get(var_name);
    }

    public Map<String, Object> getModel() {
        HashMap<String, Object> newModel = this.model == null ? new HashMap<String, Object>() : new HashMap<String, Object>(this.model);
        return newModel;
    }

    public boolean isUNSAT() {
        return this.resultType.equals((Object)SolverResultType.UNSAT);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append((Object)((Object)this.resultType) + "\n");
        if (this.resultType.equals((Object)SolverResultType.SAT)) {
            buff.append("--------------------\n");
            for (String varName : this.model.keySet()) {
                Object value = this.model.get(varName);
                buff.append(varName + "->" + value + "\n");
            }
        }
        return buff.toString();
    }

    public boolean isUnknown() {
        return this.resultType.equals((Object)SolverResultType.UNKNOWN);
    }

    private static enum SolverResultType {
        SAT,
        UNSAT,
        UNKNOWN;

    }
}

