/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.cvc4;

import dk.brics.automaton.RegExp;
import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.bv.IntegerBinaryExpression;
import org.evosuite.symbolic.expr.bv.StringBinaryComparison;
import org.evosuite.symbolic.expr.fp.RealBinaryExpression;
import org.evosuite.symbolic.solver.SmtExprBuilder;
import org.evosuite.symbolic.solver.cvc4.RegExpToCVC4Visitor;
import org.evosuite.symbolic.solver.smt.ExprToSmtVisitor;
import org.evosuite.symbolic.solver.smt.SmtExpr;
import org.evosuite.symbolic.solver.smt.SmtIntConstant;
import org.evosuite.utils.RegexDistanceUtils;

final class ExprToCVC4Visitor
extends ExprToSmtVisitor {
    private final boolean approximateNonLinearExpressions;

    public ExprToCVC4Visitor() {
        this(false);
    }

    public ExprToCVC4Visitor(boolean rewriteNonLinearExpressions) {
        this.approximateNonLinearExpressions = rewriteNonLinearExpressions;
    }

    @Override
    protected SmtExpr postVisit(IntegerBinaryExpression source, SmtExpr left, Operator operator, SmtExpr right) {
        switch (operator) {
            case DIV: {
                if (this.approximateNonLinearExpressions && left.isSymbolic() && right.isSymbolic()) {
                    SmtExpr concreteRightValue = ExprToCVC4Visitor.approximateToConcreteValue(source.getRightOperand());
                    return SmtExprBuilder.mkIntDiv(left, concreteRightValue);
                }
                return super.postVisit(source, left, operator, right);
            }
            case MUL: {
                if (this.approximateNonLinearExpressions && left.isSymbolic() && right.isSymbolic()) {
                    SmtExpr concreteRightValue = ExprToCVC4Visitor.approximateToConcreteValue(source.getRightOperand());
                    return SmtExprBuilder.mkMul(left, concreteRightValue);
                }
                return super.postVisit(source, left, operator, right);
            }
            case REM: {
                if (this.approximateNonLinearExpressions && left.isSymbolic() && right.isSymbolic()) {
                    SmtExpr concreteRightValue = ExprToCVC4Visitor.approximateToConcreteValue(source.getRightOperand());
                    return SmtExprBuilder.mkMod(left, concreteRightValue);
                }
                return super.postVisit(source, left, operator, right);
            }
            case IOR: {
                SmtExpr bv_left = SmtExprBuilder.mkInt2BV(32, left);
                SmtExpr bv_right = SmtExprBuilder.mkInt2BV(32, right);
                SmtExpr bvor = SmtExprBuilder.mkBVOR(bv_left, bv_right);
                return ExprToCVC4Visitor.mkBV2Int(bvor);
            }
            case IAND: {
                SmtExpr bv_left = SmtExprBuilder.mkInt2BV(32, left);
                SmtExpr bv_right = SmtExprBuilder.mkInt2BV(32, right);
                SmtExpr bv_and = SmtExprBuilder.mkBVAND(bv_left, bv_right);
                return ExprToCVC4Visitor.mkBV2Int(bv_and);
            }
            case IXOR: {
                SmtExpr bv_left = SmtExprBuilder.mkInt2BV(32, left);
                SmtExpr bv_right = SmtExprBuilder.mkInt2BV(32, right);
                SmtExpr bv_xor = SmtExprBuilder.mkBVXOR(bv_left, bv_right);
                return ExprToCVC4Visitor.mkBV2Int(bv_xor);
            }
            case SHL: {
                SmtExpr bv_left = SmtExprBuilder.mkInt2BV(32, left);
                SmtExpr bv_right = SmtExprBuilder.mkInt2BV(32, right);
                SmtExpr bv_shl = SmtExprBuilder.mkBVSHL(bv_left, bv_right);
                return ExprToCVC4Visitor.mkBV2Int(bv_shl);
            }
            case SHR: {
                SmtExpr bv_left = SmtExprBuilder.mkInt2BV(32, left);
                SmtExpr bv_right = SmtExprBuilder.mkInt2BV(32, right);
                SmtExpr bv_shr = SmtExprBuilder.mkBVASHR(bv_left, bv_right);
                return ExprToCVC4Visitor.mkBV2Int(bv_shr);
            }
            case USHR: {
                SmtExpr bv_left = SmtExprBuilder.mkInt2BV(32, left);
                SmtExpr bv_right = SmtExprBuilder.mkInt2BV(32, right);
                SmtExpr bv_shr = SmtExprBuilder.mkBVLSHR(bv_left, bv_right);
                SmtExpr ret_val = ExprToCVC4Visitor.mkBV2Int(bv_shr);
                return ret_val;
            }
        }
        return super.postVisit(source, left, operator, right);
    }

    private static SmtExpr mkBV2Int(SmtExpr bv) {
        SmtExpr bv2nat = SmtExprBuilder.mkBV2Nat(bv);
        SmtIntConstant maxIntValue = SmtExprBuilder.mkIntConstant(Integer.MAX_VALUE);
        SmtExpr condExpr = SmtExprBuilder.mkLe(bv2nat, maxIntValue);
        SmtExpr bvMinusOne = SmtExprBuilder.mkInt2BV(32, SmtExprBuilder.mkIntConstant(-1L));
        SmtExpr xor = SmtExprBuilder.mkBVXOR(bv, bvMinusOne);
        SmtExpr bvOne = SmtExprBuilder.mkInt2BV(32, SmtExprBuilder.ONE_INT);
        SmtExpr bvAdd = SmtExprBuilder.mkBVADD(xor, bvOne);
        SmtExpr bv2natAdd = SmtExprBuilder.mkBV2Nat(bvAdd);
        SmtExpr thenExpr = bv2nat;
        SmtExpr elseExpr = SmtExprBuilder.mkNeg(bv2natAdd);
        SmtExpr ite = SmtExprBuilder.mkITE(condExpr, thenExpr, elseExpr);
        return ite;
    }

    @Override
    protected SmtExpr postVisit(RealBinaryExpression source, SmtExpr left, Operator operator, SmtExpr right) {
        switch (operator) {
            case DIV: {
                if (this.approximateNonLinearExpressions && left.isSymbolic() && right.isSymbolic()) {
                    SmtExpr concreteRightValue = ExprToCVC4Visitor.approximateToConcreteValue(source.getRightOperand());
                    return SmtExprBuilder.mkRealDiv(left, concreteRightValue);
                }
                return super.postVisit(source, left, operator, right);
            }
            case MUL: {
                if (this.approximateNonLinearExpressions && left.isSymbolic() && right.isSymbolic()) {
                    SmtExpr concreteRightValue = ExprToCVC4Visitor.approximateToConcreteValue(source.getRightOperand());
                    return SmtExprBuilder.mkMul(left, concreteRightValue);
                }
                return super.postVisit(source, left, operator, right);
            }
        }
        return super.postVisit(source, left, operator, right);
    }

    @Override
    protected SmtExpr postVisit(StringBinaryComparison source, SmtExpr left, Operator operator, SmtExpr right) {
        switch (operator) {
            case PATTERNMATCHES: {
                String regex = source.getLeftOperand().getConcreteValue();
                String expandedRegex = RegexDistanceUtils.expandRegex(regex);
                RegExp regexp = new RegExp(expandedRegex, 1);
                RegExpToCVC4Visitor visitor = new RegExpToCVC4Visitor();
                SmtExpr regExpSmtExpr = (SmtExpr)visitor.visitRegExp(regexp);
                if (regExpSmtExpr == null) {
                    return ExprToCVC4Visitor.approximateToConcreteValue(source);
                }
                SmtExpr strInRegExp = SmtExprBuilder.mkStrInRE(right, regExpSmtExpr);
                return SmtExprBuilder.mkITE(strInRegExp, SmtExprBuilder.ONE_INT, SmtExprBuilder.ZERO_INT);
            }
        }
        return super.postVisit(source, left, operator, right);
    }
}

