/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.cvc4;

import dk.brics.automaton.RegExp;
import dk.brics.automaton.RegExpVisitor;
import org.evosuite.symbolic.solver.SmtExprBuilder;
import org.evosuite.symbolic.solver.smt.SmtExpr;
import org.evosuite.symbolic.solver.smt.SmtIntConstant;
import org.evosuite.symbolic.solver.smt.SmtStringConstant;

public final class RegExpToCVC4Visitor
extends RegExpVisitor<SmtExpr> {
    @Override
    public SmtExpr visitUnion(RegExp left, RegExp right) {
        SmtExpr leftExpr = (SmtExpr)this.visitRegExp(left);
        SmtExpr rightExpr = (SmtExpr)this.visitRegExp(right);
        if (leftExpr == null || rightExpr == null) {
            return null;
        }
        SmtExpr unionExpr = SmtExprBuilder.mkREUnion(leftExpr, rightExpr);
        return unionExpr;
    }

    @Override
    public SmtExpr visitString(String s) {
        SmtStringConstant strConstant = SmtExprBuilder.mkStringConstant(s);
        SmtExpr strToRegExpr = SmtExprBuilder.mkStrToRE(strConstant);
        return strToRegExpr;
    }

    @Override
    public SmtExpr visitRepeatMinMax(RegExp e, int min, int max) {
        SmtExpr regExpr = (SmtExpr)this.visitRegExp(e);
        if (regExpr == null) {
            return null;
        }
        SmtIntConstant minExpr = SmtExprBuilder.mkIntConstant(min);
        SmtIntConstant maxExpr = SmtExprBuilder.mkIntConstant(max);
        SmtExpr loopExpr = SmtExprBuilder.mkLoop(regExpr, minExpr, maxExpr);
        return loopExpr;
    }

    @Override
    public SmtExpr visitRepeatMin(RegExp e, int min) {
        SmtExpr regExpr = (SmtExpr)this.visitRegExp(e);
        if (regExpr == null) {
            return null;
        }
        if (min == 1) {
            SmtExpr kleeneCrossExpr = SmtExprBuilder.mkREKleeneCross(regExpr);
            return kleeneCrossExpr;
        }
        SmtIntConstant minExpr = SmtExprBuilder.mkIntConstant(min);
        SmtExpr loopExpr = SmtExprBuilder.mkLoop(regExpr, minExpr);
        return loopExpr;
    }

    @Override
    public SmtExpr visitRepeat(RegExp arg) {
        SmtExpr expr = (SmtExpr)this.visitRegExp(arg);
        if (expr == null) {
            return null;
        }
        SmtExpr repeatExpr = SmtExprBuilder.mkREKleeneStar(expr);
        return repeatExpr;
    }

    @Override
    public SmtExpr visitOptional(RegExp e) {
        SmtExpr expr = (SmtExpr)this.visitRegExp(e);
        if (expr == null) {
            return null;
        }
        SmtExpr optExpr = SmtExprBuilder.mkREOpt(expr);
        return optExpr;
    }

    @Override
    public SmtExpr visitConcatenation(RegExp left, RegExp right) {
        SmtExpr leftExpr = (SmtExpr)this.visitRegExp(left);
        SmtExpr rightExpr = (SmtExpr)this.visitRegExp(right);
        if (leftExpr == null || rightExpr == null) {
            return null;
        }
        SmtExpr concat = SmtExprBuilder.mkREConcat(leftExpr, rightExpr);
        return concat;
    }

    @Override
    public SmtExpr visitCharRange(char from, char to) {
        String fromStr = String.valueOf(from);
        SmtStringConstant fromConstant = SmtExprBuilder.mkStringConstant(fromStr);
        String toStr = String.valueOf(to);
        SmtStringConstant toConstant = SmtExprBuilder.mkStringConstant(toStr);
        SmtExpr rangeExpr = SmtExprBuilder.mkRERange(fromConstant, toConstant);
        return rangeExpr;
    }

    @Override
    public SmtExpr visitChar(char c) {
        String str = String.valueOf(c);
        SmtStringConstant strConstant = SmtExprBuilder.mkStringConstant(str);
        SmtExpr expr = SmtExprBuilder.mkStrToRE(strConstant);
        return expr;
    }

    @Override
    public SmtExpr visitAnyChar() {
        return SmtExprBuilder.mkREAllChar();
    }

    @Override
    public SmtExpr visitInterval(int min, int max) {
        throw new IllegalStateException("Optional dk.brics productions are not supported. Check syntax_flags of RegExp(String,String)");
    }

    @Override
    public SmtExpr visitIntersection(RegExp left, RegExp right) {
        throw new IllegalStateException("Optional dk.brics productions are not supported. Check syntax_flags of RegExp(String,String)");
    }

    @Override
    public SmtExpr visitAutomaton(RegExp e) {
        throw new IllegalStateException("Optional dk.brics productions are not supported. Check syntax_flags of RegExp(String,String)");
    }

    @Override
    public SmtExpr visitComplement(RegExp e) {
        throw new IllegalStateException("Optional dk.brics productions are not supported. Check syntax_flags of RegExp(String,String)");
    }

    @Override
    public SmtExpr visitEmpty() {
        throw new IllegalStateException("Optional dk.brics productions are not supported. Check syntax_flags of RegExp(String,String)");
    }

    @Override
    public SmtExpr visitAnyString() {
        throw new IllegalStateException("Optional dk.brics productions are not supported. Check syntax_flags of RegExp(String,String)");
    }
}

