/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.smt;

import java.util.LinkedList;
import java.util.Map;
import org.evosuite.symbolic.solver.smt.SmtBooleanConstant;
import org.evosuite.symbolic.solver.smt.SmtExpr;
import org.evosuite.symbolic.solver.smt.SmtExprVisitor;
import org.evosuite.symbolic.solver.smt.SmtIntConstant;
import org.evosuite.symbolic.solver.smt.SmtIntVariable;
import org.evosuite.symbolic.solver.smt.SmtOperation;
import org.evosuite.symbolic.solver.smt.SmtRealConstant;
import org.evosuite.symbolic.solver.smt.SmtRealVariable;
import org.evosuite.symbolic.solver.smt.SmtStringConstant;
import org.evosuite.symbolic.solver.smt.SmtStringVariable;

public final class SmtExprEvaluator
implements SmtExprVisitor<Object, Void> {
    private static final double DELTA = 1.0E-15;
    private final Map<String, Object> solution;

    public SmtExprEvaluator(Map<String, Object> solution) {
        this.solution = solution;
    }

    @Override
    public Long visit(SmtIntConstant n, Void arg) {
        Long longValue = n.getConstantValue();
        return longValue;
    }

    @Override
    public Double visit(SmtRealConstant n, Void arg) {
        Double doubleVal = n.getConstantValue();
        return doubleVal;
    }

    @Override
    public String visit(SmtStringConstant n, Void arg) {
        return n.getConstantValue();
    }

    @Override
    public Long visit(SmtIntVariable n, Void arg) {
        String varName = n.getName();
        if (!this.solution.containsKey(varName)) {
            throw new IllegalStateException("The variable " + varName + " is not defined in the given solution");
        }
        Object value = this.solution.get(varName);
        if (value == null) {
            throw new NullPointerException("The value of variable " + varName + " cannot be null");
        }
        if (!(value instanceof Long)) {
            throw new ClassCastException("The value of variable " + varName + " should be Long but found type is " + value.getClass().getName());
        }
        Long retVal = (Long)value;
        return retVal;
    }

    @Override
    public Double visit(SmtRealVariable n, Void arg) {
        String varName = n.getName();
        if (!this.solution.containsKey(varName)) {
            throw new IllegalStateException("The variable " + varName + " is not defined in the given solution");
        }
        Object value = this.solution.get(varName);
        if (value == null) {
            throw new NullPointerException("The value of variable " + varName + " cannot be null");
        }
        if (!(value instanceof Double)) {
            throw new ClassCastException("The value of variable " + varName + " should be Double but found type is " + value.getClass().getName());
        }
        Double retVal = (Double)value;
        return retVal;
    }

    @Override
    public String visit(SmtStringVariable n, Void arg) {
        String varName = n.getName();
        if (!this.solution.containsKey(varName)) {
            throw new IllegalStateException("The variable " + varName + " is not defined in the given solution");
        }
        Object value = this.solution.get(varName);
        if (value == null) {
            throw new NullPointerException("The value of variable " + varName + " cannot be null");
        }
        if (!(value instanceof String)) {
            throw new ClassCastException("The value of variable " + varName + " should be String but found type is " + value.getClass().getName());
        }
        String retVal = (String)value;
        return retVal;
    }

    @Override
    public Object visit(SmtOperation n, Void arg) {
        LinkedList<Object> retValues = new LinkedList<Object>();
        for (SmtExpr argument : n.getArguments()) {
            Object retValue = argument.accept(this, null);
            retValues.add(retValue);
        }
        switch (n.getOperator()) {
            case ABS: {
                Object unaryRetVal = retValues.get(0);
                Long integerOperand = (Long)unaryRetVal;
                long absLong = Math.abs(integerOperand);
                return absLong;
            }
            case ADD: {
                Double rightReal;
                Number add;
                Long rightInt;
                Object left = retValues.get(0);
                Object right = retValues.get(1);
                if (SmtExprEvaluator.isInteger(left, right)) {
                    Long leftInt = (Long)left;
                    rightInt = (Long)right;
                    add = leftInt + rightInt;
                    return add;
                }
                if (SmtExprEvaluator.isReal(left, right)) {
                    Double leftReal = (Double)left;
                    rightReal = (Double)right;
                    add = leftReal + rightReal;
                    return add;
                }
                throw new IllegalArgumentException("ADD Type mismatch left=" + left.getClass().getName() + " and right=" + right.getClass().getName());
            }
            case STR_CONCAT: 
            case CONCAT: {
                Object left = retValues.get(0);
                Object right = retValues.get(1);
                String leftString = (String)left;
                String rightString = (String)right;
                return leftString + rightString;
            }
            case STR_CONTAINS: 
            case CONTAINS: {
                Object left = retValues.get(0);
                Object right = retValues.get(1);
                String leftString = (String)left;
                String rightString = (String)right;
                return leftString.contains(rightString);
            }
            case DIV: {
                Object left = retValues.get(0);
                Object right = retValues.get(1);
                Long leftInteger = (Long)left;
                Long rightInteger = (Long)right;
                return leftInteger / rightInteger;
            }
            case STR_SUFFIXOF: {
                Object left = retValues.get(0);
                Object right = retValues.get(1);
                String leftString = (String)left;
                String rightString = (String)right;
                return rightString.endsWith(leftString);
            }
            case ENDSWITH: {
                Object left = retValues.get(0);
                Object right = retValues.get(1);
                String leftString = (String)left;
                String rightString = (String)right;
                return leftString.endsWith(rightString);
            }
            case STR_LEN: 
            case LENGTH: {
                Object expr = retValues.get(0);
                String exprString = (String)expr;
                return (long)exprString.length();
            }
            case INDEXOF: {
                Object left = retValues.get(0);
                Object right = retValues.get(1);
                String leftString = (String)left;
                String rightString = (String)right;
                return (long)leftString.indexOf(rightString);
            }
            case STR_SUBSTR: {
                Object s = retValues.get(0);
                Object startIndex = retValues.get(1);
                Object offset = retValues.get(2);
                String str = (String)s;
                Long startIndexInt = (Long)startIndex;
                Long offSetInt = (Long)offset;
                int start = startIndexInt.intValue();
                int off = offSetInt.intValue();
                return str.substring(start, start + off);
            }
            case SUBSTRING: {
                Object s = retValues.get(0);
                Object startIndex = retValues.get(1);
                Object endIndex = retValues.get(2);
                String str = (String)s;
                Long startIndexInt = (Long)startIndex;
                Long endIndexInt = (Long)endIndex;
                int start = startIndexInt.intValue();
                int end = endIndexInt.intValue();
                return str.substring(start, end);
            }
            case SLASH: {
                Object left = retValues.get(0);
                Object right = retValues.get(1);
                Double leftReal = (Double)left;
                Double rightReal = (Double)right;
                Double div = leftReal / rightReal;
                return div;
            }
            case MUL: {
                Number mul;
                Double rightReal;
                Long rightInt;
                Object left = retValues.get(0);
                Object right = retValues.get(1);
                if (SmtExprEvaluator.isInteger(left, right)) {
                    Long leftInt = (Long)left;
                    rightInt = (Long)right;
                    mul = leftInt * rightInt;
                    return mul;
                }
                if (SmtExprEvaluator.isReal(left, right)) {
                    Double leftReal = (Double)left;
                    rightReal = (Double)right;
                    mul = leftReal * rightReal;
                    return mul;
                }
                throw new IllegalArgumentException("MUL Type mismatch left=" + left.getClass().getName() + " and right=" + right.getClass().getName());
            }
            case MINUS: {
                Object operand;
                Double rightReal;
                Long rightInt;
                Object left;
                if (retValues.size() == 1) {
                    operand = retValues.get(0);
                    if (SmtExprEvaluator.isInteger(operand)) {
                        Long intOperand = (Long)operand;
                        return -intOperand.longValue();
                    }
                    if (SmtExprEvaluator.isReal(operand)) {
                        Double realOperand = (Double)operand;
                        return -realOperand.doubleValue();
                    }
                    throw new IllegalArgumentException("MINUS Type mismatch operand=" + operand.getClass().getName());
                }
                if (retValues.size() == 2) {
                    Number minus;
                    Object right;
                    left = retValues.get(0);
                    if (SmtExprEvaluator.isInteger(left, right = retValues.get(1))) {
                        Long leftInt = (Long)left;
                        rightInt = (Long)right;
                        minus = leftInt - rightInt;
                        return minus;
                    }
                    if (SmtExprEvaluator.isReal(left, right)) {
                        Double leftReal = (Double)left;
                        rightReal = (Double)right;
                        minus = leftReal - rightReal;
                        return minus;
                    }
                    throw new IllegalArgumentException("MINUS Type mismatch left=" + left.getClass().getName() + " and right=" + right.getClass().getName());
                }
                throw new IllegalArgumentException("Invalid number of arguments for MINUS: " + retValues.size());
            }
            case MOD: 
            case REM: {
                Object left = retValues.get(0);
                Object right = retValues.get(1);
                Long leftInteger = (Long)left;
                Long rightInteger = (Long)right;
                return leftInteger % rightInteger;
            }
            case GE: {
                Boolean ge;
                Double rightReal;
                Long rightInt;
                Object left = retValues.get(0);
                Object right = retValues.get(1);
                if (SmtExprEvaluator.isInteger(left, right)) {
                    Long leftInt = (Long)left;
                    rightInt = (Long)right;
                    ge = leftInt >= rightInt;
                    return ge;
                }
                if (SmtExprEvaluator.isReal(left, right)) {
                    Double leftReal = (Double)left;
                    rightReal = (Double)right;
                    ge = leftReal >= rightReal;
                    return ge;
                }
                throw new IllegalArgumentException("GE Type mismatch left=" + left.getClass().getName() + " and right=" + right.getClass().getName());
            }
            case GT: {
                Boolean gt;
                Double rightReal;
                Long rightInt;
                Object left = retValues.get(0);
                Object right = retValues.get(1);
                if (SmtExprEvaluator.isInteger(left, right)) {
                    Long leftInt = (Long)left;
                    rightInt = (Long)right;
                    gt = leftInt > rightInt;
                    return gt;
                }
                if (SmtExprEvaluator.isReal(left, right)) {
                    Double leftReal = (Double)left;
                    rightReal = (Double)right;
                    gt = leftReal > rightReal;
                    return gt;
                }
                throw new IllegalArgumentException("GT Type mismatch left=" + left.getClass().getName() + " and right=" + right.getClass().getName());
            }
            case LE: {
                Boolean le;
                Double rightReal;
                Long rightInt;
                Object left = retValues.get(0);
                Object right = retValues.get(1);
                if (SmtExprEvaluator.isInteger(left, right)) {
                    Long leftInt = (Long)left;
                    rightInt = (Long)right;
                    le = leftInt <= rightInt;
                    return le;
                }
                if (SmtExprEvaluator.isReal(left, right)) {
                    Double leftReal = (Double)left;
                    rightReal = (Double)right;
                    le = leftReal <= rightReal;
                    return le;
                }
                throw new IllegalArgumentException("LE Type mismatch left=" + left.getClass().getName() + " and right=" + right.getClass().getName());
            }
            case LT: {
                Boolean lt;
                Double rightReal;
                Long rightInt;
                Object left = retValues.get(0);
                Object right = retValues.get(1);
                if (SmtExprEvaluator.isInteger(left, right)) {
                    Long leftInt = (Long)left;
                    rightInt = (Long)right;
                    lt = leftInt < rightInt;
                    return lt;
                }
                if (SmtExprEvaluator.isReal(left, right)) {
                    Double leftReal = (Double)left;
                    rightReal = (Double)right;
                    lt = leftReal < rightReal;
                    return lt;
                }
                throw new IllegalArgumentException("LT Type mismatch left=" + left.getClass().getName() + " and right=" + right.getClass().getName());
            }
            case EQ: {
                Boolean eq;
                String rightString;
                Double rightReal;
                Long rightInt;
                Object left = retValues.get(0);
                Object right = retValues.get(1);
                if (SmtExprEvaluator.isInteger(left, right)) {
                    Long leftInt = (Long)left;
                    rightInt = (Long)right;
                    eq = leftInt.longValue() == rightInt.longValue();
                    return eq;
                }
                if (SmtExprEvaluator.isReal(left, right)) {
                    Double leftReal = (Double)left;
                    rightReal = (Double)right;
                    eq = Math.abs(leftReal - rightReal) < 1.0E-15;
                    return eq;
                }
                if (SmtExprEvaluator.isString(left, right)) {
                    String leftString = (String)left;
                    rightString = (String)right;
                    Boolean equals = leftString.equals(rightString);
                    return equals;
                }
                throw new IllegalArgumentException("EQ Type mismatch left=" + left.getClass().getName() + " and right=" + right.getClass().getName());
            }
            case NOT: {
                Object operand = retValues.get(0);
                Boolean operandBoolean = (Boolean)operand;
                Boolean not = operandBoolean == false;
                return not;
            }
            case STR_REPLACE: 
            case REPLACE: {
                Object s = retValues.get(0);
                Object target = retValues.get(1);
                Object replacement = retValues.get(2);
                String str = (String)s;
                String targetStr = (String)target;
                String replacementStr = (String)replacement;
                String ret_val = str.replace(targetStr, replacementStr);
                return ret_val;
            }
            case STR_PREFIXOF: {
                Object left = retValues.get(0);
                Object right = retValues.get(1);
                String leftString = (String)left;
                String rightString = (String)right;
                Boolean prefixOf = rightString.startsWith(leftString);
                return prefixOf;
            }
            case STARTSWITH: {
                Object left = retValues.get(0);
                Object right = retValues.get(1);
                String leftString = (String)left;
                String rightString = (String)right;
                Boolean startsWith = leftString.startsWith(rightString);
                return startsWith;
            }
            case ITE: {
                Object cond = retValues.get(0);
                Object thenObj = retValues.get(1);
                Object elseObj = retValues.get(2);
                Boolean condBoolean = (Boolean)cond;
                if (condBoolean.booleanValue()) {
                    return thenObj;
                }
                return elseObj;
            }
            case BV2INT: {
                Object operand = retValues.get(0);
                return operand;
            }
            case BVADD: {
                Object left = retValues.get(0);
                Object right = retValues.get(1);
                Long leftInteger = (Long)left;
                Long rightInteger = (Long)right;
                return leftInteger + rightInteger;
            }
            case BV2Nat: {
                Object operand = retValues.get(0);
                return operand;
            }
            case BVAND: {
                Object left = retValues.get(0);
                Object right = retValues.get(1);
                Long leftInteger = (Long)left;
                Long rightInteger = (Long)right;
                return leftInteger & rightInteger;
            }
            case BVASHR: {
                Object left = retValues.get(0);
                Object right = retValues.get(1);
                Long leftInteger = (Long)left;
                Long rightInteger = (Long)right;
                return leftInteger >> (int)rightInteger.longValue();
            }
            case BVLSHR: {
                Object left = retValues.get(0);
                Object right = retValues.get(1);
                Long leftInteger = (Long)left;
                Long rightInteger = (Long)right;
                return leftInteger >>> (int)rightInteger.longValue();
            }
            case BVOR: {
                Object left = retValues.get(0);
                Object right = retValues.get(1);
                Long leftInteger = (Long)left;
                Long rightInteger = (Long)right;
                return leftInteger | rightInteger;
            }
            case BVSHL: {
                Object left = retValues.get(0);
                Object right = retValues.get(1);
                Long leftInteger = (Long)left;
                Long rightInteger = (Long)right;
                return leftInteger << (int)rightInteger.longValue();
            }
            case BVXOR: {
                Object left = retValues.get(0);
                Object right = retValues.get(1);
                Long leftInteger = (Long)left;
                Long rightInteger = (Long)right;
                return leftInteger ^ rightInteger;
            }
            case INT2BV32: {
                Object operand = retValues.get(0);
                return operand;
            }
            case TO_REAL: {
                Object operand = retValues.get(0);
                Long operandInt = (Long)operand;
                return (double)operandInt.longValue();
            }
            case INT_TO_CHAR: 
            case INT_TO_STR: {
                Object operand = retValues.get(0);
                Long operandInt = (Long)operand;
                return Long.toString(operandInt);
            }
            case TO_INT: {
                Object operand = retValues.get(0);
                Double operandReal = (Double)operand;
                return operandReal.longValue();
            }
            case CHAR_TO_INT: {
                Object operand = retValues.get(0);
                String operandStr = (String)operand;
                if (operandStr.length() != 1) {
                    throw new IllegalArgumentException("The following string cannot be transformed into a char " + operandStr);
                }
                char charValue = operandStr.charAt(0);
                return (long)charValue;
            }
            case STR_TO_INT: {
                Object operand = retValues.get(0);
                String operandStr = (String)operand;
                return Long.parseLong(operandStr);
            }
            case STR_INDEXOF: {
                Object s = retValues.get(0);
                Object ch = retValues.get(1);
                Object index = retValues.get(2);
                String str = (String)s;
                String chString = (String)ch;
                Long indexInt = (Long)index;
                int indexOf = str.indexOf(chString, indexInt.intValue());
                return (long)indexOf;
            }
            case STR_AT: {
                Object s = retValues.get(0);
                Object index = retValues.get(1);
                String str = (String)s;
                Long indexInt = (Long)index;
                char charAt = str.charAt(indexInt.intValue());
                return String.valueOf(charAt);
            }
            case RE_ALLCHAR: 
            case RE_CONCAT: 
            case RE_KLEENE_CROSS: 
            case RE_KLEENE_STAR: 
            case RE_LOOP: 
            case RE_OPT: 
            case RE_RANGE: 
            case RE_UNION: 
            case STR_IN_RE: 
            case STR_TO_RE: {
                throw new UnsupportedOperationException("The operation " + (Object)((Object)n.getOperator()) + " should be implemented!");
            }
        }
        throw new IllegalStateException("The following operator must be implemented " + (Object)((Object)n.getOperator()));
    }

    private static boolean isReal(Object operand) {
        return operand instanceof Double;
    }

    private static boolean isInteger(Object operand) {
        return operand instanceof Long;
    }

    private static boolean isReal(Object left, Object right) {
        return left instanceof Double && right instanceof Double;
    }

    private static boolean isInteger(Object left, Object right) {
        return left instanceof Long && right instanceof Long;
    }

    private static boolean isString(Object left, Object right) {
        return left instanceof String && right instanceof String;
    }

    @Override
    public Boolean visit(SmtBooleanConstant n, Void arg) {
        return n.booleanValue();
    }
}

