/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.smt;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.evosuite.symbolic.solver.ResultParser;
import org.evosuite.symbolic.solver.SolverErrorException;
import org.evosuite.symbolic.solver.SolverParseException;
import org.evosuite.symbolic.solver.SolverResult;
import org.evosuite.symbolic.solver.SolverTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SmtModelParser
extends ResultParser {
    private static final String MODEL_TOKEN = "model";
    private static final String SAT_TOKEN = "sat";
    private static final String BLANK_SPACE_TOKEN = " ";
    private static final String REAL_TOKEN = "Real";
    private static final String QUOTE_TOKEN = "\"";
    private static final String STRING_TOKEN = "String";
    private static final String SLASH_TOKEN = "/";
    private static final String MINUS_TOKEN = "-";
    private static final String INT_TOKEN = "Int";
    private static final String DEFINE_FUN_TOKEN = "define-fun";
    private static final String RIGHT_PARENTHESIS_TOKEN = ")";
    private static final String LEFT_PARENTHESIS_TOKEN = "(";
    private static final String NEW_LINE_TOKEN = "\n";
    private final Map<String, Object> initialValues;
    static Logger logger = LoggerFactory.getLogger(SmtModelParser.class);

    public SmtModelParser(Map<String, Object> initialValues) {
        this.initialValues = initialValues;
    }

    public SmtModelParser() {
        this.initialValues = null;
    }

    public SolverResult parse(String cvc4ResultStr) throws SolverParseException, SolverErrorException, SolverTimeoutException {
        if (cvc4ResultStr.startsWith(SAT_TOKEN)) {
            logger.debug("CVC4 outcome was SAT");
            SolverResult satResult = this.parseModel(cvc4ResultStr);
            return satResult;
        }
        if (cvc4ResultStr.startsWith("unsat")) {
            logger.debug("CVC4 outcome was UNSAT");
            SolverResult unsatResult = SolverResult.newUNSAT();
            return unsatResult;
        }
        if (cvc4ResultStr.startsWith("unknown")) {
            logger.debug("CVC4 outcome was UNKNOWN (probably due to timeout)");
            throw new SolverTimeoutException();
        }
        if (cvc4ResultStr.startsWith("(error")) {
            logger.debug("CVC4 output was the following " + cvc4ResultStr);
            throw new SolverErrorException("An error (probably an invalid input) occurred while executing CVC4");
        }
        logger.debug("The following CVC4 output could not be parsed " + cvc4ResultStr);
        throw new SolverParseException("CVC4 output is unknown. We are unable to parse it to a proper solution!", cvc4ResultStr);
    }

    private SolverResult parseModel(String cvc4ResultStr) {
        HashMap<String, Object> solution = new HashMap<String, Object>();
        StringTokenizer tokenizer = new StringTokenizer(cvc4ResultStr, "() \n\t", true);
        String token = tokenizer.nextToken();
        SmtModelParser.checkExpectedToken(SAT_TOKEN, token);
        token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
        SmtModelParser.checkExpectedToken(LEFT_PARENTHESIS_TOKEN, token);
        token = tokenizer.nextToken();
        SmtModelParser.checkExpectedToken(MODEL_TOKEN, token);
        token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
        while (token != null && !token.equals(RIGHT_PARENTHESIS_TOKEN)) {
            Object value;
            SmtModelParser.checkExpectedToken(LEFT_PARENTHESIS_TOKEN, token);
            token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
            if (!token.equals(DEFINE_FUN_TOKEN)) continue;
            token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
            String fun_name = token;
            token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
            SmtModelParser.checkExpectedToken(LEFT_PARENTHESIS_TOKEN, token);
            token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
            SmtModelParser.checkExpectedToken(RIGHT_PARENTHESIS_TOKEN, token);
            token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
            if (token.equals(INT_TOKEN)) {
                value = SmtModelParser.parseIntegerValue(tokenizer);
            } else if (token.equals(REAL_TOKEN)) {
                value = SmtModelParser.parseRealValue(tokenizer);
            } else if (token.equals(STRING_TOKEN)) {
                value = this.parseStringValue(tokenizer);
            } else {
                throw new IllegalArgumentException("Unknown data type " + token);
            }
            solution.put(fun_name, value);
            token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
        }
        if (solution.isEmpty()) {
            logger.warn("The CVC4 model has no variables");
            return null;
        }
        logger.debug("Parsed values from CVC4 output");
        for (String varName : solution.keySet()) {
            String valueOf = String.valueOf(solution.get(varName));
            logger.debug(varName + ":" + valueOf);
        }
        if (this.initialValues != null && !solution.keySet().equals(this.initialValues.keySet())) {
            logger.debug("Adding missing values to Solver solution");
            SmtModelParser.addMissingValues(this.initialValues, solution);
        }
        SolverResult satResult = SolverResult.newSAT(solution);
        return satResult;
    }

    private static String consumeTokens(StringTokenizer tokenizer, String ... tokensToConsume) {
        List<String> tokenList = Arrays.asList(tokensToConsume);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (tokenList.contains(token)) continue;
            return token;
        }
        return null;
    }

    private String parseStringValue(StringTokenizer tokenizer) {
        String token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
        StringBuilder strBuilder = new StringBuilder();
        SmtModelParser.checkExpectedToken(QUOTE_TOKEN, String.valueOf(token.charAt(0)));
        strBuilder.append(token);
        if (!token.substring(1).endsWith(QUOTE_TOKEN)) {
            String stringToken;
            do {
                if (!tokenizer.hasMoreTokens()) {
                    System.out.println("Error!");
                }
                stringToken = tokenizer.nextToken();
                strBuilder.append(stringToken);
            } while (!stringToken.endsWith(QUOTE_TOKEN));
        }
        String stringWithNoQuotes = this.removeQuotes(strBuilder.toString());
        String string = SmtModelParser.decode(stringWithNoQuotes);
        token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
        SmtModelParser.checkExpectedToken(RIGHT_PARENTHESIS_TOKEN, token);
        return string;
    }

    private static String decode(String encodedString) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < encodedString.length(); ++i) {
            char c = encodedString.charAt(i);
            if (c == '\\') {
                if (i >= encodedString.length() - 1) continue;
                switch (encodedString.charAt(i + 1)) {
                    case 'b': {
                        builder.append('\b');
                        ++i;
                        break;
                    }
                    case 't': {
                        builder.append('\t');
                        ++i;
                        break;
                    }
                    case 'n': {
                        builder.append('\n');
                        ++i;
                        break;
                    }
                    case '\\': {
                        builder.append('\\');
                        ++i;
                        break;
                    }
                    case 'x': {
                        String hexString = encodedString.substring(i + 2, i + 4);
                        int decimal = Integer.parseInt(hexString, 16);
                        builder.append((char)decimal);
                        i += 3;
                        break;
                    }
                    default: {
                        builder.append(c);
                        break;
                    }
                }
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private String removeQuotes(String stringWithQuotes) {
        return stringWithQuotes.substring(1, stringWithQuotes.length() - 1);
    }

    private static Double parseRealValue(StringTokenizer tokenizer) {
        Double value;
        String token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
        if (!token.equals(LEFT_PARENTHESIS_TOKEN)) {
            value = Double.parseDouble(token);
        } else {
            token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
            if (token.equals(MINUS_TOKEN)) {
                token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
                if (token.equals(LEFT_PARENTHESIS_TOKEN)) {
                    token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
                    SmtModelParser.checkExpectedToken(SLASH_TOKEN, token);
                    String numeratorStr = token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
                    String denominatorStr = token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
                    value = SmtModelParser.parseRational(true, numeratorStr, denominatorStr);
                    token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
                    SmtModelParser.checkExpectedToken(RIGHT_PARENTHESIS_TOKEN, token);
                    token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
                    SmtModelParser.checkExpectedToken(RIGHT_PARENTHESIS_TOKEN, token);
                } else {
                    String absoluteValueStr = token;
                    value = Double.parseDouble(MINUS_TOKEN + absoluteValueStr);
                    token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
                    SmtModelParser.checkExpectedToken(RIGHT_PARENTHESIS_TOKEN, token);
                }
            } else if (token.equals(SLASH_TOKEN)) {
                String numeratorStr;
                boolean neg;
                token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
                if (token.equals(LEFT_PARENTHESIS_TOKEN)) {
                    token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
                    SmtModelParser.checkExpectedToken(MINUS_TOKEN, token);
                    neg = true;
                    numeratorStr = token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
                    token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
                    SmtModelParser.checkExpectedToken(RIGHT_PARENTHESIS_TOKEN, token);
                } else {
                    neg = false;
                    numeratorStr = token;
                }
                String denominatorStr = token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
                value = SmtModelParser.parseRational(neg, numeratorStr, denominatorStr);
                token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
                SmtModelParser.checkExpectedToken(RIGHT_PARENTHESIS_TOKEN, token);
            } else {
                value = Double.parseDouble(token);
            }
        }
        token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
        SmtModelParser.checkExpectedToken(RIGHT_PARENTHESIS_TOKEN, token);
        return value;
    }

    private static Long parseIntegerValue(StringTokenizer tokenizer) {
        Long value;
        String integerValueStr;
        String token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
        boolean neg = false;
        if (token.equals(LEFT_PARENTHESIS_TOKEN)) {
            neg = true;
            token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
            SmtModelParser.checkExpectedToken(MINUS_TOKEN, token);
            integerValueStr = token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
        } else {
            integerValueStr = token;
        }
        if (neg) {
            String absoluteIntegerValue = integerValueStr;
            value = Long.parseLong(MINUS_TOKEN + absoluteIntegerValue);
        } else {
            value = Long.parseLong(integerValueStr);
        }
        if (neg) {
            token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
            SmtModelParser.checkExpectedToken(RIGHT_PARENTHESIS_TOKEN, token);
        }
        token = SmtModelParser.consumeTokens(tokenizer, NEW_LINE_TOKEN, BLANK_SPACE_TOKEN);
        SmtModelParser.checkExpectedToken(RIGHT_PARENTHESIS_TOKEN, token);
        return value;
    }

    private static void checkExpectedToken(String expectedToken, String actualToken) {
        if (!actualToken.equals(expectedToken)) {
            throw new IllegalArgumentException("Malformed CVC4 solution. Expected \"" + expectedToken + "\" but found \"" + actualToken + QUOTE_TOKEN);
        }
    }

    private static void addMissingValues(Map<String, Object> initialValues, Map<String, Object> solution) {
        for (String otherVarName : initialValues.keySet()) {
            if (solution.containsKey(otherVarName)) continue;
            solution.put(otherVarName, initialValues.get(otherVarName));
        }
    }
}

