/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.z3;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.solver.SmtExprBuilder;
import org.evosuite.symbolic.solver.SmtSolver;
import org.evosuite.symbolic.solver.SolverEmptyQueryException;
import org.evosuite.symbolic.solver.SolverErrorException;
import org.evosuite.symbolic.solver.SolverParseException;
import org.evosuite.symbolic.solver.SolverResult;
import org.evosuite.symbolic.solver.SolverTimeoutException;
import org.evosuite.symbolic.solver.smt.SmtAssertion;
import org.evosuite.symbolic.solver.smt.SmtConstantDeclaration;
import org.evosuite.symbolic.solver.smt.SmtExpr;
import org.evosuite.symbolic.solver.smt.SmtFunctionDefinition;
import org.evosuite.symbolic.solver.smt.SmtIntVariable;
import org.evosuite.symbolic.solver.smt.SmtModelParser;
import org.evosuite.symbolic.solver.smt.SmtOperation;
import org.evosuite.symbolic.solver.smt.SmtOperatorCollector;
import org.evosuite.symbolic.solver.smt.SmtQuery;
import org.evosuite.symbolic.solver.smt.SmtQueryPrinter;
import org.evosuite.symbolic.solver.smt.SmtRealVariable;
import org.evosuite.symbolic.solver.smt.SmtStringVariable;
import org.evosuite.symbolic.solver.smt.SmtVariable;
import org.evosuite.symbolic.solver.smt.SmtVariableCollector;
import org.evosuite.symbolic.solver.z3.ConstraintToZ3Visitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Z3Solver
extends SmtSolver {
    static Logger logger = LoggerFactory.getLogger(Z3Solver.class);
    private static final int ASCII_TABLE_LENGTH = 90;

    public Z3Solver() {
    }

    public Z3Solver(boolean addMissingVariables) {
        super(addMissingVariables);
    }

    @Override
    public SolverResult solve(Collection<Constraint<?>> constraints) throws SolverTimeoutException, IOException, SolverParseException, SolverEmptyQueryException, SolverErrorException {
        boolean check;
        String output;
        HashSet variables;
        block7: {
            long hard_timeout = Properties.DSE_CONSTRAINT_SOLVER_TIMEOUT_MILLIS;
            variables = new HashSet();
            for (Constraint<?> c : constraints) {
                Set<Variable<?>> c_variables = c.getVariables();
                variables.addAll(c_variables);
            }
            SmtQuery query = Z3Solver.buildSmtQuery(constraints, hard_timeout);
            if (query.getConstantDeclarations().isEmpty()) {
                logger.debug("Z3 SMT query has no variables");
                throw new SolverEmptyQueryException("Z3 SMT query has no variables");
            }
            if (query.getAssertions().isEmpty()) {
                HashMap<String, Object> emptySolution = new HashMap<String, Object>();
                SolverResult emptySAT = SolverResult.newSAT(emptySolution);
                return emptySAT;
            }
            SmtQueryPrinter printer = new SmtQueryPrinter();
            String queryStr = printer.print(query);
            logger.debug("Z3 Query:");
            logger.debug(queryStr);
            if (Properties.Z3_PATH == null) {
                String errMsg = "Property Z3_PATH should be setted in order to use the Z3 Solver!";
                logger.error(errMsg);
                throw new IllegalStateException(errMsg);
            }
            String z3Cmd = Properties.Z3_PATH + " -smt2 -in ";
            ByteArrayOutputStream stdout = new ByteArrayOutputStream();
            try {
                Z3Solver.launchNewSolvingProcess(z3Cmd, queryStr, (int)hard_timeout, stdout);
                output = stdout.toString("UTF-8");
            }
            catch (SolverErrorException ex) {
                output = stdout.toString("UTF-8");
                if (output.startsWith("unsat")) break block7;
                throw ex;
            }
        }
        Map<String, Object> initialValues = Z3Solver.getConcreteValues(variables);
        SmtModelParser parser = this.addMissingVariables() ? new SmtModelParser(initialValues) : new SmtModelParser();
        SolverResult result = parser.parse(output);
        if (result.isSAT() && !(check = Z3Solver.checkSAT(constraints, result))) {
            logger.debug("Z3 solution fails to solve the constraint system!");
            SolverResult unsatResult = SolverResult.newUNSAT();
            return unsatResult;
        }
        return result;
    }

    private static String encodeString(String str) {
        char[] charArray = str.toCharArray();
        String ret_val = "";
        for (char c : charArray) {
            ret_val = Integer.toHexString(c).length() == 1 ? ret_val + "\\x0" + Integer.toHexString(c) : ret_val + "\\x" + Integer.toHexString(c);
        }
        return ret_val;
    }

    private static String buildIntToCharFunction() {
        int i;
        StringBuffer buff = new StringBuffer();
        buff.append((Object)((Object)SmtOperation.Operator.INT_TO_CHAR) + "((x!1 Int)) String");
        buff.append("\n");
        for (i = 0; i < 90; ++i) {
            char c = (char)i;
            String str = String.valueOf(c);
            String encodedStr = Z3Solver.encodeString(str);
            if (i < 89) {
                String iteStr = String.format("(ite (= x!1 %s) \"%s\"", i, encodedStr);
                buff.append(iteStr);
                buff.append("\n");
                continue;
            }
            buff.append("\"" + encodedStr + "\"");
        }
        for (i = 0; i < 89; ++i) {
            buff.append(")");
        }
        buff.append("\n");
        return buff.toString();
    }

    private static String buildCharToIntFunction() {
        int i;
        StringBuffer buff = new StringBuffer();
        buff.append((Object)((Object)SmtOperation.Operator.CHAR_TO_INT) + "((x!1 String)) Int");
        buff.append("\n");
        for (i = 0; i < 90; ++i) {
            char c = (char)i;
            String str = String.valueOf(c);
            String encodedStr = Z3Solver.encodeString(str);
            if (i < 89) {
                String iteStr = String.format("(ite (= x!1 \"%s\") %s", encodedStr, i);
                buff.append(iteStr);
                buff.append("\n");
                continue;
            }
            buff.append(i);
        }
        for (i = 0; i < 89; ++i) {
            buff.append(")");
        }
        buff.append("\n");
        return buff.toString();
    }

    private static SmtQuery buildSmtQuery(Collection<Constraint<?>> constraints, long timeout) {
        SmtFunctionDefinition newFunctionDef;
        SmtQuery query = new SmtQuery();
        query.addOption(":timeout", String.valueOf(timeout));
        ConstraintToZ3Visitor v = new ConstraintToZ3Visitor();
        SmtVariableCollector varCollector = new SmtVariableCollector();
        SmtOperatorCollector opCollector = new SmtOperatorCollector();
        for (Constraint<?> c : constraints) {
            SmtExpr smtExpr = c.accept(v, null);
            if (smtExpr == null) continue;
            SmtAssertion smtAssertion = new SmtAssertion(smtExpr);
            query.addAssertion(smtAssertion);
            smtExpr.accept(varCollector, null);
            smtExpr.accept(opCollector, null);
        }
        Set<SmtVariable> smtVariables = varCollector.getSmtVariables();
        Set<SmtOperation.Operator> smtOperators = opCollector.getOperators();
        HashSet<SmtVariable> smtVariablesToDeclare = new HashSet<SmtVariable>(smtVariables);
        for (SmtVariable v1 : smtVariablesToDeclare) {
            SmtConstantDeclaration constantDecl;
            String varName = v1.getName();
            if (v1 instanceof SmtIntVariable) {
                constantDecl = SmtExprBuilder.mkIntConstantDeclaration(varName);
                query.addConstantDeclaration(constantDecl);
                continue;
            }
            if (v1 instanceof SmtRealVariable) {
                constantDecl = SmtExprBuilder.mkRealConstantDeclaration(varName);
                query.addConstantDeclaration(constantDecl);
                continue;
            }
            if (v1 instanceof SmtStringVariable) {
                constantDecl = SmtExprBuilder.mkStringConstantDeclaration(varName);
                query.addConstantDeclaration(constantDecl);
                continue;
            }
            throw new RuntimeException("Unknown variable type " + v1.getClass().getCanonicalName());
        }
        if (smtOperators.contains((Object)SmtOperation.Operator.CHAR_TO_INT)) {
            String charToInt = Z3Solver.buildCharToIntFunction();
            newFunctionDef = new SmtFunctionDefinition(charToInt);
            query.addFunctionDefinition(newFunctionDef);
        }
        if (smtOperators.contains((Object)SmtOperation.Operator.INT_TO_CHAR)) {
            String intToChar = Z3Solver.buildIntToCharFunction();
            newFunctionDef = new SmtFunctionDefinition(intToChar);
            query.addFunctionDefinition(newFunctionDef);
        }
        return query;
    }
}

