/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm;

import java.util.Vector;
import org.evosuite.dse.AbstractVM;
import org.evosuite.symbolic.expr.IntegerConstraint;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.bv.IntegerValue;
import org.evosuite.symbolic.expr.ref.ReferenceExpression;
import org.evosuite.symbolic.vm.ConstraintFactory;
import org.evosuite.symbolic.vm.ExpressionFactory;
import org.evosuite.symbolic.vm.PathConditionCollector;
import org.evosuite.symbolic.vm.SymbolicEnvironment;

public final class JumpVM
extends AbstractVM {
    private final SymbolicEnvironment env;
    private final PathConditionCollector pc;

    public JumpVM(SymbolicEnvironment env, PathConditionCollector pc) {
        this.env = env;
        this.pc = pc;
    }

    @Override
    public void IFEQ(String className, String methName, int branchIndex, int p) {
        this.env.topFrame().operandStack.pushBv32(ExpressionFactory.ICONST_0);
        this.IF_ICMPEQ(className, methName, branchIndex, p, 0);
    }

    @Override
    public void IFNE(String className, String methName, int branchIndex, int p) {
        this.IFEQ(className, methName, branchIndex, p);
    }

    @Override
    public void IFLT(String className, String methName, int branchIndex, int p) {
        this.env.topFrame().operandStack.pushBv32(ExpressionFactory.ICONST_0);
        this.IF_ICMPLT(className, methName, branchIndex, p, 0);
    }

    @Override
    public void IFGE(String className, String methName, int branchIndex, int p) {
        this.IFLT(className, methName, branchIndex, p);
    }

    @Override
    public void IFGT(String className, String methName, int branchIndex, int p) {
        IntegerValue rightBv = this.env.topFrame().operandStack.popBv32();
        this.env.topFrame().operandStack.pushBv32(ExpressionFactory.ICONST_0);
        this.env.topFrame().operandStack.pushBv32(rightBv);
        this.IF_ICMPLT(className, methName, branchIndex, 0, p);
    }

    @Override
    public void IFLE(String className, String methName, int branchIndex, int p) {
        this.IFGT(className, methName, branchIndex, p);
    }

    @Override
    public void IF_ICMPEQ(String className, String methName, int branchIndex, int left, int right) {
        IntegerConstraint cnstr;
        boolean isTrueBranch;
        IntegerValue rightOp = this.env.topFrame().operandStack.popBv32();
        IntegerValue leftOp = this.env.topFrame().operandStack.popBv32();
        if (left == right) {
            isTrueBranch = true;
            cnstr = ConstraintFactory.eq(leftOp, rightOp);
        } else {
            isTrueBranch = false;
            cnstr = ConstraintFactory.neq(leftOp, rightOp);
        }
        if (cnstr.getLeftOperand().containsSymbolicVariable() || cnstr.getRightOperand().containsSymbolicVariable()) {
            this.pc.appendIfBranchCondition(className, methName, branchIndex, isTrueBranch, cnstr);
        }
    }

    @Override
    public void IF_ICMPNE(String className, String methName, int branchIndex, int left, int right) {
        this.IF_ICMPEQ(className, methName, branchIndex, left, right);
    }

    @Override
    public void IF_ICMPLT(String className, String methName, int branchIndex, int left, int right) {
        boolean isTrueBranch;
        IntegerConstraint cnstr;
        IntegerValue rightBv = this.env.topFrame().operandStack.popBv32();
        IntegerValue leftBv = this.env.topFrame().operandStack.popBv32();
        if (left < right) {
            cnstr = ConstraintFactory.lt(leftBv, rightBv);
            isTrueBranch = true;
        } else {
            cnstr = ConstraintFactory.gte(leftBv, rightBv);
            isTrueBranch = false;
        }
        if (cnstr.getLeftOperand().containsSymbolicVariable() || cnstr.getRightOperand().containsSymbolicVariable()) {
            this.pc.appendIfBranchCondition(className, methName, branchIndex, isTrueBranch, cnstr);
        }
    }

    @Override
    public void IF_ICMPGE(String className, String methName, int branchIndex, int left, int right) {
        this.IF_ICMPLT(className, methName, branchIndex, left, right);
    }

    @Override
    public void IF_ICMPGT(String className, String methName, int branchIndex, int left, int right) {
        IntegerValue rightBv = this.env.topFrame().operandStack.popBv32();
        IntegerValue leftBv = this.env.topFrame().operandStack.popBv32();
        this.env.topFrame().operandStack.pushBv32(rightBv);
        this.env.topFrame().operandStack.pushBv32(leftBv);
        this.IF_ICMPLT(className, methName, branchIndex, right, left);
    }

    @Override
    public void IF_ICMPLE(String className, String methName, int branchIndex, int left, int right) {
        this.IF_ICMPGT(className, methName, branchIndex, left, right);
    }

    @Override
    public void IF_ACMPEQ(String className, String methName, int branchIndex, Object conc_left, Object conc_right) {
        ReferenceExpression right_ref = this.env.topFrame().operandStack.popRef();
        ReferenceExpression left_ref = this.env.topFrame().operandStack.popRef();
        this.env.heap.initializeReference(conc_left, left_ref);
        this.env.heap.initializeReference(conc_right, right_ref);
    }

    @Override
    public void IF_ACMPNE(String className, String methName, int branchIndex, Object left, Object right) {
        this.IF_ACMPEQ(className, methName, branchIndex, left, right);
    }

    @Override
    public void IFNULL(String className, String methName, int branchIndex, Object p) {
        this.env.topFrame().operandStack.pushNullRef();
        this.IF_ACMPEQ(className, methName, branchIndex, p, null);
    }

    @Override
    public void IFNONNULL(String className, String methName, int branchIndex, Object p) {
        this.IFNULL(className, methName, branchIndex, p);
    }

    @Override
    public void TABLESWITCH(String className, String methName, int branchIndex, int goalConcrete, int minGoalValue, int maxGoalValue) {
        IntegerValue value = this.env.topFrame().operandStack.popBv32();
        Vector<IntegerConstraint> constraints = new Vector<IntegerConstraint>();
        boolean isDefaultGoal = true;
        for (int goalValue = minGoalValue; goalValue <= maxGoalValue; ++goalValue) {
            IntegerConstraint constraint;
            IntegerConstant literal = ExpressionFactory.buildNewIntegerConstant(goalValue);
            if (goalConcrete == goalValue) {
                constraint = ConstraintFactory.eq(value, literal);
                constraints.add(constraint);
                isDefaultGoal = false;
                break;
            }
            constraint = ConstraintFactory.neq(value, literal);
            constraints.add(constraint);
        }
        for (int i = 0; i < constraints.size() - 1; ++i) {
            IntegerConstraint cnstrt = (IntegerConstraint)constraints.get(i);
            if (!cnstrt.getLeftOperand().containsSymbolicVariable() && !cnstrt.getRightOperand().containsSymbolicVariable()) continue;
            this.pc.appendSupportingConstraint(cnstrt);
        }
        IntegerConstraint cnstr = (IntegerConstraint)constraints.get(constraints.size() - 1);
        if (cnstr.getLeftOperand().containsSymbolicVariable() || cnstr.getRightOperand().containsSymbolicVariable()) {
            if (isDefaultGoal) {
                this.pc.appendDefaultSwitchBranchCondition(className, methName, branchIndex, cnstr);
            } else {
                this.pc.appendSwitchBranchCondition(className, methName, branchIndex, cnstr, goalConcrete);
            }
        }
    }

    @Override
    public void LOOKUPSWITCH(String className, String methName, int branchIndex, int goalConcrete, int[] targetsConcrete) {
        IntegerValue goal = this.env.topFrame().operandStack.popBv32();
        Vector<IntegerConstraint> constraints = new Vector<IntegerConstraint>();
        boolean isDefaultGoal = true;
        for (int targetConcrete : targetsConcrete) {
            IntegerConstraint constraint;
            IntegerConstant integerConstant = ExpressionFactory.buildNewIntegerConstant(targetConcrete);
            if (goalConcrete == targetConcrete) {
                constraint = ConstraintFactory.eq(goal, integerConstant);
                constraints.add(constraint);
                isDefaultGoal = false;
                break;
            }
            constraint = ConstraintFactory.neq(goal, integerConstant);
            constraints.add(constraint);
        }
        for (int i = 0; i < constraints.size() - 1; ++i) {
            IntegerConstraint cnstrnt = (IntegerConstraint)constraints.get(i);
            if (!cnstrnt.getLeftOperand().containsSymbolicVariable() && !cnstrnt.getRightOperand().containsSymbolicVariable()) continue;
            this.pc.appendSupportingConstraint(cnstrnt);
        }
        IntegerConstraint cnstr = (IntegerConstraint)constraints.get(constraints.size() - 1);
        if (cnstr.getLeftOperand().containsSymbolicVariable() || cnstr.getRightOperand().containsSymbolicVariable()) {
            if (isDefaultGoal) {
                this.pc.appendDefaultSwitchBranchCondition(className, methName, branchIndex, cnstr);
            } else {
                this.pc.appendSwitchBranchCondition(className, methName, branchIndex, cnstr, goalConcrete);
            }
        }
    }

    @Override
    public void GOTO() {
    }

    @Override
    public void GOTO_W() {
        this.GOTO();
    }

    @Override
    public void ATHROW(Throwable throwable) {
        this.env.topFrame().operandStack.popRef();
    }

    @Override
    public void JSR() {
        throw new UnsupportedOperationException("Implement ME!");
    }

    @Override
    public void JSR_W() {
        this.JSR();
    }

    @Override
    public void RET() {
    }
}

