/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.vm;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.evosuite.dse.AbstractVM;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.symbolic.expr.IntegerConstraint;
import org.evosuite.symbolic.expr.bv.IntegerValue;
import org.evosuite.symbolic.expr.fp.RealValue;
import org.evosuite.symbolic.expr.ref.ReferenceExpression;
import org.evosuite.symbolic.vm.IntegerOperand;
import org.evosuite.symbolic.vm.Operand;
import org.evosuite.symbolic.vm.PathConditionCollector;
import org.evosuite.symbolic.vm.RealOperand;
import org.evosuite.symbolic.vm.ReferenceOperand;
import org.evosuite.symbolic.vm.SymbolicEnvironment;
import org.evosuite.symbolic.vm.SymbolicFunction;
import org.evosuite.symbolic.vm.apache.regex.Perl5Matcher_Matches;
import org.evosuite.symbolic.vm.bigint.BigInteger_Ctor;
import org.evosuite.symbolic.vm.bigint.BigInteger_DivideAndRemainder;
import org.evosuite.symbolic.vm.bigint.BigInteger_IntValue;
import org.evosuite.symbolic.vm.math.ABS;
import org.evosuite.symbolic.vm.math.ACOS;
import org.evosuite.symbolic.vm.math.ASIN;
import org.evosuite.symbolic.vm.math.ATAN;
import org.evosuite.symbolic.vm.math.ATAN2;
import org.evosuite.symbolic.vm.math.CBRT;
import org.evosuite.symbolic.vm.math.CEIL;
import org.evosuite.symbolic.vm.math.COS;
import org.evosuite.symbolic.vm.math.COSH;
import org.evosuite.symbolic.vm.math.CopySign;
import org.evosuite.symbolic.vm.math.EXP;
import org.evosuite.symbolic.vm.math.EXPM1;
import org.evosuite.symbolic.vm.math.FLOOR;
import org.evosuite.symbolic.vm.math.GetExponent;
import org.evosuite.symbolic.vm.math.HYPOT;
import org.evosuite.symbolic.vm.math.IEEEremainder;
import org.evosuite.symbolic.vm.math.LOG;
import org.evosuite.symbolic.vm.math.LOG10;
import org.evosuite.symbolic.vm.math.LOG1P;
import org.evosuite.symbolic.vm.math.MAX;
import org.evosuite.symbolic.vm.math.MIN;
import org.evosuite.symbolic.vm.math.NextAfter;
import org.evosuite.symbolic.vm.math.NextUp;
import org.evosuite.symbolic.vm.math.POW;
import org.evosuite.symbolic.vm.math.RINT;
import org.evosuite.symbolic.vm.math.Round;
import org.evosuite.symbolic.vm.math.SCALB;
import org.evosuite.symbolic.vm.math.SIGNUM;
import org.evosuite.symbolic.vm.math.SIN;
import org.evosuite.symbolic.vm.math.SINH;
import org.evosuite.symbolic.vm.math.SQRT;
import org.evosuite.symbolic.vm.math.TAN;
import org.evosuite.symbolic.vm.math.TANH;
import org.evosuite.symbolic.vm.math.ToDegrees;
import org.evosuite.symbolic.vm.math.ToRadians;
import org.evosuite.symbolic.vm.math.ULP;
import org.evosuite.symbolic.vm.regex.Matcher_Matches;
import org.evosuite.symbolic.vm.regex.Pattern_Matcher;
import org.evosuite.symbolic.vm.regex.Pattern_Matches;
import org.evosuite.symbolic.vm.string.CharAt;
import org.evosuite.symbolic.vm.string.CompareTo;
import org.evosuite.symbolic.vm.string.CompareToIgnoreCase;
import org.evosuite.symbolic.vm.string.Concat;
import org.evosuite.symbolic.vm.string.Contains;
import org.evosuite.symbolic.vm.string.EndsWith;
import org.evosuite.symbolic.vm.string.Equals;
import org.evosuite.symbolic.vm.string.EqualsIgnoreCase;
import org.evosuite.symbolic.vm.string.IndexOf;
import org.evosuite.symbolic.vm.string.LastIndexOf;
import org.evosuite.symbolic.vm.string.Length;
import org.evosuite.symbolic.vm.string.Matches;
import org.evosuite.symbolic.vm.string.RegionMatches;
import org.evosuite.symbolic.vm.string.RegionMatches5;
import org.evosuite.symbolic.vm.string.Replace;
import org.evosuite.symbolic.vm.string.ReplaceAll;
import org.evosuite.symbolic.vm.string.ReplaceFirst;
import org.evosuite.symbolic.vm.string.StartsWith;
import org.evosuite.symbolic.vm.string.Substring;
import org.evosuite.symbolic.vm.string.ToLowerCase;
import org.evosuite.symbolic.vm.string.ToString;
import org.evosuite.symbolic.vm.string.ToUpperCase;
import org.evosuite.symbolic.vm.string.Trim;
import org.evosuite.symbolic.vm.string.ValueOf;
import org.evosuite.symbolic.vm.string.buffer.StringBuffer_Append;
import org.evosuite.symbolic.vm.string.buffer.StringBuffer_Init;
import org.evosuite.symbolic.vm.string.buffer.StringBuffer_SetLength;
import org.evosuite.symbolic.vm.string.buffer.StringBuffer_ToString;
import org.evosuite.symbolic.vm.string.builder.StringBuilder_Append;
import org.evosuite.symbolic.vm.string.builder.StringBuilder_Init;
import org.evosuite.symbolic.vm.string.builder.StringBuilder_ToString;
import org.evosuite.symbolic.vm.string.reader.Reader_Read;
import org.evosuite.symbolic.vm.string.reader.StringReader_Init;
import org.evosuite.symbolic.vm.string.reader.StringReader_Read;
import org.evosuite.symbolic.vm.string.tokenizer.HasMoreTokens;
import org.evosuite.symbolic.vm.string.tokenizer.NextToken;
import org.evosuite.symbolic.vm.string.tokenizer.StringTokenizer_Init;
import org.evosuite.symbolic.vm.wrappers.B_ByteValue;
import org.evosuite.symbolic.vm.wrappers.B_Init;
import org.evosuite.symbolic.vm.wrappers.B_ValueOf;
import org.evosuite.symbolic.vm.wrappers.C_CharValue;
import org.evosuite.symbolic.vm.wrappers.C_Init;
import org.evosuite.symbolic.vm.wrappers.C_ValueOf;
import org.evosuite.symbolic.vm.wrappers.Character_getNumericValue;
import org.evosuite.symbolic.vm.wrappers.Character_isDigit;
import org.evosuite.symbolic.vm.wrappers.Character_isLetter;
import org.evosuite.symbolic.vm.wrappers.D_DoubleValue;
import org.evosuite.symbolic.vm.wrappers.D_Init;
import org.evosuite.symbolic.vm.wrappers.D_ValueOf;
import org.evosuite.symbolic.vm.wrappers.F_FloatValue;
import org.evosuite.symbolic.vm.wrappers.F_Init;
import org.evosuite.symbolic.vm.wrappers.F_ValueOf;
import org.evosuite.symbolic.vm.wrappers.I_Init;
import org.evosuite.symbolic.vm.wrappers.I_IntValue;
import org.evosuite.symbolic.vm.wrappers.I_ParseInt;
import org.evosuite.symbolic.vm.wrappers.I_ValueOf;
import org.evosuite.symbolic.vm.wrappers.J_Init;
import org.evosuite.symbolic.vm.wrappers.J_LongValue;
import org.evosuite.symbolic.vm.wrappers.J_ValueOf;
import org.evosuite.symbolic.vm.wrappers.S_Init;
import org.evosuite.symbolic.vm.wrappers.S_ShortValue;
import org.evosuite.symbolic.vm.wrappers.S_ValueOf;
import org.evosuite.symbolic.vm.wrappers.Z_BooleanValue;
import org.evosuite.symbolic.vm.wrappers.Z_Init;
import org.evosuite.symbolic.vm.wrappers.Z_ValueOf;

public final class SymbolicFunctionVM
extends AbstractVM {
    private final SymbolicEnvironment env;
    private final PathConditionCollector pc;
    private final Map<FunctionKey, SymbolicFunction> functionsTable = new HashMap<FunctionKey, SymbolicFunction>();
    private SymbolicFunction functionUnderExecution;

    public SymbolicFunctionVM(SymbolicEnvironment env, PathConditionCollector pc) {
        this.env = env;
        this.pc = pc;
        this.fillFunctionsTable();
    }

    private void fillFunctionsTable() {
        this.addFunctionToTable(new StringBuffer_Init.StringBufferInit_S(this.env));
        this.addFunctionToTable(new StringBuffer_ToString(this.env));
        this.addFunctionToTable(new StringBuffer_Append.StringBufferAppend_B(this.env));
        this.addFunctionToTable(new StringBuffer_Append.StringBufferAppend_C(this.env));
        this.addFunctionToTable(new StringBuffer_Append.StringBufferAppend_I(this.env));
        this.addFunctionToTable(new StringBuffer_Append.StringBufferAppend_L(this.env));
        this.addFunctionToTable(new StringBuffer_Append.StringBufferAppend_F(this.env));
        this.addFunctionToTable(new StringBuffer_Append.StringBufferAppend_D(this.env));
        this.addFunctionToTable(new StringBuffer_Append.StringBufferAppend_STR(this.env));
        this.addFunctionToTable(new StringBuffer_SetLength(this.env));
        this.addFunctionToTable(new I_Init(this.env));
        this.addFunctionToTable(new I_ValueOf(this.env));
        this.addFunctionToTable(new I_IntValue(this.env));
        this.addFunctionToTable(new I_ParseInt(this.env));
        this.addFunctionToTable(new J_Init(this.env));
        this.addFunctionToTable(new J_ValueOf(this.env));
        this.addFunctionToTable(new J_LongValue(this.env));
        this.addFunctionToTable(new F_Init(this.env));
        this.addFunctionToTable(new F_ValueOf(this.env));
        this.addFunctionToTable(new F_FloatValue(this.env));
        this.addFunctionToTable(new D_Init(this.env));
        this.addFunctionToTable(new D_ValueOf(this.env));
        this.addFunctionToTable(new D_DoubleValue(this.env));
        this.addFunctionToTable(new S_Init(this.env));
        this.addFunctionToTable(new S_ValueOf(this.env));
        this.addFunctionToTable(new S_ShortValue(this.env));
        this.addFunctionToTable(new B_Init(this.env));
        this.addFunctionToTable(new B_ValueOf(this.env));
        this.addFunctionToTable(new B_ByteValue(this.env));
        this.addFunctionToTable(new C_Init(this.env));
        this.addFunctionToTable(new C_ValueOf(this.env));
        this.addFunctionToTable(new C_CharValue(this.env));
        this.addFunctionToTable(new Character_getNumericValue(this.env));
        this.addFunctionToTable(new Character_isDigit(this.env));
        this.addFunctionToTable(new Character_isLetter(this.env));
        this.addFunctionToTable(new Z_Init(this.env));
        this.addFunctionToTable(new Z_ValueOf(this.env));
        this.addFunctionToTable(new Z_BooleanValue(this.env));
        this.addFunctionToTable(new ABS.ABS_I(this.env));
        this.addFunctionToTable(new ABS.ABS_L(this.env));
        this.addFunctionToTable(new ABS.ABS_F(this.env));
        this.addFunctionToTable(new ABS.ABS_D(this.env));
        this.addFunctionToTable(new ACOS(this.env));
        this.addFunctionToTable(new ASIN(this.env));
        this.addFunctionToTable(new ATAN(this.env));
        this.addFunctionToTable(new ATAN2(this.env));
        this.addFunctionToTable(new CBRT(this.env));
        this.addFunctionToTable(new CEIL(this.env));
        this.addFunctionToTable(new CopySign.CopySign_F(this.env));
        this.addFunctionToTable(new CopySign.CopySign_D(this.env));
        this.addFunctionToTable(new COS(this.env));
        this.addFunctionToTable(new COSH(this.env));
        this.addFunctionToTable(new EXP(this.env));
        this.addFunctionToTable(new EXPM1(this.env));
        this.addFunctionToTable(new FLOOR(this.env));
        this.addFunctionToTable(new GetExponent.GetExponent_F(this.env));
        this.addFunctionToTable(new GetExponent.GetExponent_D(this.env));
        this.addFunctionToTable(new HYPOT(this.env));
        this.addFunctionToTable(new IEEEremainder(this.env));
        this.addFunctionToTable(new LOG(this.env));
        this.addFunctionToTable(new LOG10(this.env));
        this.addFunctionToTable(new LOG1P(this.env));
        this.addFunctionToTable(new MIN.MIN_I(this.env));
        this.addFunctionToTable(new MIN.MIN_L(this.env));
        this.addFunctionToTable(new MIN.MIN_F(this.env));
        this.addFunctionToTable(new MIN.MIN_D(this.env));
        this.addFunctionToTable(new MAX.MAX_I(this.env));
        this.addFunctionToTable(new MAX.MAX_L(this.env));
        this.addFunctionToTable(new MAX.MAX_F(this.env));
        this.addFunctionToTable(new MAX.MAX_D(this.env));
        this.addFunctionToTable(new NextAfter.NextAfter_F(this.env));
        this.addFunctionToTable(new NextAfter.NextAfter_D(this.env));
        this.addFunctionToTable(new NextUp.NextUp_F(this.env));
        this.addFunctionToTable(new NextUp.NextUp_D(this.env));
        this.addFunctionToTable(new POW(this.env));
        this.addFunctionToTable(new RINT(this.env));
        this.addFunctionToTable(new Round.Round_F(this.env));
        this.addFunctionToTable(new Round.Round_D(this.env));
        this.addFunctionToTable(new SCALB.SCALB_F(this.env));
        this.addFunctionToTable(new SCALB.SCALB_D(this.env));
        this.addFunctionToTable(new SIGNUM.SIGNUM_F(this.env));
        this.addFunctionToTable(new SIGNUM.SIGNUM_D(this.env));
        this.addFunctionToTable(new SIN(this.env));
        this.addFunctionToTable(new SINH(this.env));
        this.addFunctionToTable(new SQRT(this.env));
        this.addFunctionToTable(new TAN(this.env));
        this.addFunctionToTable(new TANH(this.env));
        this.addFunctionToTable(new ToDegrees(this.env));
        this.addFunctionToTable(new ToRadians(this.env));
        this.addFunctionToTable(new ULP.ULP_F(this.env));
        this.addFunctionToTable(new ULP.ULP_D(this.env));
        this.addFunctionToTable(new CharAt(this.env));
        this.addFunctionToTable(new CompareTo(this.env));
        this.addFunctionToTable(new CompareToIgnoreCase(this.env));
        this.addFunctionToTable(new Concat(this.env));
        this.addFunctionToTable(new Contains(this.env));
        this.addFunctionToTable(new EndsWith(this.env));
        this.addFunctionToTable(new Equals(this.env));
        this.addFunctionToTable(new EqualsIgnoreCase(this.env));
        this.addFunctionToTable(new IndexOf.IndexOf_C(this.env));
        this.addFunctionToTable(new IndexOf.IndexOf_S(this.env));
        this.addFunctionToTable(new IndexOf.IndexOf_CI(this.env));
        this.addFunctionToTable(new IndexOf.IndexOf_SI(this.env));
        this.addFunctionToTable(new LastIndexOf.LastIndexOf_C(this.env));
        this.addFunctionToTable(new LastIndexOf.LastIndexOf_S(this.env));
        this.addFunctionToTable(new LastIndexOf.LastIndexOf_CI(this.env));
        this.addFunctionToTable(new LastIndexOf.LastIndexOf_SI(this.env));
        this.addFunctionToTable(new Length(this.env));
        this.addFunctionToTable(new Matches(this.env));
        this.addFunctionToTable(new RegionMatches(this.env));
        this.addFunctionToTable(new RegionMatches5(this.env));
        this.addFunctionToTable(new Replace.Replace_C(this.env));
        this.addFunctionToTable(new Replace.Replace_CS(this.env));
        this.addFunctionToTable(new ReplaceAll(this.env));
        this.addFunctionToTable(new ReplaceFirst(this.env));
        this.addFunctionToTable(new StartsWith.StartsWith_S(this.env));
        this.addFunctionToTable(new StartsWith.StartsWith_SI(this.env));
        this.addFunctionToTable(new Substring.Substring_I(this.env));
        this.addFunctionToTable(new Substring.Substring_II(this.env));
        this.addFunctionToTable(new ToLowerCase(this.env));
        this.addFunctionToTable(new ToString(this.env));
        this.addFunctionToTable(new ToUpperCase(this.env));
        this.addFunctionToTable(new Trim(this.env));
        this.addFunctionToTable(new ValueOf.ValueOf_O(this.env));
        this.addFunctionToTable(new ValueOf.ValueOf_I(this.env));
        this.addFunctionToTable(new ValueOf.ValueOf_J(this.env));
        this.addFunctionToTable(new ValueOf.ValueOf_C(this.env));
        this.addFunctionToTable(new ValueOf.ValueOf_B(this.env));
        this.addFunctionToTable(new StringBuilder_Init(this.env));
        this.addFunctionToTable(new StringBuilder_Append.Append_B(this.env));
        this.addFunctionToTable(new StringBuilder_Append.Append_C(this.env));
        this.addFunctionToTable(new StringBuilder_Append.Append_D(this.env));
        this.addFunctionToTable(new StringBuilder_Append.Append_F(this.env));
        this.addFunctionToTable(new StringBuilder_Append.Append_I(this.env));
        this.addFunctionToTable(new StringBuilder_Append.Append_L(this.env));
        this.addFunctionToTable(new StringBuilder_Append.Append_O(this.env));
        this.addFunctionToTable(new StringBuilder_Append.Append_S(this.env));
        this.addFunctionToTable(new StringBuilder_ToString(this.env));
        this.addFunctionToTable(new StringTokenizer_Init(this.env));
        this.addFunctionToTable(new HasMoreTokens(this.env));
        this.addFunctionToTable(new NextToken(this.env));
        this.addFunctionToTable(new StringReader_Init(this.env));
        this.addFunctionToTable(new StringReader_Read(this.env));
        this.addFunctionToTable(new Reader_Read(this.env));
        this.addFunctionToTable(new Pattern_Matches(this.env));
        this.addFunctionToTable(new Pattern_Matcher(this.env));
        this.addFunctionToTable(new Matcher_Matches(this.env));
        this.addFunctionToTable(new Perl5Matcher_Matches(this.env));
        this.addFunctionToTable(new BigInteger_Ctor(this.env));
        this.addFunctionToTable(new BigInteger_IntValue(this.env));
        this.addFunctionToTable(new BigInteger_DivideAndRemainder(this.env));
    }

    private void addFunctionToTable(SymbolicFunction f) {
        FunctionKey k = new FunctionKey(f.getOwner(), f.getName(), f.getDesc());
        this.functionsTable.put(k, f);
    }

    @Override
    public void INVOKESTATIC(String owner, String name, String desc) {
        this.functionUnderExecution = this.getFunction(owner, name, desc);
        if (this.functionUnderExecution != null && Type.getArgumentTypes(desc).length == 0) {
            this.callBeforeExecution(this.functionUnderExecution);
        }
    }

    @Override
    public void INVOKEVIRTUAL(Object conc_receiver, String owner, String name, String desc) {
        this.functionUnderExecution = this.getFunction(owner, name, desc);
        if (this.functionUnderExecution != null) {
            ReferenceExpression symb_receiver = this.getReceiverFromStack();
            this.functionUnderExecution.setReceiver(conc_receiver, symb_receiver);
            if (Type.getArgumentTypes(desc).length == 0) {
                this.callBeforeExecution(this.functionUnderExecution);
            }
        }
    }

    private ReferenceExpression getReceiverFromStack() {
        String desc = this.functionUnderExecution.getDesc();
        Type[] argTypes = Type.getArgumentTypes(desc);
        Iterator<Operand> it = this.env.topFrame().operandStack.iterator();
        for (int i = 0; i < argTypes.length; ++i) {
            it.next();
        }
        Operand op = it.next();
        return ((ReferenceOperand)op).getReference();
    }

    private Operand getOperandFromStack(int nr) {
        String desc = this.functionUnderExecution.getDesc();
        Type[] argTypes = Type.getArgumentTypes(desc);
        int moves = argTypes.length - 1 - nr;
        Iterator<Operand> it = this.env.topFrame().operandStack.iterator();
        for (int i = 0; i < moves; ++i) {
            it.next();
        }
        Operand op = it.next();
        return op;
    }

    private IntegerValue getIntegerExprFromStack(int nr) {
        IntegerOperand op = (IntegerOperand)this.getOperandFromStack(nr);
        return op.getIntegerExpression();
    }

    private RealValue getRealExprFromStack(int moves) {
        RealOperand op = (RealOperand)this.getOperandFromStack(moves);
        return op.getRealExpression();
    }

    private ReferenceExpression getReferenceFromStack(int moves) {
        ReferenceOperand op = (ReferenceOperand)this.getOperandFromStack(moves);
        return op.getReference();
    }

    private SymbolicFunction getFunction(String owner, String name, String desc) {
        FunctionKey k = new FunctionKey(owner, name, desc);
        SymbolicFunction f = this.functionsTable.get(k);
        return f;
    }

    @Override
    public void CALL_RESULT(int conc_ret_val, String owner, String name, String desc) {
        if (!(this.functionUnderExecution == null || this.functionUnderExecution.getOwner().equals(owner) && this.functionUnderExecution.getName().equals(name) && this.functionUnderExecution.getDesc().equals(desc))) {
            this.functionUnderExecution = null;
        }
        if (this.functionUnderExecution != null) {
            IntegerValue symb_ret_val = this.env.topFrame().operandStack.peekBv32();
            this.functionUnderExecution.setReturnValue(conc_ret_val, symb_ret_val);
            IntegerValue new_symb_ret_val = (IntegerValue)this.functionUnderExecution.executeFunction();
            this.replaceTopBv32(new_symb_ret_val);
        }
        this.functionUnderExecution = null;
    }

    @Override
    public void CALL_RESULT(Object conc_ret_val, String owner, String name, String desc) {
        if (!(this.functionUnderExecution == null || this.functionUnderExecution.getOwner().equals(owner) && this.functionUnderExecution.getName().equals(name) && this.functionUnderExecution.getDesc().equals(desc))) {
            this.functionUnderExecution = null;
        }
        if (this.functionUnderExecution != null) {
            ReferenceExpression symb_ret_val = this.env.topFrame().operandStack.peekRef();
            this.functionUnderExecution.setReturnValue(conc_ret_val, symb_ret_val);
            ReferenceExpression new_symb_ret_val = (ReferenceExpression)this.functionUnderExecution.executeFunction();
            this.replaceTopRef(new_symb_ret_val);
        }
        this.functionUnderExecution = null;
    }

    private void replaceTopRef(ReferenceExpression ref) {
        this.env.topFrame().operandStack.popRef();
        this.env.topFrame().operandStack.pushRef(ref);
    }

    @Override
    public void CALL_RESULT(String owner, String name, String desc) {
        if (!(this.functionUnderExecution == null || this.functionUnderExecution.getOwner().equals(owner) && this.functionUnderExecution.getName().equals(name) && this.functionUnderExecution.getDesc().equals(desc))) {
            this.functionUnderExecution = null;
        }
        if (this.functionUnderExecution != null) {
            this.functionUnderExecution.executeFunction();
        }
        this.functionUnderExecution = null;
    }

    @Override
    public void CALL_RESULT(boolean conc_ret_val, String owner, String name, String desc) {
        if (!(this.functionUnderExecution == null || this.functionUnderExecution.getOwner().equals(owner) && this.functionUnderExecution.getName().equals(name) && this.functionUnderExecution.getDesc().equals(desc))) {
            this.functionUnderExecution = null;
        }
        if (this.functionUnderExecution != null) {
            IntegerValue symb_ret_val = this.env.topFrame().operandStack.peekBv32();
            this.functionUnderExecution.setReturnValue(conc_ret_val, symb_ret_val);
            IntegerValue new_symb_ret_val = (IntegerValue)this.functionUnderExecution.executeFunction();
            this.replaceTopBv32(new_symb_ret_val);
        }
        this.functionUnderExecution = null;
    }

    @Override
    public void CALL_RESULT(long conc_ret_val, String owner, String name, String desc) {
        if (!(this.functionUnderExecution == null || this.functionUnderExecution.getOwner().equals(owner) && this.functionUnderExecution.getName().equals(name) && this.functionUnderExecution.getDesc().equals(desc))) {
            this.functionUnderExecution = null;
        }
        if (this.functionUnderExecution != null) {
            IntegerValue symb_ret_val = this.env.topFrame().operandStack.peekBv64();
            this.functionUnderExecution.setReturnValue(conc_ret_val, symb_ret_val);
            IntegerValue new_symb_ret_val = (IntegerValue)this.functionUnderExecution.executeFunction();
            this.replaceTopBv64(new_symb_ret_val);
        }
        this.functionUnderExecution = null;
    }

    @Override
    public void CALL_RESULT(double conc_ret_val, String owner, String name, String desc) {
        if (!(this.functionUnderExecution == null || this.functionUnderExecution.getOwner().equals(owner) && this.functionUnderExecution.getName().equals(name) && this.functionUnderExecution.getDesc().equals(desc))) {
            this.functionUnderExecution = null;
        }
        if (this.functionUnderExecution != null) {
            RealValue symb_ret_val = this.env.topFrame().operandStack.peekFp64();
            this.functionUnderExecution.setReturnValue(conc_ret_val, symb_ret_val);
            RealValue new_symb_ret_val = (RealValue)this.functionUnderExecution.executeFunction();
            this.replaceTopFp64(new_symb_ret_val);
        }
        this.functionUnderExecution = null;
    }

    @Override
    public void CALL_RESULT(float conc_ret_val, String owner, String name, String desc) {
        if (!(this.functionUnderExecution == null || this.functionUnderExecution.getOwner().equals(owner) && this.functionUnderExecution.getName().equals(name) && this.functionUnderExecution.getDesc().equals(desc))) {
            this.functionUnderExecution = null;
        }
        if (this.functionUnderExecution != null) {
            RealValue symb_ret_val = this.env.topFrame().operandStack.peekFp32();
            this.functionUnderExecution.setReturnValue(conc_ret_val, symb_ret_val);
            RealValue new_symb_ret_val = (RealValue)this.functionUnderExecution.executeFunction();
            this.replaceTopFp32(new_symb_ret_val);
        }
        this.functionUnderExecution = null;
    }

    @Override
    public void INVOKESPECIAL(String owner, String name, String desc) {
        this.functionUnderExecution = this.getFunction(owner, name, desc);
        if (this.functionUnderExecution != null) {
            ReferenceExpression symb_receiver = this.getReceiverFromStack();
            this.functionUnderExecution.setReceiver(null, symb_receiver);
            if (Type.getArgumentTypes(desc).length == 0) {
                this.callBeforeExecution(this.functionUnderExecution);
            }
        }
    }

    private void callBeforeExecution(SymbolicFunction myFunctionUnderExecution) {
        IntegerConstraint constraint = myFunctionUnderExecution.beforeExecuteFunction();
        if (constraint != null) {
            this.pc.appendSupportingConstraint(constraint);
        }
    }

    @Override
    public void INVOKESPECIAL(Object conc_receiver, String owner, String name, String desc) {
        this.functionUnderExecution = this.getFunction(owner, name, desc);
        if (this.functionUnderExecution != null) {
            ReferenceExpression symb_receiver = this.getReceiverFromStack();
            this.functionUnderExecution.setReceiver(conc_receiver, symb_receiver);
            if (Type.getArgumentTypes(desc).length == 0) {
                this.callBeforeExecution(this.functionUnderExecution);
            }
        }
    }

    @Override
    public void INVOKEINTERFACE(Object conc_receiver, String owner, String name, String desc) {
        this.functionUnderExecution = this.getFunction(owner, name, desc);
        if (this.functionUnderExecution != null) {
            ReferenceExpression symb_receiver = this.getReceiverFromStack();
            this.functionUnderExecution.setReceiver(conc_receiver, symb_receiver);
            if (Type.getArgumentTypes(this.functionUnderExecution.getDesc()).length == 0) {
                this.callBeforeExecution(this.functionUnderExecution);
            }
        }
    }

    @Override
    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, int conc_arg) {
        if (this.functionUnderExecution != null) {
            IntegerValue symb_arg = this.getIntegerExprFromStack(nr);
            this.functionUnderExecution.setParam(nr, conc_arg, symb_arg);
            this.beforeExecuteFunction(nr);
        }
    }

    @Override
    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, boolean conc_arg) {
        if (this.functionUnderExecution != null) {
            IntegerValue symb_arg = this.getIntegerExprFromStack(nr);
            this.functionUnderExecution.setParam(nr, conc_arg, symb_arg);
            this.beforeExecuteFunction(nr);
        }
    }

    private void beforeExecuteFunction(int nr) {
        if (nr == 0) {
            this.callBeforeExecution(this.functionUnderExecution);
        }
    }

    @Override
    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, short conc_arg) {
        if (this.functionUnderExecution != null) {
            IntegerValue symb_arg = this.getIntegerExprFromStack(nr);
            this.functionUnderExecution.setParam(nr, conc_arg, symb_arg);
            this.beforeExecuteFunction(nr);
        }
    }

    @Override
    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, byte conc_arg) {
        if (this.functionUnderExecution != null) {
            IntegerValue symb_arg = this.getIntegerExprFromStack(nr);
            this.functionUnderExecution.setParam(nr, conc_arg, symb_arg);
            this.beforeExecuteFunction(nr);
        }
    }

    @Override
    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, char conc_arg) {
        if (this.functionUnderExecution != null) {
            IntegerValue symb_arg = this.getIntegerExprFromStack(nr);
            this.functionUnderExecution.setParam(nr, conc_arg, symb_arg);
            this.beforeExecuteFunction(nr);
        }
    }

    @Override
    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, long conc_arg) {
        if (this.functionUnderExecution != null) {
            IntegerValue symb_arg = this.getIntegerExprFromStack(nr);
            this.functionUnderExecution.setParam(nr, conc_arg, symb_arg);
            this.beforeExecuteFunction(nr);
        }
    }

    @Override
    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, float conc_arg) {
        if (this.functionUnderExecution != null) {
            RealValue symb_arg = this.getRealExprFromStack(nr);
            this.functionUnderExecution.setParam(nr, conc_arg, symb_arg);
            this.beforeExecuteFunction(nr);
        }
    }

    @Override
    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, double conc_arg) {
        if (this.functionUnderExecution != null) {
            RealValue symb_arg = this.getRealExprFromStack(nr);
            this.functionUnderExecution.setParam(nr, conc_arg, symb_arg);
            this.beforeExecuteFunction(nr);
        }
    }

    @Override
    public void CALLER_STACK_PARAM(int nr, int calleeLocalsIndex, Object conc_arg) {
        if (this.functionUnderExecution != null) {
            ReferenceExpression symb_arg = this.getReferenceFromStack(nr);
            this.functionUnderExecution.setParam(nr, conc_arg, symb_arg);
            this.beforeExecuteFunction(nr);
        }
    }

    private void replaceTopBv32(IntegerValue expr) {
        this.env.topFrame().operandStack.popBv32();
        this.env.topFrame().operandStack.pushBv32(expr);
    }

    private void replaceTopBv64(IntegerValue expr) {
        this.env.topFrame().operandStack.popBv64();
        this.env.topFrame().operandStack.pushBv64(expr);
    }

    private void replaceTopFp32(RealValue expr) {
        this.env.topFrame().operandStack.popFp32();
        this.env.topFrame().operandStack.pushFp32(expr);
    }

    private void replaceTopFp64(RealValue expr) {
        this.env.topFrame().operandStack.popFp64();
        this.env.topFrame().operandStack.pushFp64(expr);
    }

    private static class FunctionKey {
        public String owner;
        public String name;
        public String desc;

        public FunctionKey(String owner, String name, String desc) {
            this.owner = owner;
            this.name = name;
            this.desc = desc;
        }

        public int hashCode() {
            return this.owner.hashCode() + this.name.hashCode() + this.desc.hashCode();
        }

        public boolean equals(Object o) {
            if (o == null || !o.getClass().equals(FunctionKey.class)) {
                return false;
            }
            FunctionKey that = (FunctionKey)o;
            return this.owner.equals(that.owner) && this.name.equals(that.name) && this.desc.equals(that.desc);
        }
    }
}

