/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcarver.capture;

import com.thoughtworks.xstream.XStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.PackageInfo;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.testcarver.instrument.TransformerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CaptureLog
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(CaptureLog.class);
    public static final Object[] NO_ARGS = new Object[0];
    public static final String OBSERVED_INIT = "<init>";
    public static final String PLAIN_INIT = CaptureLog.class.getName() + ".PLAIN";
    public static final String COLLECTION_INIT = CaptureLog.class.getName() + ".COLLECTION";
    public static final String MAP_INIT = CaptureLog.class.getName() + ".MAP";
    public static final String ARRAY_INIT = CaptureLog.class.getName() + ".ARRAY";
    public static final String NOT_OBSERVED_INIT = CaptureLog.class.getName() + ".XINIT";
    public static final String END_CAPTURE_PSEUDO_METHOD = CaptureLog.class.getName() + ".END_CAPTURE";
    public static final int PSEUDO_CAPTURE_ID = Integer.MAX_VALUE;
    public static final String EMPTY_DESC = Type.getMethodDescriptor(Type.VOID_TYPE, new Type[0]);
    public static final int NO_DEPENDENCY = -1;
    public static final String PUTFIELD = "PUTFIELD";
    public static final String PUTSTATIC = "PUTSTATIC";
    public static final String GETFIELD = "GETFIELD";
    public static final String GETSTATIC = "GETSTATIC";
    public static final Object RETURN_TYPE_VOID = CaptureLog.class.getName() + ".RETURN_VOID";
    private static final Set<String> NOT_OBSERVED_INIT_METHODS = Collections.synchronizedSet(new LinkedHashSet());
    public final List<Integer> objectIds = new ArrayList<Integer>();
    public final List<Integer> captureIds;
    public final List<String> methodNames = new ArrayList<String>();
    public final List<Object[]> params = new ArrayList<Object[]>();
    public final List<Object> returnValues;
    public final List<Boolean> isStaticCallList;
    public final List<String> descList;
    private final List<Integer> oids;
    private final List<Integer> oidInitRecNo;
    private final List<String> oidClassNames;
    private final List<Integer> oidFirstInits;
    private final List<Integer> oidDependencies;
    private final Map<Integer, String> oidNamesOfAccessedFields;
    private final Map<Integer, Integer> oidRecMapping;
    private final XStream xstream;

    public CaptureLog() {
        this.captureIds = new ArrayList<Integer>();
        this.returnValues = new ArrayList<Object>();
        this.descList = new ArrayList<String>();
        this.oidRecMapping = new LinkedHashMap<Integer, Integer>();
        this.oidInitRecNo = new ArrayList<Integer>();
        this.oidClassNames = new ArrayList<String>();
        this.oids = new ArrayList<Integer>();
        this.oidFirstInits = new ArrayList<Integer>();
        this.oidDependencies = new ArrayList<Integer>();
        this.isStaticCallList = new ArrayList<Boolean>();
        this.oidNamesOfAccessedFields = new LinkedHashMap<Integer, String>();
        this.xstream = new XStream();
    }

    public String getNameOfAccessedFields(int captureId) {
        return this.oidNamesOfAccessedFields.get(captureId);
    }

    public int getDependencyOID(int oid) {
        int index = this.getRecordIndex(oid);
        return this.oidDependencies.get(index);
    }

    public List<Integer> getTargetOIDs(Set<String> observedClassNames) {
        ArrayList<Integer> targetOIDs = new ArrayList<Integer>();
        int numInfoRecs = this.oidClassNames.size();
        for (int i = 0; i < numInfoRecs; ++i) {
            if (!observedClassNames.contains(this.oidClassNames.get(i))) continue;
            targetOIDs.add(this.getOID(i));
        }
        return targetOIDs;
    }

    public String getTypeName(int oid) throws IllegalArgumentException {
        if (!this.oidRecMapping.containsKey(oid)) {
            throw new IllegalArgumentException("OID " + oid + " is not recognized");
        }
        return this.oidClassNames.get(this.getRecordIndex(oid));
    }

    public int getRecordIndex(int oid) {
        return this.oidRecMapping.get(oid);
    }

    public int getOID(int recordIndex) {
        if (recordIndex < 0 || recordIndex >= this.oids.size()) {
            throw new IllegalArgumentException("index " + recordIndex + " is invalid as there are " + this.oids.size() + " OIDs");
        }
        return this.oids.get(recordIndex);
    }

    public List<String> getObservedClasses() {
        return this.oidClassNames;
    }

    public int getRecordIndexOfWhereObjectWasInitializedFirst(int oid) throws IllegalArgumentException {
        if (!this.oidRecMapping.containsKey(oid)) {
            throw new IllegalArgumentException("OID " + oid + " is not recognized");
        }
        int pos = this.oidRecMapping.get(oid);
        return this.oidInitRecNo.get(pos);
    }

    private void addNewInitRec(int currentRecord) {
        this.oidInitRecNo.add(-currentRecord);
        logger.debug("InitRecNo added " + -currentRecord);
    }

    public void updateWhereObjectWasInitializedFirst(int oid, int recordIndex) throws IllegalArgumentException {
        if (!this.oidRecMapping.containsKey(oid)) {
            throw new IllegalArgumentException("OID " + oid + " is not recognized");
        }
        int nRec = this.objectIds.size();
        if (-recordIndex <= -nRec || recordIndex >= nRec) {
            throw new IllegalArgumentException("New record index " + recordIndex + " is invalid, as there are only " + nRec + " records");
        }
        logger.debug("Updating init of OID " + oid + " from pos=" + this.getRecordIndexOfWhereObjectWasInitializedFirst(oid) + " to pos=" + recordIndex);
        int recentInitRecord = this.getRecordIndexOfWhereObjectWasInitializedFirst(oid);
        if (Math.abs(recordIndex) > Math.abs(recentInitRecord)) {
            this.oidInitRecNo.set(this.oidRecMapping.get(oid), recordIndex);
        }
    }

    public CaptureLog clone() {
        CaptureLog log = new CaptureLog();
        log.objectIds.addAll(this.objectIds);
        log.methodNames.addAll(this.methodNames);
        log.params.addAll(this.params);
        log.captureIds.addAll(this.captureIds);
        log.returnValues.addAll(this.returnValues);
        log.descList.addAll(this.descList);
        log.oidRecMapping.putAll(this.oidRecMapping);
        log.oidInitRecNo.addAll(this.oidInitRecNo);
        log.oidClassNames.addAll(this.oidClassNames);
        log.oids.addAll(this.oids);
        log.oidNamesOfAccessedFields.putAll(this.oidNamesOfAccessedFields);
        log.isStaticCallList.addAll(this.isStaticCallList);
        log.oidDependencies.addAll(this.oidDependencies);
        log.oidFirstInits.addAll(this.oidFirstInits);
        return log;
    }

    public void clear() {
        this.objectIds.clear();
        this.methodNames.clear();
        this.params.clear();
        this.captureIds.clear();
        this.returnValues.clear();
        this.descList.clear();
        this.oidRecMapping.clear();
        this.oidInitRecNo.clear();
        this.oidClassNames.clear();
        this.oids.clear();
        this.oidFirstInits.clear();
        this.oidDependencies.clear();
        this.isStaticCallList.clear();
        this.oidNamesOfAccessedFields.clear();
    }

    private boolean updateInfoTable(int oid, Object receiver, boolean replace) {
        if (this.oidRecMapping.containsKey(oid)) {
            if (replace) {
                int logRecNo = this.objectIds.size();
                this.updateWhereObjectWasInitializedFirst(oid, -logRecNo);
                return true;
            }
            return false;
        }
        int logRecNo = this.objectIds.size();
        int infoRecNo = this.oidInitRecNo.size();
        logger.debug("Adding mapping oid->index   {} -> {}", (Object)oid, (Object)infoRecNo);
        this.oidRecMapping.put(oid, infoRecNo);
        this.addNewInitRec(logRecNo);
        this.oidFirstInits.add(logRecNo);
        this.oidDependencies.add(-1);
        this.registerObjectsClassName(receiver);
        this.oids.add(oid);
        return true;
    }

    private void registerObjectsClassName(Object receiver) {
        if (receiver instanceof Class) {
            Class c = (Class)receiver;
            this.oidClassNames.add(c.getName().replace(PackageInfo.getEvoSuitePackage() + ".testcarver.wrapper.", ""));
        } else if (this.isPlain(receiver)) {
            this.oidClassNames.add(receiver.getClass().getName());
        } else if (this.isProxy(receiver) || this.isAnonymous(receiver)) {
            Class<?> c = receiver.getClass();
            Class<?>[] interfaces = c.getInterfaces();
            if (interfaces.length == 0) {
                this.oidClassNames.add(c.getSuperclass().getName());
            } else {
                this.oidClassNames.add(interfaces[0].getName());
            }
        } else {
            String name = receiver.getClass().getName().replace(PackageInfo.getEvoSuitePackage() + ".testcarver.wrapper.", "");
            this.oidClassNames.add(name);
        }
    }

    private boolean isAnonymous(Object receiver) {
        return receiver.getClass().isAnonymousClass();
    }

    private boolean isProxy(Object receiver) {
        return Proxy.isProxyClass(receiver.getClass());
    }

    private boolean isPlain(Object o) {
        return o instanceof String || o instanceof Integer || o instanceof Double || o instanceof Float || o instanceof Long || o instanceof Byte || o instanceof Short || o instanceof Boolean || o instanceof Character;
    }

    public void logEnd(int captureId, Object receiver, Object returnValue) {
        if (returnValue != null && returnValue != RETURN_TYPE_VOID) {
            this.handleReturnValue(captureId, receiver, returnValue);
        }
        this.captureIds.add(captureId);
        this.objectIds.add(System.identityHashCode(receiver));
        this.methodNames.add(END_CAPTURE_PSEUDO_METHOD);
        this.descList.add(EMPTY_DESC);
        this.params.add(NO_ARGS);
        this.returnValues.add(RETURN_TYPE_VOID);
        this.isStaticCallList.add(Boolean.FALSE);
    }

    private int findRecordOfMethodStart(Object receiver, int captureId) {
        int oid = System.identityHashCode(receiver);
        int currentRecord = this.captureIds.size() - 1;
        int nestedCalls = 0;
        while (true) {
            if (this.captureIds.get(currentRecord) == captureId && this.objectIds.get(currentRecord) == oid) {
                if (this.methodNames.get(currentRecord).equals(END_CAPTURE_PSEUDO_METHOD)) {
                    ++nestedCalls;
                } else {
                    if (nestedCalls == 0) break;
                    --nestedCalls;
                }
            }
            --currentRecord;
        }
        return currentRecord;
    }

    private void handleReturnValue(int captureId, Object receiver, Object returnValue) {
        boolean condition;
        int returnValueOID = System.identityHashCode(returnValue);
        boolean bl = condition = !this.oidRecMapping.containsKey(returnValueOID);
        if (!condition) {
            int methodStartRecord;
            int firstInitRecNo = this.oidFirstInits.get(this.oidRecMapping.get(returnValueOID));
            String methodName = this.methodNames.get(firstInitRecNo);
            boolean isObservedConstructionCaughtForThisObject = methodName.equals(OBSERVED_INIT);
            boolean isUnObservedConstructionCaughtForThisObject = NOT_OBSERVED_INIT_METHODS.contains(this.methodNames.get(firstInitRecNo));
            boolean noReturnValueHasBeenSet = RETURN_TYPE_VOID.equals(this.returnValues.get(firstInitRecNo));
            condition = !isObservedConstructionCaughtForThisObject && !isUnObservedConstructionCaughtForThisObject ? ((methodStartRecord = this.findRecordOfMethodStart(receiver, captureId)) < firstInitRecNo ? noReturnValueHasBeenSet : false) : noReturnValueHasBeenSet;
        }
        if (condition && !this.isPlain(returnValue) && !(returnValue instanceof Class)) {
            int currentRecord = this.findRecordOfMethodStart(receiver, captureId);
            if (this.oidRecMapping.containsKey(returnValueOID)) {
                int infoRecNo = this.oidRecMapping.get(returnValueOID);
                int initRecNo = this.getRecordIndexOfWhereObjectWasInitializedFirst(returnValueOID);
                String method = this.methodNames.get(Math.abs(initRecNo));
                if (!OBSERVED_INIT.equals(method) && !NOT_OBSERVED_INIT_METHODS.contains(method)) {
                    this.returnValues.set(currentRecord, returnValueOID);
                    this.updateWhereObjectWasInitializedFirst(returnValueOID, -currentRecord);
                    this.oidFirstInits.set(infoRecNo, currentRecord);
                } else {
                    this.returnValues.set(currentRecord, returnValueOID);
                }
            } else {
                int infoRecNo = this.oidInitRecNo.size();
                this.oidRecMapping.put(returnValueOID, infoRecNo);
                this.addNewInitRec(currentRecord);
                this.oidFirstInits.add(currentRecord);
                this.returnValues.set(currentRecord, returnValueOID);
                this.registerObjectsClassName(returnValue);
                this.oids.add(returnValueOID);
                this.oidDependencies.add(-1);
            }
        }
    }

    private void checkIfInstanceFromInnerInstanceClass(Object receiver) {
        if (!(receiver instanceof Class)) {
            Class<?> receiverClass = receiver.getClass();
            Class<?> enclosingClass = receiverClass.getEnclosingClass();
            if (enclosingClass == null) {
                return;
            }
            if (!receiverClass.isAnonymousClass() && !Modifier.isStatic(receiverClass.getModifiers())) {
                try {
                    Field this$0 = receiverClass.getDeclaredField("this$0");
                    this$0.setAccessible(true);
                    Object outerInstance = this$0.get(receiver);
                    int receiverOID = System.identityHashCode(receiver);
                    int initRecNo = this.oidRecMapping.get(receiverOID);
                    this.oidDependencies.set(initRecNo, System.identityHashCode(outerInstance));
                }
                catch (Exception e) {
                    logger.info("An error occurred while obtaining the enclosing object of an inner non-static class instance. FIELDS: " + Arrays.toString(receiverClass.getDeclaredFields()), e);
                }
            }
        }
    }

    public void log(int captureId, Object receiver, String methodName, String methodDesc, Object ... methodParams) {
        int oid = System.identityHashCode(receiver);
        boolean isConstructor = OBSERVED_INIT.equals(methodName);
        if (PUTSTATIC.equals(methodName) || PUTFIELD.equals(methodName)) {
            this.oidNamesOfAccessedFields.put(captureId, (String)methodParams[0]);
            Object assignedValue = methodParams[1];
            methodParams = new Object[]{assignedValue};
        } else if (GETSTATIC.equals(methodName) || GETFIELD.equals(methodName)) {
            this.oidNamesOfAccessedFields.put(captureId, (String)methodParams[0]);
            methodParams = new Object[]{};
        } else if (!(isConstructor || this.oidRecMapping.containsKey(oid) || receiver instanceof Class)) {
            logger.info("method {} was called on object {} with oid {} without foregoing (observed) init stmt --> creating unobserved init stmt", methodName, receiver, oid);
            this.updateInfoTable(oid, receiver, isConstructor);
            this.logUnobservedInitStmt(receiver);
        }
        if (receiver instanceof Class) {
            this.objectIds.add(oid);
            this.descList.add(EMPTY_DESC);
            this.methodNames.add(PLAIN_INIT);
            this.params.add(new Object[]{receiver});
            this.returnValues.add(RETURN_TYPE_VOID);
            this.captureIds.add(Integer.MAX_VALUE);
            this.isStaticCallList.add(Boolean.FALSE);
            this.logEnd(Integer.MAX_VALUE, receiver, RETURN_TYPE_VOID);
        }
        for (int i = 0; i < methodParams.length; ++i) {
            int paramOID;
            block10: {
                Object param = methodParams[i];
                if (param == null) continue;
                paramOID = System.identityHashCode(param);
                if (paramOID == oid) {
                    logger.info("PARAM is 'this' reference -> are serialized version of 'this' is created and passed as param");
                    try {
                        String xml = this.xstream.toXML(param);
                        param = this.xstream.fromXML(xml);
                        paramOID = System.identityHashCode(param);
                        this.logUnobservedInitStmt(param);
                        break block10;
                    }
                    catch (Exception e) {
                        logger.info("an error occurred while serializing and deserializing {} -> is handled as NULL param", param, (Object)e);
                        continue;
                    }
                }
                this.createInitLogEntries(param);
            }
            methodParams[i] = paramOID;
        }
        this.updateInfoTable(oid, receiver, isConstructor);
        this.objectIds.add(oid);
        this.methodNames.add(methodName);
        this.descList.add(methodDesc);
        this.params.add(methodParams);
        this.returnValues.add(RETURN_TYPE_VOID);
        this.captureIds.add(captureId);
        this.isStaticCallList.add(receiver instanceof Class);
        this.checkIfInstanceFromInnerInstanceClass(receiver);
    }

    private void createInitLogEntries(Object param) {
        if (param == null) {
            return;
        }
        int paramOID = System.identityHashCode(param);
        boolean isArray = param.getClass().isArray();
        boolean isMap = param instanceof Map;
        boolean isCollection = param instanceof Collection;
        if (isArray || isMap || isCollection || this.updateInfoTable(paramOID, param, false)) {
            boolean isInstrumented = TransformerUtil.isClassConsideredForInstrumentation(param.getClass().getName());
            if (this.isPlain(param) || param instanceof Class) {
                this.objectIds.add(paramOID);
                this.methodNames.add(PLAIN_INIT);
                this.params.add(new Object[]{param});
                this.descList.add(EMPTY_DESC);
                this.returnValues.add(RETURN_TYPE_VOID);
                this.captureIds.add(Integer.MAX_VALUE);
                this.isStaticCallList.add(Boolean.FALSE);
                this.logEnd(Integer.MAX_VALUE, param, RETURN_TYPE_VOID);
            } else if (isCollection && !isInstrumented) {
                Collection c = (Collection)param;
                Object[] valArray = new Object[c.size()];
                int index = 0;
                for (Object o : c) {
                    if (o != null) {
                        this.createInitLogEntries(o);
                        valArray[index] = System.identityHashCode(o);
                    }
                    ++index;
                }
                if (!this.oidRecMapping.containsKey(paramOID)) {
                    this.updateInfoTable(paramOID, param, true);
                }
                this.objectIds.add(paramOID);
                this.methodNames.add(COLLECTION_INIT);
                this.params.add(valArray);
                this.descList.add(EMPTY_DESC);
                this.returnValues.add(RETURN_TYPE_VOID);
                this.captureIds.add(Integer.MAX_VALUE);
                this.isStaticCallList.add(Boolean.FALSE);
                this.logEnd(Integer.MAX_VALUE, param, RETURN_TYPE_VOID);
            } else if (isMap && !isInstrumented) {
                Map m = (Map)param;
                Object[] valArray = new Object[m.size() * 2];
                int index = 0;
                Iterator iterator = m.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry oe;
                    Map.Entry entry = oe = iterator.next();
                    Object k = entry.getKey();
                    this.createInitLogEntries(k);
                    valArray[index++] = System.identityHashCode(k);
                    Object v = entry.getValue();
                    if (v == null) {
                        valArray[index++] = null;
                        continue;
                    }
                    this.createInitLogEntries(v);
                    valArray[index++] = System.identityHashCode(v);
                }
                if (!this.oidRecMapping.containsKey(paramOID)) {
                    this.updateInfoTable(paramOID, param, true);
                }
                this.objectIds.add(paramOID);
                this.methodNames.add(MAP_INIT);
                this.params.add(valArray);
                this.descList.add(EMPTY_DESC);
                this.returnValues.add(RETURN_TYPE_VOID);
                this.captureIds.add(Integer.MAX_VALUE);
                this.isStaticCallList.add(Boolean.FALSE);
                this.logEnd(Integer.MAX_VALUE, param, RETURN_TYPE_VOID);
            } else if (isArray) {
                int arraySize = Array.getLength(param);
                Object[] valArray = new Object[arraySize];
                for (int index = 0; index < arraySize; ++index) {
                    Object o = Array.get(param, index);
                    if (o == null) continue;
                    this.createInitLogEntries(o);
                    valArray[index] = System.identityHashCode(o);
                }
                if (!this.oidRecMapping.containsKey(paramOID)) {
                    this.updateInfoTable(paramOID, param, true);
                }
                this.objectIds.add(paramOID);
                this.methodNames.add(ARRAY_INIT);
                this.params.add(valArray);
                this.descList.add(EMPTY_DESC);
                this.returnValues.add(RETURN_TYPE_VOID);
                this.captureIds.add(Integer.MAX_VALUE);
                this.isStaticCallList.add(Boolean.FALSE);
                this.logEnd(Integer.MAX_VALUE, param, RETURN_TYPE_VOID);
            } else if (!isInstrumented) {
                this.logUnobservedInitStmt(param);
            }
        }
    }

    private void logUnobservedInitStmt(Object subject) {
        int subjectOID = System.identityHashCode(subject);
        if (!this.oidRecMapping.containsKey(subjectOID)) {
            this.updateInfoTable(subjectOID, subject, true);
        }
        this.objectIds.add(subjectOID);
        this.checkIfInstanceFromInnerInstanceClass(subject);
        this.methodNames.add(NOT_OBSERVED_INIT);
        try {
            this.params.add(new Object[]{this.xstream.toXML(subject)});
        }
        catch (Exception e) {
            logger.info("an error occurred while serializing param '{}' -> adding null as param instead", subject, (Object)e);
            this.params.add(new Object[]{null});
        }
        this.descList.add(EMPTY_DESC);
        this.returnValues.add(RETURN_TYPE_VOID);
        this.captureIds.add(Integer.MAX_VALUE);
        this.isStaticCallList.add(Boolean.FALSE);
        this.logEnd(Integer.MAX_VALUE, subject, RETURN_TYPE_VOID);
    }

    public String toString() {
        String delimiter = "\t|\t";
        StringBuilder builder = new StringBuilder(1000);
        builder.append("LOG:\n").append("-------------------------------------------------------------------").append('\n').append("RECNO").append("\t|\t").append("OID").append("\t|\t").append("CID").append("\t|\t").append("METHOD").append("\t|\t").append("PARAMS").append("\t|\t").append("RETURN").append("\t|\t").append("IS STATIC").append("\t|\t").append("DESC").append("\t|\t").append("ACCESSED FIELDS").append('\n').append("-------------------------------------------------------------------").append('\n');
        int numRecords = this.objectIds.size();
        for (int i = 0; i < numRecords; ++i) {
            int captureId = this.captureIds.get(i);
            builder.append(i).append("\t|\t").append(this.objectIds.get(i)).append("\t|\t").append(captureId).append("\t|\t").append(this.methodNames.get(i)).append("\t|\t").append(Arrays.toString(this.params.get(i))).append("\t|\t").append(this.returnValues.get(i)).append("\t|\t").append(this.isStaticCallList.get(i)).append("\t|\t").append(this.descList.get(i)).append("\t|\t").append(this.oidNamesOfAccessedFields.get(captureId)).append('\n');
        }
        builder.append('\n').append('\n');
        builder.append("META INF:\n").append("-------------------------------------------------------------------").append('\n').append("OID").append("\t|\t").append("INIT RECNO").append("\t|\t").append("OID CLASS").append("\t|\t").append("ACCESSED FIELDS").append("\t|\t").append("FIRST INIT").append("\t|\t").append("DEPENDENCY").append('\n').append("-------------------------------------------------------------------").append('\n');
        int numMetaInfRecords = this.oids.size();
        for (int i = 0; i < numMetaInfRecords; ++i) {
            builder.append(this.oids.get(i)).append("\t|\t").append(this.oidInitRecNo.get(i)).append("\t|\t").append(this.oidClassNames.get(i)).append("\t|\t").append(this.oidNamesOfAccessedFields.get(i)).append("\t|\t").append(this.oidFirstInits.get(i)).append("\t|\t").append(this.oidDependencies.get(i)).append('\n');
        }
        return builder.toString();
    }

    static {
        NOT_OBSERVED_INIT_METHODS.add(NOT_OBSERVED_INIT);
        NOT_OBSERVED_INIT_METHODS.add(COLLECTION_INIT);
        NOT_OBSERVED_INIT_METHODS.add(MAP_INIT);
        NOT_OBSERVED_INIT_METHODS.add(ARRAY_INIT);
    }
}

