/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericSignatureFormatError;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.evosuite.assertion.Assertion;
import org.evosuite.assertion.InspectorAssertion;
import org.evosuite.assertion.PrimitiveFieldAssertion;
import org.evosuite.contracts.ContractViolation;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.runtime.util.Inputs;
import org.evosuite.setup.TestClusterUtils;
import org.evosuite.shaded.org.apache.commons.lang3.reflect.MethodUtils;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestCodeVisitor;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.TestVisitor;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.FieldStatement;
import org.evosuite.testcase.statements.FunctionalMockForAbstractClassStatement;
import org.evosuite.testcase.statements.FunctionalMockStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.statements.environment.AccessedEnvironment;
import org.evosuite.testcase.variable.ArrayIndex;
import org.evosuite.testcase.variable.ArrayReference;
import org.evosuite.testcase.variable.FieldReference;
import org.evosuite.testcase.variable.NullReference;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.ListenableList;
import org.evosuite.utils.Listener;
import org.evosuite.utils.Randomness;
import org.evosuite.utils.generic.GenericClass;
import org.evosuite.utils.generic.GenericField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTestCase
implements TestCase,
Serializable {
    private static final long serialVersionUID = -689512549778944250L;
    private static final Logger logger = LoggerFactory.getLogger(DefaultTestCase.class);
    protected static final AtomicInteger idGenerator = new AtomicInteger(0);
    private final AccessedEnvironment accessedEnvironment = new AccessedEnvironment();
    protected final ListenableList<Statement> statements;
    private transient Set<TestFitnessFunction> coveredGoals = new LinkedHashSet<TestFitnessFunction>();
    private transient Set<ContractViolation> contractViolations = new LinkedHashSet<ContractViolation>();
    private boolean isFailing = false;
    private boolean unstable = false;
    private int id;
    private transient ClassLoader changedClassLoader = null;

    public DefaultTestCase() {
        this.statements = new ListenableList(new ArrayList());
        this.id = idGenerator.getAndIncrement();
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public void accept(TestVisitor visitor) {
        visitor.visitTestCase(this);
        for (Statement s : this.statements) {
            logger.trace("Visiting statement " + s.getCode());
            visitor.visitStatement(s);
        }
    }

    @Override
    public void addAssertions(TestCase other) {
        for (int i = 0; i < this.statements.size() && i < other.size(); ++i) {
            for (Assertion a : other.getStatement(i).getAssertions()) {
                if (this.statements.get(i).getAssertions().contains(a) || a == null) continue;
                this.statements.get(i).getAssertions().add(a.clone(this));
            }
        }
    }

    @Override
    public void addContractViolation(ContractViolation violation) {
        this.contractViolations.add(violation);
    }

    @Override
    public Set<ContractViolation> getContractViolations() {
        return this.contractViolations;
    }

    @Override
    public void addCoveredGoal(TestFitnessFunction goal) {
        this.coveredGoals.add(goal);
    }

    @Override
    public void removeCoveredGoal(TestFitnessFunction goal) {
        this.coveredGoals.remove(goal);
    }

    @Override
    public boolean isGoalCovered(TestFitnessFunction goal) {
        return this.coveredGoals.contains(goal);
    }

    private void addFields(List<VariableReference> variables, VariableReference var, Type type) {
        if (!var.isPrimitive() && !(var instanceof NullReference)) {
            for (Field field : TestClusterUtils.getAccessibleFields(var.getVariableClass())) {
                FieldReference f;
                Type fieldType = field.getType();
                try {
                    fieldType = field.getGenericType();
                }
                catch (GenericSignatureFormatError e) {
                    fieldType = field.getType();
                }
                if ((f = new FieldReference(this, new GenericField(field, var.getGenericClass()), fieldType, var)).getDepth() > 2) continue;
                if (type != null) {
                    if (!f.isAssignableTo(type) || variables.contains(f)) continue;
                    variables.add(f);
                    continue;
                }
                if (variables.contains(f)) continue;
                variables.add(f);
            }
        }
    }

    @Override
    public void addListener(Listener<Void> listener) {
        this.statements.addListener(listener);
    }

    @Override
    public VariableReference addStatement(Statement statement) {
        block8: {
            this.statements.add(statement);
            try {
                assert (this.isValid());
            }
            catch (AssertionError e) {
                logger.info("Is not valid: ");
                for (Statement s : this.statements) {
                    try {
                        logger.info(s.getCode());
                    }
                    catch (AssertionError e2) {
                        logger.info("Found error in: " + s);
                        if (!(s instanceof MethodStatement)) continue;
                        MethodStatement ms = (MethodStatement)s;
                        if (!ms.isStatic()) {
                            logger.info("Callee: ");
                            logger.info(ms.getCallee().toString());
                        }
                        int num = 0;
                        for (VariableReference v : ms.getParameterReferences()) {
                            logger.info("Parameter " + num);
                            logger.info(v.getVariableClass().toString());
                            logger.info(v.getClass().toString());
                            logger.info(v.toString());
                        }
                    }
                }
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
        return statement.getReturnValue();
    }

    @Override
    public VariableReference addStatement(Statement statement, int position) {
        this.statements.add(position, statement);
        assert (this.isValid());
        return statement.getReturnValue();
    }

    @Override
    public void addStatements(List<? extends Statement> statements) {
        this.statements.addAll(statements);
    }

    public void changeClassLoader(ClassLoader loader) {
        this.changedClassLoader = loader;
        for (Statement s : this.statements) {
            s.changeClassLoader(loader);
        }
    }

    public ClassLoader getChangedClassLoader() {
        return this.changedClassLoader;
    }

    @Override
    public void chop(int length) {
        while (this.statements.size() > length) {
            this.statements.remove(length);
        }
    }

    @Override
    public int sliceFor(VariableReference var) {
        LinkedHashSet<Statement> dependentStatements = new LinkedHashSet<Statement>();
        dependentStatements.add(this.statements.get(var.getStPosition()));
        int lastPosition = var.getStPosition();
        for (VariableReference ref : this.getReferences(var)) {
            if (ref.getStPosition() > lastPosition) {
                lastPosition = ref.getStPosition();
            }
            dependentStatements.add(this.statements.get(ref.getStPosition()));
        }
        for (int i = lastPosition; i >= 0; --i) {
            LinkedHashSet newStatements = new LinkedHashSet();
            for (Statement s : dependentStatements) {
                if (!s.references(this.statements.get(i).getReturnValue()) && !s.references(this.statements.get(i).getReturnValue().getAdditionalVariableReference())) continue;
                newStatements.add(this.statements.get(i));
                break;
            }
            dependentStatements.addAll(newStatements);
        }
        ArrayList<Integer> dependentPositions = new ArrayList<Integer>();
        for (Statement s : dependentStatements) {
            dependentPositions.add(s.getPosition());
        }
        dependentPositions.sort(Collections.reverseOrder());
        for (int pos = this.size(); pos >= 0; --pos) {
            if (dependentPositions.contains(pos)) continue;
            this.remove(pos);
        }
        return var.getStPosition();
    }

    @Override
    public boolean contains(Statement statement) {
        return this.statements.contains(statement);
    }

    @Override
    public void clearCoveredGoals() {
        this.coveredGoals.clear();
    }

    @Override
    public DefaultTestCase clone() {
        DefaultTestCase t = null;
        t = new DefaultTestCase();
        for (Statement s : this.statements) {
            Statement copy = s.clone(t);
            t.statements.add(copy);
            copy.setRetval(s.getReturnValue().clone(t));
            copy.setAssertions(s.copyAssertions(t, 0));
        }
        t.coveredGoals.addAll(this.coveredGoals);
        t.accessedEnvironment.copyFrom(this.accessedEnvironment);
        t.isFailing = this.isFailing;
        t.id = idGenerator.getAndIncrement();
        return t;
    }

    @Override
    public void deleteListener(Listener<Void> listener) {
        this.statements.deleteListener(listener);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultTestCase other = (DefaultTestCase)obj;
        if (this.statements == null) {
            return other.statements == null;
        }
        if (this.statements.size() != other.statements.size()) {
            return false;
        }
        for (int i = 0; i < this.statements.size(); ++i) {
            if (this.statements.get(i).equals(other.statements.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<Class<?>> getAccessedClasses() {
        LinkedHashSet accessedClasses = new LinkedHashSet();
        for (Statement s : this.statements) {
            for (VariableReference var : s.getVariableReferences()) {
                if (var == null || var.isPrimitive()) continue;
                Class<?> clazz = var.getVariableClass();
                while (clazz.isMemberClass()) {
                    clazz = clazz.getEnclosingClass();
                }
                while (clazz.isArray()) {
                    clazz = clazz.getComponentType();
                }
                accessedClasses.add(clazz);
            }
            if (s instanceof MethodStatement) {
                MethodStatement ms = (MethodStatement)s;
                accessedClasses.addAll(Arrays.asList(ms.getMethod().getMethod().getExceptionTypes()));
                accessedClasses.add(ms.getMethod().getMethod().getDeclaringClass());
                accessedClasses.add(ms.getMethod().getMethod().getReturnType());
                accessedClasses.addAll(Arrays.asList(ms.getMethod().getMethod().getParameterTypes()));
                continue;
            }
            if (s instanceof FieldStatement) {
                FieldStatement fs = (FieldStatement)s;
                accessedClasses.add(fs.getField().getField().getDeclaringClass());
                accessedClasses.add(fs.getField().getField().getType());
                continue;
            }
            if (!(s instanceof ConstructorStatement)) continue;
            ConstructorStatement cs = (ConstructorStatement)s;
            accessedClasses.add(cs.getConstructor().getConstructor().getDeclaringClass());
            accessedClasses.addAll(Arrays.asList(cs.getConstructor().getConstructor().getExceptionTypes()));
            accessedClasses.addAll(Arrays.asList(cs.getConstructor().getConstructor().getParameterTypes()));
        }
        return accessedClasses;
    }

    @Override
    public List<Assertion> getAssertions() {
        ArrayList<Assertion> assertions = new ArrayList<Assertion>();
        for (Statement s : this.statements) {
            assertions.addAll(s.getAssertions());
        }
        return assertions;
    }

    @Override
    public Set<TestFitnessFunction> getCoveredGoals() {
        return this.coveredGoals;
    }

    @Override
    public Set<Class<?>> getDeclaredExceptions() {
        LinkedHashSet exceptions = new LinkedHashSet();
        for (Statement statement : this.statements) {
            exceptions.addAll(statement.getDeclaredExceptions());
        }
        return exceptions;
    }

    @Override
    public AccessedEnvironment getAccessedEnvironment() {
        return this.accessedEnvironment;
    }

    @Override
    public Set<VariableReference> getDependencies(VariableReference var) {
        LinkedHashSet<VariableReference> dependencies = new LinkedHashSet<VariableReference>();
        if (var == null || var.getStPosition() == -1) {
            return dependencies;
        }
        LinkedHashSet<Statement> dependentStatements = new LinkedHashSet<Statement>();
        if (this.statements.size() > var.getStPosition()) {
            dependentStatements.add(this.statements.get(var.getStPosition()));
        }
        for (int i = var.getStPosition(); i >= 0; --i) {
            LinkedHashSet<Statement> newStatements = new LinkedHashSet<Statement>();
            for (Statement s : dependentStatements) {
                if (!s.references(this.statements.get(i).getReturnValue())) continue;
                newStatements.add(this.statements.get(i));
                dependencies.add(this.statements.get(i).getReturnValue());
                break;
            }
            dependentStatements.addAll(newStatements);
        }
        return dependencies;
    }

    @Override
    public VariableReference getLastObject(Type type) throws ConstructionFailedException {
        return this.getLastObject(type, 0);
    }

    @Override
    public VariableReference getLastObject(Type type, int position) throws ConstructionFailedException {
        for (int i = this.statements.size() - 1; i >= position; --i) {
            Statement statement = this.statements.get(i);
            VariableReference var = statement.getReturnValue();
            if (!var.isAssignableTo(type)) continue;
            return var;
        }
        throw new ConstructionFailedException("Found no variables of type " + type);
    }

    @Override
    public Object getObject(VariableReference reference, Scope scope) {
        try {
            return reference.getObject(scope);
        }
        catch (CodeUnderTestException e) {
            throw new AssertionError((Object)"This case isn't handled yet");
        }
    }

    @Override
    public List<VariableReference> getObjects(int position) {
        LinkedList<VariableReference> variables = new LinkedList<VariableReference>();
        for (int i = 0; i < position && i < this.statements.size(); ++i) {
            VariableReference value = this.statements.get(i).getReturnValue();
            if (value == null) continue;
            if (value instanceof ArrayReference) {
                for (int index = 0; index < ((ArrayReference)value).getArrayLength(); ++index) {
                    variables.add(new ArrayIndex((TestCase)this, (ArrayReference)value, index));
                }
                continue;
            }
            if (value instanceof ArrayIndex) continue;
            variables.add(value);
            this.addFields(variables, value, null);
        }
        return variables;
    }

    @Override
    public List<VariableReference> getObjects(Type type, int position) {
        LinkedList<VariableReference> variables = new LinkedList<VariableReference>();
        GenericClass genericClass = new GenericClass(type);
        Class<?> rawClass = genericClass.getRawClass();
        for (int i = 0; i < position && i < this.size(); ++i) {
            VariableReference value;
            Statement statement = this.statements.get(i);
            if (statement instanceof MethodStatement && ((MethodStatement)statement).getMethod().getName().equals("hashCode") || (value = statement.getReturnValue()) == null) continue;
            if (value instanceof ArrayReference) {
                Class<?> arrayClass;
                boolean isClassUtilsBug = false;
                if (value.isArray()) {
                    arrayClass = value.getVariableClass();
                    isClassUtilsBug = this.isClassUtilsBug(rawClass, arrayClass);
                }
                if (rawClass.isArray() && !isClassUtilsBug) {
                    isClassUtilsBug = this.isClassUtilsBug(value.getVariableClass(), rawClass);
                }
                if (value.isAssignableTo(type) && !isClassUtilsBug && value.isArray() == rawClass.isArray()) {
                    logger.debug("Array is assignable: " + value.getType() + " to " + type + ", " + value.isArray() + ", " + rawClass.isArray());
                    variables.add(value);
                    continue;
                }
                if (!GenericClass.isAssignable(type, value.getComponentType()) || this.isClassUtilsBug(rawClass, arrayClass = value.getComponentClass())) continue;
                for (int index = 0; index < ((ArrayReference)value).getArrayLength(); ++index) {
                    if (!((ArrayReference)value).isInitialized(index, position)) continue;
                    variables.add(new ArrayIndex((TestCase)this, (ArrayReference)value, index));
                }
                continue;
            }
            if (value instanceof ArrayIndex) continue;
            if (value.isAssignableTo(type) && value.isPrimitive() == rawClass.isPrimitive() && value.isArray() == rawClass.isArray()) {
                variables.add(value);
                continue;
            }
            this.addFields(variables, value, type);
        }
        return variables;
    }

    @Override
    public VariableReference getRandomNonNullNonPrimitiveObject(Type type, int position) throws ConstructionFailedException {
        Inputs.checkNull(type);
        List<VariableReference> variables = this.getObjects(type, position);
        Iterator<VariableReference> iterator = variables.iterator();
        while (iterator.hasNext()) {
            VariableReference var = iterator.next();
            if (var instanceof NullReference) {
                iterator.remove();
                continue;
            }
            if (this.getStatement(var.getStPosition()) instanceof PrimitiveStatement) {
                iterator.remove();
                continue;
            }
            if (var.isPrimitive() || var.isWrapperType()) {
                iterator.remove();
                continue;
            }
            if (!(this.getStatement(var.getStPosition()) instanceof FunctionalMockStatement) || this.getStatement(var.getStPosition()) instanceof FunctionalMockForAbstractClassStatement) continue;
            iterator.remove();
        }
        if (variables.isEmpty()) {
            throw new ConstructionFailedException("Found no variables of type " + type + " at position " + position);
        }
        return Randomness.choice(variables);
    }

    @Override
    public VariableReference getRandomNonNullObject(Type type, int position) throws ConstructionFailedException {
        Inputs.checkNull(type);
        List<VariableReference> variables = this.getObjects(type, position);
        variables.removeIf(ref -> {
            Statement statement = this.getStatement(ref.getStPosition());
            return ref instanceof NullReference || statement instanceof FunctionalMockStatement;
        });
        if (variables.isEmpty()) {
            throw new ConstructionFailedException("Found no variables of type " + type + " at position " + position);
        }
        return Randomness.choice(variables);
    }

    @Override
    public VariableReference getRandomObject() {
        return this.getRandomObject(this.statements.size());
    }

    @Override
    public VariableReference getRandomObject(int position) {
        List<VariableReference> variables = this.getObjects(position);
        if (variables.isEmpty()) {
            return null;
        }
        return Randomness.choice(variables);
    }

    @Override
    public VariableReference getRandomObject(Type type) throws ConstructionFailedException {
        return this.getRandomObject(type, this.statements.size());
    }

    @Override
    public VariableReference getRandomObject(Type type, int position) throws ConstructionFailedException {
        assert (type != null);
        List<VariableReference> variables = this.getObjects(type, position);
        if (variables.isEmpty()) {
            throw new ConstructionFailedException("Found no variables of type " + type + " at position " + position);
        }
        return Randomness.choice(variables);
    }

    @Override
    public Set<VariableReference> getReferences(VariableReference var) {
        LinkedHashSet<VariableReference> references = new LinkedHashSet<VariableReference>();
        if (var == null || var.getStPosition() == -1) {
            return references;
        }
        for (int i = var.getStPosition() + 1; i < this.statements.size(); ++i) {
            LinkedHashSet<VariableReference> temp = new LinkedHashSet<VariableReference>();
            if (this.statements.get(i).references(var)) {
                temp.add(this.statements.get(i).getReturnValue());
            } else if (this.statements.get(i).references(var.getAdditionalVariableReference())) {
                temp.add(this.statements.get(i).getReturnValue());
            }
            for (VariableReference v : references) {
                if (this.statements.get(i).references(v)) {
                    temp.add(this.statements.get(i).getReturnValue());
                    continue;
                }
                if (!this.statements.get(i).references(v.getAdditionalVariableReference())) continue;
                temp.add(this.statements.get(i).getReturnValue());
            }
            references.addAll(temp);
        }
        return references;
    }

    @Override
    public VariableReference getReturnValue(int position) {
        return this.getStatement(position).getReturnValue();
    }

    @Override
    public Statement getStatement(int position) {
        if (position < 0 || position >= this.statements.size()) {
            throw new IllegalArgumentException("Cannot access statement due to wrong position " + position + ", where total number of statements is " + this.statements.size());
        }
        return this.statements.get(position);
    }

    @Override
    public boolean hasStatement(int position) {
        return this.statements.size() > position && position >= 0;
    }

    @Override
    public boolean hasAssertions() {
        return this.statements.stream().anyMatch(Statement::hasAssertions);
    }

    @Override
    public boolean hasCastableObject(Type type) {
        return this.statements.stream().anyMatch(s -> s.getReturnValue().isAssignableFrom(type));
    }

    public int hashCode() {
        return this.statements.hashCode();
    }

    @Override
    public boolean hasObject(Type type, int position) {
        for (int i = 0; i < position && i < this.size(); ++i) {
            Statement st = this.statements.get(i);
            if (st.getReturnValue() == null || !st.getReturnValue().isAssignableTo(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasReferences(VariableReference var) {
        if (var == null || var.getStPosition() == -1) {
            return false;
        }
        for (int i = var.getStPosition() + 1; i < this.statements.size(); ++i) {
            if (!this.statements.get(i).references(var)) continue;
            return true;
        }
        for (Assertion assertion : this.statements.get(var.getStPosition()).getAssertions()) {
            if (!assertion.getReferencedVariables().contains(var)) continue;
            return true;
        }
        return false;
    }

    private boolean isClassUtilsBug(Class<?> rawClass, Class<?> arrayClass) {
        while (arrayClass != null && arrayClass.isArray()) {
            if (rawClass.isAssignableFrom(arrayClass.getComponentType())) {
                return true;
            }
            arrayClass = arrayClass.getComponentType();
        }
        return false;
    }

    @Override
    public boolean isAccessible() {
        return this.statements.stream().allMatch(Statement::isAccessible);
    }

    @Override
    public boolean isEmpty() {
        return this.statements.isEmpty();
    }

    @Override
    public boolean isFailing() {
        return this.isFailing;
    }

    @Override
    public void setFailing() {
        this.isFailing = true;
    }

    @Override
    public boolean isPrefix(TestCase t) {
        if (this.statements.size() > t.size()) {
            return false;
        }
        for (int i = 0; i < this.statements.size(); ++i) {
            if (this.statements.get(i).same(t.getStatement(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isUnstable() {
        return this.unstable;
    }

    @Override
    public boolean isValid() {
        for (Statement s : this.statements) {
            assert (s.isValid()) : this.toCode();
        }
        return true;
    }

    @Override
    public Iterator<Statement> iterator() {
        return this.statements.iterator();
    }

    @Override
    public void remove(int position) {
        logger.debug("Removing statement {}", (Object)position);
        if (position >= this.size()) {
            return;
        }
        this.statements.remove(position);
        assert (this.isValid());
    }

    @Override
    public void removeAssertion(Assertion assertion) {
        this.statements.forEach(s -> s.removeAssertion(assertion));
    }

    @Override
    public void removeAssertions() {
        this.statements.forEach(Statement::removeAssertions);
    }

    private boolean methodNeedsDownCast(MethodStatement methodStatement, VariableReference var, Class<?> abstractClass) {
        if (!methodStatement.isStatic() && methodStatement.getCallee().equals(var)) {
            if (MethodUtils.getAccessibleMethod(abstractClass, methodStatement.getMethodName(), methodStatement.getMethod().getRawParameterTypes()) == null) {
                return true;
            }
            Method superClassMethod = MethodUtils.getMatchingMethod(abstractClass, methodStatement.getMethodName(), methodStatement.getMethod().getRawParameterTypes());
            if (superClassMethod != null && !methodStatement.getMethod().getRawGeneratedType().equals(superClassMethod.getReturnType())) {
                return true;
            }
        }
        List<VariableReference> parameters = methodStatement.getParameterReferences();
        Class<?>[] parameterTypes = methodStatement.getMethod().getRawParameterTypes();
        for (int i = 0; i < parameters.size(); ++i) {
            VariableReference param = parameters.get(i);
            if (!param.equals(var) || parameterTypes[i].isAssignableFrom(abstractClass)) continue;
            return true;
        }
        return false;
    }

    private boolean constructorNeedsDownCast(ConstructorStatement constructorStatement, VariableReference var, Class<?> abstractClass) {
        List<VariableReference> parameters = constructorStatement.getParameterReferences();
        Class<?>[] parameterTypes = constructorStatement.getConstructor().getConstructor().getParameterTypes();
        for (int i = 0; i < parameters.size(); ++i) {
            VariableReference param = parameters.get(i);
            if (!param.equals(var) || parameterTypes[i].isAssignableFrom(abstractClass)) continue;
            return true;
        }
        return false;
    }

    private boolean fieldNeedsDownCast(FieldReference fieldReference, VariableReference var, Class<?> abstractClass) {
        if (fieldReference.getSource() != null && fieldReference.getSource().equals(var)) {
            return !fieldReference.getField().getDeclaringClass().isAssignableFrom(abstractClass);
        }
        return false;
    }

    private boolean fieldNeedsDownCast(FieldStatement fieldStatement, VariableReference var, Class<?> abstractClass) {
        if (!fieldStatement.isStatic() && fieldStatement.getSource().equals(var)) {
            return !fieldStatement.getField().getDeclaringClass().isAssignableFrom(abstractClass);
        }
        return false;
    }

    private boolean assertionsNeedDownCast(Statement s, VariableReference var, Class<?> abstractClass) {
        for (Assertion assertion : s.getAssertions()) {
            PrimitiveFieldAssertion fieldAssertion;
            InspectorAssertion inspectorAssertion;
            Method inspectorMethod;
            if (!(assertion instanceof InspectorAssertion && assertion.getSource().equals(var) ? MethodUtils.getAccessibleMethod(abstractClass, (inspectorMethod = (inspectorAssertion = (InspectorAssertion)assertion).getInspector().getMethod()).getName(), inspectorMethod.getParameterTypes()) == null : assertion instanceof PrimitiveFieldAssertion && assertion.getSource().equals(var) && !(fieldAssertion = (PrimitiveFieldAssertion)assertion).getField().getDeclaringClass().isAssignableFrom(abstractClass))) continue;
            return true;
        }
        return false;
    }

    public void removeDownCasts() {
        for (Statement s : this.statements) {
            Class<?> methodReturnClass;
            if (!(s instanceof MethodStatement)) continue;
            MethodStatement ms = (MethodStatement)s;
            VariableReference retVal = s.getReturnValue();
            Class<?> variableClass = retVal.getVariableClass();
            if (variableClass.equals(methodReturnClass = ms.getMethod().getRawGeneratedType()) || !methodReturnClass.isAssignableFrom(variableClass)) continue;
            logger.debug("Found downcast from {} to {}", (Object)methodReturnClass.getName(), (Object)variableClass);
            if (this.assertionsNeedDownCast(ms, retVal, methodReturnClass)) {
                return;
            }
            for (VariableReference ref : this.getReferences(retVal)) {
                Statement usageStatement = this.statements.get(ref.getStPosition());
                if (this.assertionsNeedDownCast(usageStatement, retVal, methodReturnClass)) {
                    return;
                }
                if (usageStatement instanceof MethodStatement ? this.methodNeedsDownCast((MethodStatement)usageStatement, retVal, methodReturnClass) : (usageStatement instanceof ConstructorStatement ? this.constructorNeedsDownCast((ConstructorStatement)usageStatement, retVal, methodReturnClass) : usageStatement instanceof FieldStatement && this.fieldNeedsDownCast((FieldStatement)usageStatement, retVal, methodReturnClass))) {
                    return;
                }
                if (!ref.isFieldReference() || !this.fieldNeedsDownCast((FieldReference)ref, retVal, methodReturnClass)) continue;
                return;
            }
            logger.debug("Downcast not needed, replacing with {}", (Object)ms.getMethod().getReturnType());
            retVal.setType(ms.getMethod().getReturnType());
        }
    }

    @Override
    public void replace(VariableReference var1, VariableReference var2) {
        this.statements.forEach(s -> s.replace(var1, var2));
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.coveredGoals = new LinkedHashSet<TestFitnessFunction>();
        this.contractViolations = new LinkedHashSet<ContractViolation>();
    }

    public void setFailing(boolean failing) {
        this.isFailing = failing;
    }

    @Override
    public VariableReference setStatement(Statement statement, int position) {
        this.statements.set(position, statement);
        assert (this.isValid());
        return statement.getReturnValue();
    }

    @Override
    public void setUnstable(boolean unstable) {
        this.unstable = unstable;
    }

    @Override
    public int size() {
        return this.statements.size();
    }

    @Override
    public int sizeWithAssertions() {
        return this.size() + this.getAssertions().size();
    }

    @Override
    public String toCode() {
        TestCodeVisitor visitor = new TestCodeVisitor();
        this.accept(visitor);
        return visitor.getCode();
    }

    @Override
    public String toCode(Map<Integer, Throwable> exceptions) {
        TestCodeVisitor visitor = new TestCodeVisitor();
        visitor.setExceptions(exceptions);
        this.accept(visitor);
        return visitor.getCode();
    }

    public String toString() {
        return this.toCode();
    }
}

