/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.bloatcontrol.BloatControlFunction;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.testcase.ExecutableChromosome;

public class RelativeTestLengthBloatControl<T extends ExecutableChromosome<T>>
implements BloatControlFunction<T>,
SearchListener<T> {
    private static final long serialVersionUID = -459141492060919204L;
    protected int current_max;
    protected double best_fitness;

    public RelativeTestLengthBloatControl() {
        this.current_max = 0;
        this.best_fitness = Double.MAX_VALUE;
    }

    public RelativeTestLengthBloatControl(RelativeTestLengthBloatControl<?> that) {
        this.current_max = that.current_max;
        this.best_fitness = that.best_fitness;
    }

    @Override
    public boolean isTooLong(T chromosome) {
        if (((Chromosome)chromosome).getFitness() < this.best_fitness) {
            return false;
        }
        if (this.current_max > 0) {
            return ((Chromosome)chromosome).size() > Properties.BLOAT_FACTOR * this.current_max;
        }
        return false;
    }

    @Override
    public void fitnessEvaluation(T result) {
    }

    @Override
    public void iteration(GeneticAlgorithm<T> algorithm) {
        this.current_max = ((ExecutableChromosome)algorithm.getBestIndividual()).size();
        this.best_fitness = ((ExecutableChromosome)algorithm.getBestIndividual()).getFitness();
    }

    @Override
    public void searchFinished(GeneticAlgorithm<T> algorithm) {
    }

    @Override
    public void searchStarted(GeneticAlgorithm<T> algorithm) {
    }

    @Override
    public void modification(T individual) {
    }
}

