/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.testcase.ConcreteValueObserver;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.testcase.statements.ArrayStatement;
import org.evosuite.testcase.statements.AssignmentStatement;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.NullStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.ArrayIndex;
import org.evosuite.testcase.variable.ArrayReference;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.generic.GenericClass;

public class TestCaseExpander {
    private final Set<VariableReference> usedVariables = new HashSet<VariableReference>();
    public Map<Integer, Set<VariableReference>> variableMapping = new HashMap<Integer, Set<VariableReference>>();
    private int currentPosition = 0;

    public TestCase expandTestCase(TestCase test) {
        TestCase expandedTest = test.clone();
        while (this.currentPosition < expandedTest.size()) {
            Statement statement = expandedTest.getStatement(this.currentPosition);
            if (statement instanceof MethodStatement) {
                this.visitMethodStatement(expandedTest, (MethodStatement)statement);
            } else if (statement instanceof ConstructorStatement) {
                this.visitConstructorStatement(expandedTest, (ConstructorStatement)statement);
            } else if (statement instanceof ArrayStatement) {
                this.visitArrayStatement(expandedTest, (ArrayStatement)statement);
            } else if (statement instanceof AssignmentStatement) {
                this.visitAssignmentStatement(expandedTest, (AssignmentStatement)statement);
            }
            ++this.currentPosition;
        }
        return expandedTest;
    }

    private void createConcretePrimitives(TestCase test) {
        TestCaseExecutor executor = TestCaseExecutor.getInstance();
        ConcreteValueObserver observer = new ConcreteValueObserver();
        executor.addObserver(observer);
        executor.execute(test);
        executor.removeObserver(observer);
        Map<Integer, Object> concreteValues = observer.getConcreteValues();
        ArrayList<Integer> positions = new ArrayList<Integer>(concreteValues.keySet());
        positions.sort(Collections.reverseOrder());
        for (Integer position : positions) {
            Object value = concreteValues.get(position);
            Statement statement = test.getStatement(position);
            PrimitiveStatement<?> primitive = PrimitiveStatement.getPrimitiveStatement(test, new GenericClass(value.getClass()));
            primitive.setValue(value);
            VariableReference replacement = test.addStatement(primitive, position);
            test.replace(statement.getReturnValue(), replacement);
        }
    }

    private VariableReference duplicateStatement(TestCase test, VariableReference owner) {
        Statement statement = test.getStatement(owner.getStPosition());
        ++this.currentPosition;
        VariableReference copy = test.addStatement(statement.clone(test), owner.getStPosition() + 1);
        if (!this.variableMapping.containsKey(owner.getStPosition())) {
            this.variableMapping.put(owner.getStPosition(), new HashSet());
        }
        this.variableMapping.get(owner.getStPosition()).add(copy);
        return copy;
    }

    private void addUnchangedMapping(TestCase test, VariableReference var) {
        VariableReference copy = test.getStatement(var.getStPosition()).getReturnValue();
        if (!this.variableMapping.containsKey(var.getStPosition())) {
            this.variableMapping.put(var.getStPosition(), new HashSet());
            this.variableMapping.get(var.getStPosition()).add(var);
        }
        this.variableMapping.get(var.getStPosition()).add(copy);
    }

    public void visitMethodStatement(TestCase test, MethodStatement statement) {
        int i = 0;
        for (VariableReference var : statement.getParameterReferences()) {
            if (var.isPrimitive() || var.isString()) {
                if (this.usedVariables.contains(var) && test.getStatement(var.getStPosition()) instanceof PrimitiveStatement) {
                    VariableReference varCopy = this.duplicateStatement(test, var);
                    statement.replaceParameterReference(varCopy, i);
                    this.usedVariables.add(varCopy);
                }
                this.usedVariables.add(var);
            }
            ++i;
        }
        this.addUnchangedMapping(test, statement.getReturnValue());
    }

    public void visitConstructorStatement(TestCase test, ConstructorStatement statement) {
        int i = 0;
        for (VariableReference var : statement.getParameterReferences()) {
            if (var.isPrimitive() || var.isString()) {
                if (this.usedVariables.contains(var) && test.getStatement(var.getStPosition()) instanceof PrimitiveStatement) {
                    VariableReference varCopy = this.duplicateStatement(test, var);
                    statement.replaceParameterReference(varCopy, i);
                    this.usedVariables.add(varCopy);
                }
                this.usedVariables.add(var);
            }
            ++i;
        }
        this.addUnchangedMapping(test, statement.getReturnValue());
    }

    public void visitArrayStatement(TestCase test, ArrayStatement statement) {
        int position;
        ArrayReference arrRef = (ArrayReference)statement.getReturnValue();
        HashSet<Integer> assignments = new HashSet<Integer>();
        for (position = statement.getPosition() + 1; position < test.size(); ++position) {
            Statement st = test.getStatement(position);
            if (st instanceof AssignmentStatement) {
                ArrayIndex arrayIndex;
                if (!(st.getReturnValue() instanceof ArrayIndex) || !(arrayIndex = (ArrayIndex)st.getReturnValue()).getArray().equals(arrRef)) continue;
                assignments.add(arrayIndex.getArrayIndex());
                continue;
            }
            if (!(st instanceof PrimitiveStatement)) break;
        }
        position = statement.getPosition() + 1;
        for (int i = 0; i < statement.size(); ++i) {
            if (assignments.contains(i)) continue;
            ArrayIndex index = new ArrayIndex(test, arrRef, i);
            VariableReference retVal = null;
            if (index.isPrimitive()) {
                PrimitiveStatement<?> primitive = PrimitiveStatement.getPrimitiveStatement(test, index.getGenericClass());
                retVal = test.addStatement(primitive, position++);
            } else {
                NullStatement nullStatement = new NullStatement(test, index.getType());
                retVal = test.addStatement(nullStatement, position++);
            }
            AssignmentStatement assignment = new AssignmentStatement(test, index, retVal);
            test.addStatement(assignment, position++);
        }
    }

    public void visitAssignmentStatement(TestCase test, AssignmentStatement statement) {
        VariableReference var = statement.getValue();
        if (var.isPrimitive() || var.isString()) {
            if (this.usedVariables.contains(var) && test.getStatement(var.getStPosition()) instanceof PrimitiveStatement) {
                VariableReference varCopy = this.duplicateStatement(test, var);
                statement.replace(var, varCopy);
                this.usedVariables.add(varCopy);
            }
            this.usedVariables.add(var);
        }
        this.addUnchangedMapping(test, statement.getReturnValue());
    }
}

