/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import org.evosuite.Properties;
import org.evosuite.ga.ReplacementFunction;
import org.evosuite.testcase.TestChromosome;

public class TestCaseReplacementFunction
extends ReplacementFunction<TestChromosome> {
    private static final long serialVersionUID = 2894768695219052674L;

    public TestCaseReplacementFunction(boolean maximize) {
        super(maximize);
    }

    public TestCaseReplacementFunction() {
        super(false);
    }

    public int getLengthSum(TestChromosome chromosome1, TestChromosome chromosome2) {
        return chromosome1.size() + chromosome2.size();
    }

    @Override
    public boolean keepOffspring(TestChromosome parent1, TestChromosome parent2, TestChromosome offspring1, TestChromosome offspring2) {
        int cmp = this.compareBestOffspringToBestParent(parent1, parent2, offspring1, offspring2);
        if (Properties.CHECK_PARENTS_LENGTH) {
            int offspringLength = this.getLengthSum(offspring1, offspring2);
            int parentLength = this.getLengthSum(parent1, parent2);
            if (cmp == 0 && offspringLength <= parentLength) {
                return true;
            }
            if (this.maximize) {
                return cmp > 0;
            }
            return cmp < 0;
        }
        if (this.maximize) {
            return cmp >= 0;
        }
        return cmp <= 0;
    }
}

