/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import com.googlecode.gentyref.CaptureType;
import com.googlecode.gentyref.GenericTypeReflector;
import dk.brics.automaton.RegExp;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.evosuite.PackageInfo;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.assertion.ArrayEqualsAssertion;
import org.evosuite.assertion.ArrayLengthAssertion;
import org.evosuite.assertion.Assertion;
import org.evosuite.assertion.CompareAssertion;
import org.evosuite.assertion.ContainsAssertion;
import org.evosuite.assertion.EqualsAssertion;
import org.evosuite.assertion.Inspector;
import org.evosuite.assertion.InspectorAssertion;
import org.evosuite.assertion.NullAssertion;
import org.evosuite.assertion.PrimitiveAssertion;
import org.evosuite.assertion.PrimitiveFieldAssertion;
import org.evosuite.assertion.SameAssertion;
import org.evosuite.classpath.ResourceList;
import org.evosuite.runtime.TooManyResourcesException;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.evosuite.runtime.mock.EvoSuiteMock;
import org.evosuite.shaded.org.apache.commons.lang3.CharUtils;
import org.evosuite.shaded.org.apache.commons.lang3.ClassUtils;
import org.evosuite.shaded.org.apache.commons.lang3.StringEscapeUtils;
import org.evosuite.shaded.org.apache.commons.lang3.reflect.TypeUtils;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestVisitor;
import org.evosuite.testcase.fm.MethodDescriptor;
import org.evosuite.testcase.statements.AbstractStatement;
import org.evosuite.testcase.statements.ArrayStatement;
import org.evosuite.testcase.statements.AssignmentStatement;
import org.evosuite.testcase.statements.ClassPrimitiveStatement;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.EnumPrimitiveStatement;
import org.evosuite.testcase.statements.FieldStatement;
import org.evosuite.testcase.statements.FunctionalMockForAbstractClassStatement;
import org.evosuite.testcase.statements.FunctionalMockStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.NullStatement;
import org.evosuite.testcase.statements.PrimitiveExpression;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.statements.StringPrimitiveStatement;
import org.evosuite.testcase.statements.environment.EnvironmentDataStatement;
import org.evosuite.testcase.variable.ArrayIndex;
import org.evosuite.testcase.variable.ArrayReference;
import org.evosuite.testcase.variable.ConstantValue;
import org.evosuite.testcase.variable.FieldReference;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.NumberFormatter;
import org.evosuite.utils.StringUtil;
import org.evosuite.utils.generic.GenericClass;
import org.evosuite.utils.generic.GenericConstructor;
import org.evosuite.utils.generic.GenericField;
import org.evosuite.utils.generic.GenericMethod;

public class TestCodeVisitor
extends TestVisitor {
    protected String testCode = "";
    protected static final String NEWLINE = System.getProperty("line.separator");
    protected final Map<Integer, Throwable> exceptions = new HashMap<Integer, Throwable>();
    protected TestCase test = null;
    protected final Map<VariableReference, String> variableNames = new HashMap<VariableReference, String>();
    protected final Map<Class<?>, String> classNames = new HashMap();
    protected final Map<String, Integer> nextIndices = new HashMap<String, Integer>();
    private List<Class<?>> invalidExceptions = Arrays.asList(StackOverflowError.class, AssertionError.class);

    public String getCode() {
        return this.testCode;
    }

    public Set<Class<?>> getImports() {
        return this.classNames.keySet().stream().filter(clazz -> !this.classNames.get(clazz).contains(".")).collect(Collectors.toCollection(HashSet::new));
    }

    public void clearExceptions() {
        this.exceptions.clear();
    }

    public void setExceptions(Map<Integer, Throwable> exceptions) {
        this.exceptions.putAll(exceptions);
    }

    public void setException(Statement statement, Throwable exception) {
        this.exceptions.put(statement.getPosition(), exception);
    }

    protected Throwable getException(Statement statement) {
        return this.exceptions.getOrDefault(statement.getPosition(), null);
    }

    public String getClassName(VariableReference var) {
        return this.getTypeName(var.getType());
    }

    private String getTypeName(ParameterizedType type) {
        String name = this.getClassName((Class)type.getRawType());
        Type[] types = type.getActualTypeArguments();
        boolean isDefined = false;
        for (Type parameterType : types) {
            if (!(parameterType instanceof Class) && !(parameterType instanceof ParameterizedType) && !(parameterType instanceof WildcardType) && !(parameterType instanceof GenericArrayType)) continue;
            isDefined = true;
            break;
        }
        if (isDefined && types.length > 0) {
            name = name + "<";
            for (int i = 0; i < types.length; ++i) {
                if (i != 0) {
                    name = name + ", ";
                }
                name = name + this.getTypeParameterName(types[i]);
            }
            name = name + ">";
        }
        return name;
    }

    public String getTypeName(Type type) {
        if (type instanceof Class) {
            return this.getClassName((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return this.getTypeName((ParameterizedType)type);
        }
        if (type instanceof WildcardType) {
            String ret = "Object";
            return ret;
        }
        if (type instanceof TypeVariable) {
            return "Object";
        }
        if (type instanceof CaptureType) {
            CaptureType captureType = (CaptureType)type;
            if (captureType.getLowerBounds().length == 0) {
                return "Object";
            }
            return this.getTypeName(captureType.getLowerBounds()[0]);
        }
        if (type instanceof GenericArrayType) {
            return this.getTypeName(((GenericArrayType)type).getGenericComponentType()) + "[]";
        }
        throw new RuntimeException("Unsupported type:" + type + ", class" + type.getClass());
    }

    public String getTypeParameterName(Type type) {
        if (type instanceof Class) {
            return this.getClassName((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return this.getTypeName((ParameterizedType)type);
        }
        if (type instanceof WildcardType) {
            String ret = "?";
            boolean first = true;
            for (Type bound : ((WildcardType)type).getLowerBounds()) {
                if (bound == null) continue;
                if (!first) {
                    ret = ret + ", ";
                }
                ret = ret + " super " + this.getTypeParameterName(bound);
                first = false;
            }
            for (Type bound : ((WildcardType)type).getUpperBounds()) {
                if (bound == null || !(bound instanceof CaptureType) && GenericTypeReflector.erase(bound).equals(Object.class)) continue;
                if (!first) {
                    ret = ret + ", ";
                }
                ret = ret + " extends " + this.getTypeParameterName(bound);
                first = false;
            }
            return ret;
        }
        if (type instanceof TypeVariable) {
            return "?";
        }
        if (type instanceof CaptureType) {
            CaptureType captureType = (CaptureType)type;
            if (captureType.getLowerBounds().length == 0) {
                return "?";
            }
            return this.getTypeName(captureType.getLowerBounds()[0]);
        }
        if (type instanceof GenericArrayType) {
            return this.getTypeName(((GenericArrayType)type).getGenericComponentType()) + "[]";
        }
        throw new RuntimeException("Unsupported type:" + type + ", class" + type.getClass());
    }

    public String getTypeName(VariableReference var) {
        GenericClass clazz = var.getGenericClass();
        return this.getTypeName(clazz.getType());
    }

    public String getClassName(Class<?> clazz) {
        Class<?> declaringClass;
        if (this.classNames.containsKey(clazz)) {
            return this.classNames.get(clazz);
        }
        if (clazz.isArray()) {
            return this.getClassName(clazz.getComponentType()) + "[]";
        }
        GenericClass c = new GenericClass(clazz);
        String name = c.getSimpleName();
        if (this.classNames.values().contains(name)) {
            name = clazz.getCanonicalName();
        } else {
            String fullName = Properties.CLASS_PREFIX + "." + name;
            if (!fullName.equals(clazz.getCanonicalName())) {
                try {
                    if (ResourceList.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).hasClass(fullName)) {
                        name = clazz.getCanonicalName();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        Class<?> outerClass = clazz.getEnclosingClass();
        if (outerClass != null) {
            String enclosingName = this.getClassName(outerClass);
            String simpleOuterName = outerClass.getSimpleName() + ".";
            name = simpleOuterName.equals(enclosingName) ? enclosingName + name.substring(simpleOuterName.length()) : enclosingName + name.substring(name.lastIndexOf(simpleOuterName) + simpleOuterName.length() - 1);
        }
        if ((declaringClass = clazz.getDeclaringClass()) != null) {
            this.getClassName(declaringClass);
        }
        if (name.equals("Test")) {
            name = clazz.getCanonicalName();
        }
        this.classNames.put(clazz, name);
        return name;
    }

    public String getVariableName(VariableReference var) {
        if (var instanceof ConstantValue) {
            ConstantValue cval = (ConstantValue)var;
            if (cval.getValue() != null && cval.getVariableClass().equals(Class.class)) {
                return this.getClassName((Class)cval.getValue()) + ".class";
            }
            return var.getName();
        }
        if (var instanceof FieldReference) {
            VariableReference source = ((FieldReference)var).getSource();
            GenericField field = ((FieldReference)var).getField();
            if (source != null) {
                String ret = "";
                if (!field.isPublic() && !field.getDeclaringClass().equals(source.getVariableClass()) && source.isAssignableTo(field.getDeclaringClass())) {
                    String packageName2;
                    String packageName1 = ClassUtils.getPackageName(field.getDeclaringClass());
                    ret = !packageName1.equals(packageName2 = ClassUtils.getPackageName(source.getVariableClass())) ? ret + "((" + this.getClassName(field.getDeclaringClass()) + ")" + this.getVariableName(source) + ")" : ret + this.getVariableName(source);
                } else if (!source.isAssignableTo(field.getField().getDeclaringClass())) {
                    try {
                        source.getVariableClass().getDeclaredField(field.getName());
                        ret = this.getVariableName(source);
                    }
                    catch (NoSuchFieldException e) {
                        ret = "((" + this.getTypeName(field.getField().getDeclaringClass()) + ") " + this.getVariableName(source) + ")";
                    }
                } else {
                    ret = ret + this.getVariableName(source);
                }
                return ret + "." + field.getName();
            }
            return this.getClassName(field.getField().getDeclaringClass()) + "." + field.getName();
        }
        if (var instanceof ArrayIndex) {
            ArrayReference array = ((ArrayIndex)var).getArray();
            List<Integer> indices = ((ArrayIndex)var).getArrayIndices();
            String result = this.getVariableName(array);
            for (Integer index : indices) {
                result = result + "[" + index + "]";
            }
            return result;
        }
        if (var instanceof ArrayReference) {
            String className = var.getSimpleClassName();
            String variableName = className.substring(0, 1).toLowerCase() + className.substring(1) + "Array";
            variableName = variableName.replace('.', '_').replace("[]", "");
            if (!this.variableNames.containsKey(var)) {
                if (!this.nextIndices.containsKey(variableName)) {
                    this.nextIndices.put(variableName, 0);
                }
                int index = this.nextIndices.get(variableName);
                this.nextIndices.put(variableName, index + 1);
                variableName = variableName + index;
                this.variableNames.put(var, variableName);
            }
        } else if (!this.variableNames.containsKey(var)) {
            String className = var.getSimpleClassName();
            String variableName = className.substring(0, 1).toLowerCase() + className.substring(1);
            if (variableName.contains("[]")) {
                variableName = variableName.replace("[]", "Array");
            }
            if (CharUtils.isAsciiNumeric((variableName = variableName.replace(".", "_")).charAt(variableName.length() - 1))) {
                variableName = variableName + "_";
            }
            if (!this.nextIndices.containsKey(variableName)) {
                this.nextIndices.put(variableName, 0);
            }
            int index = this.nextIndices.get(variableName);
            this.nextIndices.put(variableName, index + 1);
            variableName = variableName + index;
            this.variableNames.put(var, variableName);
        }
        return this.variableNames.get(var);
    }

    public Collection<String> getVariableNames() {
        return this.variableNames.values();
    }

    public Collection<String> getClassNames() {
        return this.classNames.values();
    }

    @Override
    public void visitTestCase(TestCase test) {
        this.test = test;
        this.testCode = "";
        this.variableNames.clear();
        this.nextIndices.clear();
    }

    protected void visitPrimitiveAssertion(PrimitiveAssertion assertion) {
        VariableReference source = assertion.getSource();
        Object value = assertion.getValue();
        String stmt = "";
        if (value == null) {
            stmt = stmt + "assertNull(" + this.getVariableName(source) + ");";
        } else if (source.getVariableClass().equals(Float.TYPE)) {
            stmt = stmt + "assertEquals(" + NumberFormatter.getNumberString(value, this) + ", " + this.getVariableName(source) + ", " + NumberFormatter.getNumberString(Float.valueOf(Properties.FLOAT_PRECISION), this) + ");";
        } else if (source.getVariableClass().equals(Double.TYPE)) {
            stmt = stmt + "assertEquals(" + NumberFormatter.getNumberString(value, this) + ", " + this.getVariableName(source) + ", " + NumberFormatter.getNumberString(Properties.DOUBLE_PRECISION, this) + ");";
        } else if (value.getClass().isEnum()) {
            stmt = stmt + "assertEquals(" + NumberFormatter.getNumberString(value, this) + ", " + this.getVariableName(source) + ");";
            this.getClassName(value.getClass());
        } else if (source.getVariableClass().equals(Boolean.TYPE) || source.getVariableClass().equals(Boolean.class)) {
            Boolean flag = (Boolean)value;
            stmt = flag != false ? stmt + "assertTrue(" : stmt + "assertFalse(";
            stmt = stmt + "" + this.getVariableName(source) + ");";
        } else {
            stmt = source.isWrapperType() ? (source.getVariableClass().equals(Float.class) ? stmt + "assertEquals(" + NumberFormatter.getNumberString(value, this) + ", (float)" + this.getVariableName(source) + ", " + NumberFormatter.getNumberString(Float.valueOf(Properties.FLOAT_PRECISION), this) + ");" : (source.getVariableClass().equals(Double.class) ? stmt + "assertEquals(" + NumberFormatter.getNumberString(value, this) + ", (double)" + this.getVariableName(source) + ", " + NumberFormatter.getNumberString(Properties.DOUBLE_PRECISION, this) + ");" : (value.getClass().isEnum() ? stmt + "assertEquals(" + NumberFormatter.getNumberString(value, this) + ", " + this.getVariableName(source) + ");" : stmt + "assertEquals(" + NumberFormatter.getNumberString(value, this) + ", (" + NumberFormatter.getBoxedClassName(value) + ")" + this.getVariableName(source) + ");"))) : stmt + "assertEquals(" + NumberFormatter.getNumberString(value, this) + ", " + this.getVariableName(source) + ");";
        }
        this.testCode = this.testCode + stmt;
    }

    protected void visitArrayEqualsAssertion(ArrayEqualsAssertion assertion) {
        VariableReference source = assertion.getSource();
        Object[] value = (Object[])assertion.getValue();
        String stmt = "";
        if (source.getComponentClass().equals(Boolean.class) || source.getComponentClass().equals(Boolean.TYPE)) {
            stmt = stmt + "assertTrue(Arrays.equals(";
            this.getClassName(Arrays.class);
        } else {
            stmt = stmt + "assertArrayEquals(";
        }
        stmt = stmt + "new " + this.getTypeName(source.getComponentType()) + "[] {";
        boolean first = true;
        for (Object o : value) {
            if (!first) {
                stmt = stmt + ", ";
            } else {
                first = false;
            }
            stmt = stmt + NumberFormatter.getNumberString(o, this);
        }
        stmt = stmt + "}, " + this.getVariableName(source);
        stmt = source.getComponentClass().equals(Float.class) || source.getComponentClass().equals(Float.TYPE) ? stmt + ", " + NumberFormatter.getNumberString(Float.valueOf(Properties.FLOAT_PRECISION), this) + ");" : (source.getComponentClass().equals(Double.class) || source.getComponentClass().equals(Double.TYPE) ? stmt + ", " + NumberFormatter.getNumberString(Properties.DOUBLE_PRECISION, this) + ");" : (source.getComponentClass().equals(Boolean.class) || source.getComponentClass().equals(Boolean.TYPE) ? stmt + "));" : stmt + ");"));
        this.testCode = this.testCode + stmt;
    }

    protected void visitArrayLengthAssertion(ArrayLengthAssertion assertion) {
        VariableReference source = assertion.getSource();
        int length = assertion.length;
        String stmt = "assertEquals(";
        stmt = stmt + length + ", " + this.getVariableName(source) + ".length);";
        this.testCode = this.testCode + stmt;
    }

    protected void visitContainsAssertion(ContainsAssertion assertion) {
        VariableReference containerObject = assertion.getSource();
        VariableReference containedObject = assertion.getContainedVariable();
        Boolean contains = (Boolean)assertion.getValue();
        String stmt = "";
        stmt = contains != false ? stmt + "assertTrue(" : stmt + "assertFalse(";
        stmt = stmt + this.getVariableName(containerObject) + ".contains(" + this.getVariableName(containedObject) + "));";
        this.testCode = this.testCode + stmt;
    }

    protected void visitPrimitiveFieldAssertion(PrimitiveFieldAssertion assertion) {
        VariableReference source = assertion.getSource();
        Object value = assertion.getValue();
        Field field = assertion.getField();
        String target = "";
        target = Modifier.isStatic(field.getModifiers()) ? this.getClassName(field.getDeclaringClass()) + "." + field.getName() : this.getVariableName(source) + "." + field.getName();
        if (value == null) {
            this.testCode = this.testCode + "assertNull(" + target + ");";
        } else if (value.getClass().equals(Long.class)) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value, this) + ", " + target + ");";
        } else if (value.getClass().equals(Float.class)) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value, this) + ", " + target + ", " + NumberFormatter.getNumberString(Float.valueOf(Properties.FLOAT_PRECISION), this) + ");";
        } else if (value.getClass().equals(Double.class)) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value, this) + ", " + target + ", " + NumberFormatter.getNumberString(Properties.DOUBLE_PRECISION, this) + ");";
        } else if (value.getClass().equals(Character.class)) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value, this) + ", " + target + ");";
        } else if (value.getClass().equals(String.class)) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value, this) + ", " + target + ");";
        } else if (value.getClass().equals(Boolean.class)) {
            Boolean flag = (Boolean)value;
            this.testCode = flag != false ? this.testCode + "assertTrue(" : this.testCode + "assertFalse(";
            this.testCode = this.testCode + "" + target + ");";
        } else if (value.getClass().isEnum()) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value, this) + ", " + target + ");";
            this.getClassName(value.getClass());
        } else {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value, this) + ", " + target + ");";
        }
    }

    protected void visitInspectorAssertion(InspectorAssertion assertion) {
        VariableReference source = assertion.getSource();
        Object value = assertion.getValue();
        Inspector inspector = assertion.getInspector();
        Class<?> generatedType = inspector.getReturnType();
        if (value == null) {
            this.testCode = this.testCode + "assertNull(" + this.getVariableName(source) + "." + inspector.getMethodCall() + "());";
        } else if (value.getClass().equals(Long.class)) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value, this) + ", ";
            if (ClassUtils.isPrimitiveWrapper(generatedType)) {
                this.testCode = this.testCode + "(long)";
            }
            this.testCode = this.testCode + this.getVariableName(source) + "." + inspector.getMethodCall() + "());";
        } else if (value.getClass().equals(Short.class)) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value, this) + ", ";
            if (ClassUtils.isPrimitiveWrapper(generatedType)) {
                this.testCode = this.testCode + "(short)";
            }
            this.testCode = this.testCode + this.getVariableName(source) + "." + inspector.getMethodCall() + "());";
        } else if (value.getClass().equals(Integer.class)) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value, this) + ", ";
            if (ClassUtils.isPrimitiveWrapper(generatedType)) {
                this.testCode = this.testCode + "(int)";
            }
            this.testCode = this.testCode + this.getVariableName(source) + "." + inspector.getMethodCall() + "());";
        } else if (value.getClass().equals(Byte.class)) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value, this) + ", ";
            if (ClassUtils.isPrimitiveWrapper(generatedType)) {
                this.testCode = this.testCode + "(byte)";
            }
            this.testCode = this.testCode + this.getVariableName(source) + "." + inspector.getMethodCall() + "());";
        } else if (value.getClass().equals(Float.class)) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value, this) + ", ";
            this.testCode = this.testCode + this.getVariableName(source) + "." + inspector.getMethodCall() + "(), " + NumberFormatter.getNumberString(Float.valueOf(Properties.FLOAT_PRECISION), this) + ");";
        } else if (value.getClass().equals(Double.class)) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value, this) + ", ";
            this.testCode = this.testCode + this.getVariableName(source) + "." + inspector.getMethodCall() + "(), " + NumberFormatter.getNumberString(Properties.DOUBLE_PRECISION, this) + ");";
        } else if (value.getClass().equals(Character.class)) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value, this) + ", ";
            if (ClassUtils.isPrimitiveWrapper(generatedType)) {
                this.testCode = this.testCode + "(char)";
            }
            this.testCode = this.testCode + this.getVariableName(source) + "." + inspector.getMethodCall() + "());";
        } else if (value.getClass().equals(String.class)) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value, this) + ", ";
            this.testCode = this.testCode + this.getVariableName(source) + "." + inspector.getMethodCall() + "());";
        } else if (value.getClass().isEnum() || value instanceof Enum) {
            this.testCode = this.testCode + "assertEquals(" + NumberFormatter.getNumberString(value, this) + ", " + this.getVariableName(source) + "." + inspector.getMethodCall() + "());";
            this.getClassName(value.getClass());
        } else {
            this.testCode = value.getClass().equals(Boolean.TYPE) || value.getClass().equals(Boolean.class) ? (((Boolean)value).booleanValue() ? this.testCode + "assertTrue(" + this.getVariableName(source) + "." + inspector.getMethodCall() + "());" : this.testCode + "assertFalse(" + this.getVariableName(source) + "." + inspector.getMethodCall() + "());") : this.testCode + "assertEquals(" + value + ", " + this.getVariableName(source) + "." + inspector.getMethodCall() + "());";
        }
    }

    protected void visitNullAssertion(NullAssertion assertion) {
        VariableReference source = assertion.getSource();
        Boolean value = (Boolean)assertion.getValue();
        this.testCode = value != false ? this.testCode + "assertNull(" + this.getVariableName(source) + ");" : this.testCode + "assertNotNull(" + this.getVariableName(source) + ");";
    }

    protected void visitCompareAssertion(CompareAssertion assertion) {
        VariableReference source = assertion.getSource();
        VariableReference dest = assertion.getDest();
        Object value = assertion.getValue();
        this.testCode = source.getType().equals(Integer.class) ? ((Integer)value == 0 ? this.testCode + "assertTrue(" + this.getVariableName(source) + " == " + this.getVariableName(dest) + ");" : ((Integer)value < 0 ? this.testCode + "assertTrue(" + this.getVariableName(source) + " < " + this.getVariableName(dest) + ");" : this.testCode + "assertTrue(" + this.getVariableName(source) + " > " + this.getVariableName(dest) + ");")) : this.testCode + "assertEquals(" + this.getVariableName(source) + ".compareTo(" + this.getVariableName(dest) + "), " + value + ");";
    }

    protected void visitEqualsAssertion(EqualsAssertion assertion) {
        VariableReference source = assertion.getSource();
        VariableReference dest = assertion.getDest();
        Object value = assertion.getValue();
        this.testCode = source.isPrimitive() || source.isWrapperType() ? (source.getVariableClass().equals(Float.TYPE) ? (((Boolean)value).booleanValue() ? this.testCode + "assertEquals(" + this.getVariableName(source) + ", " + this.getVariableName(dest) + ", " + NumberFormatter.getNumberString(Float.valueOf(Properties.FLOAT_PRECISION), this) + ");" : this.testCode + "assertNotEquals(" + this.getVariableName(source) + ", " + this.getVariableName(dest) + ", " + NumberFormatter.getNumberString(Float.valueOf(Properties.FLOAT_PRECISION), this) + ");") : (source.getVariableClass().equals(Float.class) ? (((Boolean)value).booleanValue() ? this.testCode + "assertEquals((float)" + this.getVariableName(source) + ", (float)" + this.getVariableName(dest) + ", " + NumberFormatter.getNumberString(Float.valueOf(Properties.FLOAT_PRECISION), this) + ");" : this.testCode + "assertNotEquals((float)" + this.getVariableName(source) + ", (float)" + this.getVariableName(dest) + ", " + NumberFormatter.getNumberString(Float.valueOf(Properties.FLOAT_PRECISION), this) + ");") : (source.getVariableClass().equals(Double.TYPE) ? (((Boolean)value).booleanValue() ? this.testCode + "assertEquals(" + this.getVariableName(source) + ", " + this.getVariableName(dest) + ", " + NumberFormatter.getNumberString(Properties.DOUBLE_PRECISION, this) + ");" : this.testCode + "assertNotEquals(" + this.getVariableName(source) + ", " + this.getVariableName(dest) + ", " + NumberFormatter.getNumberString(Properties.DOUBLE_PRECISION, this) + ");") : (source.getVariableClass().equals(Double.class) ? (((Boolean)value).booleanValue() ? this.testCode + "assertEquals((double)" + this.getVariableName(source) + ", (double)" + this.getVariableName(dest) + ", " + NumberFormatter.getNumberString(Properties.DOUBLE_PRECISION, this) + ");" : this.testCode + "assertNotEquals((double)" + this.getVariableName(source) + ", (double)" + this.getVariableName(dest) + ", " + NumberFormatter.getNumberString(Properties.DOUBLE_PRECISION, this) + ");") : (source.isWrapperType() ? (((Boolean)value).booleanValue() ? this.testCode + "assertTrue(" + this.getVariableName(source) + ".equals((" + this.getClassName(Object.class) + ")" + this.getVariableName(dest) + "));" : this.testCode + "assertFalse(" + this.getVariableName(source) + ".equals((" + this.getClassName(Object.class) + ")" + this.getVariableName(dest) + "));") : (dest.isWrapperType() ? (((Boolean)value).booleanValue() ? this.testCode + "assertTrue(" + this.getVariableName(dest) + ".equals((" + this.getClassName(Object.class) + ")" + this.getVariableName(source) + "));" : this.testCode + "assertFalse(" + this.getVariableName(dest) + ".equals((" + this.getClassName(Object.class) + ")" + this.getVariableName(source) + "));") : (((Boolean)value).booleanValue() ? this.testCode + "assertTrue(" + this.getVariableName(source) + " == " + this.getVariableName(dest) + ");" : this.testCode + "assertFalse(" + this.getVariableName(source) + " == " + this.getVariableName(dest) + ");"))))))) : ((Boolean)value != false ? this.testCode + "assertTrue(" + this.getVariableName(source) + ".equals((" + this.getClassName(Object.class) + ")" + this.getVariableName(dest) + "));" : this.testCode + "assertFalse(" + this.getVariableName(source) + ".equals((" + this.getClassName(Object.class) + ")" + this.getVariableName(dest) + "));");
    }

    protected void visitSameAssertion(SameAssertion assertion) {
        VariableReference source = assertion.getSource();
        VariableReference dest = assertion.getDest();
        Object value = assertion.getValue();
        this.testCode = (Boolean)value != false ? this.testCode + "assertSame(" + this.getVariableName(source) + ", " + this.getVariableName(dest) + ");" : this.testCode + "assertNotSame(" + this.getVariableName(source) + ", " + this.getVariableName(dest) + ");";
    }

    private String getUnstableTestComment() {
        return " // Unstable assertion";
    }

    private boolean isTestUnstable() {
        return this.test != null && this.test.isUnstable();
    }

    protected void visitAssertion(Assertion assertion) {
        if (this.isTestUnstable()) {
            this.testCode = this.testCode + "// " + this.getUnstableTestComment() + ": ";
        }
        if (assertion instanceof PrimitiveAssertion) {
            this.visitPrimitiveAssertion((PrimitiveAssertion)assertion);
        } else if (assertion instanceof PrimitiveFieldAssertion) {
            this.visitPrimitiveFieldAssertion((PrimitiveFieldAssertion)assertion);
        } else if (assertion instanceof InspectorAssertion) {
            this.visitInspectorAssertion((InspectorAssertion)assertion);
        } else if (assertion instanceof NullAssertion) {
            this.visitNullAssertion((NullAssertion)assertion);
        } else if (assertion instanceof CompareAssertion) {
            this.visitCompareAssertion((CompareAssertion)assertion);
        } else if (assertion instanceof EqualsAssertion) {
            this.visitEqualsAssertion((EqualsAssertion)assertion);
        } else if (assertion instanceof SameAssertion) {
            this.visitSameAssertion((SameAssertion)assertion);
        } else if (assertion instanceof ArrayEqualsAssertion) {
            this.visitArrayEqualsAssertion((ArrayEqualsAssertion)assertion);
        } else if (assertion instanceof ArrayLengthAssertion) {
            this.visitArrayLengthAssertion((ArrayLengthAssertion)assertion);
        } else if (assertion instanceof ContainsAssertion) {
            this.visitContainsAssertion((ContainsAssertion)assertion);
        } else {
            throw new RuntimeException("Unknown assertion type: " + assertion);
        }
        if (assertion.hasComment()) {
            this.testCode = this.testCode + assertion.getComment();
        }
    }

    private void addAssertions(Statement statement) {
        boolean assertionAdded = false;
        if (this.getException(statement) != null) {
            VariableReference returnValue = statement.getReturnValue();
            for (Assertion assertion : statement.getAssertions()) {
                if (assertion == null || assertion.getReferencedVariables().contains(returnValue)) continue;
                this.visitAssertion(assertion);
                this.testCode = this.testCode + NEWLINE;
                assertionAdded = true;
            }
        } else {
            for (Assertion assertion : statement.getAssertions()) {
                if (assertion == null) continue;
                this.visitAssertion(assertion);
                this.testCode = this.testCode + NEWLINE;
                assertionAdded = true;
            }
        }
        if (assertionAdded) {
            this.testCode = this.testCode + NEWLINE;
        }
    }

    protected String getEnumValue(EnumPrimitiveStatement<?> statement) {
        Object value = statement.getValue();
        Class<?> clazz = statement.getEnumClass();
        String className = this.getClassName(clazz);
        try {
            if (value.getClass().getField(value.toString()) != null) {
                return className + "." + value;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        for (Field field : value.getClass().getDeclaredFields()) {
            if (!field.isEnumConstant()) continue;
            try {
                if (!field.get(value).equals(value)) continue;
                return className + "." + field.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return className + ".valueOf(\"" + value + "\")";
    }

    @Override
    public void visitPrimitiveStatement(PrimitiveStatement<?> statement) {
        VariableReference retval = statement.getReturnValue();
        Object value = statement.getValue();
        if (statement instanceof StringPrimitiveStatement) {
            if (value == null) {
                this.testCode = this.testCode + ((Class)retval.getType()).getSimpleName() + " " + this.getVariableName(retval) + " = null;" + NEWLINE;
            } else {
                String escapedString = StringUtil.getEscapedString((String)value);
                this.testCode = this.testCode + ((Class)retval.getType()).getSimpleName() + " " + this.getVariableName(retval) + " = \"" + escapedString + "\";" + NEWLINE;
            }
        } else if (statement instanceof EnvironmentDataStatement) {
            this.testCode = this.testCode + ((EnvironmentDataStatement)statement).getTestCode(this.getVariableName(retval));
        } else if (statement instanceof ClassPrimitiveStatement) {
            StringBuilder builder = new StringBuilder();
            String className = this.getClassName(retval);
            className = className.replaceAll("Class<(.*)(<.*>)>", "Class<$1>");
            builder.append(className);
            builder.append(" ");
            builder.append(this.getVariableName(retval));
            builder.append(" = ");
            builder.append(this.getClassName((Class)value));
            builder.append(".class;");
            builder.append(NEWLINE);
            this.testCode = this.testCode + builder.toString();
        } else {
            this.testCode = this.testCode + this.getClassName(retval) + " " + this.getVariableName(retval) + " = " + NumberFormatter.getNumberString(value, this) + ";" + NEWLINE;
        }
        this.addAssertions(statement);
    }

    @Override
    public void visitPrimitiveExpression(PrimitiveExpression statement) {
        VariableReference retval = statement.getReturnValue();
        String expression = ((Class)retval.getType()).getSimpleName() + " " + this.getVariableName(retval) + " = ";
        expression = expression + this.getVariableName(statement.getLeftOperand()) + " " + statement.getOperator().toCode() + " " + this.getVariableName(statement.getRightOperand());
        this.testCode = this.testCode + expression + ";" + NEWLINE;
        this.addAssertions(statement);
    }

    @Override
    public void visitFieldStatement(FieldStatement statement) {
        GenericField field;
        Throwable exception = this.getException(statement);
        String cast_str = "";
        StringBuilder builder = new StringBuilder();
        VariableReference retval = statement.getReturnValue();
        if (!retval.isAssignableFrom((field = statement.getField()).getFieldType())) {
            cast_str = cast_str + "(" + this.getClassName(retval) + ")";
        }
        if (exception != null) {
            builder.append(this.getClassName(retval));
            builder.append(" ");
            builder.append(this.getVariableName(retval));
            builder.append(" = null;");
            builder.append(NEWLINE);
            builder.append("try {  ");
            builder.append(NEWLINE);
        } else {
            builder.append(this.getClassName(retval));
            builder.append(" ");
        }
        if (!field.isStatic()) {
            VariableReference source = statement.getSource();
            builder.append(this.getVariableName(retval));
            builder.append(" = ");
            builder.append(cast_str);
            builder.append(this.getVariableName(source));
        } else {
            builder.append(this.getVariableName(retval));
            builder.append(" = ");
            builder.append(cast_str);
            builder.append(this.getClassName(field.getField().getDeclaringClass()));
        }
        builder.append(".");
        builder.append(field.getName());
        builder.append(";");
        if (exception != null) {
            Class<?> ex = exception.getClass();
            while (!Modifier.isPublic(ex.getModifiers())) {
                ex = ex.getSuperclass();
            }
            builder.append(NEWLINE);
            builder.append("} catch(");
            builder.append(this.getClassName(ex));
            builder.append(" e) {}");
        }
        builder.append(NEWLINE);
        this.testCode = this.testCode + builder.toString();
        this.addAssertions(statement);
    }

    private String getPrimitiveNullCast(Class<?> declaredParamType) {
        String castString = "";
        castString = castString + "(" + this.getTypeName(declaredParamType) + ") ";
        castString = castString + "(" + this.getTypeName(ClassUtils.primitiveToWrapper(declaredParamType)) + ") ";
        return castString;
    }

    private String getParameterString(Type[] parameterTypes, List<VariableReference> parameters, boolean isGenericMethod, boolean isOverloaded, int startPos) {
        String parameterString = "";
        for (int i = startPos; i < parameters.size(); ++i) {
            Class rawParamClass;
            if (i > startPos) {
                parameterString = parameterString + ", ";
            }
            Type declaredParamType = parameterTypes[i];
            Type actualParamType = parameters.get(i).getType();
            String name = this.getVariableName(parameters.get(i));
            Class clazz = rawParamClass = declaredParamType instanceof WildcardType ? Object.class : GenericTypeReflector.erase(declaredParamType);
            if (rawParamClass.isPrimitive() && name.equals("null")) {
                parameterString = parameterString + this.getPrimitiveNullCast(rawParamClass);
            } else if (isGenericMethod && !(declaredParamType instanceof WildcardType)) {
                if (!declaredParamType.equals(actualParamType) || name.equals("null")) {
                    parameterString = parameterString + "(" + this.getTypeName(declaredParamType) + ") ";
                    if (name.contains("(short")) {
                        name = name.replace("(short)", "");
                    }
                    if (name.contains("(byte")) {
                        name = name.replace("(byte)", "");
                    }
                }
            } else if (name.equals("null")) {
                parameterString = parameterString + "(" + this.getTypeName(declaredParamType) + ") ";
            } else if (!GenericClass.isAssignable(declaredParamType, actualParamType)) {
                if (TypeUtils.isArrayType(declaredParamType) && TypeUtils.isArrayType(actualParamType)) {
                    Class<?> componentClass = GenericTypeReflector.erase(declaredParamType).getComponentType();
                    if (componentClass.equals(Object.class)) {
                        GenericClass genericComponentClass = new GenericClass(componentClass);
                        if (!genericComponentClass.hasWildcardOrTypeVariables()) {
                            parameterString = parameterString + "(" + this.getTypeName(declaredParamType) + ") ";
                        }
                    } else {
                        parameterString = parameterString + "(" + this.getTypeName(declaredParamType) + ") ";
                    }
                } else if (!(actualParamType instanceof ParameterizedType)) {
                    parameterString = parameterString + "(" + this.getTypeName(declaredParamType) + ") ";
                }
                if (name.contains("(short")) {
                    name = name.replace("(short)", "");
                }
                if (name.contains("(byte")) {
                    name = name.replace("(byte)", "");
                }
            } else {
                GenericClass parameterClass = new GenericClass(declaredParamType);
                if (parameterClass.isWrapperType() && parameters.get(i).isPrimitive()) {
                    parameterString = parameterString + "(" + this.getTypeName(declaredParamType) + ") ";
                } else if (parameterClass.isPrimitive() && parameters.get(i).isWrapperType()) {
                    parameterString = parameterString + "(" + this.getTypeName(declaredParamType) + ") ";
                } else if (isOverloaded && !declaredParamType.equals(actualParamType)) {
                    parameterString = parameterString + "(" + this.getTypeName(declaredParamType) + ") ";
                }
            }
            parameterString = parameterString + name;
        }
        return parameterString;
    }

    @Override
    public void visitFunctionalMockStatement(FunctionalMockStatement st) {
        VariableReference retval = st.getReturnValue();
        String result = "";
        Class<?> rawClass = new GenericClass(retval.getType()).getRawClass();
        Class<?> targetClass = st.getTargetClass();
        assert (rawClass.getName().equals(targetClass.getName())) : "Mismatch between variable raw type " + rawClass + " and mocked " + targetClass;
        String rawClassName = this.getClassName(rawClass);
        String variableType = this.getClassName(retval);
        result = result + variableType + " " + this.getVariableName(retval);
        result = result + " = ";
        if (!variableType.equals(rawClassName)) {
            result = result + "(" + variableType + ") ";
        }
        if (st.doesNeedToUpdateInputs()) {
            try {
                st.updateMockedMethods();
            }
            catch (Exception exception) {
                // empty catch block
            }
            st.fillWithNullRefs();
        }
        result = st instanceof FunctionalMockForAbstractClassStatement ? result + "mock(" + rawClassName + ".class, CALLS_REAL_METHODS);" + NEWLINE : result + "mock(" + rawClassName + ".class, new " + ViolatedAssumptionAnswer.class.getSimpleName() + "());" + NEWLINE;
        for (MethodDescriptor md : st.getMockedMethods()) {
            String parameter_string;
            if (!md.shouldBeMocked()) continue;
            List<VariableReference> params = st.getParameters(md.getID());
            GenericClass returnType = md.getReturnClass();
            if (!returnType.isPrimitive()) {
                Type[] types = new Type[params.size()];
                boolean isOverloaded = false;
                for (int i = 0; i < types.length; ++i) {
                    if (types.length > 1 && returnType.isArray()) {
                        types[i] = Object.class;
                        isOverloaded = true;
                        continue;
                    }
                    types[i] = params.get(i).getType();
                }
                parameter_string = this.getParameterString(types, params, false, isOverloaded, 0);
            } else {
                parameter_string = this.getParameterStringForFMthatReturnPrimitive(returnType.getRawClass(), params);
            }
            result = result + "doReturn(" + parameter_string + ").when(" + this.getVariableName(retval) + ")";
            result = result + "." + md.getMethodName() + "(" + md.getInputParameterMatchers() + ");";
            result = result + NEWLINE;
        }
        this.testCode = this.testCode + result;
    }

    private String getParameterStringForFMthatReturnPrimitive(Class<?> returnType, List<VariableReference> parameters) {
        assert (returnType.isPrimitive());
        String parameterString = "";
        for (int i = 0; i < parameters.size(); ++i) {
            if (i > 0) {
                parameterString = parameterString + ", ";
            }
            String name = this.getVariableName(parameters.get(i));
            Class<?> parameterType = parameters.get(i).getVariableClass();
            if (returnType.equals(parameterType)) {
                parameterString = parameterString + name;
                continue;
            }
            GenericClass parameterClass = new GenericClass(parameterType);
            if (parameterClass.isWrapperType()) {
                boolean isRightWrapper = false;
                if (Integer.class.equals(parameterClass.getRawClass())) {
                    isRightWrapper = returnType.equals(Integer.TYPE);
                } else if (Character.class.equals(parameterClass.getRawClass())) {
                    isRightWrapper = returnType.equals(Character.TYPE);
                } else if (Boolean.class.equals(parameterClass.getRawClass())) {
                    isRightWrapper = returnType.equals(Boolean.TYPE);
                } else if (Float.class.equals(parameterClass.getRawClass())) {
                    isRightWrapper = returnType.equals(Float.TYPE);
                } else if (Double.class.equals(parameterClass.getRawClass())) {
                    isRightWrapper = returnType.equals(Double.TYPE);
                } else if (Long.class.equals(parameterClass.getRawClass())) {
                    isRightWrapper = returnType.equals(Long.TYPE);
                } else if (Short.class.equals(parameterClass.getRawClass())) {
                    isRightWrapper = returnType.equals(Short.TYPE);
                } else if (Byte.class.equals(parameterClass.getRawClass())) {
                    isRightWrapper = returnType.equals(Byte.TYPE);
                }
                if (isRightWrapper) {
                    parameterString = parameterString + name;
                    continue;
                }
            }
            parameterString = parameterString + "(" + returnType.getName() + ")" + name;
            if (!parameterClass.isWrapperType()) continue;
            if (Integer.class.equals(parameterClass.getRawClass())) {
                parameterString = parameterString + ".intValue()";
                continue;
            }
            if (Character.class.equals(parameterClass.getRawClass())) {
                parameterString = parameterString + ".charValue()";
                continue;
            }
            if (Boolean.class.equals(parameterClass.getRawClass())) {
                parameterString = parameterString + ".booleanValue()";
                continue;
            }
            if (Float.class.equals(parameterClass.getRawClass())) {
                parameterString = parameterString + ".floatValue()";
                continue;
            }
            if (Double.class.equals(parameterClass.getRawClass())) {
                parameterString = parameterString + ".doubleValue()";
                continue;
            }
            if (Long.class.equals(parameterClass.getRawClass())) {
                parameterString = parameterString + ".longValue()";
                continue;
            }
            if (Short.class.equals(parameterClass.getRawClass())) {
                parameterString = parameterString + ".shortValue()";
                continue;
            }
            if (!Byte.class.equals(parameterClass.getRawClass())) continue;
            parameterString = parameterString + ".byteValue()";
        }
        return parameterString;
    }

    @Override
    public void visitMethodStatement(MethodStatement statement) {
        String name;
        boolean unused;
        boolean lastStatement;
        String result = "";
        VariableReference retval = statement.getReturnValue();
        GenericMethod method = statement.getMethod();
        Throwable exception = this.getException(statement);
        List<VariableReference> parameters = statement.getParameterReferences();
        boolean isGenericMethod = method.hasTypeParameters();
        if (exception != null && !statement.isDeclaredException(exception)) {
            result = result + "// Undeclared exception!" + NEWLINE;
        }
        boolean bl = lastStatement = statement.getPosition() == statement.getTestCase().size() - 1;
        boolean bl2 = !Properties.ASSERTIONS ? exception != null : (unused = this.test != null && !this.test.hasReferences(retval));
        if (!retval.isVoid() && retval.getAdditionalVariableReference() == null && !unused) {
            if (exception != null) {
                if (!lastStatement || statement.hasAssertions()) {
                    result = result + this.getClassName(retval) + " " + this.getVariableName(retval) + " = " + retval.getDefaultValueString() + ";" + NEWLINE;
                }
            } else {
                result = result + this.getClassName(retval) + " ";
            }
        }
        if (this.shouldUseTryCatch(exception, statement.isDeclaredException(exception))) {
            result = result + "try { " + NEWLINE + "  ";
        }
        String parameter_string = this.getParameterString(method.getParameterTypes(), parameters, isGenericMethod, method.isOverloaded(parameters), 0);
        String callee_str = "";
        if (!(unused || retval.isAssignableFrom(method.getReturnType()) || retval.getVariableClass().isAnonymousClass() || isGenericMethod && method.getParameterTypes().length == 0 && method.isStatic() || (name = this.getClassName(retval)).matches(".*\\.\\d+$"))) {
            callee_str = "(" + name + ")";
        }
        if (method.isStatic()) {
            callee_str = callee_str + this.getClassName(method.getMethod().getDeclaringClass());
        } else {
            VariableReference callee = statement.getCallee();
            if (callee instanceof ConstantValue) {
                callee_str = callee_str + "((" + this.getClassName(method.getMethod().getDeclaringClass()) + ")" + this.getVariableName(callee) + ")";
            } else if (!method.isPublic() && !method.getDeclaringClass().equals(callee.getVariableClass()) && callee.isAssignableTo(method.getMethod().getDeclaringClass())) {
                String packageName2;
                String packageName1 = ClassUtils.getPackageName(method.getDeclaringClass());
                callee_str = !packageName1.equals(packageName2 = ClassUtils.getPackageName(callee.getVariableClass())) ? callee_str + "((" + this.getClassName(method.getMethod().getDeclaringClass()) + ")" + this.getVariableName(callee) + ")" : callee_str + this.getVariableName(callee);
            } else if (!callee.isAssignableTo(method.getMethod().getDeclaringClass())) {
                try {
                    callee.getVariableClass().getDeclaredMethod(method.getName(), method.getRawParameterTypes());
                    callee_str = callee_str + this.getVariableName(callee);
                }
                catch (NoSuchMethodException e) {
                    callee_str = callee_str + "((" + this.getTypeName(method.getMethod().getDeclaringClass()) + ") " + this.getVariableName(callee) + ")";
                }
            } else {
                callee_str = callee_str + this.getVariableName(callee);
            }
        }
        if (retval.isVoid()) {
            result = result + callee_str + "." + method.getName() + "(" + parameter_string + ");";
        } else {
            if (!unused) {
                result = result + this.getVariableName(retval) + " = ";
            }
            result = result + callee_str + "." + method.getName() + "(" + parameter_string + ");";
        }
        if (this.shouldUseTryCatch(exception, statement.isDeclaredException(exception))) {
            if (Properties.ASSERTIONS) {
                result = result + this.generateFailAssertion(statement, exception);
            }
            result = result + NEWLINE + "}";
            result = result + this.generateCatchBlock(statement, exception);
        }
        this.testCode = this.testCode + result + NEWLINE;
        this.addAssertions(statement);
    }

    public String generateCatchBlock(AbstractStatement statement, Throwable exception) {
        String exceptionMessage;
        String result = "";
        Class<?> ex = this.getExceptionClassToUse(exception);
        result = !(exception instanceof RuntimeException) && !(exception instanceof Error) ? (statement.isDeclaredException(exception) ? result + " catch(" + this.getClassName(ex) + " e) {" + NEWLINE : result + " catch(" + this.getClassName(Throwable.class) + " e) {" + NEWLINE) : result + " catch(" + this.getClassName(ex) + " e) {" + NEWLINE;
        try {
            exceptionMessage = exception.getMessage() != null ? exception.getMessage().replace("*/", "*_/") : "no message in exception (getMessage() returned null)";
        }
        catch (Exception exceptionThownExecutionGetMessage) {
            exceptionMessage = "no message (getMessage() has thrown an exception)";
        }
        String sourceClass = this.getSourceClassName(exception);
        if (sourceClass == null || this.isValidSource(sourceClass)) {
            result = result + "   //" + NEWLINE;
            for (String msg : exceptionMessage.split("\n")) {
                result = result + "   // " + StringEscapeUtils.escapeJava(msg) + NEWLINE;
            }
            result = result + "   //" + NEWLINE;
        }
        if (sourceClass != null && this.isValidSource(sourceClass) && this.isExceptionToAssertThrownBy(ex) && !Properties.NO_RUNTIME_DEPENDENCY) {
            result = result + "   verifyException(\"" + sourceClass + "\", e);" + NEWLINE;
        }
        result = result + "}" + NEWLINE;
        return result;
    }

    private String getSourceClassName(Throwable exception) {
        if (exception.getStackTrace().length == 0) {
            return null;
        }
        return exception.getStackTrace()[0].getClassName();
    }

    private boolean isValidSource(String sourceClass) {
        return (!sourceClass.startsWith(PackageInfo.getEvoSuitePackage() + ".") || sourceClass.startsWith(PackageInfo.getEvoSuitePackage() + ".runtime.")) && !sourceClass.equals(URLClassLoader.class.getName()) && !sourceClass.startsWith(RegExp.class.getPackage().getName()) && !sourceClass.startsWith("java.lang.System") && !sourceClass.startsWith("java.lang.String") && !sourceClass.startsWith("java.lang.Class") && !sourceClass.startsWith("sun.") && !sourceClass.startsWith("com.sun.") && !sourceClass.startsWith("jdk.internal.") && !sourceClass.startsWith("<evosuite>");
    }

    private boolean isExceptionToAssertThrownBy(Class<?> exceptionClass) {
        return !this.invalidExceptions.contains(exceptionClass);
    }

    private Class<?> getExceptionClassToUse(Throwable exception) {
        Class<?> ex = exception.getClass();
        while (!Modifier.isPublic(ex.getModifiers()) || EvoSuiteMock.class.isAssignableFrom(ex) || ex.getCanonicalName().startsWith("com.sun.")) {
            ex = ex.getSuperclass();
        }
        return ex;
    }

    private String getSimpleTypeName(Type type) {
        String typeName = this.getTypeName(type);
        int dotIndex = typeName.lastIndexOf(".");
        if (dotIndex >= 0 && dotIndex + 1 < typeName.length()) {
            typeName = typeName.substring(dotIndex + 1);
        }
        return typeName;
    }

    @Override
    public void visitConstructorStatement(ConstructorStatement statement) {
        String result = "";
        GenericConstructor constructor = statement.getConstructor();
        VariableReference retval = statement.getReturnValue();
        Throwable exception = this.getException(statement);
        boolean isGenericConstructor = constructor.hasTypeParameters();
        boolean isNonStaticMemberClass = constructor.getConstructor().getDeclaringClass().isMemberClass() && !constructor.isStatic() && !Modifier.isStatic(constructor.getConstructor().getDeclaringClass().getModifiers());
        List<VariableReference> parameters = statement.getParameterReferences();
        int startPos = 0;
        if (isNonStaticMemberClass) {
            startPos = 1;
        }
        Type[] parameterTypes = constructor.getParameterTypes();
        String parameterString = this.getParameterString(parameterTypes, parameters, isGenericConstructor, constructor.isOverloaded(parameters), startPos);
        if (this.shouldUseTryCatch(exception, statement.isDeclaredException(exception))) {
            String className = this.getClassName(retval);
            if (retval.isPrimitive()) {
                className = retval.getGenericClass().getUnboxedType().getSimpleName();
            }
            result = className + " " + this.getVariableName(retval) + " = null;" + NEWLINE;
            result = result + "try {" + NEWLINE + "  ";
        } else {
            result = result + this.getClassName(retval) + " ";
        }
        result = isNonStaticMemberClass ? result + this.getVariableName(retval) + " = " + this.getVariableName(parameters.get(0)) + ".new " + this.getSimpleTypeName(constructor.getOwnerType()) + "(" + parameterString + ");" : result + this.getVariableName(retval) + " = new " + this.getTypeName(constructor.getOwnerType()) + "(" + parameterString + ");";
        if (this.shouldUseTryCatch(exception, statement.isDeclaredException(exception))) {
            if (Properties.ASSERTIONS) {
                result = result + this.generateFailAssertion(statement, exception);
            }
            result = result + NEWLINE + "}";
            result = result + this.generateCatchBlock(statement, exception);
        }
        this.testCode = this.testCode + result + NEWLINE;
        this.addAssertions(statement);
    }

    private boolean shouldUseTryCatch(Throwable t, boolean isDeclared) {
        return t != null && !(t instanceof OutOfMemoryError) && !(t instanceof TooManyResourcesException) && !this.test.isFailing() && (Properties.CATCH_UNDECLARED_EXCEPTIONS || isDeclared);
    }

    public String generateFailAssertion(AbstractStatement statement, Throwable exception) {
        Class<?> ex = this.getExceptionClassToUse(exception);
        String stmt = " fail(\"Expecting exception: " + this.getClassName(ex) + "\");" + NEWLINE;
        if (this.isTestUnstable()) {
            stmt = "// " + stmt + this.getUnstableTestComment();
        }
        return NEWLINE + " " + stmt;
    }

    @Override
    public void visitArrayStatement(ArrayStatement statement) {
        VariableReference retval = statement.getReturnValue();
        List<Integer> lengths = statement.getLengths();
        String type = this.getClassName(retval);
        String multiDimensions = "";
        if (lengths.size() == 1) {
            type = type.replaceFirst("\\[\\]", "");
            multiDimensions = "[" + lengths.get(0) + "]";
            while (type.contains("[]")) {
                multiDimensions = multiDimensions + "[]";
                type = type.replaceFirst("\\[\\]", "");
            }
        } else {
            type = type.replaceAll("\\[\\]", "");
            for (int length : lengths) {
                multiDimensions = multiDimensions + "[" + length + "]";
            }
        }
        if (retval.getGenericClass().isGenericArray()) {
            if (lengths.size() > 1) {
                multiDimensions = "new int[] {" + lengths.get(0);
                for (int i = 1; i < lengths.size(); ++i) {
                    multiDimensions = multiDimensions + ", " + lengths.get(i);
                }
                multiDimensions = multiDimensions + "}";
            } else {
                multiDimensions = "" + lengths.get(0);
            }
            this.testCode = this.testCode + this.getClassName(retval) + " " + this.getVariableName(retval) + " = (" + this.getClassName(retval) + ") " + this.getClassName(Array.class) + ".newInstance(" + this.getClassName(retval.getComponentClass()).replaceAll("\\[\\]", "") + ".class, " + multiDimensions + ");" + NEWLINE;
        } else {
            this.testCode = this.testCode + this.getClassName(retval) + " " + this.getVariableName(retval) + " = new " + type + multiDimensions + ";" + NEWLINE;
        }
        this.addAssertions(statement);
    }

    @Override
    public void visitAssignmentStatement(AssignmentStatement statement) {
        String cast = "";
        VariableReference retval = statement.getReturnValue();
        VariableReference parameter = statement.getValue();
        if (!retval.getVariableClass().equals(parameter.getVariableClass())) {
            if (retval.isWrapperType() && parameter.isPrimitive()) {
                cast = "(" + this.getTypeName(retval.getType()) + ") ";
                if (!ClassUtils.primitiveToWrapper(parameter.getVariableClass()).equals(retval.getVariableClass())) {
                    cast = cast + "(" + ClassUtils.wrapperToPrimitive(retval.getVariableClass()) + ")";
                }
            } else if (retval.isPrimitive() && parameter.isWrapperType()) {
                cast = "(" + this.getTypeName(retval.getType()) + ") ";
                if (!ClassUtils.primitiveToWrapper(retval.getVariableClass()).equals(parameter.getVariableClass())) {
                    cast = cast + "(" + ClassUtils.wrapperToPrimitive(parameter.getVariableClass()) + ")";
                }
            } else if (retval.isWrapperType() && parameter.isWrapperType()) {
                cast = "(" + this.getTypeName(retval.getType()) + ") ";
                if (!ClassUtils.primitiveToWrapper(parameter.getVariableClass()).equals(retval.getVariableClass())) {
                    cast = cast + "(" + ClassUtils.wrapperToPrimitive(retval.getVariableClass()) + ")";
                }
            } else {
                cast = "(" + this.getClassName(retval) + ") ";
            }
        }
        this.testCode = this.testCode + this.getVariableName(retval) + " = " + cast + this.getVariableName(parameter) + ";" + NEWLINE;
        this.addAssertions(statement);
    }

    @Override
    public void visitNullStatement(NullStatement statement) {
        VariableReference retval = statement.getReturnValue();
        this.testCode = this.testCode + this.getClassName(retval) + " " + this.getVariableName(retval) + " = null;" + NEWLINE;
    }

    @Override
    public void visitStatement(Statement statement) {
        if (!statement.getComment().isEmpty()) {
            String comment = statement.getComment();
            for (String line : comment.split("\n")) {
                this.testCode = this.testCode + "// " + line + NEWLINE;
            }
        }
        super.visitStatement(statement);
    }
}

