/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.branch.Branch;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.coverage.dataflow.DefUse;
import org.evosuite.coverage.dataflow.DefUsePool;
import org.evosuite.coverage.dataflow.Definition;
import org.evosuite.coverage.dataflow.Use;
import org.evosuite.setup.CallContext;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testcase.execution.ExecutionTrace;
import org.evosuite.testcase.execution.ExecutionTraceProxy;
import org.evosuite.testcase.execution.MethodCall;
import org.evosuite.utils.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionTraceImpl
implements ExecutionTrace,
Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionTrace.class);
    public static boolean traceCalls = false;
    public static boolean disableContext = false;
    public static boolean traceCoverage = true;
    private List<BranchEval> branchesTrace = new ArrayList<BranchEval>();
    public Map<String, Map<String, Map<Integer, Integer>>> coverage = Collections.synchronizedMap(new HashMap());
    public Map<Integer, Integer> coveredFalse = Collections.synchronizedMap(new HashMap());
    public Map<String, Integer> coveredMethods = Collections.synchronizedMap(new HashMap());
    public Map<String, Integer> coveredBranchlessMethods = Collections.synchronizedMap(new HashMap());
    public Map<Integer, Integer> coveredPredicates = Collections.synchronizedMap(new HashMap());
    public Map<Integer, Integer> coveredTrue = Collections.synchronizedMap(new HashMap());
    public Map<Integer, Integer> coveredDefs = Collections.synchronizedMap(new HashMap());
    public Map<Integer, Map<CallContext, Double>> coveredTrueContext = Collections.synchronizedMap(new HashMap());
    public Map<Integer, Map<CallContext, Double>> coveredFalseContext = Collections.synchronizedMap(new HashMap());
    public Map<Integer, Map<CallContext, Integer>> coveredPredicateContext = Collections.synchronizedMap(new HashMap());
    public Map<String, Map<CallContext, Integer>> coveredMethodContext = Collections.synchronizedMap(new HashMap());
    private int duCounter = 0;
    private Throwable explicitException = null;
    public Map<Integer, Double> falseDistances = Collections.synchronizedMap(new HashMap());
    private final Map<Integer, Double> falseDistancesSum = Collections.synchronizedMap(new HashMap());
    public List<MethodCall> finishedCalls = Collections.synchronizedList(new ArrayList());
    public Map<Integer, Object> knownCallerObjects = Collections.synchronizedMap(new HashMap());
    private int methodId = 0;
    public Map<Integer, Double> mutantDistances = Collections.synchronizedMap(new HashMap());
    private int objectCounter = 0;
    public Map<String, HashMap<Integer, HashMap<Integer, Integer>>> passedDefinitions = Collections.synchronizedMap(new HashMap());
    public Map<String, HashMap<Integer, HashMap<Integer, Integer>>> passedUses = Collections.synchronizedMap(new HashMap());
    public Map<String, HashMap<Integer, HashMap<Integer, Object>>> passedDefinitionObject = Collections.synchronizedMap(new HashMap());
    public Map<String, HashMap<Integer, HashMap<Integer, Object>>> passedUseObject = Collections.synchronizedMap(new HashMap());
    private int proxyCount = 1;
    public Map<String, Map<String, Map<Integer, Integer>>> returnData = Collections.synchronizedMap(new HashMap());
    LinkedList<MethodCall> stack = new LinkedList();
    public Set<Integer> touchedMutants = Collections.synchronizedSet(new HashSet());
    public Map<Integer, Double> trueDistances = Collections.synchronizedMap(new HashMap());
    private final Map<Integer, Double> trueDistancesSum = Collections.synchronizedMap(new HashMap());
    public static Set<Integer> gradientBranches = Collections.synchronizedSet(new HashSet());
    public static Set<Integer> gradientBranchesCoveredTrue = Collections.synchronizedSet(new HashSet());
    public static Set<Integer> gradientBranchesCoveredFalse = Collections.synchronizedSet(new HashSet());
    public static Map<RuntimeVariable, Set<Integer>> bytecodeInstructionReached = Collections.synchronizedMap(new HashMap());
    public static Map<RuntimeVariable, Set<Integer>> bytecodeInstructionCoveredTrue = Collections.synchronizedMap(new HashMap());
    public static Map<RuntimeVariable, Set<Integer>> bytecodeInstructionCoveredFalse = Collections.synchronizedMap(new HashMap());
    private HashSet<String> classesWithStaticWrites = new HashSet();
    private HashSet<String> classesWithStaticReads = new HashSet();
    private List<String> initializedClasses = new LinkedList<String>();

    private static void checkSaneCall(MethodCall call) {
        if (call.trueDistanceTrace.size() != call.falseDistanceTrace.size() || call.falseDistanceTrace.size() != call.defuseCounterTrace.size() || call.defuseCounterTrace.size() != call.branchTrace.size()) {
            throw new IllegalStateException("insane MethodCall: traces should all be of equal size. " + call.explain());
        }
    }

    public static void enableContext() {
        disableContext = false;
    }

    public static void disableContext() {
        ExecutionTraceImpl.disableTraceCalls();
        disableContext = true;
    }

    public static void disableTraceCalls() {
        traceCalls = false;
    }

    public static void enableTraceCalls() {
        traceCalls = true;
    }

    public static boolean isTraceCallsEnabled() {
        return traceCalls;
    }

    public static void enableTraceCoverage() {
        traceCoverage = true;
    }

    private static void removeFinishCalls(ExecutionTraceImpl trace, ArrayList<Integer> removableCalls) {
        Collections.sort(removableCalls);
        for (int i = removableCalls.size() - 1; i >= 0; --i) {
            int toRemove = removableCalls.get(i);
            MethodCall removed = trace.finishedCalls.remove(toRemove);
            if (removed != null) continue;
            throw new IllegalStateException("trace.finished_calls not allowed to contain null");
        }
    }

    private static void removeFromFinishCall(MethodCall call, ArrayList<Integer> removableIndices) {
        ExecutionTraceImpl.checkSaneCall(call);
        Collections.sort(removableIndices);
        for (int i = removableIndices.size() - 1; i >= 0; --i) {
            int removableIndex = removableIndices.get(i);
            Integer removedBranch = call.branchTrace.remove(removableIndex);
            Double removedTrue = call.trueDistanceTrace.remove(removableIndex);
            Double removedFalse = call.falseDistanceTrace.remove(removableIndex);
            Integer removedCounter = call.defuseCounterTrace.remove(removableIndex);
            if (removedCounter != null && removedBranch != null && removedTrue != null && removedFalse != null) continue;
            throw new IllegalStateException("trace.finished_calls-traces not allowed to contain null");
        }
    }

    public ExecutionTraceImpl() {
        this.stack.add(new MethodCall("", "", 0, 0, 0));
    }

    public void addProxy() {
        ++this.proxyCount;
    }

    public void removeProxy() {
        --this.proxyCount;
    }

    @Override
    public void branchPassed(int branch, int bytecode_id, double true_distance, double false_distance) {
        assert (true_distance >= 0.0);
        assert (false_distance >= 0.0);
        this.updateTopStackMethodCall(branch, bytecode_id, true_distance, false_distance);
        if (Properties.TRACK_BOOLEAN_BRANCHES && (true_distance != 0.0 && true_distance != 1.0 || false_distance != 0.0 && false_distance != 1.0)) {
            gradientBranches.add(branch);
        }
        if (traceCoverage) {
            if (!this.coveredPredicates.containsKey(branch)) {
                this.coveredPredicates.put(branch, 1);
            } else {
                this.coveredPredicates.put(branch, this.coveredPredicates.get(branch) + 1);
            }
            if (true_distance == 0.0) {
                if (!this.coveredTrue.containsKey(branch)) {
                    this.coveredTrue.put(branch, 1);
                } else {
                    this.coveredTrue.put(branch, this.coveredTrue.get(branch) + 1);
                }
            }
            if (false_distance == 0.0) {
                if (!this.coveredFalse.containsKey(branch)) {
                    this.coveredFalse.put(branch, 1);
                } else {
                    this.coveredFalse.put(branch, this.coveredFalse.get(branch) + 1);
                }
            }
        }
        if (Properties.TRACK_COVERED_GRADIENT_BRANCHES && gradientBranches.contains(branch)) {
            if (this.coveredTrue.containsKey(branch)) {
                gradientBranchesCoveredTrue.add(branch);
            }
            if (this.coveredFalse.containsKey(branch)) {
                gradientBranchesCoveredFalse.add(branch);
            }
        }
        if (Properties.BRANCH_COMPARISON_TYPES) {
            int opcode = BranchPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getBranch(branch).getInstruction().getASMNode().getOpcode();
            int previousOpcode = -2;
            if (BranchPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getBranch(branch).getInstruction().getASMNode().getPrevious() != null) {
                previousOpcode = BranchPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getBranch(branch).getInstruction().getASMNode().getPrevious().getOpcode();
            }
            boolean cTrue = this.coveredTrue.containsKey(branch);
            boolean cFalse = this.coveredFalse.containsKey(branch);
            switch (previousOpcode) {
                case 148: {
                    this.trackBranchOpcode(bytecodeInstructionReached, RuntimeVariable.Reached_lcmp, branch);
                    if (cTrue) {
                        this.trackBranchOpcode(bytecodeInstructionCoveredTrue, RuntimeVariable.Covered_lcmp, branch);
                    }
                    if (!cFalse) break;
                    this.trackBranchOpcode(bytecodeInstructionCoveredFalse, RuntimeVariable.Covered_lcmp, branch);
                    break;
                }
                case 149: {
                    this.trackBranchOpcode(bytecodeInstructionReached, RuntimeVariable.Reached_fcmpl, branch);
                    if (cTrue) {
                        this.trackBranchOpcode(bytecodeInstructionCoveredTrue, RuntimeVariable.Covered_fcmpl, branch);
                    }
                    if (!cFalse) break;
                    this.trackBranchOpcode(bytecodeInstructionCoveredFalse, RuntimeVariable.Covered_fcmpl, branch);
                    break;
                }
                case 150: {
                    this.trackBranchOpcode(bytecodeInstructionReached, RuntimeVariable.Reached_fcmpg, branch);
                    if (cTrue) {
                        this.trackBranchOpcode(bytecodeInstructionCoveredTrue, RuntimeVariable.Covered_fcmpg, branch);
                    }
                    if (!cFalse) break;
                    this.trackBranchOpcode(bytecodeInstructionCoveredFalse, RuntimeVariable.Covered_fcmpg, branch);
                    break;
                }
                case 151: {
                    this.trackBranchOpcode(bytecodeInstructionReached, RuntimeVariable.Reached_dcmpl, branch);
                    if (cTrue) {
                        this.trackBranchOpcode(bytecodeInstructionCoveredTrue, RuntimeVariable.Covered_dcmpl, branch);
                    }
                    if (!cFalse) break;
                    this.trackBranchOpcode(bytecodeInstructionCoveredFalse, RuntimeVariable.Covered_dcmpl, branch);
                    break;
                }
                case 152: {
                    this.trackBranchOpcode(bytecodeInstructionReached, RuntimeVariable.Reached_dcmpg, branch);
                    if (cTrue) {
                        this.trackBranchOpcode(bytecodeInstructionCoveredTrue, RuntimeVariable.Covered_dcmpg, branch);
                    }
                    if (!cFalse) break;
                    this.trackBranchOpcode(bytecodeInstructionCoveredFalse, RuntimeVariable.Covered_dcmpg, branch);
                }
            }
            switch (opcode) {
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: {
                    this.trackBranchOpcode(bytecodeInstructionReached, RuntimeVariable.Reached_IntZero, branch);
                    if (cTrue) {
                        this.trackBranchOpcode(bytecodeInstructionCoveredTrue, RuntimeVariable.Covered_IntZero, branch);
                    }
                    if (!cFalse) break;
                    this.trackBranchOpcode(bytecodeInstructionCoveredFalse, RuntimeVariable.Covered_IntZero, branch);
                    break;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: {
                    this.trackBranchOpcode(bytecodeInstructionReached, RuntimeVariable.Reached_IntInt, branch);
                    if (cTrue) {
                        this.trackBranchOpcode(bytecodeInstructionCoveredTrue, RuntimeVariable.Covered_IntInt, branch);
                    }
                    if (!cFalse) break;
                    this.trackBranchOpcode(bytecodeInstructionCoveredFalse, RuntimeVariable.Covered_IntInt, branch);
                    break;
                }
                case 165: 
                case 166: {
                    this.trackBranchOpcode(bytecodeInstructionReached, RuntimeVariable.Reached_RefRef, branch);
                    if (cTrue) {
                        this.trackBranchOpcode(bytecodeInstructionCoveredTrue, RuntimeVariable.Covered_RefRef, branch);
                    }
                    if (!cFalse) break;
                    this.trackBranchOpcode(bytecodeInstructionCoveredFalse, RuntimeVariable.Covered_RefRef, branch);
                    break;
                }
                case 198: 
                case 199: {
                    this.trackBranchOpcode(bytecodeInstructionReached, RuntimeVariable.Reached_RefNull, branch);
                    if (cTrue) {
                        this.trackBranchOpcode(bytecodeInstructionCoveredTrue, RuntimeVariable.Covered_RefNull, branch);
                    }
                    if (!cFalse) break;
                    this.trackBranchOpcode(bytecodeInstructionCoveredFalse, RuntimeVariable.Covered_RefNull, branch);
                }
            }
        }
        if (!this.trueDistances.containsKey(branch)) {
            this.trueDistances.put(branch, true_distance);
        } else {
            this.trueDistances.put(branch, Math.min(this.trueDistances.get(branch), true_distance));
        }
        if (!this.falseDistances.containsKey(branch)) {
            this.falseDistances.put(branch, false_distance);
        } else {
            this.falseDistances.put(branch, Math.min(this.falseDistances.get(branch), false_distance));
        }
        if (!this.trueDistancesSum.containsKey(branch)) {
            this.trueDistancesSum.put(branch, true_distance);
        } else {
            this.trueDistancesSum.put(branch, this.trueDistancesSum.get(branch) + true_distance);
        }
        if (!this.falseDistancesSum.containsKey(branch)) {
            this.falseDistancesSum.put(branch, false_distance);
        } else {
            this.falseDistancesSum.put(branch, this.falseDistancesSum.get(branch) + false_distance);
        }
        if (!disableContext && (Properties.INSTRUMENT_CONTEXT || Properties.INSTRUMENT_METHOD_CALLS || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.IBRANCH) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.CBRANCH))) {
            this.updateBranchContextMaps(branch, true_distance, false_distance);
        }
        if (Properties.BRANCH_EVAL) {
            this.branchesTrace.add(new BranchEval(branch, true_distance, false_distance));
        }
    }

    private void trackBranchOpcode(Map<RuntimeVariable, Set<Integer>> trackedMap, RuntimeVariable v, int branch_id) {
        if (!trackedMap.containsKey((Object)v)) {
            trackedMap.put(v, new HashSet());
        }
        Set<Integer> branchSet = trackedMap.get((Object)v);
        branchSet.add(branch_id);
        trackedMap.put(v, branchSet);
    }

    private void updateBranchContextMaps(int branch, double true_distance, double false_distance) {
        if (!this.coveredPredicateContext.containsKey(branch)) {
            this.coveredPredicateContext.put(branch, new HashMap());
            this.coveredTrueContext.put(branch, new HashMap());
            this.coveredFalseContext.put(branch, new HashMap());
        }
        CallContext context = new CallContext(this.stack);
        if (!this.coveredPredicateContext.get(branch).containsKey(context)) {
            this.coveredPredicateContext.get(branch).put(context, 1);
            this.coveredTrueContext.get(branch).put(context, true_distance);
            this.coveredFalseContext.get(branch).put(context, false_distance);
        } else {
            this.coveredPredicateContext.get(branch).put(context, this.coveredPredicateContext.get(branch).get(context) + 1);
            this.coveredTrueContext.get(branch).put(context, Math.min(this.coveredTrueContext.get(branch).get(context), true_distance));
            this.coveredFalseContext.get(branch).put(context, Math.min(this.coveredFalseContext.get(branch).get(context), false_distance));
        }
    }

    @Override
    public void clear() {
        this.finishedCalls = new ArrayList<MethodCall>();
        this.stack = new LinkedList();
        this.stack.add(new MethodCall("", "", 0, 0, 0));
        this.coverage = new HashMap<String, Map<String, Map<Integer, Integer>>>();
        this.returnData = new HashMap<String, Map<String, Map<Integer, Integer>>>();
        this.methodId = 0;
        this.duCounter = 0;
        this.objectCounter = 0;
        this.knownCallerObjects = new HashMap<Integer, Object>();
        this.trueDistances = new HashMap<Integer, Double>();
        this.falseDistances = new HashMap<Integer, Double>();
        this.mutantDistances = new HashMap<Integer, Double>();
        this.touchedMutants = new HashSet<Integer>();
        this.coveredMethods = new HashMap<String, Integer>();
        this.coveredBranchlessMethods = new HashMap<String, Integer>();
        this.coveredPredicates = new HashMap<Integer, Integer>();
        this.coveredTrue = new HashMap<Integer, Integer>();
        this.coveredFalse = new HashMap<Integer, Integer>();
        this.coveredDefs = new HashMap<Integer, Integer>();
        this.passedDefinitions = new HashMap<String, HashMap<Integer, HashMap<Integer, Integer>>>();
        this.passedUses = new HashMap<String, HashMap<Integer, HashMap<Integer, Integer>>>();
        this.passedDefinitionObject = new HashMap<String, HashMap<Integer, HashMap<Integer, Object>>>();
        this.passedUseObject = new HashMap<String, HashMap<Integer, HashMap<Integer, Object>>>();
        this.branchesTrace = new ArrayList<BranchEval>();
        this.coveredTrueContext = new HashMap<Integer, Map<CallContext, Double>>();
        this.coveredFalseContext = new HashMap<Integer, Map<CallContext, Double>>();
        this.coveredPredicateContext = new HashMap<Integer, Map<CallContext, Integer>>();
        this.initializedClasses = new ArrayList<String>();
        this.classesWithStaticReads = new HashSet();
        this.classesWithStaticWrites = new HashSet();
    }

    public ExecutionTraceImpl clone() {
        ExecutionTraceImpl copy = new ExecutionTraceImpl();
        for (MethodCall call : this.finishedCalls) {
            copy.finishedCalls.add(call.clone());
        }
        copy.coverage = new HashMap<String, Map<String, Map<Integer, Integer>>>();
        if (this.coverage != null) {
            copy.coverage.putAll(this.coverage);
        }
        copy.returnData = new HashMap<String, Map<String, Map<Integer, Integer>>>();
        copy.returnData.putAll(this.returnData);
        copy.trueDistances.putAll(this.trueDistances);
        copy.falseDistances.putAll(this.falseDistances);
        copy.coveredMethods.putAll(this.coveredMethods);
        copy.coveredBranchlessMethods.putAll(this.coveredBranchlessMethods);
        copy.coveredPredicates.putAll(this.coveredPredicates);
        copy.coveredTrue.putAll(this.coveredTrue);
        copy.coveredFalse.putAll(this.coveredFalse);
        copy.coveredDefs.putAll(this.coveredDefs);
        copy.touchedMutants.addAll(this.touchedMutants);
        copy.mutantDistances.putAll(this.mutantDistances);
        copy.passedDefinitions.putAll(this.passedDefinitions);
        copy.passedUses.putAll(this.passedUses);
        copy.passedDefinitionObject.putAll(this.passedDefinitionObject);
        copy.passedUseObject.putAll(this.passedUseObject);
        copy.branchesTrace.addAll(this.branchesTrace);
        copy.coveredTrueContext.putAll(this.coveredTrueContext);
        copy.coveredFalseContext.putAll(this.coveredFalseContext);
        copy.coveredPredicateContext.putAll(this.coveredPredicateContext);
        copy.initializedClasses.addAll(this.initializedClasses);
        copy.classesWithStaticReads.addAll(this.classesWithStaticReads);
        copy.classesWithStaticWrites.addAll(this.classesWithStaticWrites);
        copy.methodId = this.methodId;
        copy.duCounter = this.duCounter;
        copy.objectCounter = this.objectCounter;
        copy.knownCallerObjects.putAll(this.knownCallerObjects);
        copy.proxyCount = 1;
        return copy;
    }

    @Override
    public void definitionPassed(Object object, Object caller, int defID) {
        if (!traceCalls) {
            return;
        }
        Definition def = DefUsePool.getDefinitionByDefId(defID);
        if (def == null) {
            throw new IllegalStateException("expect DefUsePool to known defIDs that are passed by instrumented code");
        }
        if (!this.coveredDefs.containsKey(defID)) {
            this.coveredDefs.put(defID, 0);
        } else {
            this.coveredDefs.put(defID, this.coveredDefs.get(defID) + 1);
        }
        String varName = def.getVariableName();
        int objectID = this.registerObject(caller);
        if (objectID != 0 && def.isStaticDefUse()) {
            objectID = 0;
        }
        if (this.passedDefinitions.get(varName) == null) {
            this.passedDefinitions.put(varName, new HashMap());
            this.passedDefinitionObject.put(varName, new HashMap());
        }
        HashMap<Integer, Integer> defs = this.passedDefinitions.get(varName).get(objectID);
        HashMap<Integer, Object> defsObject = this.passedDefinitionObject.get(varName).get(objectID);
        if (defs == null) {
            defs = new HashMap();
            defsObject = new HashMap();
        }
        defs.put(this.duCounter, defID);
        defsObject.put(this.duCounter, object);
        this.passedDefinitions.get(varName).put(objectID, defs);
        this.passedDefinitionObject.get(varName).put(objectID, defsObject);
        ++this.duCounter;
    }

    @Override
    public void enteredMethod(String className, String methodName, Object caller) {
        if (traceCoverage) {
            String id = className + "." + methodName;
            if (!this.coveredMethods.containsKey(id)) {
                this.coveredMethods.put(id, 1);
            } else {
                this.coveredMethods.put(id, this.coveredMethods.get(id) + 1);
            }
            if (BranchPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).isBranchlessMethod(className, id)) {
                if (!this.coveredBranchlessMethods.containsKey(id)) {
                    this.coveredBranchlessMethods.put(id, 1);
                } else {
                    this.coveredBranchlessMethods.put(id, this.coveredBranchlessMethods.get(id) + 1);
                }
            }
        }
        if (!className.isEmpty() && !methodName.isEmpty()) {
            int callingObjectID = this.registerObject(caller);
            MethodCall call = new MethodCall(className, methodName, this.methodId, callingObjectID, this.stack.size());
            ++this.methodId;
            if (traceCalls && (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.DEFUSE) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.ALLDEFS))) {
                call.branchTrace.add(-1);
                call.trueDistanceTrace.add(1.0);
                call.falseDistanceTrace.add(0.0);
                call.defuseCounterTrace.add(this.duCounter);
            }
            this.stack.push(call);
            if (!disableContext && (Properties.INSTRUMENT_CONTEXT || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.IBRANCH) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.CBRANCH))) {
                this.updateMethodContextMaps(className, methodName, caller);
            }
        }
    }

    private void updateMethodContextMaps(String className, String methodName, Object caller) {
        String id = className + "." + methodName;
        if (!this.coveredMethodContext.containsKey(id)) {
            this.coveredMethodContext.put(id, new HashMap());
        }
        CallContext context = new CallContext(this.stack);
        if (!this.coveredMethodContext.get(id).containsKey(context)) {
            this.coveredMethodContext.get(id).put(context, 1);
        } else {
            this.coveredMethodContext.get(id).put(context, this.coveredMethodContext.get(id).get(context) + 1);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExecutionTraceImpl other = (ExecutionTraceImpl)obj;
        if (this.coverage == null ? other.coverage != null : !this.coverage.equals(other.coverage)) {
            return false;
        }
        if (this.finishedCalls == null ? other.finishedCalls != null : !this.finishedCalls.equals(other.finishedCalls)) {
            return false;
        }
        if (this.returnData == null ? other.returnData != null : !this.returnData.equals(other.returnData)) {
            return false;
        }
        return !(this.stack == null ? other.stack != null : !this.stack.equals(other.stack));
    }

    @Override
    public void exitMethod(String classname, String methodname) {
        if (!classname.isEmpty() && !methodname.isEmpty()) {
            if (!this.stack.isEmpty() && !this.stack.peek().methodName.equals(methodname)) {
                if (this.stack.peek().methodName.isEmpty() && !this.stack.peek().branchTrace.isEmpty()) {
                    this.finishedCalls.add(this.stack.pop());
                } else {
                    this.stack.pop();
                }
            } else {
                this.finishedCalls.add(this.stack.pop());
            }
        }
    }

    @Override
    public synchronized void finishCalls() {
        logger.debug("At the end, we have " + this.stack.size() + " calls left on stack");
        while (!this.stack.isEmpty()) {
            this.finishedCalls.add(this.stack.pop());
        }
    }

    @Override
    public List<BranchEval> getBranchesTrace() {
        return this.branchesTrace;
    }

    @Override
    public Map<String, Map<String, Map<Integer, Integer>>> getCoverageData() {
        return this.coverage;
    }

    @Override
    public Set<Integer> getCoveredFalseBranches() {
        HashSet<Integer> covered = new HashSet<Integer>();
        for (Map.Entry<Integer, Double> entry : this.falseDistances.entrySet()) {
            if (entry.getValue() != 0.0) continue;
            covered.add(entry.getKey());
        }
        return covered;
    }

    @Override
    public Set<Integer> getCoveredLines(String className) {
        HashSet<Integer> coveredLines = new HashSet<Integer>();
        for (Map.Entry<String, Map<String, Map<Integer, Integer>>> entry : this.coverage.entrySet()) {
            if (!entry.getKey().equals(className) && !entry.getKey().startsWith(className + "$")) continue;
            for (Map<Integer, Integer> methodentry : entry.getValue().values()) {
                coveredLines.addAll(methodentry.keySet());
            }
        }
        return coveredLines;
    }

    @Override
    public Set<Integer> getCoveredLines() {
        return this.getCoveredLines(Properties.TARGET_CLASS);
    }

    @Override
    public Set<Integer> getAllCoveredLines() {
        HashSet<Integer> coveredLines = new HashSet<Integer>();
        for (Map.Entry<String, Map<String, Map<Integer, Integer>>> entry : this.coverage.entrySet()) {
            for (Map<Integer, Integer> methodentry : entry.getValue().values()) {
                coveredLines.addAll(methodentry.keySet());
            }
        }
        return coveredLines;
    }

    @Override
    public Set<String> getCoveredMethods() {
        return this.coveredMethods.keySet();
    }

    @Override
    public Set<String> getCoveredBranchlessMethods() {
        return this.coveredBranchlessMethods.keySet();
    }

    @Override
    public Set<Integer> getCoveredPredicates() {
        return this.coveredPredicates.keySet();
    }

    @Override
    public Set<Integer> getCoveredTrueBranches() {
        HashSet<Integer> covered = new HashSet<Integer>();
        for (Map.Entry<Integer, Double> entry : this.trueDistances.entrySet()) {
            if (entry.getValue() != 0.0) continue;
            covered.add(entry.getKey());
        }
        return covered;
    }

    @Override
    public Set<Integer> getCoveredDefinitions() {
        return this.coveredDefs.keySet();
    }

    @Override
    public Map<Integer, Integer> getDefinitionExecutionCount() {
        return this.coveredDefs;
    }

    @Override
    public Map<String, HashMap<Integer, HashMap<Integer, Integer>>> getDefinitionData() {
        return this.passedDefinitions;
    }

    @Override
    public Map<String, HashMap<Integer, HashMap<Integer, Object>>> getDefinitionDataObjects() {
        return this.passedDefinitionObject;
    }

    @Override
    public Throwable getExplicitException() {
        return this.explicitException;
    }

    @Override
    public double getFalseDistance(int branchId) {
        return this.falseDistances.get(branchId);
    }

    @Override
    public Map<Integer, Double> getFalseDistances() {
        return this.falseDistances;
    }

    @Override
    public List<MethodCall> getMethodCalls() {
        return this.finishedCalls;
    }

    @Override
    public Map<String, Integer> getMethodExecutionCount() {
        return this.coveredMethods;
    }

    @Override
    public double getMutationDistance(int mutationId) {
        return this.mutantDistances.get(mutationId);
    }

    @Override
    public Map<Integer, Double> getMutationDistances() {
        return this.mutantDistances;
    }

    @Override
    public Map<Integer, HashMap<Integer, Integer>> getPassedDefinitions(String variableName) {
        return this.passedDefinitions.get(variableName);
    }

    @Override
    public Map<Integer, HashMap<Integer, Integer>> getPassedUses(String variableName) {
        return this.passedUses.get(variableName);
    }

    @Override
    public Map<Integer, Integer> getPredicateExecutionCount() {
        return this.coveredPredicates;
    }

    public int getProxyCount() {
        return this.proxyCount;
    }

    @Override
    public Map<String, Map<String, Map<Integer, Integer>>> getReturnData() {
        return this.returnData;
    }

    @Override
    public Set<Integer> getTouchedMutants() {
        return this.touchedMutants;
    }

    @Override
    public Set<Integer> getInfectedMutants() {
        LinkedHashSet<Integer> infectedMutants = new LinkedHashSet<Integer>();
        for (Map.Entry<Integer, Double> entry : this.mutantDistances.entrySet()) {
            if (entry.getValue() != 0.0) continue;
            infectedMutants.add(entry.getKey());
        }
        return infectedMutants;
    }

    @Override
    public ExecutionTrace getTraceForObject(int objectId) {
        ExecutionTraceImpl r = this.clone();
        ArrayList<Integer> removableCalls = new ArrayList<Integer>();
        for (int i = 0; i < r.finishedCalls.size(); ++i) {
            MethodCall call = r.finishedCalls.get(i);
            if (call.callingObjectID == objectId || call.callingObjectID == 0) continue;
            removableCalls.add(i);
        }
        ExecutionTraceImpl.removeFinishCalls(r, removableCalls);
        return new ExecutionTraceProxy(r);
    }

    @Override
    public ExecutionTrace getTraceInDUCounterRange(DefUse targetDU, boolean wantToCoverTargetDU, int duCounterStart, int duCounterEnd) {
        if (duCounterStart > duCounterEnd) {
            throw new IllegalArgumentException("start has to be lesser or equal end");
        }
        ExecutionTraceImpl r = this.clone();
        Branch targetDUBranch = targetDU.getControlDependentBranch();
        ArrayList<Integer> removableCalls = new ArrayList<Integer>();
        for (int callPos = 0; callPos < r.finishedCalls.size(); ++callPos) {
            MethodCall call = r.finishedCalls.get(callPos);
            if (!call.methodName.equals(targetDU.getMethodName())) {
                removableCalls.add(callPos);
                continue;
            }
            ArrayList<Integer> removableIndices = new ArrayList<Integer>();
            for (int i = 0; i < call.defuseCounterTrace.size(); ++i) {
                int currentDUCounter = call.defuseCounterTrace.get(i);
                int currentBranchBytecode = call.branchTrace.get(i);
                if (currentDUCounter < duCounterStart || currentDUCounter > duCounterEnd) {
                    removableIndices.add(i);
                    continue;
                }
                if (currentBranchBytecode != targetDUBranch.getInstruction().getInstructionId()) continue;
                boolean targetExpressionValue = targetDU.getControlDependentBranchExpressionValue();
                if (targetExpressionValue) {
                    if (call.trueDistanceTrace.get(i) != 0.0) continue;
                    removableIndices.add(i);
                    continue;
                }
                if (call.falseDistanceTrace.get(i) != 0.0) continue;
                removableIndices.add(i);
            }
            ExecutionTraceImpl.removeFromFinishCall(call, removableIndices);
            if (call.defuseCounterTrace.size() != 0) continue;
            removableCalls.add(callPos);
        }
        ExecutionTraceImpl.removeFinishCalls(r, removableCalls);
        return new ExecutionTraceProxy(r);
    }

    @Override
    public double getTrueDistance(int branchId) {
        return this.trueDistances.get(branchId);
    }

    @Override
    public Map<Integer, Double> getTrueDistances() {
        return this.trueDistances;
    }

    @Override
    public Map<String, HashMap<Integer, HashMap<Integer, Integer>>> getUseData() {
        return this.passedUses;
    }

    @Override
    public Map<String, HashMap<Integer, HashMap<Integer, Object>>> getUseDataObjects() {
        return this.passedUseObject;
    }

    @Override
    public boolean hasFalseDistance(int predicateId) {
        return this.falseDistances.containsKey(predicateId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.coverage == null ? 0 : this.coverage.hashCode());
        result = 31 * result + (this.finishedCalls == null ? 0 : this.finishedCalls.hashCode());
        result = 31 * result + (this.returnData == null ? 0 : this.returnData.hashCode());
        result = 31 * result + (this.stack == null ? 0 : this.stack.hashCode());
        return result;
    }

    @Override
    public boolean hasTrueDistance(int predicateId) {
        return this.trueDistances.containsKey(predicateId);
    }

    @Override
    public ExecutionTrace lazyClone() {
        return null;
    }

    private boolean stackHasMethod(String methodName) {
        for (MethodCall call : this.stack) {
            if (!call.methodName.equals(methodName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void linePassed(String className, String methodName, int line) {
        if (traceCalls) {
            if (this.stack.isEmpty()) {
                logger.info("Method stack is empty: " + className + "." + methodName + " - l" + line);
            } else {
                boolean empty = false;
                if (!this.stack.peek().methodName.equals(methodName)) {
                    if (this.stack.peek().methodName.equals("")) {
                        return;
                    }
                    if (this.stackHasMethod(methodName)) {
                        do {
                            logger.debug("Popping method " + this.stack.peek().methodName + " because we were looking for " + methodName);
                            this.finishedCalls.add(this.stack.pop());
                        } while (!this.stack.isEmpty() && !this.stack.peek().methodName.equals(methodName) && !this.stack.peek().methodName.equals(""));
                    } else {
                        logger.warn("Popping method " + this.stack.peek().methodName + " because we were looking for " + methodName);
                        logger.warn("Current stack: " + this.stack);
                        this.finishedCalls.add(this.stack.pop());
                    }
                    if (this.stack.isEmpty()) {
                        logger.warn("Method stack is empty: " + className + "." + methodName + " - l" + line);
                        empty = true;
                    }
                }
                if (!empty) {
                    this.stack.peek().lineTrace.add(line);
                }
            }
        }
        if (traceCoverage) {
            if (!this.coverage.containsKey(className)) {
                this.coverage.put(className, new HashMap());
            }
            if (!this.coverage.get(className).containsKey(methodName)) {
                this.coverage.get(className).put(methodName, new HashMap());
            }
            if (!this.coverage.get(className).get(methodName).containsKey(line)) {
                this.coverage.get(className).get(methodName).put(line, 1);
            } else {
                this.coverage.get(className).get(methodName).put(line, this.coverage.get(className).get(methodName).get(line) + 1);
            }
        }
    }

    @Override
    public void mutationPassed(int mutationId, double distance) {
        this.touchedMutants.add(mutationId);
        if (!this.mutantDistances.containsKey(mutationId)) {
            this.mutantDistances.put(mutationId, distance);
        } else {
            this.mutantDistances.put(mutationId, Math.min(distance, this.mutantDistances.get(mutationId)));
        }
    }

    private int registerObject(Object caller) {
        if (caller == null) {
            return 0;
        }
        for (Integer objectId : this.knownCallerObjects.keySet()) {
            if (this.knownCallerObjects.get(objectId) != caller) continue;
            return objectId;
        }
        ++this.objectCounter;
        this.knownCallerObjects.put(this.objectCounter, caller);
        return this.objectCounter;
    }

    @Override
    public void returnValue(String className, String methodName, int value) {
        if (!this.returnData.containsKey(className)) {
            this.returnData.put(className, new HashMap());
        }
        if (!this.returnData.get(className).containsKey(methodName)) {
            this.returnData.get(className).put(methodName, new HashMap());
        }
        if (!this.returnData.get(className).get(methodName).containsKey(value)) {
            this.returnData.get(className).get(methodName).put(value, 1);
        } else {
            this.returnData.get(className).get(methodName).put(value, this.returnData.get(className).get(methodName).get(value) + 1);
        }
    }

    @Override
    public void setExplicitException(Throwable explicitException) {
        this.explicitException = explicitException;
    }

    @Override
    public String toDefUseTraceInformation() {
        StringBuffer r = new StringBuffer();
        for (String var : this.passedDefinitions.keySet()) {
            r.append("  for variable: " + var + ": ");
            for (Integer objectId : this.passedDefinitions.get(var).keySet()) {
                if (this.passedDefinitions.get(var).keySet().size() > 1) {
                    r.append("\n\ton object " + objectId + ": ");
                }
                r.append(this.toDefUseTraceInformation(var, objectId));
            }
            r.append("\n  ");
        }
        return r.toString();
    }

    @Override
    public String toDefUseTraceInformation(String targetVar) {
        StringBuffer r = new StringBuffer();
        for (Integer objectId : this.passedDefinitions.get(targetVar).keySet()) {
            if (this.passedDefinitions.get(targetVar).keySet().size() > 1) {
                r.append("\n\ton object " + objectId + ": ");
            }
            r.append(this.toDefUseTraceInformation(targetVar, objectId));
        }
        r.append("\n  ");
        return r.toString();
    }

    @Override
    public String toDefUseTraceInformation(String var, int objectId) {
        if (this.passedDefinitions.get(var) == null) {
            return "";
        }
        if (objectId == -1 && this.passedDefinitions.get(var).keySet().size() == 1) {
            objectId = (Integer)this.passedDefinitions.get(var).keySet().toArray()[0];
        }
        if (this.passedDefinitions.get(var).get(objectId) == null) {
            return "";
        }
        String[] duTrace = new String[this.duCounter];
        for (int i = 0; i < this.duCounter; ++i) {
            duTrace[i] = "";
        }
        for (Integer n : this.passedDefinitions.get(var).get(objectId).keySet()) {
            duTrace[n.intValue()] = "(" + n + ":Def " + this.passedDefinitions.get(var).get(objectId).get(n) + ")";
        }
        if (this.passedUses.get(var) != null && this.passedUses.get(var).get(objectId) != null) {
            for (Integer n : this.passedUses.get(var).get(objectId).keySet()) {
                duTrace[n.intValue()] = "(" + n + ":Use " + this.passedUses.get(var).get(objectId).get(n) + ")";
            }
        }
        StringBuffer r = new StringBuffer();
        for (String s : duTrace) {
            r.append(s);
            if (s.length() <= 0) continue;
            r.append(", ");
        }
        String string = r.toString();
        if (string.length() > 2) {
            return string.substring(0, string.length() - 2);
        }
        return string;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        for (MethodCall methodCall : this.finishedCalls) {
            ret.append(methodCall);
        }
        ret.append("\nCovered methods: ");
        for (Map.Entry entry : this.coveredMethods.entrySet()) {
            ret.append((String)entry.getKey() + ": " + entry.getValue() + ", ");
        }
        ret.append("\nCovered predicates: ");
        for (Map.Entry entry : this.coveredPredicates.entrySet()) {
            ret.append(entry.getKey() + ": " + entry.getValue() + ", ");
        }
        ret.append("\nTrue distances: ");
        for (Map.Entry entry : this.trueDistances.entrySet()) {
            ret.append(entry.getKey() + ": " + entry.getValue() + ", ");
        }
        ret.append("\nFalse distances: ");
        for (Map.Entry entry : this.falseDistances.entrySet()) {
            ret.append(entry.getKey() + ": " + entry.getValue() + ", ");
        }
        return ret.toString();
    }

    private void updateTopStackMethodCall(int branch, int bytecode_id, double true_distance, double false_distance) {
        if (traceCalls) {
            if (this.stack.isEmpty()) {
                return;
            }
            this.stack.peek().branchTrace.add(branch);
            this.stack.peek().trueDistanceTrace.add(true_distance);
            this.stack.peek().falseDistanceTrace.add(false_distance);
            assert (true_distance == 0.0 || false_distance == 0.0);
            if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.DEFUSE) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.ALLDEFS)) {
                this.stack.peek().defuseCounterTrace.add(this.duCounter);
            }
        }
    }

    @Override
    public void usePassed(Object object, Object caller, int useID) {
        String varName;
        if (!traceCalls) {
            return;
        }
        Use use = DefUsePool.getUseByUseId(useID);
        int objectID = this.registerObject(caller);
        if (objectID != 0) {
            if (use == null) {
                throw new IllegalStateException("expect DefUsePool to known defIDs that are passed by instrumented code");
            }
            if (use.isStaticDefUse()) {
                objectID = 0;
            }
        }
        if (this.passedUses.get(varName = use.getVariableName()) == null) {
            this.passedUses.put(varName, new HashMap());
            this.passedUseObject.put(varName, new HashMap());
        }
        HashMap<Integer, Integer> uses = this.passedUses.get(varName).get(objectID);
        HashMap<Integer, Object> usesObject = this.passedUseObject.get(varName).get(objectID);
        if (uses == null) {
            uses = new HashMap();
            usesObject = new HashMap();
        }
        uses.put(this.duCounter, useID);
        usesObject.put(this.duCounter, object);
        this.passedUses.get(varName).put(objectID, uses);
        this.passedUseObject.get(varName).put(objectID, usesObject);
        ++this.duCounter;
    }

    @Override
    public boolean wasMutationTouched(int mutationId) {
        return this.touchedMutants.contains(mutationId);
    }

    @Override
    public Map<Integer, Double> getFalseDistancesSum() {
        return this.falseDistancesSum;
    }

    @Override
    public Map<Integer, Double> getTrueDistancesSum() {
        return this.trueDistancesSum;
    }

    @Override
    public Map<String, HashMap<Integer, HashMap<Integer, Integer>>> getPassedUses() {
        return this.passedUses;
    }

    @Override
    public Set<Integer> getPassedDefIDs() {
        HashSet<Integer> defs = new HashSet<Integer>();
        for (HashMap<Integer, HashMap<Integer, Integer>> classDefs : this.passedDefinitions.values()) {
            for (HashMap<Integer, Integer> currentDefs : classDefs.values()) {
                defs.addAll(currentDefs.values());
            }
        }
        return defs;
    }

    @Override
    public Set<Integer> getPassedUseIDs() {
        HashSet<Integer> uses = new HashSet<Integer>();
        for (HashMap<Integer, HashMap<Integer, Integer>> classUses : this.passedUses.values()) {
            for (HashMap<Integer, Integer> currentUses : classUses.values()) {
                uses.addAll(currentUses.values());
            }
        }
        return uses;
    }

    @Override
    public Map<Integer, Map<CallContext, Double>> getTrueDistancesContext() {
        return this.coveredTrueContext;
    }

    @Override
    public Map<Integer, Map<CallContext, Double>> getFalseDistancesContext() {
        return this.coveredFalseContext;
    }

    @Override
    public Map<Integer, Map<CallContext, Integer>> getPredicateContextExecutionCount() {
        return this.coveredPredicateContext;
    }

    @Override
    public Map<String, Map<CallContext, Integer>> getMethodContextCount() {
        return this.coveredMethodContext;
    }

    @Override
    public void putStaticPassed(String classNameWithDots, String fieldName) {
        this.classesWithStaticWrites.add(classNameWithDots);
    }

    @Override
    public void getStaticPassed(String classNameWithDots, String fieldName) {
        this.classesWithStaticReads.add(classNameWithDots);
    }

    @Override
    public Set<String> getClassesWithStaticWrites() {
        return this.classesWithStaticWrites;
    }

    @Override
    public void classInitialized(String classNameWithDots) {
        if (!this.initializedClasses.contains(classNameWithDots)) {
            this.initializedClasses.add(classNameWithDots);
        }
    }

    @Override
    public Set<String> getClassesWithStaticReads() {
        return this.classesWithStaticReads;
    }

    @Override
    public List<String> getInitializedClasses() {
        return this.initializedClasses;
    }

    @Deprecated
    public static class BranchEval {
        private final int branchId;
        private CallContext context = null;
        private final double falseDistance;
        private final double trueDistance;

        public BranchEval(int branchId, double trueDistance, double falseDistance) {
            this.branchId = branchId;
            this.trueDistance = trueDistance;
            this.falseDistance = falseDistance;
        }

        public BranchEval(int branchId, double trueDistance, double falseDistance, CallContext context) {
            this.branchId = branchId;
            this.trueDistance = trueDistance;
            this.falseDistance = falseDistance;
            this.context = context;
        }

        public int getBranchId() {
            return this.branchId;
        }

        public CallContext getContext() {
            return this.context;
        }

        public double getFalseDistance() {
            return this.falseDistance;
        }

        public double getTrueDistance() {
            return this.trueDistance;
        }

        public String toString() {
            return "BranchEval [branchId=" + this.branchId + ", trueDistance=" + this.trueDistance + ", falseDistance=" + this.falseDistance + "]";
        }
    }
}

