/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.execution;

import java.io.PrintStream;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.ga.stoppingconditions.MaxStatementsStoppingCondition;
import org.evosuite.ga.stoppingconditions.MaxTestsStoppingCondition;
import org.evosuite.instrumentation.InstrumentingClassLoader;
import org.evosuite.runtime.LoopCounter;
import org.evosuite.runtime.Runtime;
import org.evosuite.runtime.sandbox.PermissionStatistics;
import org.evosuite.runtime.sandbox.Sandbox;
import org.evosuite.runtime.util.JOptionPaneInputs;
import org.evosuite.runtime.util.SystemInUtil;
import org.evosuite.setup.TestCluster;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.ExecutionObserver;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.execution.TestRunnable;
import org.evosuite.testcase.execution.TimeoutHandler;
import org.evosuite.testcase.execution.reset.ClassReInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCaseExecutor
implements ThreadFactory {
    public static final String TEST_EXECUTION_THREAD_GROUP = "Test_Execution_Group";
    public static final String TEST_EXECUTION_THREAD = "TEST_EXECUTION_THREAD";
    private static final Logger logger = LoggerFactory.getLogger(TestCaseExecutor.class);
    private static final PrintStream systemOut = System.out;
    private static final PrintStream systemErr = System.err;
    private static TestCaseExecutor instance = null;
    private ExecutorService executor;
    private Thread currentThread = null;
    private ThreadGroup threadGroup = null;
    private Set<ExecutionObserver> observers;
    private final Set<Thread> stalledThreads = new HashSet<Thread>();
    public static long timeExecuted = 0L;
    public static int testsExecuted = 0;
    public volatile int threadCounter;

    public static synchronized TestCaseExecutor getInstance() {
        if (instance == null) {
            instance = new TestCaseExecutor();
        }
        return instance;
    }

    public static ExecutionResult runTest(TestCase test) {
        ExecutionResult result = new ExecutionResult(test, null);
        try {
            TestCaseExecutor executor = TestCaseExecutor.getInstance();
            logger.debug("Executing test");
            result = executor.execute(test);
            MaxStatementsStoppingCondition.statementsExecuted(result.getExecutedStatements());
        }
        catch (Exception e) {
            logger.error("TG: Exception caught: ", e);
            throw new Error(e);
        }
        return result;
    }

    private TestCaseExecutor() {
        this.executor = Executors.newSingleThreadExecutor(this);
        this.newObservers();
    }

    public void setup() {
    }

    public static void pullDown() {
        if (instance != null && TestCaseExecutor.instance.executor != null) {
            TestCaseExecutor.instance.executor.shutdownNow();
            TestCaseExecutor.instance.executor = null;
        }
    }

    public static void initExecutor() {
        if (instance != null) {
            if (TestCaseExecutor.instance.executor == null) {
                logger.info("TestCaseExecutor instance is non-null, but its actual executor is null");
                TestCaseExecutor.instance.executor = Executors.newSingleThreadExecutor(instance);
            } else {
                TestCaseExecutor.instance.executor = Executors.newSingleThreadExecutor(instance);
            }
        }
    }

    public void addObserver(ExecutionObserver observer) {
        if (!this.observers.contains(observer)) {
            logger.debug("Adding observer");
            this.observers.add(observer);
        }
    }

    public void removeObserver(ExecutionObserver observer) {
        if (this.observers.contains(observer)) {
            logger.debug("Removing observer");
            this.observers.remove(observer);
        }
    }

    public void newObservers() {
        this.observers = new LinkedHashSet<ExecutionObserver>();
    }

    public Set<ExecutionObserver> getExecutionObservers() {
        return new LinkedHashSet<ExecutionObserver>(this.observers);
    }

    private void resetObservers() {
        for (ExecutionObserver observer : this.observers) {
            observer.clear();
        }
    }

    public ExecutionResult execute(TestCase tc) {
        ExecutionResult result = this.execute(tc, Properties.TIMEOUT);
        return result;
    }

    public ExecutionResult execute(TestCase tc, int timeout) {
        Scope scope = new Scope();
        ExecutionResult result = this.execute(tc, scope, timeout);
        if (Properties.RESET_STATIC_FIELDS) {
            logger.debug("Resetting classes after execution");
            ClassReInitializer.getInstance().reInitializeClassesAfterTestExecution(tc, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutionResult execute(TestCase tc, Scope scope, int timeout) {
        ExecutionTracer.getExecutionTracer().clear();
        this.resetObservers();
        ExecutionObserver.setCurrentTest(tc);
        MaxTestsStoppingCondition.testExecuted();
        Runtime.getInstance().resetRuntime();
        long startTime = System.currentTimeMillis();
        TimeoutHandler<ExecutionResult> handler = new TimeoutHandler<ExecutionResult>();
        TestRunnable callable = new TestRunnable(tc, scope, this.observers);
        callable.storeCurrentThreads();
        try {
            ExecutionResult result = null;
            SystemInUtil.getInstance().initForTestCase();
            JOptionPaneInputs.getInstance().initForTestCase();
            Sandbox.goingToExecuteSUTCode();
            TestGenerationContext.getInstance().goingToExecuteSUTCode();
            try {
                result = handler.execute(callable, this.executor, timeout, Properties.CPU_TIMEOUT);
            }
            finally {
                Sandbox.doneWithExecutingSUTCode();
                TestGenerationContext.getInstance().doneWithExecutingSUTCode();
            }
            PermissionStatistics.getInstance().countThreads(this.threadGroup.activeCount());
            result.setSecurityException(PermissionStatistics.getInstance().getAndResetExceptionInfo());
            callable.killAndJoinClientThreads();
            long endTime = System.currentTimeMillis();
            timeExecuted += endTime - startTime;
            ++testsExecuted;
            ExecutionResult executionResult = result;
            return executionResult;
        }
        catch (ThreadDeath t) {
            logger.warn("Caught ThreadDeath during test execution");
            ExecutionResult result = new ExecutionResult(tc, null);
            result.setThrownExceptions(callable.getExceptionsThrown());
            result.setTrace(ExecutionTracer.getExecutionTracer().getTrace());
            ExecutionTracer.getExecutionTracer().clear();
            ExecutionResult executionResult = result;
            return executionResult;
        }
        catch (InterruptedException e1) {
            logger.info("InterruptedException");
            ExecutionResult result = new ExecutionResult(tc, null);
            result.setThrownExceptions(callable.getExceptionsThrown());
            result.setTrace(ExecutionTracer.getExecutionTracer().getTrace());
            ExecutionTracer.getExecutionTracer().clear();
            ExecutionResult executionResult = result;
            return executionResult;
        }
        catch (ExecutionException e1) {
            System.setOut(systemOut);
            System.setErr(systemErr);
            logger.error("ExecutionException (this is likely a serious error in the framework)", e1);
            ExecutionResult result = new ExecutionResult(tc, null);
            result.setThrownExceptions(callable.getExceptionsThrown());
            result.setTrace(ExecutionTracer.getExecutionTracer().getTrace());
            ExecutionTracer.getExecutionTracer().clear();
            if (e1.getCause() instanceof Error) {
                throw (Error)e1.getCause();
            }
            if (e1.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e1.getCause();
            }
            ExecutionResult executionResult = result;
            return executionResult;
        }
        catch (TimeoutException e1) {
            if (Properties.LOG_TIMEOUT) {
                logger.warn("Timeout occurred for " + Properties.TARGET_CLASS);
            }
            logger.info("TimeoutException, need to stop runner", e1);
            ExecutionTracer.setKillSwitch(true);
            try {
                handler.getLastTask().get(Properties.SHUTDOWN_TIMEOUT, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException result) {
            }
            catch (ExecutionException result) {
            }
            catch (TimeoutException result) {
                // empty catch block
            }
            if (!callable.isRunFinished()) {
                logger.info("Cancelling thread:");
                for (StackTraceElement elem : this.currentThread.getStackTrace()) {
                    logger.info(elem.toString());
                }
                logger.info(tc.toCode());
                boolean loopCounter = LoopCounter.getInstance().isActivated();
                while (this.isInStaticInit()) {
                    LoopCounter.getInstance().setActive(false);
                    ExecutionTracer.setKillSwitch(false);
                    logger.info("Run still not finished, but awaiting for static initializer to finish.");
                    try {
                        this.executor.awaitTermination(Properties.SHUTDOWN_TIMEOUT, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        logger.info("Interrupted");
                        e.printStackTrace();
                    }
                }
                LoopCounter.getInstance().setActive(loopCounter);
                ExecutionTracer.setKillSwitch(true);
                if (!callable.isRunFinished()) {
                    handler.getLastTask().cancel(true);
                    logger.info("Run not finished, waiting...");
                    try {
                        this.executor.awaitTermination(Properties.SHUTDOWN_TIMEOUT, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        logger.info("Interrupted");
                        e.printStackTrace();
                    }
                }
                if (!callable.isRunFinished()) {
                    logger.info("Run still not finished, replacing executor.");
                    try {
                        this.executor.shutdownNow();
                        if (this.currentThread.isAlive()) {
                            logger.info("Thread survived - unsafe operation.");
                            for (StackTraceElement element : this.currentThread.getStackTrace()) {
                                logger.info(element.toString());
                            }
                            logger.info("Killing thread:");
                            for (StackTraceElement elem : this.currentThread.getStackTrace()) {
                                logger.info(elem.toString());
                            }
                            this.currentThread.stop();
                        }
                    }
                    catch (ThreadDeath t) {
                        logger.info("ThreadDeath.");
                    }
                    catch (Throwable t) {
                        logger.info("Throwable: " + t);
                    }
                    ExecutionTracer.disable();
                    this.executor = Executors.newSingleThreadExecutor(this);
                }
            } else {
                logger.info("Run is finished - " + this.currentThread.isAlive() + ": " + this.getNumStalledThreads());
            }
            ExecutionTracer.disable();
            if (Sandbox.isOnAndExecutingSUTCode()) {
                Sandbox.doneWithExecutingSUTCode();
                TestGenerationContext.getInstance().doneWithExecutingSUTCode();
            }
            ExecutionResult result = new ExecutionResult(tc, null);
            result.setThrownExceptions(callable.getExceptionsThrown());
            result.reportNewThrownException(tc.size(), new TimeoutExceeded());
            result.setTrace(ExecutionTracer.getExecutionTracer().getTrace());
            ExecutionTracer.getExecutionTracer().clear();
            ExecutionTracer.setKillSwitch(false);
            ExecutionTracer.enable();
            System.setOut(systemOut);
            System.setErr(systemErr);
            ExecutionResult executionResult = result;
            return executionResult;
        }
        finally {
            if (this.threadGroup != null) {
                PermissionStatistics.getInstance().countThreads(this.threadGroup.activeCount());
            }
            TestCluster.getInstance().handleRuntimeAccesses(tc);
        }
    }

    private boolean isInStaticInit() {
        for (StackTraceElement elem : this.currentThread.getStackTrace()) {
            if (elem.getMethodName().equals("<clinit>")) {
                return true;
            }
            if (elem.getMethodName().equals("loadClass") && elem.getClassName().equals(InstrumentingClassLoader.class.getCanonicalName())) {
                return true;
            }
            if (!elem.getClassName().equals("sun.font.CFontManager")) continue;
            return true;
        }
        return false;
    }

    public int getNumStalledThreads() {
        this.stalledThreads.removeIf(t -> !t.isAlive());
        return this.stalledThreads.size();
    }

    @Override
    public Thread newThread(Runnable r) {
        if (this.currentThread != null && this.currentThread.isAlive()) {
            this.currentThread.setPriority(1);
            this.stalledThreads.add(this.currentThread);
            logger.info("Current number of stalled threads: " + this.getNumStalledThreads());
        } else {
            logger.info("No stalled threads");
        }
        if (this.threadGroup != null) {
            PermissionStatistics.getInstance().countThreads(this.threadGroup.activeCount());
        }
        this.threadGroup = new ThreadGroup(TEST_EXECUTION_THREAD_GROUP);
        this.currentThread = new Thread(this.threadGroup, r);
        this.currentThread.setName("TEST_EXECUTION_THREAD_" + this.threadCounter);
        ++this.threadCounter;
        this.currentThread.setContextClassLoader(TestGenerationContext.getInstance().getClassLoaderForSUT());
        ExecutionTracer.setThread(this.currentThread);
        return this.currentThread;
    }

    public void setExecutionObservers(Set<ExecutionObserver> observers) {
        this.observers = observers;
    }

    static {
        PermissionStatistics.getInstance().setThreadGroupToMonitor(TEST_EXECUTION_THREAD_GROUP);
    }

    public static class TimeoutExceeded
    extends RuntimeException {
        private static final long serialVersionUID = -5314228165430676893L;
    }
}

