/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.execution;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.evosuite.PackageInfo;
import org.evosuite.Properties;
import org.evosuite.dse.VMError;
import org.evosuite.runtime.System;
import org.evosuite.runtime.jvm.ShutdownHookHandler;
import org.evosuite.runtime.thread.KillSwitch;
import org.evosuite.runtime.thread.ThreadStopper;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.EvosuiteError;
import org.evosuite.testcase.execution.ExecutionObserver;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.evosuite.testcase.execution.InterfaceTestRunnable;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRunnable
implements InterfaceTestRunnable {
    private static final Logger logger = LoggerFactory.getLogger(TestRunnable.class);
    private static ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
    private final TestCase test;
    private final Scope scope;
    protected boolean runFinished;
    protected Map<Integer, Throwable> exceptionsThrown = new HashMap<Integer, Throwable>();
    protected Set<ExecutionObserver> observers;
    protected final ThreadStopper threadStopper;

    public TestRunnable(TestCase tc, Scope scope, Set<ExecutionObserver> observers) {
        this.test = tc;
        this.scope = scope;
        this.observers = observers;
        this.runFinished = false;
        KillSwitch killSwitch = ExecutionTracer::setKillSwitch;
        LinkedHashSet<String> threadsToIgnore = new LinkedHashSet<String>();
        threadsToIgnore.add("TEST_EXECUTION_THREAD");
        threadsToIgnore.addAll(Arrays.asList(Properties.IGNORE_THREADS));
        this.threadStopper = new ThreadStopper(killSwitch, threadsToIgnore, Properties.TIMEOUT);
    }

    public void storeCurrentThreads() {
        this.threadStopper.storeCurrentThreads();
    }

    public void killAndJoinClientThreads() throws IllegalStateException {
        this.threadStopper.killAndJoinClientThreads();
    }

    protected void informObservers_before(Statement s) {
        ExecutionTracer.disable();
        try {
            this.observers.forEach(o -> o.beforeStatement(s, this.scope));
        }
        finally {
            ExecutionTracer.enable();
        }
    }

    protected void informObservers_after(Statement s, Throwable exceptionThrown) {
        ExecutionTracer.disable();
        try {
            this.observers.forEach(o -> o.afterStatement(s, this.scope, exceptionThrown));
        }
        finally {
            ExecutionTracer.enable();
        }
    }

    protected void informObservers_finished(ExecutionResult result) {
        ExecutionTracer.disable();
        try {
            this.observers.forEach(o -> o.testExecutionFinished(result, this.scope));
        }
        finally {
            ExecutionTracer.enable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult call() {
        this.exceptionsThrown.clear();
        this.runFinished = false;
        ExecutionResult result = new ExecutionResult(this.test, null);
        ExecutionTracer.enable();
        PrintStream out = Properties.PRINT_TO_SYSTEM ? java.lang.System.out : new PrintStream(byteStream);
        byteStream.reset();
        if (!Properties.PRINT_TO_SYSTEM) {
            LoggingUtils.muteCurrentOutAndErrStream();
        }
        this.threadStopper.startRecordingTime();
        AtomicInteger num = new AtomicInteger(0);
        try {
            if (Properties.REPLACE_CALLS) {
                ShutdownHookHandler.getInstance().initHandler();
            }
            this.executeStatements(result, out, num);
        }
        catch (ThreadDeath e) {
            logger.info("Found error in " + this.test.toCode(), e);
            throw e;
        }
        catch (TimeoutException | TestCaseExecutor.TimeoutExceeded e) {
            logger.info("Test timed out!");
        }
        catch (Throwable e) {
            if (e instanceof EvosuiteError) {
                logger.info("Evosuite Error!", e);
                throw (EvosuiteError)e;
            }
            if (e instanceof VMError) {
                logger.info("VM Error!", e);
                throw (VMError)e;
            }
            logger.info("Exception at statement " + num + "! " + e);
            for (StackTraceElement elem : e.getStackTrace()) {
                logger.info(elem.toString());
            }
            if (e instanceof InvocationTargetException) {
                logger.info("Cause: " + e.getCause().toString(), e);
                e = e.getCause();
            }
            if (e instanceof AssertionError && e.getStackTrace()[0].getClassName().contains(PackageInfo.getEvoSuitePackage())) {
                logger.error("Assertion Error in evosuitecode, for statement \n" + this.test.getStatement(num.get()).getCode() + " \n which is number: " + num + " testcase \n" + this.test.toCode(), e);
                throw (AssertionError)((Object)e);
            }
            logger.error("Suppressed/ignored exception during test case execution on class " + Properties.TARGET_CLASS + ": " + e.getMessage(), e);
        }
        finally {
            if (!Properties.PRINT_TO_SYSTEM) {
                LoggingUtils.restorePreviousOutAndErrStream();
            }
            if (Properties.REPLACE_CALLS) {
                ShutdownHookHandler.getInstance().safeExecuteAddedHooks();
            }
            this.runFinished = true;
        }
        result.setTrace(ExecutionTracer.getExecutionTracer().getTrace());
        result.setExecutionTime(java.lang.System.currentTimeMillis() - this.threadStopper.getStartTime());
        result.setExecutedStatements(num.get());
        result.setThrownExceptions(this.exceptionsThrown);
        result.setReadProperties(System.getAllPropertiesReadSoFar());
        result.setWasAnyPropertyWritten(System.wasAnyPropertyWritten());
        return result;
    }

    private void executeStatements(ExecutionResult result, PrintStream out, AtomicInteger num) throws TimeoutException, InvocationTargetException, IllegalAccessException, InstantiationException, VMError, EvosuiteError {
        for (Statement s : this.test) {
            if (Thread.currentThread().isInterrupted() || Thread.interrupted()) {
                logger.info("Thread interrupted at statement " + num + ": " + s.getCode());
                throw new TimeoutException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Executing statement " + s.getCode());
            }
            ExecutionTracer.statementExecuted();
            this.informObservers_before(s);
            Throwable exceptionThrown = s.execute(this.scope, out);
            if (exceptionThrown != null) {
                if (exceptionThrown instanceof VMError) {
                    throw (VMError)exceptionThrown;
                }
                if (exceptionThrown instanceof EvosuiteError) {
                    throw (EvosuiteError)exceptionThrown;
                }
                if (exceptionThrown instanceof TestCaseExecutor.TimeoutExceeded) {
                    logger.debug("Test timed out!");
                    this.exceptionsThrown.put(this.test.size(), exceptionThrown);
                    result.setThrownExceptions(this.exceptionsThrown);
                    result.reportNewThrownException(this.test.size(), exceptionThrown);
                    result.setTrace(ExecutionTracer.getExecutionTracer().getTrace());
                    break;
                }
                this.exceptionsThrown.put(num.get(), exceptionThrown);
                if (ExecutionTracer.getExecutionTracer().getLastException() == exceptionThrown) {
                    result.explicitExceptions.put(num.get(), true);
                } else {
                    result.explicitExceptions.put(num.get(), false);
                }
                this.printDebugInfo(s, exceptionThrown);
                if (Properties.BREAK_ON_EXCEPTION || exceptionThrown instanceof System.SystemExitException) {
                    this.informObservers_after(s, exceptionThrown);
                    break;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Done statement " + s.getCode());
            }
            this.informObservers_after(s, exceptionThrown);
            num.incrementAndGet();
        }
        this.informObservers_finished(result);
    }

    private void printDebugInfo(Statement s, Throwable exceptionThrown) {
        if (logger.isDebugEnabled()) {
            logger.debug("Exception thrown in statement: " + s.getCode() + " - " + exceptionThrown.getClass().getName() + " - " + exceptionThrown.getMessage());
            for (StackTraceElement elem : exceptionThrown.getStackTrace()) {
                logger.debug(elem.toString());
            }
            if (exceptionThrown.getCause() != null) {
                logger.debug("Cause: " + exceptionThrown.getCause().getClass().getName() + " - " + exceptionThrown.getCause().getMessage());
                for (StackTraceElement elem : exceptionThrown.getCause().getStackTrace()) {
                    logger.debug(elem.toString());
                }
            } else {
                logger.debug("Cause is null");
            }
        }
    }

    @Override
    public Map<Integer, Throwable> getExceptionsThrown() {
        return new HashMap<Integer, Throwable>(this.exceptionsThrown);
    }

    @Override
    public boolean isRunFinished() {
        return this.runFinished;
    }
}

