/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.execution;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutHandler<T> {
    protected FutureTask<T> task = null;
    private final ThreadMXBean bean = ManagementFactory.getThreadMXBean();
    protected static final Logger logger = LoggerFactory.getLogger(TimeoutHandler.class);

    public FutureTask<T> getLastTask() {
        return this.task;
    }

    public T execute(Callable<T> testcase, ExecutorService executor, long timeout, boolean timeout_based_on_cpu) throws TimeoutException, InterruptedException, ExecutionException {
        if (!this.bean.isCurrentThreadCpuTimeSupported() && timeout_based_on_cpu) {
            timeout_based_on_cpu = false;
            logger.warn("Requested to use timeout_based_on_cpu, but it is not supported by the JVM/OS");
        }
        if (!timeout_based_on_cpu) {
            return this.executeWithTimeout(testcase, executor, timeout);
        }
        return this.executeWithCpuBasedTimeout(testcase, executor, timeout);
    }

    private T executeWithTimeout(Callable<T> testcase, ExecutorService executor, long timeout) throws InterruptedException, ExecutionException, TimeoutException {
        this.task = new FutureTask<T>(testcase);
        executor.execute(this.task);
        T result = this.task.get(timeout, TimeUnit.MILLISECONDS);
        return result;
    }

    private T executeWithCpuBasedTimeout(Callable<T> testcase, ExecutorService executor, long timeout) throws InterruptedException, ExecutionException, TimeoutException {
        long[] other_thread_ids = this.bean.getAllThreadIds();
        this.task = new FutureTask<T>(testcase);
        executor.execute(this.task);
        T result = null;
        long waiting_time = timeout;
        while (waiting_time > 0L) {
            try {
                result = this.task.get(waiting_time, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                long[] all_thread_ids = this.bean.getAllThreadIds();
                long cpu_usage = 0L;
                block4: for (long id : all_thread_ids) {
                    for (long other_thread_id : other_thread_ids) {
                        if (id == other_thread_id) continue block4;
                    }
                    long ns = this.bean.getThreadCpuTime(id);
                    long ms = ns / 1000000L;
                    cpu_usage += ms;
                }
                double alpha = 0.9;
                if ((double)cpu_usage < 0.9 * (double)timeout) {
                    waiting_time = timeout - cpu_usage;
                    continue;
                }
                throw e;
            }
            catch (ThreadDeath t) {
                throw new InterruptedException();
            }
        }
        return result;
    }
}

