/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.localsearch;

import org.evosuite.Properties;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.testcase.TestCaseExpander;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.localsearch.StatementLocalSearch;
import org.evosuite.testcase.localsearch.TestCaseLocalSearch;
import org.evosuite.testcase.statements.ArrayStatement;
import org.evosuite.testcase.statements.AssignmentStatement;
import org.evosuite.testcase.statements.NullStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.ArrayReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayLocalSearch
extends StatementLocalSearch {
    private int oldLength = 0;
    private static final Logger logger = LoggerFactory.getLogger(TestCaseLocalSearch.class);
    private int positionDelta = 0;

    @Override
    public int getPositionDelta() {
        return this.positionDelta;
    }

    @Override
    public boolean doSearch(TestChromosome test, int statement, LocalSearchObjective<TestChromosome> objective) {
        boolean hasImproved = false;
        ArrayStatement p = (ArrayStatement)test.getTestCase().getStatement(statement);
        logger.debug("Doing array local search on statement " + statement + ": " + test.getTestCase().toCode());
        int difference = this.stripAssignments(p, test, objective);
        logger.debug("Adjusting position from " + statement + " to " + (statement - difference) + ": " + test.getTestCase().toCode());
        this.positionDelta = difference;
        p = (ArrayStatement)test.getTestCase().getStatement(statement -= difference);
        hasImproved = this.searchLength(test, statement, objective);
        TestCaseExpander expander = new TestCaseExpander();
        int lengthWithoutAssignments = test.size();
        p = (ArrayStatement)test.getTestCase().getStatement(statement);
        expander.visitArrayStatement(test.getTestCase(), p);
        int assignmentLength = test.size() - lengthWithoutAssignments;
        for (int position = statement + 1; position < statement + assignmentLength; ++position) {
            logger.debug("Local search on statement " + position);
            StatementLocalSearch search = StatementLocalSearch.getLocalSearchFor(test.getTestCase().getStatement(position));
            if (search == null || !search.doSearch(test, position, objective)) continue;
            hasImproved = true;
        }
        logger.debug("Finished local search with result {}", (Object)p.getCode());
        return hasImproved;
    }

    private int stripAssignments(ArrayStatement statement, TestChromosome test, LocalSearchObjective<TestChromosome> objective) {
        int difference = 0;
        ArrayReference arrRef = (ArrayReference)statement.getReturnValue();
        TestFactory factory = TestFactory.getInstance();
        for (int position = test.size() - 1; position > statement.getPosition(); --position) {
            logger.debug("Current delete position: " + position);
            if (!(test.getTestCase().getStatement(position) instanceof AssignmentStatement)) continue;
            logger.debug("Is assignment statement");
            AssignmentStatement assignment = (AssignmentStatement)test.getTestCase().getStatement(position);
            Statement valueStatement = test.getTestCase().getStatement(assignment.getValue().getStPosition());
            if (assignment.getReturnValue().getAdditionalVariableReference() != arrRef) continue;
            int currentDelta = 0;
            int differenceDelta = 0;
            logger.debug("Assigns to target array. Checking if we can remove it without worsening fitness");
            this.backup(test);
            factory.deleteStatement(test.getTestCase(), position);
            if ((valueStatement instanceof PrimitiveStatement || valueStatement instanceof NullStatement) && !test.getTestCase().hasReferences(valueStatement.getReturnValue())) {
                if (valueStatement.getPosition() < statement.getPosition()) {
                    differenceDelta = 1;
                }
                currentDelta = 1;
                logger.debug("Deleting primitive statement assigned to this array at " + valueStatement.getPosition());
                factory.deleteStatement(test.getTestCase(), valueStatement.getPosition());
            }
            if (!objective.hasNotWorsened(test)) {
                logger.debug("Fitness has decreased, so restoring test");
                this.restore(test);
                currentDelta = 0;
                differenceDelta = 0;
            }
            position -= currentDelta;
            difference += differenceDelta;
        }
        return difference;
    }

    private boolean searchLength(TestChromosome test, int statement, LocalSearchObjective<TestChromosome> objective) {
        boolean hasImproved = false;
        ArrayStatement p = (ArrayStatement)test.getTestCase().getStatement(statement);
        logger.debug("Performing local search on array length, starting with length {}", (Object)p.size());
        ExecutionResult oldResult = test.getLastExecutionResult();
        this.oldLength = p.size();
        boolean done = false;
        while (!done) {
            boolean improved;
            done = true;
            p.setSize(this.oldLength + 1);
            logger.debug("Trying increment of {}", (Object)p.getCode());
            if (objective.hasImproved(test)) {
                done = false;
                hasImproved = true;
                improved = true;
                while (improved) {
                    this.oldLength = p.size();
                    oldResult = test.getLastExecutionResult();
                    p.setSize(this.oldLength + 1);
                    logger.debug("Trying increment of {}", (Object)p.getCode());
                    improved = objective.hasImproved(test);
                }
                p.setSize(this.oldLength);
                test.setLastExecutionResult(oldResult);
                test.setChanged(false);
                continue;
            }
            if (this.oldLength > 0) {
                p.setSize(this.oldLength);
                test.setLastExecutionResult(oldResult);
                test.setChanged(false);
                p.setSize(this.oldLength - 1);
            } else {
                p.setSize(Properties.MAX_ARRAY);
            }
            logger.debug("Trying decrement of {}", (Object)p.getCode());
            if (objective.hasImproved(test)) {
                done = false;
                hasImproved = true;
                improved = true;
                while (improved && p.size() > 0) {
                    this.oldLength = p.size();
                    oldResult = test.getLastExecutionResult();
                    p.setSize(this.oldLength - 1);
                    logger.debug("Trying decrement of {}", (Object)p.getCode());
                    improved = objective.hasImproved(test);
                }
                p.setSize(this.oldLength);
                test.setLastExecutionResult(oldResult);
                test.setChanged(false);
                continue;
            }
            p.setSize(this.oldLength);
            test.setLastExecutionResult(oldResult);
            test.setChanged(false);
        }
        logger.debug("Finished local array length search with result {}", (Object)p.getCode());
        return hasImproved;
    }
}

