/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.localsearch;

import java.util.Arrays;
import org.evosuite.Properties;
import org.evosuite.ga.localsearch.LocalSearchBudget;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.localsearch.StatementLocalSearch;
import org.evosuite.testcase.statements.StringPrimitiveStatement;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringLocalSearch
extends StatementLocalSearch {
    private static final Logger logger = LoggerFactory.getLogger(StringLocalSearch.class);
    private String oldValue;
    private ExecutionResult oldResult;
    private boolean oldChanged;

    private void backup(TestChromosome test, StringPrimitiveStatement p) {
        this.oldValue = (String)p.getValue();
        this.oldResult = test.getLastExecutionResult();
        this.oldChanged = test.isChanged();
    }

    private void restore(TestChromosome test, StringPrimitiveStatement p) {
        p.setValue(this.oldValue);
        test.setLastExecutionResult(this.oldResult);
        test.setChanged(this.oldChanged);
    }

    @Override
    public boolean doSearch(TestChromosome test, int statement, LocalSearchObjective<TestChromosome> objective) {
        StringPrimitiveStatement p = (StringPrimitiveStatement)test.getTestCase().getStatement(statement);
        this.backup(test, p);
        boolean affected = false;
        String oldValue = (String)p.getValue();
        for (int i = 0; i < Properties.LOCAL_SEARCH_PROBES; ++i) {
            if (Randomness.nextDouble() > 0.5) {
                p.increment();
            } else {
                p.randomize();
            }
            logger.info("Probing string " + oldValue + " ->" + p.getCode());
            int result = objective.hasChanged(test);
            if (result < 0) {
                this.backup(test, p);
            } else {
                this.restore(test, p);
            }
            if (result == 0) continue;
            affected = true;
            logger.info("String affects fitness");
            break;
        }
        if (affected) {
            boolean hasImproved = false;
            logger.info("Applying local search to string " + p.getCode());
            logger.info("Removing characters");
            if (this.removeCharacters(objective, test, p, statement)) {
                hasImproved = true;
            }
            logger.info("Statement: " + p.getCode());
            logger.info("Replacing characters");
            if (this.replaceCharacters(objective, test, p, statement)) {
                hasImproved = true;
            }
            logger.info("Statement: " + p.getCode());
            logger.info("Adding characters");
            if (this.addCharacters(objective, test, p, statement)) {
                hasImproved = true;
            }
            logger.info("Statement: " + p.getCode());
            logger.info("Resulting string: " + (String)p.getValue());
            return hasImproved;
        }
        return false;
    }

    private boolean removeCharacters(LocalSearchObjective<TestChromosome> objective, TestChromosome test, StringPrimitiveStatement p, int statement) {
        boolean improvement = false;
        this.backup(test, p);
        for (int i = this.oldValue.length() - 1; i >= 0; --i) {
            String newString = this.oldValue.substring(0, i) + this.oldValue.substring(i + 1);
            p.setValue(newString);
            logger.info(" " + i + " " + this.oldValue + "/" + this.oldValue.length() + " -> " + newString + "/" + newString.length());
            if (objective.hasImproved(test)) {
                logger.info("Has improved");
                this.backup(test, p);
                improvement = true;
            } else {
                logger.info("Has not improved");
                this.restore(test, p);
            }
            if (LocalSearchBudget.getInstance().isFinished()) break;
        }
        return improvement;
    }

    private boolean replaceCharacters(LocalSearchObjective<TestChromosome> objective, TestChromosome test, StringPrimitiveStatement p, int statement) {
        logger.info(" -> In replacement");
        boolean improvement = false;
        this.backup(test, p);
        block0: for (int i = 0; i < this.oldValue.length(); ++i) {
            char oldChar = this.oldValue.charAt(i);
            logger.info(" -> Character " + i + ": " + oldChar);
            char[] characters = this.oldValue.toCharArray();
            for (char replacement = '\t'; replacement < '\u0080'; replacement = (char)(replacement + '\u0001')) {
                if (LocalSearchBudget.getInstance().isFinished()) {
                    return improvement;
                }
                if (replacement == oldChar) continue;
                characters[i] = replacement;
                String newString = new String(characters);
                p.setValue(newString);
                logger.info(" " + i + " " + this.oldValue + "/" + this.oldValue.length() + " -> " + newString + "/" + newString.length());
                if (objective.hasImproved(test)) {
                    this.backup(test, p);
                    improvement = true;
                    continue block0;
                }
                characters[i] = oldChar;
                this.restore(test, p);
            }
        }
        return improvement;
    }

    private boolean addCharacters(LocalSearchObjective<TestChromosome> objective, TestChromosome test, StringPrimitiveStatement p, int statement) {
        String newString;
        int replacement;
        char[] characters;
        int position;
        boolean improvement = false;
        this.backup(test, p);
        boolean add = true;
        block0: while (add) {
            add = false;
            position = this.oldValue.length();
            characters = Arrays.copyOf(this.oldValue.toCharArray(), position + 1);
            for (replacement = 9; replacement < 128; replacement = (int)((char)(replacement + 1))) {
                if (LocalSearchBudget.getInstance().isFinished()) {
                    return improvement;
                }
                characters[position] = replacement;
                newString = new String(characters);
                p.setValue(newString);
                if (objective.hasImproved(test)) {
                    this.backup(test, p);
                    improvement = true;
                    add = true;
                    continue block0;
                }
                this.restore(test, p);
            }
        }
        add = true;
        block2: while (add) {
            add = false;
            position = 0;
            characters = (" " + this.oldValue).toCharArray();
            for (replacement = 9; replacement < 128; replacement = (int)((char)(replacement + 1))) {
                if (LocalSearchBudget.getInstance().isFinished()) {
                    return improvement;
                }
                characters[position] = replacement;
                newString = new String(characters);
                p.setValue(newString);
                if (objective.hasImproved(test)) {
                    this.backup(test, p);
                    improvement = true;
                    add = true;
                    continue block2;
                }
                this.restore(test, p);
            }
        }
        return improvement;
    }
}

