/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.runtime.util.Inputs;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.statements.AbstractStatement;
import org.evosuite.testcase.statements.FunctionalMockStatement;
import org.evosuite.testcase.statements.NullStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.ArrayIndex;
import org.evosuite.testcase.variable.NullReference;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.Randomness;
import org.evosuite.utils.generic.GenericUtils;

public abstract class EntityWithParametersStatement
extends AbstractStatement {
    private static final long serialVersionUID = 2971944785047056480L;
    protected final List<VariableReference> parameters;
    protected final Annotation[][] parameterAnnotations;
    protected final Annotation[] annotations;

    protected EntityWithParametersStatement(TestCase tc, Type type, List<VariableReference> parameters, Annotation[] annotations, Annotation[][] parameterAnnotations) throws IllegalArgumentException {
        super(tc, type);
        this.parameters = parameters;
        this.annotations = annotations;
        this.parameterAnnotations = parameterAnnotations;
        this.validateInputs();
    }

    protected EntityWithParametersStatement(TestCase tc, VariableReference retval, List<VariableReference> parameters, Annotation[] annotations, Annotation[][] parameterAnnotations) throws IllegalArgumentException {
        super(tc, retval);
        this.parameters = parameters;
        this.annotations = annotations;
        this.parameterAnnotations = parameterAnnotations;
        this.validateInputs();
    }

    protected EntityWithParametersStatement(TestCase tc, VariableReference retval) {
        super(tc, retval);
        this.parameters = new ArrayList<VariableReference>();
        this.annotations = null;
        this.parameterAnnotations = null;
    }

    protected EntityWithParametersStatement(TestCase tc, Type type) {
        super(tc, type);
        this.parameters = new ArrayList<VariableReference>();
        this.annotations = null;
        this.parameterAnnotations = null;
    }

    private void validateInputs() throws IllegalArgumentException {
        Inputs.checkNull(this.parameters);
        for (VariableReference ref : this.parameters) {
            Inputs.checkNull(ref);
        }
        if (this.parameterAnnotations != null && this.parameterAnnotations.length != this.parameters.size()) {
            throw new IllegalArgumentException("Size mismatched");
        }
    }

    public List<VariableReference> getParameterReferences() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public void replace(VariableReference var1, VariableReference var2) {
        if (this.retval.equals(var1)) {
            this.retval = var2;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (this.parameters.get(i).equals(var1)) {
                this.parameters.set(i, var2);
                continue;
            }
            this.parameters.get(i).replaceAdditionalVariableReference(var1, var2);
        }
    }

    @Override
    public List<VariableReference> getUniqueVariableReferences() {
        ArrayList<VariableReference> references = new ArrayList<VariableReference>();
        references.add(this.retval);
        references.addAll(this.parameters);
        for (VariableReference param : this.parameters) {
            if (!(param instanceof ArrayIndex)) continue;
            references.add(((ArrayIndex)param).getArray());
        }
        return references;
    }

    @Override
    public Set<VariableReference> getVariableReferences() {
        LinkedHashSet<VariableReference> references = new LinkedHashSet<VariableReference>();
        references.add(this.retval);
        for (VariableReference param : this.parameters) {
            if (param == null) continue;
            references.add(param);
            if (param.getAdditionalVariableReference() == null) continue;
            references.add(param.getAdditionalVariableReference());
        }
        references.addAll(this.getAssertionReferences());
        return references;
    }

    @Override
    public int getNumParameters() {
        return this.parameters.size();
    }

    public void replaceParameterReference(VariableReference var, int numParameter) throws IllegalArgumentException {
        Inputs.checkNull(var);
        if (numParameter < 0 || numParameter >= this.parameters.size()) {
            throw new IllegalArgumentException("Out of range index " + numParameter + " from list of size " + this.parameters.size());
        }
        this.parameters.set(numParameter, var);
    }

    public boolean isBounded(VariableReference var) throws IllegalArgumentException {
        Inputs.checkNull(var);
        if (this.parameterAnnotations == null) {
            assert (this instanceof FunctionalMockStatement);
            return false;
        }
        return false;
    }

    protected int getNumParametersOfType(Class<?> clazz) {
        int num = 0;
        for (VariableReference var : this.parameters) {
            if (!var.getVariableClass().equals(clazz)) continue;
            ++num;
        }
        return num;
    }

    protected boolean mutateParameter(TestCase test, int numParameter) {
        VariableReference parameter = this.parameters.get(numParameter);
        List<VariableReference> objects = test.getObjects(parameter.getType(), this.getPosition());
        objects.remove(parameter);
        objects.remove(this.getReturnValue());
        NullStatement nullStatement = new NullStatement(test, parameter.getType());
        Statement copy = null;
        boolean avoidNull = false;
        if (Properties.HONOUR_DATA_ANNOTATIONS && numParameter < this.parameterAnnotations.length && GenericUtils.isAnnotationTypePresent(this.parameterAnnotations[numParameter], "Nonnull")) {
            avoidNull = true;
        }
        if (avoidNull) {
            objects.removeIf(ref -> ref instanceof NullReference);
        } else if (!parameter.isPrimitive()) {
            objects.add(nullStatement.getReturnValue());
        }
        if (this.getNumParametersOfType(parameter.getVariableClass()) + 1 > objects.size()) {
            Statement originalStatement = test.getStatement(parameter.getStPosition());
            copy = originalStatement.clone(test);
            if (originalStatement instanceof PrimitiveStatement) {
                ((PrimitiveStatement)copy).delta();
            }
            objects.add(copy.getReturnValue());
        }
        if (objects.isEmpty()) {
            return false;
        }
        VariableReference replacement = Randomness.choice(objects);
        if (replacement == nullStatement.getReturnValue()) {
            test.addStatement(nullStatement, this.getPosition());
        } else if (copy != null && replacement == copy.getReturnValue()) {
            test.addStatement(copy, this.getPosition());
        }
        this.replaceParameterReference(replacement, numParameter);
        return true;
    }

    public abstract String getDeclaringClassName();

    public abstract String getMethodName();

    public abstract String getDescriptor();
}

