/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements;

import java.lang.reflect.Type;
import java.util.Map;
import org.evosuite.shaded.org.mockito.MockSettings;
import org.evosuite.shaded.org.mockito.Mockito;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.fm.EvoAbstractMethodInvocationListener;
import org.evosuite.testcase.fm.EvoInvocationListener;
import org.evosuite.testcase.fm.MethodDescriptor;
import org.evosuite.testcase.statements.FunctionalMockStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.generic.GenericClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionalMockForAbstractClassStatement
extends FunctionalMockStatement {
    private static final long serialVersionUID = -3933543503326450446L;
    private static final Logger logger = LoggerFactory.getLogger(FunctionalMockForAbstractClassStatement.class);

    public FunctionalMockForAbstractClassStatement(TestCase tc, VariableReference retval, GenericClass targetClass) throws IllegalArgumentException {
        super(tc, retval, targetClass);
    }

    public FunctionalMockForAbstractClassStatement(TestCase tc, Type retvalType, GenericClass targetClass) throws IllegalArgumentException {
        super(tc, retvalType, targetClass);
    }

    @Override
    protected void checkTarget() {
        if (!FunctionalMockForAbstractClassStatement.canBeFunctionalMockedIncludingSUT(this.targetClass.getRawClass())) {
            throw new IllegalArgumentException("Cannot create a basic functional mock for class " + this.targetClass);
        }
    }

    @Override
    protected EvoInvocationListener createInvocationListener() {
        return new EvoAbstractMethodInvocationListener(this.retval.getGenericClass());
    }

    @Override
    protected MockSettings createMockSettings() {
        return Mockito.withSettings().defaultAnswer(Mockito.CALLS_REAL_METHODS).invocationListeners(this.listener);
    }

    @Override
    public Statement copy(TestCase newTestCase, int offset) {
        FunctionalMockForAbstractClassStatement copy = new FunctionalMockForAbstractClassStatement(newTestCase, this.retval.getType(), this.targetClass);
        for (VariableReference variableReference : this.parameters) {
            copy.parameters.add(variableReference.copy(newTestCase, offset));
        }
        copy.listener = this.listener;
        for (MethodDescriptor methodDescriptor : this.mockedMethods) {
            copy.mockedMethods.add(methodDescriptor.getCopy());
        }
        for (Map.Entry entry : this.methodParameters.entrySet()) {
            int[] nArray;
            int[] array = (int[])entry.getValue();
            if (array == null) {
                nArray = null;
            } else {
                int[] nArray2 = new int[2];
                nArray2[0] = array[0];
                nArray = nArray2;
                nArray2[1] = array[1];
            }
            int[] copiedArray = nArray;
            copy.methodParameters.put(entry.getKey(), copiedArray);
        }
        return copy;
    }
}

