/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements;

import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.evosuite.Properties;
import org.evosuite.shaded.org.apache.commons.lang3.reflect.TypeUtils;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.EvosuiteError;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.execution.UncompilableCodeException;
import org.evosuite.testcase.statements.AbstractStatement;
import org.evosuite.testcase.statements.EntityWithParametersStatement;
import org.evosuite.testcase.statements.FunctionalMockStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.ArrayIndex;
import org.evosuite.testcase.variable.ArrayReference;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.Randomness;
import org.evosuite.utils.generic.GenericMethod;

public class MethodStatement
extends EntityWithParametersStatement {
    private static final long serialVersionUID = 6134126797102983073L;
    protected GenericMethod method;
    protected VariableReference callee;

    public MethodStatement(TestCase tc, GenericMethod method, VariableReference callee, List<VariableReference> parameters) throws IllegalArgumentException {
        super(tc, method.getReturnType(), parameters, method.getMethod().getAnnotations(), method.getMethod().getParameterAnnotations());
        this.init(method, callee);
    }

    public MethodStatement(TestCase tc, GenericMethod method, VariableReference callee, List<VariableReference> parameters, VariableReference retVal) throws IllegalArgumentException {
        this(tc, method, callee, parameters);
        this.retval = retVal;
    }

    public MethodStatement(TestCase tc, GenericMethod method, VariableReference callee, VariableReference retvar, List<VariableReference> parameters) {
        super(tc, retvar, parameters, method.getMethod().getAnnotations(), method.getMethod().getParameterAnnotations());
        if (retvar.getStPosition() >= tc.size()) {
            throw new IllegalArgumentException("Cannot replace in position " + retvar.getStPosition() + " when the test case has only " + tc.size() + " elements");
        }
        this.init(method, callee);
    }

    private void init(GenericMethod method, VariableReference callee) throws IllegalArgumentException {
        if (callee == null && !method.isStatic()) {
            throw new IllegalArgumentException("A null callee cannot call a non-static method: " + method.getDeclaringClass().getCanonicalName() + "." + method.getName());
        }
        if (this.parameters == null) {
            throw new IllegalArgumentException("Parameter list cannot be null for method " + method.getDeclaringClass().getCanonicalName() + "." + method.getName());
        }
        for (VariableReference var : this.parameters) {
            if (var != null) continue;
            throw new IllegalArgumentException("Parameter list cannot have null parameters (this is different from a NullReference)");
        }
        if (method.getParameterTypes().length != this.parameters.size()) {
            throw new IllegalArgumentException("Parameters list mismatch from the types declared in the method: " + method.getParameterTypes().length + " != " + this.parameters.size());
        }
        this.method = method;
        this.callee = this.isStatic() ? null : callee;
    }

    public GenericMethod getMethod() {
        return this.method;
    }

    public void setMethod(GenericMethod method) {
        this.method = method;
    }

    public VariableReference getCallee() {
        return this.callee;
    }

    public void setCallee(VariableReference callee) {
        if (!this.isStatic()) {
            this.callee = callee;
        }
    }

    public boolean isStatic() {
        return this.method.isStatic();
    }

    private boolean isInstanceMethod() {
        return !this.method.isStatic();
    }

    @Override
    public Throwable execute(final Scope scope, PrintStream out) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, InstantiationException {
        logger.trace("Executing method " + this.method.getName());
        final Object[] inputs = new Object[this.parameters.size()];
        Throwable exceptionThrown = null;
        try {
            return super.exceptionHandler(new AbstractStatement.Executer(){

                @Override
                public void execute() throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, InstantiationException, CodeUnderTestException {
                    Class returnClass;
                    Object callee_object;
                    try {
                        Type[] parameterTypes = MethodStatement.this.method.getParameterTypes();
                        for (int i = 0; i < MethodStatement.this.parameters.size(); ++i) {
                            VariableReference parameterVar = (VariableReference)MethodStatement.this.parameters.get(i);
                            inputs[i] = parameterVar.getObject(scope);
                            if (inputs[i] == null && MethodStatement.this.method.getMethod().getParameterTypes()[i].isPrimitive()) {
                                throw new CodeUnderTestException(new NullPointerException());
                            }
                            if (inputs[i] == null || TypeUtils.isAssignable(inputs[i].getClass(), parameterTypes[i])) continue;
                            throw new CodeUnderTestException(new UncompilableCodeException("Cannot assign " + parameterVar.getVariableClass().getName() + " to " + parameterTypes[i]));
                        }
                        Object object = callee_object = MethodStatement.this.method.isStatic() ? null : MethodStatement.this.callee.getObject(scope);
                        if (!MethodStatement.this.method.isStatic() && callee_object == null) {
                            throw new CodeUnderTestException(new NullPointerException());
                        }
                    }
                    catch (CodeUnderTestException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        throw new EvosuiteError(e);
                    }
                    Object ret = MethodStatement.this.method.getMethod().invoke(callee_object, inputs);
                    if (MethodStatement.this.method.getReturnType() instanceof Class && !(returnClass = (Class)MethodStatement.this.method.getReturnType()).isPrimitive() && ret != null && !returnClass.isAssignableFrom(ret.getClass())) {
                        throw new CodeUnderTestException(new ClassCastException("Cannot assign " + MethodStatement.this.method.getReturnType() + " to variable of type " + MethodStatement.this.retval.getType()));
                    }
                    try {
                        MethodStatement.this.retval.setObject(scope, ret);
                    }
                    catch (CodeUnderTestException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new EvosuiteError(e);
                    }
                }

                @Override
                public Set<Class<? extends Throwable>> throwableExceptions() {
                    LinkedHashSet<Class<? extends Throwable>> t = new LinkedHashSet<Class<? extends Throwable>>();
                    t.add(InvocationTargetException.class);
                    return t;
                }
            });
        }
        catch (InvocationTargetException e) {
            exceptionThrown = e.getCause();
            logger.debug("Exception thrown in method {}: {}", (Object)this.method.getName(), (Object)exceptionThrown);
            return exceptionThrown;
        }
    }

    @Override
    public boolean isDeclaredException(Throwable t) {
        if (t == null) {
            return false;
        }
        for (Class<?> declaredException : this.method.getMethod().getExceptionTypes()) {
            if (!declaredException.isAssignableFrom(t.getClass())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Statement copy(TestCase newTestCase, int offset) {
        MethodStatement m;
        ArrayList<VariableReference> newParams = new ArrayList<VariableReference>();
        for (VariableReference r : this.parameters) {
            newParams.add(r.copy(newTestCase, offset));
        }
        if (this.isStatic()) {
            m = new MethodStatement(newTestCase, this.method.copy(), null, newParams);
        } else {
            VariableReference newCallee = this.callee.copy(newTestCase, offset);
            m = new MethodStatement(newTestCase, this.method.copy(), newCallee, newParams);
        }
        if (this.retval instanceof ArrayReference && !(m.getReturnValue() instanceof ArrayReference)) {
            ArrayReference newRetVal = new ArrayReference(newTestCase, this.retval.getGenericClass(), ((ArrayReference)this.retval).getArrayLength());
            m.setRetval(newRetVal);
        }
        m.getReturnValue().setType(this.retval.getType());
        return m;
    }

    @Override
    public Set<VariableReference> getVariableReferences() {
        Set<VariableReference> references = super.getVariableReferences();
        if (this.isInstanceMethod()) {
            references.add(this.callee);
            if (this.callee.getAdditionalVariableReference() != null) {
                references.add(this.callee.getAdditionalVariableReference());
            }
        }
        return references;
    }

    @Override
    public void replace(VariableReference oldVar, VariableReference newVar) {
        super.replace(oldVar, newVar);
        if (this.isInstanceMethod()) {
            if (this.callee.equals(oldVar)) {
                this.callee = newVar;
            } else {
                this.callee.replaceAdditionalVariableReference(oldVar, newVar);
            }
        }
    }

    @Override
    public int getNumParameters() {
        return this.parameters.size() + (this.isStatic() ? 0 : 1);
    }

    public String toString() {
        return this.method.getName() + org.evosuite.shaded.org.objectweb.asm.Type.getMethodDescriptor(this.method.getMethod());
    }

    @Override
    public boolean equals(Object s) {
        if (this == s) {
            return true;
        }
        if (s == null) {
            return false;
        }
        if (this.getClass() != s.getClass()) {
            return false;
        }
        MethodStatement ms = (MethodStatement)s;
        if (ms.parameters.size() != this.parameters.size()) {
            return false;
        }
        if (!this.method.equals(ms.method)) {
            return false;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (((VariableReference)this.parameters.get(i)).equals(ms.parameters.get(i))) continue;
            return false;
        }
        if (!this.retval.equals(ms.retval)) {
            return false;
        }
        if (this.callee == null && ms.callee != null || this.callee != null && ms.callee == null) {
            return false;
        }
        if (this.callee == null) {
            return true;
        }
        return this.callee.equals(ms.callee);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.callee == null ? 0 : this.callee.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    @Override
    public Set<Class<?>> getDeclaredExceptions() {
        Set<Class<?>> ex = super.getDeclaredExceptions();
        ex.addAll(Arrays.asList(this.method.getMethod().getExceptionTypes()));
        return ex;
    }

    @Override
    public List<VariableReference> getUniqueVariableReferences() {
        List<VariableReference> references = super.getUniqueVariableReferences();
        if (this.isInstanceMethod()) {
            references.add(this.callee);
            if (this.callee instanceof ArrayIndex) {
                references.add(((ArrayIndex)this.callee).getArray());
            }
        }
        return references;
    }

    @Override
    public boolean isAccessible() {
        if (!this.method.isAccessible()) {
            return false;
        }
        return super.isAccessible();
    }

    @Override
    public boolean isValid() {
        assert (super.isValid());
        for (VariableReference v : this.parameters) {
            v.getStPosition();
        }
        if (!this.isStatic()) {
            this.callee.getStPosition();
        }
        return true;
    }

    @Override
    public boolean same(Statement s) {
        if (this == s) {
            return true;
        }
        if (s == null) {
            return false;
        }
        if (this.getClass() != s.getClass()) {
            return false;
        }
        MethodStatement ms = (MethodStatement)s;
        if (ms.parameters.size() != this.parameters.size()) {
            return false;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (((VariableReference)this.parameters.get(i)).same((VariableReference)ms.parameters.get(i))) continue;
            return false;
        }
        if (!this.method.equals(ms.method)) {
            return false;
        }
        if (!this.retval.same(ms.retval)) {
            return false;
        }
        if (this.callee == null && ms.callee != null || this.callee != null && ms.callee == null) {
            return false;
        }
        if (this.callee == null) {
            return true;
        }
        return this.callee.same(ms.callee);
    }

    @Override
    public boolean mutate(TestCase test, TestFactory factory) {
        if (Randomness.nextDouble() >= Properties.P_CHANGE_PARAMETER) {
            return false;
        }
        List<VariableReference> parameters = this.getParameterReferences();
        boolean changed = false;
        int max = parameters.size();
        if (!this.isStatic()) {
            ++max;
        }
        if (max == 0) {
            return false;
        }
        double pParam = 1.0 / (double)max;
        if (!this.isStatic() && Randomness.nextDouble() < pParam) {
            VariableReference callee = this.getCallee();
            List<VariableReference> objects = test.getObjects(callee.getType(), this.getPosition());
            objects.remove(callee);
            objects = objects.stream().filter(var -> !(test.getStatement(var.getStPosition()) instanceof FunctionalMockStatement)).collect(Collectors.toList());
            if (!objects.isEmpty()) {
                VariableReference replacement = Randomness.choice(objects);
                this.setCallee(replacement);
                changed = true;
            }
        }
        for (int numParameter = 0; numParameter < parameters.size(); ++numParameter) {
            if (!(Randomness.nextDouble() < pParam) || !this.mutateParameter(test, numParameter)) continue;
            changed = true;
        }
        return changed;
    }

    public GenericMethod getAccessibleObject() {
        return this.method;
    }

    @Override
    public boolean isAssignmentStatement() {
        return false;
    }

    @Override
    public void changeClassLoader(ClassLoader loader) {
        this.method.changeClassLoader(loader);
        super.changeClassLoader(loader);
    }

    @Override
    public String getDescriptor() {
        return this.method.getDescriptor();
    }

    @Override
    public String getDeclaringClassName() {
        return this.method.getDeclaringClass().getCanonicalName();
    }

    @Override
    public String getMethodName() {
        return this.method.getName();
    }
}

