/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements.environment;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.evosuite.runtime.util.Inputs;
import org.evosuite.runtime.vnet.EndPointInfo;

public class AccessedEnvironment
implements Serializable {
    private static final long serialVersionUID = 2653568611955383431L;
    private final Set<String> localFiles = new LinkedHashSet<String>();
    private final Set<String> remoteURLs = new LinkedHashSet<String>();
    private final Set<EndPointInfo> localListeningPorts = new LinkedHashSet<EndPointInfo>();
    private final Set<EndPointInfo> remoteContactedPorts = new LinkedHashSet<EndPointInfo>();

    public void copyFrom(AccessedEnvironment other) {
        this.clear();
        this.localFiles.addAll(other.localFiles);
        this.remoteURLs.addAll(other.remoteURLs);
        this.localListeningPorts.addAll(other.localListeningPorts);
        this.remoteContactedPorts.addAll(other.remoteContactedPorts);
    }

    public void clear() {
        this.localFiles.clear();
        this.remoteURLs.clear();
        this.localListeningPorts.clear();
        this.remoteContactedPorts.clear();
    }

    public boolean hasProperty(String property) throws IllegalArgumentException {
        Inputs.checkNull(property);
        return false;
    }

    public void addRemoteContactedPorts(Collection<EndPointInfo> ports) {
        this.remoteContactedPorts.addAll(ports);
    }

    public Set<EndPointInfo> getViewOfRemoteContactedPorts() {
        return Collections.unmodifiableSet(this.remoteContactedPorts);
    }

    public void addLocalListeningPorts(Collection<EndPointInfo> ports) {
        this.localListeningPorts.addAll(ports);
    }

    public Set<EndPointInfo> getViewOfLocalListeningPorts() {
        return Collections.unmodifiableSet(this.localListeningPorts);
    }

    public void addLocalFiles(Collection<String> files) {
        this.localFiles.addAll(files);
    }

    public Set<String> getViewOfAccessedFiles() {
        return Collections.unmodifiableSet(this.localFiles);
    }

    public void addRemoteURLs(Collection<String> urls) {
        this.remoteURLs.addAll(urls);
    }

    public Set<String> getViewOfRemoteURLs() {
        return Collections.unmodifiableSet(this.remoteURLs);
    }

    public boolean isNetworkAccessed() {
        return !this.remoteURLs.isEmpty() || !this.localListeningPorts.isEmpty() || !this.remoteContactedPorts.isEmpty();
    }

    public boolean isFileSystemAccessed() {
        return !this.localFiles.isEmpty();
    }
}

