/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.operators.mutation.MutationDistribution;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestSuiteChromosome<T extends AbstractTestSuiteChromosome<T, E>, E extends ExecutableChromosome<E>>
extends Chromosome<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractTestSuiteChromosome.class);
    protected List<E> tests = new ArrayList();
    protected ChromosomeFactory<E> testChromosomeFactory;

    protected AbstractTestSuiteChromosome() {
    }

    protected AbstractTestSuiteChromosome(ChromosomeFactory<E> testChromosomeFactory) {
        this.testChromosomeFactory = testChromosomeFactory;
    }

    public ChromosomeFactory<? extends E> getTestChromosomeFactory() {
        return this.testChromosomeFactory;
    }

    protected AbstractTestSuiteChromosome(T source) {
        this(((AbstractTestSuiteChromosome)source).testChromosomeFactory);
        ((AbstractTestSuiteChromosome)source).tests.forEach(e -> this.addTest((ExecutableChromosome)e.clone()));
        this.setFitnessValues(((Chromosome)source).getFitnessValues());
        this.setPreviousFitnessValues(((Chromosome)source).getPreviousFitnessValues());
        this.setChanged(((Chromosome)source).isChanged());
        this.setCoverageValues(((Chromosome)source).getCoverageValues());
        this.setNumsOfCoveredGoals(((Chromosome)source).getNumsOfCoveredGoals());
        this.setNumsOfNotCoveredGoals(((Chromosome)source).getNumsNotCoveredGoals());
        this.setNumberOfMutations(((Chromosome)source).getNumberOfMutations());
        this.setNumberOfEvaluations(((Chromosome)source).getNumberOfEvaluations());
        this.setKineticEnergy(((Chromosome)source).getKineticEnergy());
        this.setNumCollisions(((Chromosome)source).getNumCollisions());
    }

    public void addTest(E test) {
        this.tests.add(test);
        this.setChanged(true);
    }

    public void deleteTest(E test) {
        boolean changed = this.tests.remove(test);
        if (changed) {
            this.setChanged(true);
        }
    }

    public abstract E addTest(TestCase var1);

    public void addTests(Collection<E> tests) {
        this.tests.addAll(tests);
        if (!tests.isEmpty()) {
            this.setChanged(true);
        }
    }

    public abstract void addTestChromosome(TestChromosome var1);

    public void addTestChromosomes(Collection<TestChromosome> testChromosomes) {
        testChromosomes.forEach(this::addTestChromosome);
    }

    public void addUnmodifiableTest(E test) {
        this.tests.add(test);
        this.setChanged(true);
    }

    @Override
    public void crossOver(T other, int position) throws ConstructionFailedException {
        ExecutableChromosome otherTest = (ExecutableChromosome)((AbstractTestSuiteChromosome)other.self()).tests.get(position);
        ExecutableChromosome clonedTest = (ExecutableChromosome)((ExecutableChromosome)otherTest.clone()).self();
        this.tests.add(clonedTest);
        this.setChanged(true);
    }

    @Override
    public void crossOver(T other, int position1, int position2) throws ConstructionFailedException {
        while (this.tests.size() > position1) {
            this.tests.remove(position1);
        }
        for (int num = position2; num < ((AbstractTestSuiteChromosome)other).size(); ++num) {
            ExecutableChromosome otherTest = (ExecutableChromosome)((AbstractTestSuiteChromosome)other.self()).tests.get(num);
            ExecutableChromosome clonedTest = (ExecutableChromosome)((ExecutableChromosome)otherTest.clone()).self();
            this.tests.add(clonedTest);
        }
        this.setChanged(true);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractTestSuiteChromosome)) {
            return false;
        }
        if (!obj.getClass().isInstance(this.getClass())) {
            return false;
        }
        TestSuiteChromosome other = (TestSuiteChromosome)obj;
        if (other.size() != this.size()) {
            return false;
        }
        return this.tests.equals(other.tests);
    }

    @Override
    public int hashCode() {
        return this.tests.hashCode();
    }

    @Override
    public void mutate() {
        boolean changed = false;
        MutationDistribution probabilityDistribution = MutationDistribution.getMutationDistribution(this.tests.size());
        for (int i = 0; i < this.tests.size(); ++i) {
            ExecutableChromosome test2 = (ExecutableChromosome)this.tests.get(i);
            if (!probabilityDistribution.toMutate(i)) continue;
            test2.mutate();
            if (!test2.isChanged()) continue;
            changed = true;
        }
        double ALPHA = Properties.P_TEST_INSERTION;
        int count = 1;
        while (Randomness.nextDouble() <= Math.pow(ALPHA, count) && this.size() < Properties.MAX_SIZE) {
            ExecutableChromosome test3 = (ExecutableChromosome)this.testChromosomeFactory.getChromosome();
            this.addTest(test3);
            logger.debug("Adding new test case");
            changed = true;
            ++count;
        }
        this.tests.removeIf(test -> test.size() == 0);
        if (changed) {
            this.increaseNumberOfMutations();
            this.setChanged(true);
        }
    }

    public int totalLengthOfTestCases() {
        return this.tests.stream().mapToInt(Chromosome::size).sum();
    }

    @Override
    public int size() {
        return this.tests.size();
    }

    @Override
    public abstract T clone();

    public E getTestChromosome(int index) {
        return (E)((ExecutableChromosome)this.tests.get(index));
    }

    public List<E> getTestChromosomes() {
        return this.tests;
    }

    public void replaceTests(List<E> newTests) {
        this.tests.clear();
        this.tests.addAll(newTests);
    }

    public void replaceWithTestChromosomes(List<TestChromosome> newTests) {
        this.tests.clear();
        this.addTestChromosomes(newTests);
    }

    public List<ExecutionResult> getLastExecutionResults() {
        return this.tests.stream().map(ExecutableChromosome::getLastExecutionResult).collect(Collectors.toList());
    }

    public void setTestChromosome(int index, E test) {
        this.tests.set(index, test);
        this.setChanged(true);
    }

    public void clearTests() {
        this.tests.clear();
    }
}

