/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite.factories;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteSerialization;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializationSuiteChromosomeFactory
implements ChromosomeFactory<TestSuiteChromosome> {
    private static final long serialVersionUID = -569338946355072318L;
    private static final Logger logger = LoggerFactory.getLogger(SerializationSuiteChromosomeFactory.class);
    private List<TestChromosome> previousSuite = new ArrayList<TestChromosome>();
    private ChromosomeFactory<TestChromosome> defaultFactory;

    public SerializationSuiteChromosomeFactory(ChromosomeFactory<TestChromosome> defaultFactory) throws IllegalStateException {
        this.defaultFactory = defaultFactory;
        if (Properties.CTG_SEEDS_FILE_IN != null) {
            this.previousSuite.addAll(TestSuiteSerialization.loadTests(Properties.CTG_SEEDS_FILE_IN));
        } else {
            this.previousSuite.addAll(TestSuiteSerialization.loadTests(Properties.SEED_DIR + File.separator + Properties.TARGET_CLASS));
        }
    }

    @Override
    public TestSuiteChromosome getChromosome() {
        TestSuiteChromosome tsc = new TestSuiteChromosome(this.defaultFactory);
        tsc.clearTests();
        if (Randomness.nextDouble() <= Properties.SEED_CLONE && this.previousSuite.size() > 0) {
            logger.debug("seeding previous test suite");
            for (TestChromosome tc : this.previousSuite) {
                TestChromosome clone = tc.clone();
                clone.getTestCase().removeAssertions();
                tsc.addTest(clone);
            }
        } else {
            logger.debug("creating a random testsuite");
            int numTests = Randomness.nextInt(Properties.MIN_INITIAL_TESTS, Properties.MAX_INITIAL_TESTS + 1);
            for (int i = 0; i < numTests; ++i) {
                TestChromosome tc = this.defaultFactory.getChromosome();
                tsc.addTest(tc);
            }
        }
        assert (!tsc.getTestChromosomes().isEmpty());
        return tsc;
    }
}

