/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite.localsearch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.localsearch.LocalSearch;
import org.evosuite.ga.localsearch.LocalSearchBudget;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.testcase.AbstractTestChromosome;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestCaseExpander;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.testcase.localsearch.AVMTestCaseLocalSearch;
import org.evosuite.testcase.localsearch.BranchCoverageMap;
import org.evosuite.testcase.localsearch.DSETestCaseLocalSearch;
import org.evosuite.testcase.localsearch.TestCaseLocalSearch;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.evosuite.testsuite.localsearch.TestSuiteLocalSearchObjective;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuiteLocalSearch
implements LocalSearch<TestSuiteChromosome> {
    private static final Logger logger = LoggerFactory.getLogger(TestSuiteLocalSearch.class);

    private void updateFitness(TestSuiteChromosome individual, List<FitnessFunction<TestSuiteChromosome>> fitnessFunctions) {
        for (FitnessFunction<TestSuiteChromosome> ff : fitnessFunctions) {
            ff.getFitness(individual);
        }
    }

    public static TestSuiteLocalSearch selectTestSuiteLocalSearch() {
        return new TestSuiteLocalSearch();
    }

    private static <T extends AbstractTestSuiteChromosome<T, E>, E extends AbstractTestChromosome<E>> void expandTestSuite(T suite, LocalSearchObjective<T> objective) {
        logger.debug("Expanding tests for local search");
        TestSuiteChromosome newTestSuite = new TestSuiteChromosome();
        for (AbstractTestChromosome abstractTestChromosome : suite.getTestChromosomes()) {
            if (abstractTestChromosome.getLastExecutionResult() == null || abstractTestChromosome.isChanged()) {
                abstractTestChromosome.setLastExecutionResult(TestCaseExecutor.runTest(abstractTestChromosome.getTestCase()));
                abstractTestChromosome.setChanged(false);
            }
            if (abstractTestChromosome.getLastExecutionResult().hasTimeout() || abstractTestChromosome.getLastExecutionResult().hasTestException()) {
                logger.info("Skipping test with timeout or exception");
                continue;
            }
            boolean hasLocalSearchBeenApplied = abstractTestChromosome.hasLocalSearchBeenApplied();
            TestCase newTest = abstractTestChromosome.getTestCase().clone();
            TestCase expandedTest = TestSuiteLocalSearch.expandTestCase(newTest);
            TestChromosome expandedTestChromosome = newTestSuite.addTest(expandedTest);
            expandedTestChromosome.setLocalSearchApplied(hasLocalSearchBeenApplied);
        }
        suite.replaceWithTestChromosomes(newTestSuite.getTestChromosomes());
        suite.setChanged(true);
        for (FitnessFunction fitnessFunction : objective.getFitnessFunctions()) {
            fitnessFunction.getFitness(suite);
        }
    }

    private static TestCase expandTestCase(TestCase test) {
        if (!Properties.LOCAL_SEARCH_EXPAND_TESTS) {
            return test;
        }
        TestCaseExpander expander = new TestCaseExpander();
        return expander.expandTestCase(test);
    }

    protected static void ensureDoubleExecution(TestSuiteChromosome individual, LocalSearchObjective<TestSuiteChromosome> objective) {
        logger.debug("Ensuring double execution");
        HashSet<TestChromosome> duplicates = new HashSet<TestChromosome>();
        TestSuiteFitnessFunction defaultFitness = (TestSuiteFitnessFunction)objective.getFitnessFunctions().get(0);
        HashMap covered = new HashMap();
        HashMap testMap = new HashMap();
        for (TestChromosome testChromosome : individual.getTestChromosomes()) {
            if (testChromosome.getLastExecutionResult() == null || testChromosome.isChanged()) {
                ExecutionResult result = testChromosome.executeForFitnessFunction(defaultFitness);
                testChromosome.setLastExecutionResult(result);
                testChromosome.setChanged(false);
            }
            for (Map.Entry entry : testChromosome.getLastExecutionResult().getTrace().getPredicateExecutionCount().entrySet()) {
                if (!covered.containsKey(entry.getKey())) {
                    covered.put(entry.getKey(), 0);
                }
                covered.put(entry.getKey(), (Integer)covered.get(entry.getKey()) + (Integer)entry.getValue());
                testMap.put(entry.getKey(), testChromosome);
            }
        }
        for (Map.Entry entry : covered.entrySet()) {
            int branchId = (Integer)entry.getKey();
            int n = (Integer)entry.getValue();
            if (n != 1) continue;
            TestChromosome duplicate = ((TestChromosome)testMap.get(branchId)).clone();
            ExecutionResult result = duplicate.executeForFitnessFunction(defaultFitness);
            duplicate.setLastExecutionResult(result);
            duplicate.setChanged(false);
            duplicates.add(duplicate);
        }
        if (!duplicates.isEmpty()) {
            logger.info("Adding " + duplicates.size() + " tests to cover branches sufficiently");
            for (TestChromosome testChromosome : duplicates) {
                individual.addTest(testChromosome);
            }
            individual.setChanged(true);
            for (FitnessFunction fitnessFunction : objective.getFitnessFunctions()) {
                fitnessFunction.getFitness(individual);
            }
        }
    }

    private static <T extends AbstractTestSuiteChromosome<T, E>, E extends AbstractTestChromosome<E>> Set<Integer> getCoveredTrueBranches(AbstractTestSuiteChromosome<T, E> suite) {
        LinkedHashSet<Integer> covered = new LinkedHashSet<Integer>();
        for (AbstractTestChromosome testChromosome : suite.getTestChromosomes()) {
            ExecutionResult lastResult = testChromosome.getLastExecutionResult();
            if (lastResult == null) continue;
            covered.addAll(lastResult.getTrace().getCoveredTrueBranches());
        }
        return covered;
    }

    private static <T extends AbstractTestSuiteChromosome<T, E>, E extends AbstractTestChromosome<E>> Set<Integer> getCoveredFalseBranches(AbstractTestSuiteChromosome<T, E> suite) {
        LinkedHashSet<Integer> covered = new LinkedHashSet<Integer>();
        for (AbstractTestChromosome testChromosome : suite.getTestChromosomes()) {
            ExecutionResult lastResult = testChromosome.getLastExecutionResult();
            if (lastResult == null) continue;
            covered.addAll(lastResult.getTrace().getCoveredFalseBranches());
        }
        return covered;
    }

    private void restoreBranchCoverage(TestSuiteChromosome individual) {
        logger.debug("Adding branches already covered previously");
        BranchCoverageMap branchMap = BranchCoverageMap.getInstance();
        LinkedHashSet<Integer> uncoveredTrueBranches = new LinkedHashSet<Integer>(branchMap.getCoveredTrueBranches());
        LinkedHashSet<Integer> uncoveredFalseBranches = new LinkedHashSet<Integer>(branchMap.getCoveredFalseBranches());
        uncoveredTrueBranches.removeAll(TestSuiteLocalSearch.getCoveredTrueBranches(individual));
        uncoveredFalseBranches.removeAll(TestSuiteLocalSearch.getCoveredFalseBranches(individual));
        for (Integer branchId : uncoveredTrueBranches) {
            individual.addTest(branchMap.getTestCoveringTrue(branchId).clone());
        }
        for (Integer branchId : uncoveredFalseBranches) {
            individual.addTest(branchMap.getTestCoveringFalse(branchId).clone());
        }
    }

    private boolean hasImproved(double fitnessBefore, TestSuiteChromosome individual, LocalSearchObjective<TestSuiteChromosome> objective) {
        return objective.isMaximizationObjective() ? fitnessBefore < individual.getFitness() : fitnessBefore > individual.getFitness();
    }

    @Override
    public boolean doSearch(TestSuiteChromosome suite, LocalSearchObjective<TestSuiteChromosome> objective) {
        this.updateFitness(suite, objective.getFitnessFunctions());
        double fitnessBefore = suite.getFitness();
        ArrayList originalTests = new ArrayList(suite.getTestChromosomes());
        List tests = suite.getTestChromosomes();
        Randomness.shuffle(tests);
        if (Properties.LOCAL_SEARCH_ENSURE_DOUBLE_EXECUTION) {
            TestSuiteLocalSearch.ensureDoubleExecution(suite, objective);
        }
        if (Properties.LOCAL_SEARCH_RESTORE_COVERAGE) {
            this.restoreBranchCoverage(suite);
        }
        if (Properties.LOCAL_SEARCH_EXPAND_TESTS) {
            TestSuiteLocalSearch.expandTestSuite(suite, objective);
        }
        this.applyLocalSearch(suite, objective);
        LocalSearchBudget.getInstance().countLocalSearchOnTestSuite();
        boolean hasImproved = this.hasImproved(fitnessBefore, suite, objective);
        if (!hasImproved) {
            suite.clearTests();
            suite.addTests(originalTests);
        }
        return hasImproved;
    }

    private static LocalSearchSuiteType chooseLocalSearchSuiteType() {
        LocalSearchSuiteType localSearchType;
        if (Properties.DSE_PROBABILITY <= 0.0) {
            localSearchType = LocalSearchSuiteType.ALWAYS_AVM;
        } else if (Properties.LOCAL_SEARCH_DSE == Properties.DSEType.SUITE) {
            localSearchType = Randomness.nextDouble() <= Properties.DSE_PROBABILITY ? LocalSearchSuiteType.ALWAYS_DSE : LocalSearchSuiteType.ALWAYS_AVM;
        } else {
            assert (Properties.LOCAL_SEARCH_DSE == Properties.DSEType.TEST);
            localSearchType = LocalSearchSuiteType.DSE_AND_AVM;
        }
        return localSearchType;
    }

    private void applyLocalSearch(TestSuiteChromosome suite, LocalSearchObjective<TestSuiteChromosome> objective) {
        LocalSearchSuiteType localSearchType = TestSuiteLocalSearch.chooseLocalSearchSuiteType();
        ArrayList originalTests = new ArrayList(suite.getTestChromosomes());
        for (TestChromosome test : originalTests) {
            if (test.hasLocalSearchBeenApplied()) {
                TestCaseLocalSearch.randomizePrimitives(test.getTestCase());
                this.updateFitness(suite, objective.getFitnessFunctions());
            }
            if (LocalSearchBudget.getInstance().isFinished()) {
                logger.debug("Local search budget used up: " + (Object)((Object)Properties.LOCAL_SEARCH_BUDGET_TYPE));
                break;
            }
            logger.debug("Local search budget not yet used up");
            double tossCoin = Randomness.nextDouble();
            boolean shouldApplyDSE = localSearchType == LocalSearchSuiteType.ALWAYS_DSE || localSearchType == LocalSearchSuiteType.DSE_AND_AVM && tossCoin <= Properties.DSE_PROBABILITY;
            TestChromosome clonedTest = test.clone();
            suite.addTest(clonedTest);
            int lastIndex = suite.size() - 1;
            boolean improved = shouldApplyDSE ? this.applyDSE(suite, lastIndex, clonedTest, objective) : this.applyAVM(suite, lastIndex, clonedTest, objective);
            if (improved) {
                this.updateFitness(suite, objective.getFitnessFunctions());
            } else {
                suite.deleteTest(clonedTest);
            }
            test.setLocalSearchApplied(true);
        }
    }

    private boolean applyAVM(TestSuiteChromosome suite, int testIndex, TestChromosome test, LocalSearchObjective<TestSuiteChromosome> objective) {
        logger.debug("Local search on test " + testIndex + ", current fitness: " + suite.getFitness());
        List fitnessFunctions = objective.getFitnessFunctions();
        TestSuiteLocalSearchObjective testCaseLocalSearchObjective = TestSuiteLocalSearchObjective.buildNewTestSuiteLocalSearchObjective(fitnessFunctions, suite, testIndex);
        AVMTestCaseLocalSearch testCaselocalSearch = new AVMTestCaseLocalSearch();
        boolean improved = testCaselocalSearch.doSearch(test, (LocalSearchObjective<TestChromosome>)testCaseLocalSearchObjective);
        return improved;
    }

    private boolean applyDSE(TestSuiteChromosome suite, int testIndex, TestChromosome test, LocalSearchObjective<TestSuiteChromosome> objective) {
        TestSuiteLocalSearchObjective testSuiteObject = TestSuiteLocalSearchObjective.buildNewTestSuiteLocalSearchObjective(objective.getFitnessFunctions(), suite, testIndex);
        DSETestCaseLocalSearch dseTestCaseLocalSearch = new DSETestCaseLocalSearch(suite);
        boolean improved = dseTestCaseLocalSearch.doSearch(test, (LocalSearchObjective<TestChromosome>)testSuiteObject);
        return improved;
    }

    static enum LocalSearchSuiteType {
        ALWAYS_DSE,
        ALWAYS_AVM,
        DSE_AND_AVM;

    }
}

