/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite.secondaryobjectives;

import org.evosuite.ga.SecondaryObjective;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;

public class MinimizeExceptionsSecondaryObjective
extends SecondaryObjective<TestSuiteChromosome> {
    private static final long serialVersionUID = -4405276303273532040L;

    private int getNumExceptions(TestSuiteChromosome chromosome) {
        int sum = 0;
        for (TestChromosome test : chromosome.getTestChromosomes()) {
            if (test.getLastExecutionResult() == null) continue;
            sum += test.getLastExecutionResult().getNumberOfThrownExceptions();
        }
        return sum;
    }

    @Override
    public int compareChromosomes(TestSuiteChromosome chromosome1, TestSuiteChromosome chromosome2) {
        return this.getNumExceptions(chromosome1) - this.getNumExceptions(chromosome2);
    }

    @Override
    public int compareGenerations(TestSuiteChromosome parent1, TestSuiteChromosome parent2, TestSuiteChromosome child1, TestSuiteChromosome child2) {
        return Math.min(this.getNumExceptions(parent1), this.getNumExceptions(parent2)) - Math.min(this.getNumExceptions(child1), this.getNumExceptions(child2));
    }
}

