/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class IterUtil {
    public static final String DEFAULT_JOIN_SEPARATOR = ", ";

    public static String join(Iterable<?> iter, String separator) {
        StringBuilder result = new StringBuilder();
        boolean isFirst = true;
        for (Object item : iter) {
            if (!isFirst) {
                result.append(separator);
            }
            result.append(item);
            isFirst = false;
        }
        return result.toString();
    }

    public static String join(Iterable<?> iter) {
        return IterUtil.join(iter, DEFAULT_JOIN_SEPARATOR);
    }

    public static <T> List<T> minList(Iterable<T> collection, Comparator<? super T> comparator) {
        LinkedList<T> minima = new LinkedList<T>();
        if (collection == null) {
            return minima;
        }
        Iterator<T> it = collection.iterator();
        T currentMin = it.next();
        minima.add(currentMin);
        while (it.hasNext()) {
            T element = it.next();
            int comparison = comparator.compare(element, currentMin);
            if (comparison < 0) {
                minima.clear();
                currentMin = element;
                minima.add(element);
                continue;
            }
            if (comparison != 0) continue;
            minima.add(element);
        }
        return minima;
    }
}

