/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import org.evosuite.shaded.org.apache.commons.lang3.StringEscapeUtils;

public abstract class StringUtil {
    public static String getEscapedString(String original) {
        char[] charArray = StringEscapeUtils.escapeJava(original).toCharArray();
        StringBuilder sb = new StringBuilder();
        for (char c : charArray) {
            if (c > '\u00ff') {
                sb.append("\\u");
                sb.append(Integer.toHexString(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String escapeQuotes(String str) {
        return str.replaceAll("['\"\\\\]", "\\\\$0");
    }

    public static String getCommonPrefix(String[] strs) {
        if (strs == null || strs.length == 0) {
            return "";
        }
        int smallestIndexOfDiff = StringUtil.indexOfDifference(strs);
        if (smallestIndexOfDiff == -1) {
            if (strs[0] == null) {
                return "";
            }
            return strs[0];
        }
        if (smallestIndexOfDiff == 0) {
            return "";
        }
        return strs[0].substring(0, smallestIndexOfDiff);
    }

    public static int indexOfDifference(String[] strs) {
        if (strs == null || strs.length <= 1) {
            return -1;
        }
        boolean anyStringNull = false;
        boolean allStringsNull = true;
        int arrayLen = strs.length;
        int shortestStrLen = Integer.MAX_VALUE;
        int longestStrLen = 0;
        for (String str : strs) {
            if (str == null) {
                anyStringNull = true;
                shortestStrLen = 0;
                continue;
            }
            allStringsNull = false;
            shortestStrLen = Math.min(str.length(), shortestStrLen);
            longestStrLen = Math.max(str.length(), longestStrLen);
        }
        if (allStringsNull || longestStrLen == 0 && !anyStringNull) {
            return -1;
        }
        if (shortestStrLen == 0) {
            return 0;
        }
        int firstDiff = -1;
        for (int stringPos = 0; stringPos < shortestStrLen; ++stringPos) {
            char comparisonChar = strs[0].charAt(stringPos);
            for (int arrayPos = 1; arrayPos < arrayLen; ++arrayPos) {
                if (strs[arrayPos].charAt(stringPos) == comparisonChar) continue;
                firstDiff = stringPos;
                break;
            }
            if (firstDiff != -1) break;
        }
        if (firstDiff == -1 && shortestStrLen != longestStrLen) {
            return shortestStrLen;
        }
        return firstDiff;
    }
}

