/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils.generic;

import com.googlecode.gentyref.CaptureType;
import com.googlecode.gentyref.GenericTypeReflector;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.seeding.CastClassManager;
import org.evosuite.shaded.org.apache.commons.lang3.ClassUtils;
import org.evosuite.shaded.org.apache.commons.lang3.reflect.TypeUtils;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.ParameterizedTypeImpl;
import org.evosuite.utils.generic.GenericArrayTypeImpl;
import org.evosuite.utils.generic.GenericUtils;
import org.evosuite.utils.generic.WildcardTypeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericClass
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(GenericClass.class);
    private static List<String> primitiveClasses = Arrays.asList("char", "int", "short", "long", "boolean", "float", "double", "byte");
    private static final long serialVersionUID = -3307107227790458308L;
    private static final Set<Class<?>> WRAPPER_TYPES = new LinkedHashSet<Class>(Arrays.asList(Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class));
    transient Class<?> rawClass = null;
    transient Type type = null;
    private Map<TypeVariable<?>, Type> typeVariableMap = null;

    protected static Type addTypeParameters(Class<?> clazz) {
        if (clazz.isArray()) {
            return GenericArrayTypeImpl.createArrayType(GenericClass.addTypeParameters(clazz.getComponentType()));
        }
        if (GenericClass.isMissingTypeParameters(clazz)) {
            Type[] vars = clazz.getTypeParameters();
            Type owner = clazz.getDeclaringClass() == null ? null : GenericClass.addTypeParameters(clazz.getDeclaringClass());
            return new ParameterizedTypeImpl(clazz, vars, owner);
        }
        return clazz;
    }

    private static Class<?> erase(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            if (tv.getBounds().length == 0) {
                return Object.class;
            }
            return GenericClass.erase(tv.getBounds()[0]);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType aType = (GenericArrayType)type;
            return GenericArrayTypeImpl.createArrayType(GenericClass.erase(aType.getGenericComponentType()));
        }
        if (type instanceof CaptureType) {
            CaptureType captureType = (CaptureType)type;
            if (captureType.getUpperBounds().length == 0) {
                return Object.class;
            }
            return GenericClass.erase(captureType.getUpperBounds()[0]);
        }
        throw new RuntimeException("not supported: " + type.getClass());
    }

    private static Class<?> getClass(String name) throws ClassNotFoundException {
        return GenericClass.getClass(name, TestGenerationContext.getInstance().getClassLoaderForSUT());
    }

    private static Class<?> getClass(String name, ClassLoader loader) throws ClassNotFoundException {
        if (name.equals("void")) {
            return Void.TYPE;
        }
        if (name.equals("int") || name.equals("I")) {
            return Integer.TYPE;
        }
        if (name.equals("short") || name.equals("S")) {
            return Short.TYPE;
        }
        if (name.equals("long") || name.equals("J")) {
            return Long.TYPE;
        }
        if (name.equals("float") || name.equals("F")) {
            return Float.TYPE;
        }
        if (name.equals("double") || name.equals("D")) {
            return Double.TYPE;
        }
        if (name.equals("boolean") || name.equals("Z")) {
            return Boolean.TYPE;
        }
        if (name.equals("byte") || name.equals("B")) {
            return Byte.TYPE;
        }
        if (name.equals("char") || name.equals("C")) {
            return Character.TYPE;
        }
        if (name.startsWith("[")) {
            Class<?> componentType = GenericClass.getClass(name.substring(1, name.length()), loader);
            Object array = Array.newInstance(componentType, 0);
            return array.getClass();
        }
        if (name.startsWith("L") && name.endsWith(";")) {
            return GenericClass.getClass(name.substring(1, name.length() - 1), loader);
        }
        if (name.endsWith(";")) {
            return GenericClass.getClass(name.substring(0, name.length() - 1), loader);
        }
        if (name.endsWith(".class")) {
            return GenericClass.getClass(name.replace(".class", ""), loader);
        }
        return loader.loadClass(name);
    }

    public static boolean isAssignable(Type lhsType, Type rhsType) {
        if (rhsType == null || lhsType == null) {
            return false;
        }
        try {
            return TypeUtils.isAssignable(rhsType, lhsType);
        }
        catch (Throwable e) {
            logger.debug("Found unassignable type: " + e);
            return false;
        }
    }

    public static boolean isMissingTypeParameters(Type type) {
        if (type instanceof Class) {
            for (Class<?> clazz = (Class<?>)type; clazz != null; clazz = clazz.getEnclosingClass()) {
                if (clazz.getTypeParameters().length == 0) continue;
                return true;
            }
            return false;
        }
        if (type instanceof ParameterizedType) {
            return false;
        }
        if (type instanceof GenericArrayType) {
            return false;
        }
        if (type instanceof TypeVariable) {
            return false;
        }
        if (type instanceof WildcardType) {
            return false;
        }
        throw new AssertionError((Object)("Unexpected type " + type.getClass()));
    }

    public static boolean isSubclass(Type superclass, Type subclass) {
        List<Class<?>> superclasses = ClassUtils.getAllSuperclasses((Class)subclass);
        List<Class<?>> interfaces = ClassUtils.getAllInterfaces((Class)subclass);
        return superclasses.contains(superclass) || interfaces.contains(superclass);
    }

    public GenericClass(Class<?> clazz) {
        this.type = GenericClass.addTypeParameters(clazz);
        this.rawClass = clazz;
    }

    public GenericClass(GenericClass copy) {
        this.type = copy.type;
        this.rawClass = copy.rawClass;
    }

    public GenericClass(Type type) {
        if (type instanceof Class) {
            this.type = GenericClass.addTypeParameters((Class)type);
            this.rawClass = (Class)type;
        } else if (!this.handleGenericArraySpecialCase(type)) {
            this.type = type;
            try {
                this.rawClass = GenericClass.erase(type);
            }
            catch (RuntimeException e) {
                this.rawClass = Object.class;
            }
        }
    }

    public GenericClass(Type type, Class<?> clazz) {
        this.type = type;
        this.rawClass = clazz;
        this.handleGenericArraySpecialCase(type);
    }

    public boolean canBeInstantiatedTo(GenericClass otherType) {
        Class<?> otherRawClass;
        if (this.isPrimitive() && otherType.isWrapperType()) {
            return false;
        }
        if (this.isAssignableTo(otherType)) {
            return true;
        }
        if (!this.isTypeVariable() && !otherType.isTypeVariable()) {
            try {
                if (otherType.isGenericSuperTypeOf(this)) {
                    return true;
                }
            }
            catch (RuntimeException e) {
                return false;
            }
        }
        if ((otherRawClass = otherType.getRawClass()).isAssignableFrom(this.rawClass)) {
            Map<TypeVariable<?>, Type> typeMap = otherType.getTypeVariableMap();
            if (otherType.isParameterizedType()) {
                typeMap.putAll(TypeUtils.determineTypeArguments(this.rawClass, (ParameterizedType)otherType.getType()));
            }
            try {
                GenericClass instantiation = this.getGenericInstantiation(typeMap);
                if (this.equals(instantiation)) {
                    return !this.hasWildcardOrTypeVariables();
                }
                return instantiation.canBeInstantiatedTo(otherType);
            }
            catch (ConstructionFailedException e) {
                logger.debug("Failed to instantiate " + this.toString());
                return false;
            }
        }
        return false;
    }

    public void changeClassLoader(ClassLoader loader) {
        block14: {
            try {
                if (this.rawClass != null) {
                    this.rawClass = GenericClass.getClass(this.rawClass.getName(), loader);
                }
                if (this.type instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)this.type;
                    GenericClass ownerType = null;
                    if (pt.getOwnerType() != null) {
                        ownerType = new GenericClass(pt.getOwnerType());
                        ownerType.changeClassLoader(loader);
                    }
                    ArrayList<GenericClass> parameterClasses = new ArrayList<GenericClass>();
                    for (Type parameterType : pt.getActualTypeArguments()) {
                        GenericClass parameter = new GenericClass(parameterType);
                        parameter.changeClassLoader(loader);
                        parameterClasses.add(parameter);
                    }
                    Type[] parameterTypes = new Type[parameterClasses.size()];
                    for (int i = 0; i < parameterClasses.size(); ++i) {
                        parameterTypes[i] = ((GenericClass)parameterClasses.get(i)).getType();
                    }
                    this.type = new ParameterizedTypeImpl(this.rawClass, parameterTypes, ownerType != null ? ownerType.getType() : null);
                    break block14;
                }
                if (this.type instanceof GenericArrayType) {
                    GenericClass componentClass = this.getComponentClass();
                    componentClass.changeClassLoader(loader);
                    this.type = GenericArrayTypeImpl.createArrayType(componentClass.getType());
                    break block14;
                }
                if (this.type instanceof WildcardType) {
                    GenericClass bound;
                    int i;
                    Type[] oldUpperBounds = ((WildcardType)this.type).getUpperBounds();
                    Type[] oldLowerBounds = ((WildcardType)this.type).getLowerBounds();
                    Type[] upperBounds = new Type[oldUpperBounds.length];
                    Type[] lowerBounds = new Type[oldLowerBounds.length];
                    for (i = 0; i < oldUpperBounds.length; ++i) {
                        bound = new GenericClass(oldUpperBounds[i]);
                        bound.changeClassLoader(loader);
                        upperBounds[i] = bound.getType();
                    }
                    for (i = 0; i < oldLowerBounds.length; ++i) {
                        bound = new GenericClass(oldLowerBounds[i]);
                        bound.changeClassLoader(loader);
                        lowerBounds[i] = bound.getType();
                    }
                    this.type = new WildcardTypeImpl(upperBounds, lowerBounds);
                    break block14;
                }
                if (this.type instanceof TypeVariable) {
                    for (TypeVariable<Class<?>> newVar : this.rawClass.getTypeParameters()) {
                        if (!newVar.getName().equals(((TypeVariable)this.type).getName())) continue;
                        this.type = newVar;
                        break block14;
                    }
                    break block14;
                }
                this.type = GenericClass.addTypeParameters(this.rawClass);
            }
            catch (ClassNotFoundException e) {
                logger.warn("Class not found: " + this.rawClass + " - keeping old class loader ", e);
            }
            catch (SecurityException e) {
                logger.warn("Class not found: " + this.rawClass + " - keeping old class loader ", e);
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericClass other = (GenericClass)obj;
        return this.getTypeName().equals(other.getTypeName());
    }

    public Class<?> getBoxedType() {
        if (this.isPrimitive()) {
            if (this.rawClass.equals(Integer.TYPE)) {
                return Integer.class;
            }
            if (this.rawClass.equals(Byte.TYPE)) {
                return Byte.class;
            }
            if (this.rawClass.equals(Short.TYPE)) {
                return Short.class;
            }
            if (this.rawClass.equals(Long.TYPE)) {
                return Long.class;
            }
            if (this.rawClass.equals(Float.TYPE)) {
                return Float.class;
            }
            if (this.rawClass.equals(Double.TYPE)) {
                return Double.class;
            }
            if (this.rawClass.equals(Character.TYPE)) {
                return Character.class;
            }
            if (this.rawClass.equals(Boolean.TYPE)) {
                return Boolean.class;
            }
            if (this.rawClass.equals(Void.TYPE)) {
                return Void.class;
            }
            throw new RuntimeException("Unknown unboxed type: " + this.rawClass);
        }
        return this.rawClass;
    }

    public String getClassName() {
        return this.rawClass.getName();
    }

    public GenericClass getComponentClass() {
        if (this.type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)this.type;
            Type componentType = arrayType.getGenericComponentType();
            Class<?> rawComponentType = this.rawClass.getComponentType();
            return new GenericClass(componentType, rawComponentType);
        }
        return new GenericClass(this.rawClass.getComponentType());
    }

    public String getComponentName() {
        return this.rawClass.getComponentType().getSimpleName();
    }

    public Type getComponentType() {
        return GenericTypeReflector.getArrayComponentType(this.type);
    }

    public Collection<GenericClass> getGenericBounds() {
        LinkedHashSet<GenericClass> bounds = new LinkedHashSet<GenericClass>();
        if (this.isRawClass() || !this.hasWildcardOrTypeVariables()) {
            return bounds;
        }
        if (this.isWildcardType()) {
            this.getGenericWildcardBounds(bounds);
        } else if (this.isArray()) {
            bounds.addAll(this.getComponentClass().getGenericBounds());
        } else if (this.isTypeVariable()) {
            this.getGenericTypeVarBounds(bounds);
        } else if (this.isParameterizedType()) {
            this.getGenericParameterizedTypeBounds(bounds);
        }
        return bounds;
    }

    private void getGenericWildcardBounds(Collection<GenericClass> bounds) {
        for (Type t : ((WildcardType)this.type).getUpperBounds()) {
            bounds.add(new GenericClass(t));
        }
        for (Type t : ((WildcardType)this.type).getLowerBounds()) {
            bounds.add(new GenericClass(t));
        }
    }

    private void getGenericTypeVarBounds(Collection<GenericClass> bounds) {
        for (Type t : ((TypeVariable)this.type).getBounds()) {
            bounds.add(new GenericClass(t));
        }
    }

    private void getGenericParameterizedTypeBounds(Collection<GenericClass> bounds) {
        for (TypeVariable<?> typeVar : this.getTypeVariables()) {
            for (Type t : typeVar.getBounds()) {
                bounds.add(new GenericClass(t));
            }
        }
    }

    public GenericClass getGenericInstantiation() throws ConstructionFailedException {
        return this.getGenericInstantiation(new HashMap());
    }

    public GenericClass getGenericInstantiation(Map<TypeVariable<?>, Type> typeMap) throws ConstructionFailedException {
        return this.getGenericInstantiation(typeMap, 0);
    }

    private GenericClass getGenericInstantiation(Map<TypeVariable<?>, Type> typeMap, int recursionLevel) throws ConstructionFailedException {
        logger.debug("Instantiation " + this.toString() + " with type map " + typeMap);
        if (this.isRawClass() || !this.hasWildcardOrTypeVariables() || recursionLevel > Properties.MAX_GENERIC_DEPTH) {
            logger.debug("Nothing to replace: " + this.toString() + ", " + this.isRawClass() + ", " + this.hasWildcardOrTypeVariables());
            return new GenericClass(this);
        }
        if (this.isWildcardType()) {
            logger.debug("Is wildcard type.");
            return this.getGenericWildcardInstantiation(typeMap, recursionLevel);
        }
        if (this.isArray()) {
            return this.getGenericArrayInstantiation(typeMap, recursionLevel);
        }
        if (this.isTypeVariable()) {
            logger.debug("Is type variable ");
            return this.getGenericTypeVariableInstantiation(typeMap, recursionLevel);
        }
        if (this.isParameterizedType()) {
            logger.debug("Is parameterized type");
            return this.getGenericParameterizedTypeInstantiation(typeMap, recursionLevel);
        }
        return null;
    }

    private GenericClass getGenericArrayInstantiation(Map<TypeVariable<?>, Type> typeMap, int recursionLevel) throws ConstructionFailedException {
        GenericClass componentClass = this.getComponentClass().getGenericInstantiation();
        return this.getWithComponentClass(componentClass);
    }

    private GenericClass getGenericTypeVariableInstantiation(Map<TypeVariable<?>, Type> typeMap, int recursionLevel) throws ConstructionFailedException {
        GenericClass selectedClass;
        if (typeMap.containsKey(this.type)) {
            logger.debug("Type contains {}: {}", (Object)this.toString(), (Object)typeMap);
            if (typeMap.get(this.type) == this.type) {
                throw new ConstructionFailedException("Type points to itself");
            }
            selectedClass = new GenericClass(typeMap.get(this.type)).getGenericInstantiation(typeMap, recursionLevel + 1);
            if (!selectedClass.satisfiesBoundaries((TypeVariable)this.type)) {
                logger.debug("Cannot be instantiated to: {}", (Object)selectedClass);
            } else {
                logger.debug("Can be instantiated to: {}", (Object)selectedClass);
                return selectedClass;
            }
        }
        logger.debug("Type map does not contain {}: {}", (Object)this.toString(), (Object)typeMap);
        selectedClass = CastClassManager.getInstance().selectCastClass((TypeVariable)this.type, recursionLevel < Properties.MAX_GENERIC_DEPTH, typeMap);
        if (selectedClass == null) {
            throw new ConstructionFailedException("Unable to instantiate " + this.toString());
        }
        logger.debug("Getting instantiation of type variable {}: {}", (Object)this.toString(), (Object)selectedClass);
        HashMap extendedMap = new HashMap(typeMap);
        extendedMap.putAll(this.getTypeVariableMap());
        for (Type bound : ((TypeVariable)this.type).getBounds()) {
            Class<?> boundRawClass;
            logger.debug("Current bound of variable {}: {}", (Object)this.type, (Object)bound);
            GenericClass boundClass = new GenericClass(bound);
            extendedMap.putAll(boundClass.getTypeVariableMap());
            if (!boundClass.isParameterizedType() || !(boundRawClass = boundClass.getRawClass()).isAssignableFrom(selectedClass.getRawClass())) continue;
            Map<TypeVariable<?>, Type> xmap = TypeUtils.determineTypeArguments(selectedClass.getRawClass(), (ParameterizedType)boundClass.getType());
            extendedMap.putAll(xmap);
        }
        logger.debug("Updated type variable map to {}", (Object)extendedMap);
        GenericClass instantiation = selectedClass.getGenericInstantiation(extendedMap, recursionLevel + 1);
        typeMap.put((TypeVariable)this.type, instantiation.getType());
        return instantiation;
    }

    private GenericClass getGenericWildcardInstantiation(Map<TypeVariable<?>, Type> typeMap, int recursionLevel) throws ConstructionFailedException {
        GenericClass selectedClass = CastClassManager.getInstance().selectCastClass((WildcardType)this.type, recursionLevel < Properties.MAX_GENERIC_DEPTH, typeMap);
        return selectedClass.getGenericInstantiation(typeMap, recursionLevel + 1);
    }

    public List<GenericClass> getInterfaces() {
        ArrayList<GenericClass> ret = new ArrayList<GenericClass>();
        for (Class<?> intf : this.rawClass.getInterfaces()) {
            ret.add(new GenericClass(intf));
        }
        return ret;
    }

    private GenericClass getGenericParameterizedTypeInstantiation(Map<TypeVariable<?>, Type> typeMap, int recursionLevel) throws ConstructionFailedException {
        List<TypeVariable<?>> typeParameters = this.getTypeVariables();
        Type[] parameterTypes = new Type[typeParameters.size()];
        Type ownerType = null;
        int numParam = 0;
        for (GenericClass parameterClass : this.getParameterClasses()) {
            GenericClass parameterInstance;
            logger.debug("Current parameter to instantiate: {}", (Object)parameterClass);
            if (!parameterClass.hasWildcardOrTypeVariables()) {
                logger.debug("Parameter has no wildcard or type variable");
                parameterTypes[numParam++] = parameterClass.getType();
                continue;
            }
            logger.debug("Current parameter has type variables: " + parameterClass);
            HashMap extendedMap = new HashMap(typeMap);
            extendedMap.putAll(parameterClass.getTypeVariableMap());
            if (!extendedMap.containsKey(typeParameters.get(numParam)) && !parameterClass.isTypeVariable()) {
                extendedMap.put(typeParameters.get(numParam), parameterClass.getType());
            }
            logger.debug("New type map: " + extendedMap);
            if (parameterClass.isWildcardType()) {
                logger.debug("Is wildcard type, here we should value the wildcard boundaries");
                logger.debug("Wildcard boundaries: " + parameterClass.getGenericBounds());
                logger.debug("Boundaries of underlying var: " + Arrays.asList(typeParameters.get(numParam).getBounds()));
                parameterInstance = parameterClass.getGenericWildcardInstantiation(extendedMap, recursionLevel + 1);
                if (!parameterInstance.satisfiesBoundaries(typeParameters.get(numParam))) {
                    throw new ConstructionFailedException("Invalid generic instance");
                }
                parameterTypes[numParam++] = parameterInstance.getType();
                continue;
            }
            logger.debug("Is not wildcard but type variable? " + parameterClass.isTypeVariable());
            parameterInstance = parameterClass.getGenericInstantiation(extendedMap, recursionLevel + 1);
            parameterTypes[numParam++] = parameterInstance.getType();
        }
        if (this.hasOwnerType()) {
            GenericClass ownerClass = this.getOwnerType().getGenericInstantiation(typeMap, recursionLevel);
            ownerType = ownerClass.getType();
        }
        return new GenericClass(new ParameterizedTypeImpl(this.rawClass, parameterTypes, ownerType));
    }

    public int getNumParameters() {
        if (this.type instanceof ParameterizedType) {
            return Arrays.asList(((ParameterizedType)this.type).getActualTypeArguments()).size();
        }
        return 0;
    }

    public GenericClass getOwnerType() {
        return new GenericClass(((ParameterizedType)this.type).getOwnerType());
    }

    public List<Type> getParameterTypes() {
        if (this.type instanceof ParameterizedType) {
            return Arrays.asList(((ParameterizedType)this.type).getActualTypeArguments());
        }
        return new ArrayList<Type>();
    }

    public List<GenericClass> getParameterClasses() {
        if (this.type instanceof ParameterizedType) {
            ArrayList<GenericClass> parameters = new ArrayList<GenericClass>();
            for (Type parameterType : ((ParameterizedType)this.type).getActualTypeArguments()) {
                parameters.add(new GenericClass(parameterType));
            }
            return parameters;
        }
        return new ArrayList<GenericClass>();
    }

    public Class<?> getRawClass() {
        return this.rawClass;
    }

    public Type getRawComponentClass() {
        return GenericTypeReflector.erase(this.rawClass.getComponentType());
    }

    public GenericClass getRawGenericClass() {
        return new GenericClass(this.rawClass);
    }

    public String getSimpleName() {
        String name = ClassUtils.getShortClassName(this.rawClass).replace(";", "[]");
        if (!this.isPrimitive() && primitiveClasses.contains(name)) {
            return this.rawClass.getSimpleName().replace(";", "[]");
        }
        return name;
    }

    public GenericClass getSuperClass() {
        return new GenericClass(GenericTypeReflector.getExactSuperType(this.type, this.rawClass.getSuperclass()));
    }

    public Type getType() {
        return this.type;
    }

    public String getTypeName() {
        return GenericTypeReflector.getTypeName(this.type);
    }

    public Map<TypeVariable<?>, Type> getTypeVariableMap() {
        if (this.typeVariableMap != null) {
            return this.typeVariableMap;
        }
        List<TypeVariable<?>> typeVariables = this.getTypeVariables();
        List<Type> types = this.getParameterTypes();
        LinkedHashMap typeMap = new LinkedHashMap();
        try {
            if (!(this.rawClass.getSuperclass() == null || this.rawClass.isAnonymousClass() || this.rawClass.getSuperclass().isAnonymousClass() || this.hasOwnerType() && this.getOwnerType().getRawClass().isAnonymousClass())) {
                GenericClass superClass = this.getSuperClass();
                Map<TypeVariable<?>, Type> superMap = superClass.getTypeVariableMap();
                typeMap.putAll(superMap);
            }
            for (Class<?> interFace : this.rawClass.getInterfaces()) {
                GenericClass interFaceClass = new GenericClass(interFace);
                Map<TypeVariable<?>, Type> superMap = interFaceClass.getTypeVariableMap();
                typeMap.putAll(superMap);
            }
            if (this.isTypeVariable()) {
                for (Type boundType : ((TypeVariable)this.type).getBounds()) {
                    GenericClass boundClass = new GenericClass(boundType);
                    typeMap.putAll(boundClass.getTypeVariableMap());
                }
            }
        }
        catch (Exception e) {
            logger.debug("Exception while getting type map: " + e);
        }
        for (int i = 0; i < typeVariables.size(); ++i) {
            if (types.get(i) == typeVariables.get(i)) continue;
            typeMap.put(typeVariables.get(i), types.get(i));
        }
        this.typeVariableMap = typeMap;
        return typeMap;
    }

    public List<TypeVariable<?>> getTypeVariables() {
        ArrayList typeVariables = new ArrayList();
        if (this.type instanceof ParameterizedType) {
            typeVariables.addAll(Arrays.asList(this.rawClass.getTypeParameters()));
        }
        return typeVariables;
    }

    public Class<?> getUnboxedType() {
        if (this.isWrapperType()) {
            if (this.rawClass.equals(Integer.class)) {
                return Integer.TYPE;
            }
            if (this.rawClass.equals(Byte.class)) {
                return Byte.TYPE;
            }
            if (this.rawClass.equals(Short.class)) {
                return Short.TYPE;
            }
            if (this.rawClass.equals(Long.class)) {
                return Long.TYPE;
            }
            if (this.rawClass.equals(Float.class)) {
                return Float.TYPE;
            }
            if (this.rawClass.equals(Double.class)) {
                return Double.TYPE;
            }
            if (this.rawClass.equals(Character.class)) {
                return Character.TYPE;
            }
            if (this.rawClass.equals(Boolean.class)) {
                return Boolean.TYPE;
            }
            if (this.rawClass.equals(Void.class)) {
                return Void.TYPE;
            }
            throw new RuntimeException("Unknown boxed type: " + this.rawClass);
        }
        return this.rawClass;
    }

    public GenericClass getWithComponentClass(GenericClass componentClass) {
        if (this.type instanceof GenericArrayType) {
            return new GenericClass(GenericArrayTypeImpl.createArrayType(componentClass.getType()), this.rawClass);
        }
        return new GenericClass(this.type, this.rawClass);
    }

    public GenericClass getWithGenericParameterTypes(List<GenericClass> parameters) {
        Type[] typeArray = new Type[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            typeArray[i] = parameters.get(i).getType();
        }
        Type ownerType = null;
        if (this.type instanceof ParameterizedType) {
            ownerType = ((ParameterizedType)this.type).getOwnerType();
        }
        return new GenericClass(new ParameterizedTypeImpl(this.rawClass, typeArray, ownerType));
    }

    public GenericClass getWithOwnerType(GenericClass ownerClass) {
        if (this.type instanceof ParameterizedType) {
            ParameterizedType currentType = (ParameterizedType)this.type;
            return new GenericClass(new ParameterizedTypeImpl(this.rawClass, currentType.getActualTypeArguments(), ownerClass.getType()));
        }
        return new GenericClass(this.type);
    }

    public GenericClass getWithParametersFromSuperclass(GenericClass superClass) throws ConstructionFailedException {
        GenericClass exactClass = new GenericClass(this.type);
        if (!(this.type instanceof ParameterizedType)) {
            exactClass.type = this.type;
            return exactClass;
        }
        ParameterizedType pType = (ParameterizedType)this.type;
        if (superClass.isParameterizedType()) {
            Map<TypeVariable<?>, Type> typeMap = TypeUtils.determineTypeArguments(this.rawClass, (ParameterizedType)superClass.getType());
            return this.getGenericInstantiation(typeMap);
        }
        Class<?> targetClass = superClass.getRawClass();
        Class<?> currentClass = this.rawClass;
        Type[] parameterTypes = new Type[superClass.getNumParameters()];
        superClass.getParameterTypes().toArray(parameterTypes);
        if (targetClass.equals(currentClass)) {
            logger.info("Raw classes match, setting parameters to: " + superClass.getParameterTypes());
            exactClass.type = new ParameterizedTypeImpl(currentClass, parameterTypes, pType.getOwnerType());
        } else {
            Type ownerType = pType.getOwnerType();
            Map<TypeVariable<?>, Type> superTypeMap = superClass.getTypeVariableMap();
            Type[] origArguments = pType.getActualTypeArguments();
            Type[] arguments = new Type[origArguments.length];
            for (int i = 0; i < origArguments.length; ++i) {
                arguments[i] = origArguments[i];
            }
            List<TypeVariable<?>> variables = this.getTypeVariables();
            for (int i = 0; i < arguments.length; ++i) {
                TypeVariable<?> var = variables.get(i);
                if (superTypeMap.containsKey(var)) {
                    arguments[i] = superTypeMap.get(var);
                    logger.info("Setting type variable " + var + " to " + superTypeMap.get(var));
                    continue;
                }
                if (!(arguments[i] instanceof WildcardType) || i >= parameterTypes.length) continue;
                logger.info("Replacing wildcard with " + parameterTypes[i]);
                logger.info("Lower Bounds: " + Arrays.asList(TypeUtils.getImplicitLowerBounds((WildcardType)arguments[i])));
                logger.info("Upper Bounds: " + Arrays.asList(TypeUtils.getImplicitUpperBounds((WildcardType)arguments[i])));
                logger.info("Type variable: " + variables.get(i));
                if (!TypeUtils.isAssignable(parameterTypes[i], arguments[i])) {
                    logger.info("Not assignable to bounds!");
                    return null;
                }
                boolean assignable = false;
                for (Type bound : variables.get(i).getBounds()) {
                    if (!TypeUtils.isAssignable(parameterTypes[i], bound)) continue;
                    assignable = true;
                    break;
                }
                if (!assignable) {
                    logger.info("Not assignable to type variable!");
                    return null;
                }
                arguments[i] = parameterTypes[i];
            }
            GenericClass ownerClass = new GenericClass(ownerType).getWithParametersFromSuperclass(superClass);
            if (ownerClass == null) {
                return null;
            }
            exactClass.type = new ParameterizedTypeImpl(currentClass, arguments, ownerClass.getType());
        }
        return exactClass;
    }

    public GenericClass getWithParameterTypes(List<Type> parameters) {
        Type[] typeArray = new Type[parameters.size()];
        for (int i = 0; i < parameters.size(); ++i) {
            typeArray[i] = parameters.get(i);
        }
        Type ownerType = null;
        if (this.type instanceof ParameterizedType) {
            ownerType = ((ParameterizedType)this.type).getOwnerType();
        }
        return new GenericClass(new ParameterizedTypeImpl(this.rawClass, typeArray, ownerType));
    }

    public GenericClass getWithParameterTypes(Type[] parameters) {
        Type ownerType = null;
        if (this.type instanceof ParameterizedType) {
            ownerType = ((ParameterizedType)this.type).getOwnerType();
        }
        return new GenericClass(new ParameterizedTypeImpl(this.rawClass, parameters, ownerType));
    }

    public GenericClass getWithWildcardTypes() {
        Type ownerType = GenericTypeReflector.addWildcardParameters(this.rawClass);
        return new GenericClass(ownerType);
    }

    private boolean handleGenericArraySpecialCase(Type type) {
        Type componentType;
        if (type instanceof GenericArrayType && (componentType = ((GenericArrayType)type).getGenericComponentType()) == null) {
            this.type = this.rawClass = Object[].class;
            return true;
        }
        return false;
    }

    public boolean hasGenericSuperType(GenericClass superType) {
        return GenericTypeReflector.isSuperType(superType.getType(), this.type);
    }

    public boolean hasGenericSuperType(Type superType) {
        return GenericTypeReflector.isSuperType(superType, this.type);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getTypeName().hashCode();
        return result;
    }

    public boolean hasOwnerType() {
        if (this.type instanceof ParameterizedType) {
            return ((ParameterizedType)this.type).getOwnerType() != null;
        }
        return false;
    }

    public boolean hasTypeVariables() {
        if (this.isParameterizedType()) {
            return this.hasTypeVariables((ParameterizedType)this.type);
        }
        return this.isTypeVariable();
    }

    private boolean hasTypeVariables(ParameterizedType parameterType) {
        for (Type t : parameterType.getActualTypeArguments()) {
            if (t instanceof TypeVariable) {
                return true;
            }
            if (!(t instanceof ParameterizedType) || !this.hasTypeVariables((ParameterizedType)t)) continue;
            return true;
        }
        return false;
    }

    public boolean hasWildcardOrTypeVariables() {
        if (this.isTypeVariable() || this.isWildcardType()) {
            return true;
        }
        if (this.hasWildcardTypes()) {
            return true;
        }
        if (this.hasTypeVariables()) {
            return true;
        }
        if (this.hasOwnerType() && this.getOwnerType().hasWildcardOrTypeVariables()) {
            return true;
        }
        return this.type instanceof GenericArrayType && this.getComponentClass().hasWildcardOrTypeVariables();
    }

    private boolean hasWildcardType(ParameterizedType parameterType) {
        for (Type t : parameterType.getActualTypeArguments()) {
            if (t instanceof WildcardType) {
                return true;
            }
            if (!(t instanceof ParameterizedType) || !this.hasWildcardType((ParameterizedType)t)) continue;
            return true;
        }
        return false;
    }

    public boolean hasWildcardTypes() {
        if (this.isParameterizedType()) {
            return this.hasWildcardType((ParameterizedType)this.type);
        }
        return this.isWildcardType();
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.rawClass.getModifiers());
    }

    public boolean isAnonymous() {
        return this.rawClass.isAnonymousClass();
    }

    public boolean isArray() {
        return this.rawClass.isArray();
    }

    public boolean isAssignableFrom(GenericClass rhsType) {
        return GenericClass.isAssignable(this.type, rhsType.type);
    }

    public boolean isAssignableFrom(Type rhsType) {
        return GenericClass.isAssignable(this.type, rhsType);
    }

    public boolean isAssignableTo(GenericClass lhsType) {
        return GenericClass.isAssignable(lhsType.type, this.type);
    }

    public boolean isAssignableTo(Type lhsType) {
        return GenericClass.isAssignable(lhsType, this.type);
    }

    public boolean isClass() {
        return this.rawClass.equals(Class.class);
    }

    public boolean isEnum() {
        return this.rawClass.isEnum();
    }

    public boolean isGenericArray() {
        GenericClass componentClass = new GenericClass(this.rawClass.getComponentType());
        return componentClass.hasWildcardOrTypeVariables();
    }

    public boolean isGenericSuperTypeOf(GenericClass subType) {
        return GenericTypeReflector.isSuperType(this.type, subType.getType());
    }

    public boolean isGenericSuperTypeOf(Type subType) {
        return GenericTypeReflector.isSuperType(this.type, subType);
    }

    public boolean isObject() {
        return this.rawClass.equals(Object.class);
    }

    public boolean isParameterizedType() {
        return this.type instanceof ParameterizedType;
    }

    public boolean isPrimitive() {
        return this.rawClass.isPrimitive();
    }

    public boolean isRawClass() {
        return this.type instanceof Class;
    }

    public boolean isTypeVariable() {
        return this.type instanceof TypeVariable;
    }

    public boolean isWildcardType() {
        return this.type instanceof WildcardType;
    }

    public boolean isString() {
        return this.rawClass.equals(String.class);
    }

    public boolean isVoid() {
        return this.rawClass.equals(Void.class) || this.rawClass.equals(Void.TYPE);
    }

    public boolean isWrapperType() {
        return WRAPPER_TYPES.contains(this.rawClass);
    }

    public boolean satisfiesBoundaries(TypeVariable<?> typeVariable) {
        return this.satisfiesBoundaries(typeVariable, this.getTypeVariableMap());
    }

    public boolean satisfiesBoundaries(TypeVariable<?> typeVariable, Map<TypeVariable<?>, Type> typeMap) {
        boolean isAssignable = true;
        Map<TypeVariable<?>, Type> ownerVariableMap = this.getTypeVariableMap();
        for (Type bound : typeVariable.getBounds()) {
            Class<?> boundClass;
            if (!(bound instanceof ParameterizedType) || !(boundClass = GenericTypeReflector.erase(bound)).isAssignableFrom(this.rawClass)) continue;
            Map<TypeVariable<?>, Type> xmap = TypeUtils.determineTypeArguments(this.rawClass, (ParameterizedType)bound);
            ownerVariableMap.putAll(xmap);
        }
        ownerVariableMap.putAll(typeMap);
        boolean changed = true;
        while (changed) {
            changed = false;
            for (TypeVariable<?> var : ownerVariableMap.keySet()) {
                Type x;
                Type other;
                TypeVariable value;
                if (!(ownerVariableMap.get(var) instanceof TypeVariable) || !ownerVariableMap.containsKey(value = (TypeVariable)ownerVariableMap.get(var)) || (other = ownerVariableMap.get(value)) instanceof TypeVariable && ownerVariableMap.containsKey(other) && ((x = ownerVariableMap.get(other)) == var || x == value || x == other) || var == other || value == other) continue;
                ownerVariableMap.put(var, other);
                changed = true;
            }
        }
        GenericClass concreteClass = new GenericClass(GenericUtils.replaceTypeVariables(this.type, ownerVariableMap));
        for (Type theType : typeVariable.getBounds()) {
            if (GenericTypeReflector.erase(theType).equals(Enum.class)) {
                if (this.isEnum()) continue;
                isAssignable = false;
                break;
            }
            Type boundType = GenericUtils.replaceTypeVariables(theType, ownerVariableMap);
            boundType = GenericUtils.replaceTypeVariable(boundType, typeVariable, this.getType());
            if (concreteClass.isAssignableTo(boundType = GenericUtils.replaceTypeVariablesWithWildcards(boundType)) || boundType instanceof WildcardType) continue;
            if (GenericTypeReflector.erase(boundType).isAssignableFrom(this.getRawClass())) {
                Type instanceType = GenericTypeReflector.getExactSuperType(boundType, this.getRawClass());
                if (instanceType == null) {
                    isAssignable = false;
                    break;
                }
                boundType = GenericUtils.replaceTypeVariable(theType, typeVariable, instanceType);
                if (GenericClass.isAssignable(boundType, instanceType)) continue;
            }
            isAssignable = false;
            break;
        }
        return isAssignable;
    }

    public boolean satisfiesBoundaries(WildcardType wildcardType) {
        return this.satisfiesBoundaries(wildcardType, this.getTypeVariableMap());
    }

    public boolean satisfiesBoundaries(WildcardType wildcardType, Map<TypeVariable<?>, Type> typeMap) {
        Type[] lowerBounds;
        boolean isAssignable = true;
        Map<TypeVariable<?>, Type> ownerVariableMap = this.getTypeVariableMap();
        ownerVariableMap.putAll(typeMap);
        for (Type theType : wildcardType.getUpperBounds()) {
            logger.debug("Checking upper bound " + theType);
            if (GenericTypeReflector.erase(theType).equals(Enum.class)) {
                if (this.isEnum()) continue;
                isAssignable = false;
                break;
            }
            Type type = GenericUtils.replaceTypeVariables(theType, ownerVariableMap);
            if (this.isAssignableTo(type)) continue;
            if (GenericTypeReflector.erase(type).isAssignableFrom(this.getRawClass())) {
                Type instanceType = GenericTypeReflector.getExactSuperType(type, this.getRawClass());
                if (instanceType == null) {
                    isAssignable = false;
                    break;
                }
                if (GenericClass.isAssignable(type, instanceType)) {
                    logger.debug("Found assignable generic exact type: " + instanceType);
                    continue;
                }
            }
            isAssignable = false;
            break;
        }
        if ((lowerBounds = wildcardType.getLowerBounds()) != null && lowerBounds.length > 0) {
            for (Type theType : wildcardType.getLowerBounds()) {
                logger.debug("Checking lower bound " + theType);
                Type type = GenericUtils.replaceTypeVariables(theType, ownerVariableMap);
                logger.debug("Bound after variable replacement: " + type);
                logger.debug("Is assignable from " + this.toString() + "?");
                if (!this.isAssignableFrom(type)) {
                    logger.debug("Not assignable from " + this.toString());
                    if (type instanceof WildcardType) continue;
                    if (GenericTypeReflector.erase(type).isAssignableFrom(this.getRawClass())) {
                        Type instanceType = GenericTypeReflector.getExactSuperType(type, this.getRawClass());
                        if (instanceType == null) {
                            isAssignable = false;
                            break;
                        }
                        if (GenericClass.isAssignable(type, instanceType)) {
                            logger.debug("Found assignable generic exact type: " + instanceType);
                            continue;
                        }
                    }
                    isAssignable = false;
                    break;
                }
                logger.debug("Is assignable from " + this.toString());
            }
        }
        return isAssignable;
    }

    public String toString() {
        if (this.type == null) {
            LoggingUtils.getEvoLogger().info("Type is null for raw class " + this.rawClass);
            for (StackTraceElement elem : Thread.currentThread().getStackTrace()) {
                LoggingUtils.getEvoLogger().info(elem.toString());
            }
            assert (false);
        }
        return this.type.toString();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        String name;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        URL cpURL = new File(Properties.CP).toURI().toURL();
        if (!(contextClassLoader instanceof URLClassLoader) || !Arrays.asList(((URLClassLoader)contextClassLoader).getURLs()).contains(cpURL)) {
            URL[] urls = new URL[]{cpURL};
            URLClassLoader urlClassLoader = new URLClassLoader(urls, contextClassLoader);
            Thread.currentThread().setContextClassLoader(urlClassLoader);
        }
        if ((name = (String)ois.readObject()) == null) {
            this.rawClass = null;
            this.type = null;
            return;
        }
        this.rawClass = GenericClass.getClass(name);
        Boolean isParameterized = (Boolean)ois.readObject();
        if (isParameterized.booleanValue()) {
            GenericClass ownerType = (GenericClass)ois.readObject();
            List parameterClasses = (List)ois.readObject();
            Type[] parameterTypes = new Type[parameterClasses.size()];
            for (int i = 0; i < parameterClasses.size(); ++i) {
                parameterTypes[i] = ((GenericClass)parameterClasses.get(i)).getType();
            }
            this.type = new ParameterizedTypeImpl(this.rawClass, parameterTypes, ownerType.getType());
        } else {
            this.type = GenericClass.addTypeParameters(this.rawClass);
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.rawClass == null) {
            oos.writeObject(null);
        } else {
            oos.writeObject(this.rawClass.getName());
            if (this.type instanceof ParameterizedType) {
                oos.writeObject(Boolean.TRUE);
                ParameterizedType pt = (ParameterizedType)this.type;
                oos.writeObject(new GenericClass(pt.getOwnerType()));
                ArrayList<GenericClass> parameterClasses = new ArrayList<GenericClass>();
                for (Type parameterType : pt.getActualTypeArguments()) {
                    parameterClasses.add(new GenericClass(parameterType));
                }
                oos.writeObject(parameterClasses);
            } else {
                oos.writeObject(Boolean.FALSE);
            }
        }
    }
}

