/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils.generic;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.LinkedHashMap;
import java.util.Map;
import org.evosuite.runtime.util.Inputs;
import org.evosuite.utils.ParameterizedTypeImpl;
import org.evosuite.utils.generic.GenericArrayTypeImpl;
import org.evosuite.utils.generic.GenericClass;
import org.evosuite.utils.generic.WildcardTypeImpl;

public class VarMap {
    private final Map<TypeVariable<?>, Type> map = new LinkedHashMap();

    public void add(TypeVariable<?> variable, Type value) {
        this.map.put(variable, value);
    }

    public void addAll(TypeVariable<?>[] variables, Type[] values) throws IllegalArgumentException {
        Inputs.checkNull(variables, values);
        if (variables.length != values.length) {
            throw new IllegalArgumentException("Array length mismatch");
        }
        for (int i = 0; i < variables.length; ++i) {
            this.add(variables[i], values[i]);
        }
    }

    public void addAll(Map<TypeVariable<?>, GenericClass> variables) throws IllegalArgumentException {
        Inputs.checkNull(variables);
        for (Map.Entry<TypeVariable<?>, GenericClass> entry : variables.entrySet()) {
            this.add(entry.getKey(), entry.getValue().getType());
        }
    }

    public Type map(Type type) throws IllegalArgumentException {
        Inputs.checkNull(type);
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof TypeVariable) {
            if (this.map.containsKey(type)) {
                return this.map.get(type);
            }
            return new WildcardTypeImpl(new Type[]{Object.class}, new Type[0]);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return new ParameterizedTypeImpl((Class)pType.getRawType(), this.map(pType.getActualTypeArguments()), pType.getOwnerType() == null ? pType.getOwnerType() : this.map(pType.getOwnerType()));
        }
        if (type instanceof WildcardType) {
            WildcardType wType = (WildcardType)type;
            return new WildcardTypeImpl(this.map(wType.getUpperBounds()), this.map(wType.getLowerBounds()));
        }
        if (type instanceof GenericArrayType) {
            return GenericArrayTypeImpl.createArrayType(this.map(((GenericArrayType)type).getGenericComponentType()));
        }
        throw new IllegalArgumentException("not implemented: mapping " + type.getClass() + " (" + type + ")");
    }

    public Type[] map(Type[] types) throws IllegalArgumentException {
        Inputs.checkNull(types);
        Type[] result = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = this.map(types[i]);
        }
        return result;
    }
}

