/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.xsd;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.evosuite.xsd.Coverage;
import org.evosuite.xsd.Generation;

public abstract class GenerationUtil {
    public static int getNumberStatements(Generation generation) {
        if (generation == null || generation.isFailed() || generation.getSuite() == null) {
            return 0;
        }
        return generation.getSuite().getTotalNumberOfStatements().intValue();
    }

    public static int getTotalEffort(Generation generation) {
        if (generation == null || generation.isFailed() || generation.getSuite() == null) {
            return 0;
        }
        return (int)Math.ceil(generation.getSuite().getTotalEffortInSeconds().doubleValue() / 60.0);
    }

    public static int getTimeBudget(Generation generation) {
        if (generation == null) {
            return 0;
        }
        return (int)Math.ceil(generation.getTimeBudgetInSeconds().doubleValue() / 60.0);
    }

    public static int getNumberTests(Generation generation) {
        if (generation == null || generation.isFailed() || generation.getSuite() == null) {
            return 0;
        }
        return generation.getSuite().getNumberOfTests().intValue();
    }

    public static Set<String> getCriteria(Generation generation) {
        if (generation == null || generation.isFailed() || generation.getSuite() == null) {
            return new HashSet<String>();
        }
        return generation.getSuite().getCoverage().parallelStream().map(c -> c.getCriterion()).collect(Collectors.toSet());
    }

    public static double getCriterionCoverage(Generation generation, String criterionName) {
        if (generation == null || generation.isFailed() || generation.getSuite() == null) {
            return 0.0;
        }
        for (Coverage coverage : generation.getSuite().getCoverage()) {
            if (!coverage.getCriterion().equals(criterionName)) continue;
            return coverage.getCoverageValue();
        }
        return 0.0;
    }

    public static double getOverallCoverage(Generation generation) {
        if (generation == null || generation.isFailed() || generation.getSuite() == null) {
            return 0.0;
        }
        return generation.getSuite().getCoverage().parallelStream().mapToDouble(c -> c.getCoverageValue()).average().getAsDouble();
    }
}

