/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite;

import java.io.File;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.evosuite.ClientProcess;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.TestSuiteGeneratorHelper;
import org.evosuite.TimeController;
import org.evosuite.classpath.ClassPathHacker;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.contracts.ContractChecker;
import org.evosuite.contracts.FailingTestSet;
import org.evosuite.coverage.CoverageCriteriaAnalyzer;
import org.evosuite.coverage.FitnessFunctions;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.coverage.dataflow.DefUseCoverageSuiteFitness;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.stoppingconditions.StoppingCondition;
import org.evosuite.junit.JUnitAnalyzer;
import org.evosuite.junit.writer.TestSuiteWriter;
import org.evosuite.result.TestGenerationResult;
import org.evosuite.result.TestGenerationResultBuilder;
import org.evosuite.rmi.ClientServices;
import org.evosuite.rmi.service.ClientState;
import org.evosuite.runtime.LoopCounter;
import org.evosuite.runtime.sandbox.PermissionStatistics;
import org.evosuite.seeding.ObjectPool;
import org.evosuite.seeding.ObjectPoolManager;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.setup.ExceptionMapGenerator;
import org.evosuite.setup.TestCluster;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.statistics.StatisticsSender;
import org.evosuite.strategy.TestGenerationStrategy;
import org.evosuite.symbolic.DSEStats;
import org.evosuite.testcase.ConstantInliner;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.EvosuiteError;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.ExecutionTrace;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.testcase.execution.reset.ClassReInitializer;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.StringPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.BooleanPrimitiveStatement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.evosuite.testsuite.TestSuiteMinimizer;
import org.evosuite.testsuite.TestSuiteSerialization;
import org.evosuite.utils.ArrayUtil;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.generic.GenericMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuiteGenerator {
    private static final String FOR_NAME = "forName";
    private static final Logger logger = LoggerFactory.getLogger(TestSuiteGenerator.class);

    private void initializeTargetClass() throws Throwable {
        String cp = ClassPathHandler.getInstance().getTargetProjectClasspath();
        DependencyAnalysis.initInheritanceTree(Arrays.asList(cp.split(File.pathSeparator)));
        DependencyAnalysis.initCallGraph(Properties.TARGET_CLASS);
        DefaultTestCase test = TestSuiteGenerator.buildLoadTargetClassTestCase(Properties.TARGET_CLASS);
        ExecutionResult execResult = TestCaseExecutor.getInstance().execute(test, Integer.MAX_VALUE);
        if (TestSuiteGenerator.hasThrownInitializerError(execResult)) {
            TestSuiteGenerator.writeJUnitTestSuiteForFailedInitialization();
            ExceptionInInitializerError ex = TestSuiteGenerator.getInitializerError(execResult);
            throw ex;
        }
        if (!execResult.getAllThrownExceptions().isEmpty()) {
            Throwable t = execResult.getAllThrownExceptions().iterator().next();
            throw t;
        }
        DependencyAnalysis.analyzeClass(Properties.TARGET_CLASS, Arrays.asList(cp.split(File.pathSeparator)));
        LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Finished analyzing classpath");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestGenerationResult generateTestSuite() {
        LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Analyzing classpath: ");
        ClientServices.getInstance().getClientNode().changeState(ClientState.INITIALIZATION);
        LoopCounter.getInstance().setActive(false);
        ExceptionMapGenerator.initializeExceptionMap(Properties.TARGET_CLASS);
        TestCaseExecutor.initExecutor();
        try {
            this.initializeTargetClass();
        }
        catch (Throwable e) {
            boolean error = true;
            String message = e.getMessage();
            if (message != null && (message.contains("Method code too large") || message.contains("Class file too large"))) {
                LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Instrumentation exceeds Java's 64K limit per method in target class");
                Properties.Criterion[] newCriteria = (Properties.Criterion[])Arrays.stream(Properties.CRITERION).filter(t -> !t.equals((Object)Properties.Criterion.STRONGMUTATION) && !t.equals((Object)Properties.Criterion.WEAKMUTATION) && !t.equals((Object)Properties.Criterion.MUTATION)).toArray(Properties.Criterion[]::new);
                if (newCriteria.length < Properties.CRITERION.length) {
                    TestGenerationContext.getInstance().resetContext();
                    LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Attempting re-instrumentation without mutation");
                    Properties.CRITERION = newCriteria;
                    if (Properties.NEW_STATISTICS) {
                        LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Deactivating EvoSuite statistics because of instrumentation problem");
                        Properties.NEW_STATISTICS = false;
                    }
                    try {
                        this.initializeTargetClass();
                        error = false;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (Properties.ASSERTIONS && Properties.ASSERTION_STRATEGY == Properties.AssertionStrategy.MUTATION) {
                        LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Deactivating assertion minimization because mutation instrumentation does not work");
                        Properties.ASSERTION_STRATEGY = Properties.AssertionStrategy.ALL;
                    }
                }
            }
            if (error) {
                LoggingUtils.getEvoLogger().error("* " + ClientProcess.getPrettyPrintIdentifier() + "Error while initializing target class: " + (e.getMessage() != null ? e.getMessage() : e.toString()));
                logger.error("Problem for " + Properties.TARGET_CLASS + ". Full stack:", e);
                TestGenerationResult testGenerationResult = TestGenerationResultBuilder.buildErrorResult(e.getMessage() != null ? e.getMessage() : e.toString());
                return testGenerationResult;
            }
        }
        finally {
            if (Properties.RESET_STATIC_FIELDS) {
                this.configureClassReInitializer();
            }
            LoopCounter.getInstance().setActive(true);
        }
        ObjectPoolManager.getInstance();
        LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Generating tests for class " + Properties.TARGET_CLASS);
        TestSuiteGeneratorHelper.printTestCriterion();
        if (!Properties.hasTargetClassBeenLoaded()) {
            return TestGenerationResultBuilder.buildErrorResult("Could not load target class");
        }
        TestSuiteChromosome testCases = this.generateTests();
        Properties.TEST_ARCHIVE = false;
        TestGenerationResult result = null;
        if ("Client-0".equals(ClientProcess.getIdentifier())) {
            this.postProcessTests(testCases);
            ClientServices.getInstance().getClientNode().publishPermissionStatistics();
            PermissionStatistics.getInstance().printStatistics(LoggingUtils.getEvoLogger());
            LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Writing tests to file");
            result = TestSuiteGenerator.writeJUnitTestsAndCreateResult(testCases);
            this.writeJUnitFailingTests();
        }
        TestCaseExecutor.pullDown();
        ClientServices.getInstance().getClientNode().changeState(ClientState.WRITING_STATISTICS);
        LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Done!");
        LoggingUtils.getEvoLogger().info("");
        return result != null ? result : TestGenerationResultBuilder.buildSuccessResult();
    }

    private static boolean hasThrownInitializerError(ExecutionResult execResult) {
        for (Throwable t : execResult.getAllThrownExceptions()) {
            if (!(t instanceof ExceptionInInitializerError)) continue;
            return true;
        }
        return false;
    }

    private static ExceptionInInitializerError getInitializerError(ExecutionResult execResult) {
        for (Throwable t : execResult.getAllThrownExceptions()) {
            if (!(t instanceof ExceptionInInitializerError)) continue;
            ExceptionInInitializerError exceptionInInitializerError = (ExceptionInInitializerError)t;
            return exceptionInInitializerError;
        }
        return null;
    }

    private void configureClassReInitializer() {
        ExecutionTrace execTrace = ExecutionTracer.getExecutionTracer().getTrace();
        List<String> initializedClasses = execTrace.getInitializedClasses();
        ClassReInitializer.getInstance().addInitializedClasses(initializedClasses);
        boolean reset_all_classes = Properties.RESET_ALL_CLASSES_DURING_TEST_GENERATION;
        ClassReInitializer.getInstance().setReInitializeAllClasses(reset_all_classes);
    }

    private static void writeJUnitTestSuiteForFailedInitialization() throws EvosuiteError {
        TestSuiteChromosome suite = new TestSuiteChromosome();
        DefaultTestCase test = TestSuiteGenerator.buildLoadTargetClassTestCase(Properties.TARGET_CLASS);
        suite.addTest(test);
        TestSuiteGenerator.writeJUnitTestsAndCreateResult(suite);
    }

    private static DefaultTestCase buildLoadTargetClassTestCase(String className) throws EvosuiteError {
        DefaultTestCase test = new DefaultTestCase();
        StringPrimitiveStatement stmt0 = new StringPrimitiveStatement((TestCase)test, className);
        VariableReference string0 = test.addStatement(stmt0);
        try {
            Method currentThreadMethod = Thread.class.getMethod("currentThread", new Class[0]);
            MethodStatement currentThreadStmt = new MethodStatement(test, new GenericMethod(currentThreadMethod, currentThreadMethod.getDeclaringClass()), null, Collections.emptyList());
            VariableReference currentThreadVar = test.addStatement(currentThreadStmt);
            Method getContextClassLoaderMethod = Thread.class.getMethod("getContextClassLoader", new Class[0]);
            MethodStatement getContextClassLoaderStmt = new MethodStatement(test, new GenericMethod(getContextClassLoaderMethod, getContextClassLoaderMethod.getDeclaringClass()), currentThreadVar, Collections.emptyList());
            VariableReference contextClassLoaderVar = test.addStatement(getContextClassLoaderStmt);
            BooleanPrimitiveStatement stmt1 = new BooleanPrimitiveStatement((TestCase)test, true);
            VariableReference boolean0 = test.addStatement(stmt1);
            Method forNameMethod = Class.class.getMethod(FOR_NAME, String.class, Boolean.TYPE, ClassLoader.class);
            MethodStatement forNameStmt = new MethodStatement(test, new GenericMethod(forNameMethod, forNameMethod.getDeclaringClass()), null, Arrays.asList(string0, boolean0, contextClassLoaderVar));
            test.addStatement(forNameStmt);
            return test;
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new EvosuiteError("Unexpected exception while creating Class Initializer Test Case");
        }
    }

    protected void postProcessTests(TestSuiteChromosome testSuite) {
        testSuite.getTestChromosomes().removeIf(t -> t.getLastExecutionResult() != null && (t.getLastExecutionResult().hasTimeout() || t.getLastExecutionResult().hasTestException()));
        if (Properties.CTG_SEEDS_FILE_OUT != null) {
            TestSuiteSerialization.saveTests(testSuite, new File(Properties.CTG_SEEDS_FILE_OUT));
        } else if (Properties.TEST_FACTORY == Properties.TestFactory.SERIALIZATION) {
            TestSuiteSerialization.saveTests(testSuite, new File(Properties.SEED_DIR + File.separator + Properties.TARGET_CLASS));
        }
        ArrayList<? extends TestFitnessFunction> goals = new ArrayList<TestFitnessFunction>();
        for (TestFitnessFactory<? extends TestFitnessFunction> ff : TestSuiteGenerator.getFitnessFactories()) {
            goals.addAll(ff.getCoverageGoals());
        }
        for (TestFitnessFunction f : testSuite.getCoveredGoals()) {
            if (goals.contains(f)) continue;
            testSuite.removeCoveredGoal(f);
        }
        if (Properties.INLINE) {
            ClientServices.getInstance().getClientNode().changeState(ClientState.INLINING);
            ConstantInliner inliner = new ConstantInliner();
            inliner.inline(testSuite);
        }
        if (Properties.MINIMIZE) {
            ClientServices.getInstance().getClientNode().changeState(ClientState.MINIMIZATION);
            if (!TimeController.getInstance().hasTimeToExecuteATestCase()) {
                LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Skipping minimization because not enough time is left");
                ClientServices.track(RuntimeVariable.Result_Size, testSuite.size());
                ClientServices.track(RuntimeVariable.Minimized_Size, testSuite.size());
                ClientServices.track(RuntimeVariable.Result_Length, testSuite.totalLengthOfTestCases());
                ClientServices.track(RuntimeVariable.Minimized_Length, testSuite.totalLengthOfTestCases());
            } else {
                double before = testSuite.getFitness();
                TestSuiteMinimizer minimizer = new TestSuiteMinimizer(TestSuiteGenerator.getFitnessFactories());
                LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Minimizing test suite");
                minimizer.minimize(testSuite, true);
                double after = testSuite.getFitness();
                if (after > before + 0.01) {
                    throw new Error("EvoSuite bug: minimization lead fitness from " + before + " to " + after);
                }
            }
        } else {
            if (!TimeController.getInstance().hasTimeToExecuteATestCase()) {
                LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Skipping minimization because not enough time is left");
            }
            ClientServices.track(RuntimeVariable.Result_Size, testSuite.size());
            ClientServices.track(RuntimeVariable.Minimized_Size, testSuite.size());
            ClientServices.track(RuntimeVariable.Result_Length, testSuite.totalLengthOfTestCases());
            ClientServices.track(RuntimeVariable.Minimized_Length, testSuite.totalLengthOfTestCases());
        }
        if (Properties.COVERAGE) {
            ClientServices.getInstance().getClientNode().changeState(ClientState.COVERAGE_ANALYSIS);
            CoverageCriteriaAnalyzer.analyzeCoverage(testSuite);
        }
        double coverage = testSuite.getCoverage();
        if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.MUTATION) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.STRONGMUTATION)) {
            // empty if block
        }
        StatisticsSender.executedAndThenSendIndividualToMaster(testSuite);
        LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Generated " + testSuite.size() + " tests with total length " + testSuite.totalLengthOfTestCases());
        if (!Properties.ANALYSIS_CRITERIA.isEmpty()) {
            CoverageCriteriaAnalyzer.analyzeCriteria(testSuite, Properties.ANALYSIS_CRITERIA);
        }
        if (Properties.CRITERION.length > 1) {
            LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Resulting test suite's coverage: " + NumberFormat.getPercentInstance().format(coverage) + " (average coverage for all fitness functions)");
        } else {
            LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Resulting test suite's coverage: " + NumberFormat.getPercentInstance().format(coverage));
        }
        if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.DEFUSE) && Properties.ANALYSIS_CRITERIA.isEmpty()) {
            DefUseCoverageSuiteFitness.printCoverage();
        }
        DSEStats.getInstance().trackConstraintTypes();
        DSEStats.getInstance().trackSolverStatistics();
        if (Properties.DSE_PROBABILITY > 0.0 && Properties.LOCAL_SEARCH_RATE > 0 && Properties.LOCAL_SEARCH_PROBABILITY > 0.0) {
            DSEStats.getInstance().logStatistics();
        }
        if (Properties.FILTER_SANDBOX_TESTS) {
            for (TestChromosome test : testSuite.getTestChromosomes()) {
                int position;
                ExecutionResult result = test.getLastExecutionResult();
                if (result == null) {
                    result = TestCaseExecutor.runTest(test.getTestCase());
                }
                if (!result.hasSecurityException() || (position = result.getFirstPositionOfThrownException().intValue()) <= 0) continue;
                test.getTestCase().chop(position);
                result = TestCaseExecutor.runTest(test.getTestCase());
                test.setLastExecutionResult(result);
            }
        }
        if (Properties.ASSERTIONS) {
            LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Generating assertions");
            ClientServices.getInstance().getClientNode().changeState(ClientState.ASSERTION_GENERATION);
            if (!TimeController.getInstance().hasTimeToExecuteATestCase()) {
                LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Skipping assertion generation because not enough time is left");
            } else {
                TestSuiteGeneratorHelper.addAssertions(testSuite);
            }
            StatisticsSender.sendIndividualToMaster(testSuite);
        }
        if (Properties.NO_RUNTIME_DEPENDENCY) {
            LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Property NO_RUNTIME_DEPENDENCY is set to true - skipping JUnit compile check");
            LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "WARNING: Not including the runtime dependencies is likely to lead to flaky tests!");
        } else if (Properties.JUNIT_TESTS && (Properties.JUNIT_CHECK == Properties.JUnitCheckValues.TRUE || Properties.JUNIT_CHECK == Properties.JUnitCheckValues.OPTIONAL)) {
            if (ClassPathHacker.isJunitCheckAvailable()) {
                this.compileAndCheckTests(testSuite);
            } else {
                logger.warn("Cannot run Junit test. Cause {}", (Object)ClassPathHacker.getCause());
            }
        }
    }

    private void compileAndCheckTests(TestSuiteChromosome chromosome) {
        boolean unstable;
        LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Compiling and checking tests");
        if (!JUnitAnalyzer.isJavaCompilerAvailable()) {
            String msg = "No Java compiler is available. Make sure to run EvoSuite with the JDK and not the JRE.You can try to setup the JAVA_HOME system variable to point to it, as well as to make sure that the PATH variable points to the JDK before any JRE.";
            logger.error(msg);
            throw new RuntimeException(msg);
        }
        ClientServices.getInstance().getClientNode().changeState(ClientState.JUNIT_CHECK);
        boolean junitSeparateClassLoader = Properties.USE_SEPARATE_CLASSLOADER;
        Properties.USE_SEPARATE_CLASSLOADER = false;
        int numUnstable = 0;
        if (!TimeController.getInstance().isThereStillTimeInThisPhase()) {
            Properties.USE_SEPARATE_CLASSLOADER = junitSeparateClassLoader;
            return;
        }
        List<TestCase> testCases = chromosome.getTests();
        JUnitAnalyzer.removeTestsThatDoNotCompile(testCases);
        long start = System.currentTimeMillis();
        Iterator<TestCase> iter = testCases.iterator();
        while (iter.hasNext() && TimeController.getInstance().hasTimeToExecuteATestCase()) {
            TestCase tc = iter.next();
            ArrayList<TestCase> list = new ArrayList<TestCase>();
            list.add(tc);
            numUnstable += JUnitAnalyzer.handleTestsThatAreUnstable(list);
            if (!list.isEmpty()) continue;
            iter.remove();
        }
        long delta = System.currentTimeMillis() - start;
        numUnstable += TestSuiteGenerator.checkAllTestsIfTime(testCases, delta);
        if (testCases.size() > 1) {
            Collections.reverse(testCases);
            numUnstable += TestSuiteGenerator.checkAllTestsIfTime(testCases, delta);
        }
        chromosome.clearTests();
        for (TestCase testCase : testCases) {
            chromosome.addTest(testCase);
        }
        boolean bl = unstable = numUnstable > 0;
        if (!TimeController.getInstance().isThereStillTimeInThisPhase()) {
            logger.warn("JUnit checking timed out");
        }
        ClientServices.track(RuntimeVariable.HadUnstableTests, unstable);
        ClientServices.track(RuntimeVariable.NumUnstableTests, numUnstable);
        Properties.USE_SEPARATE_CLASSLOADER = junitSeparateClassLoader;
    }

    private static int checkAllTestsIfTime(List<TestCase> testCases, long delta) {
        if (TimeController.getInstance().hasTimeToExecuteATestCase() && TimeController.getInstance().isThereStillTimeInThisPhase(delta)) {
            return JUnitAnalyzer.handleTestsThatAreUnstable(testCases);
        }
        return 0;
    }

    private TestSuiteChromosome generateTests() {
        TestCluster.getInstance();
        ContractChecker checker = null;
        if (Properties.CHECK_CONTRACTS) {
            checker = new ContractChecker();
            TestCaseExecutor.getInstance().addObserver(checker);
        }
        TestGenerationStrategy strategy = TestSuiteGeneratorHelper.getTestGenerationStrategy();
        TestSuiteChromosome testSuite = strategy.generateTests();
        if (Properties.CHECK_CONTRACTS) {
            TestCaseExecutor.getInstance().removeObserver(checker);
        }
        StatisticsSender.executedAndThenSendIndividualToMaster(testSuite);
        TestSuiteGeneratorHelper.getBytecodeStatistics();
        ClientServices.getInstance().getClientNode().publishPermissionStatistics();
        this.writeObjectPool(testSuite);
        return testSuite;
    }

    public static TestGenerationResult writeJUnitTestsAndCreateResult(TestSuiteChromosome testSuite, String suffix) {
        List<TestCase> tests = testSuite.getTests();
        if (Properties.JUNIT_TESTS) {
            ClientServices.getInstance().getClientNode().changeState(ClientState.WRITING_TESTS);
            TestSuiteWriter suiteWriter = new TestSuiteWriter();
            suiteWriter.insertTests(tests);
            String name = Properties.TARGET_CLASS.substring(Properties.TARGET_CLASS.lastIndexOf(".") + 1);
            String testDir = Properties.TEST_DIR;
            LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Writing JUnit test case '" + name + suffix + "' to " + testDir);
            suiteWriter.writeTestSuite(name + suffix, testDir, testSuite.getLastExecutionResults());
        }
        return TestGenerationResultBuilder.buildSuccessResult();
    }

    public static TestGenerationResult writeJUnitTestsAndCreateResult(TestSuiteChromosome testSuite) {
        return TestSuiteGenerator.writeJUnitTestsAndCreateResult(testSuite, Properties.JUNIT_SUFFIX);
    }

    public void writeJUnitFailingTests() {
        if (!Properties.CHECK_CONTRACTS) {
            return;
        }
        FailingTestSet.sendStatistics();
        if (Properties.JUNIT_TESTS) {
            TestSuiteWriter suiteWriter = new TestSuiteWriter();
            TestSuiteChromosome suite = new TestSuiteChromosome();
            for (TestCase test : FailingTestSet.getFailingTests()) {
                test.setFailing();
                suite.addTest(test);
            }
            String name = Properties.TARGET_CLASS.substring(Properties.TARGET_CLASS.lastIndexOf(".") + 1);
            String testDir = Properties.TEST_DIR;
            LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Writing failing test cases '" + name + Properties.JUNIT_SUFFIX + "' to " + testDir);
            suiteWriter.insertAllTests(suite.getTests());
            FailingTestSet.writeJUnitTestSuite(suiteWriter);
            suiteWriter.writeTestSuite(name + Properties.JUNIT_FAILED_SUFFIX, testDir, suite.getLastExecutionResults());
        }
    }

    private void writeObjectPool(TestSuiteChromosome suite) {
        if (!Properties.WRITE_POOL.isEmpty()) {
            LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Writing sequences to pool");
            ObjectPool pool = ObjectPool.getPoolFromTestSuite(suite);
            pool.writePool(Properties.WRITE_POOL);
        }
    }

    public static List<TestSuiteFitnessFunction> getFitnessFunctions() {
        ArrayList<TestSuiteFitnessFunction> ffs = new ArrayList<TestSuiteFitnessFunction>();
        for (int i = 0; i < Properties.CRITERION.length; ++i) {
            ffs.add(FitnessFunctions.getFitnessFunction(Properties.CRITERION[i]));
        }
        return ffs;
    }

    public void printBudget(GeneticAlgorithm<?> algorithm) {
        LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Search Budget:");
        for (StoppingCondition<?> sc : algorithm.getStoppingConditions()) {
            LoggingUtils.getEvoLogger().info("\t- " + sc.toString());
        }
    }

    public String getBudgetString(GeneticAlgorithm<?> algorithm) {
        String r = "";
        for (StoppingCondition<?> sc : algorithm.getStoppingConditions()) {
            r = r + sc.toString() + " ";
        }
        return r;
    }

    public static List<TestFitnessFactory<? extends TestFitnessFunction>> getFitnessFactories() {
        ArrayList<TestFitnessFactory<? extends TestFitnessFunction>> goalsFactory = new ArrayList<TestFitnessFactory<? extends TestFitnessFunction>>();
        for (int i = 0; i < Properties.CRITERION.length; ++i) {
            goalsFactory.add(FitnessFunctions.getFitnessFactory(Properties.CRITERION[i]));
        }
        return goalsFactory;
    }

    public static void main(String[] args) {
        TestSuiteGenerator generator = new TestSuiteGenerator();
        generator.generateTestSuite();
        System.exit(0);
    }
}

