/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite;

import java.util.Map;
import java.util.Set;
import org.evosuite.ClientProcess;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.assertion.AssertionGenerator;
import org.evosuite.assertion.CompleteAssertionGenerator;
import org.evosuite.assertion.SimpleMutationAssertionGenerator;
import org.evosuite.assertion.UnitAssertionGenerator;
import org.evosuite.contracts.ContractChecker;
import org.evosuite.coverage.branch.Branch;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.rmi.ClientServices;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.strategy.EntBugTestStrategy;
import org.evosuite.strategy.FixedNumRandomTestStrategy;
import org.evosuite.strategy.IndividualTestStrategy;
import org.evosuite.strategy.MAPElitesStrategy;
import org.evosuite.strategy.MOSuiteStrategy;
import org.evosuite.strategy.NoveltyStrategy;
import org.evosuite.strategy.RandomTestStrategy;
import org.evosuite.strategy.TestGenerationStrategy;
import org.evosuite.strategy.WholeTestSuiteStrategy;
import org.evosuite.symbolic.DSEStrategy;
import org.evosuite.testcase.execution.ExecutionTraceImpl;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.LoggingUtils;

public class TestSuiteGeneratorHelper {
    static void printTestCriterion(Properties.Criterion criterion) {
        switch (criterion) {
            case WEAKMUTATION: {
                LoggingUtils.getEvoLogger().info("  - Mutation testing (weak)");
                break;
            }
            case ONLYMUTATION: {
                LoggingUtils.getEvoLogger().info("  - Only Mutation testing (weak)");
                break;
            }
            case STRONGMUTATION: 
            case MUTATION: {
                LoggingUtils.getEvoLogger().info("  - Mutation testing (strong)");
                break;
            }
            case DEFUSE: {
                LoggingUtils.getEvoLogger().info("  - All DU Pairs");
                break;
            }
            case STATEMENT: {
                LoggingUtils.getEvoLogger().info("  - Statement Coverage");
                break;
            }
            case RHO: {
                LoggingUtils.getEvoLogger().info("  - Rho Coverage");
                break;
            }
            case AMBIGUITY: {
                LoggingUtils.getEvoLogger().info("  - Ambiguity Coverage");
                break;
            }
            case ALLDEFS: {
                LoggingUtils.getEvoLogger().info("  - All Definitions");
                break;
            }
            case EXCEPTION: {
                LoggingUtils.getEvoLogger().info("  - Exception");
                break;
            }
            case ONLYBRANCH: {
                LoggingUtils.getEvoLogger().info("  - Only-Branch Coverage");
                break;
            }
            case METHODTRACE: {
                LoggingUtils.getEvoLogger().info("  - Method Coverage");
                break;
            }
            case METHOD: {
                LoggingUtils.getEvoLogger().info("  - Top-Level Method Coverage");
                break;
            }
            case METHODNOEXCEPTION: {
                LoggingUtils.getEvoLogger().info("  - No-Exception Top-Level Method Coverage");
                break;
            }
            case LINE: {
                LoggingUtils.getEvoLogger().info("  - Line Coverage");
                break;
            }
            case ONLYLINE: {
                LoggingUtils.getEvoLogger().info("  - Only-Line Coverage");
                break;
            }
            case OUTPUT: {
                LoggingUtils.getEvoLogger().info("  - Method-Output Coverage");
                break;
            }
            case INPUT: {
                LoggingUtils.getEvoLogger().info("  - Method-Input Coverage");
                break;
            }
            case BRANCH: {
                LoggingUtils.getEvoLogger().info("  - Branch Coverage");
                break;
            }
            case CBRANCH: {
                LoggingUtils.getEvoLogger().info("  - Context Branch Coverage");
                break;
            }
            case IBRANCH: {
                LoggingUtils.getEvoLogger().info("  - Interprocedural Context Branch Coverage");
                break;
            }
            case TRYCATCH: {
                LoggingUtils.getEvoLogger().info("  - Try-Catch Branch Coverage");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized criterion: " + (Object)((Object)criterion));
            }
        }
    }

    private static int getBytecodeCount(RuntimeVariable v, Map<RuntimeVariable, Set<Integer>> m) {
        Set<Integer> branchSet = m.get((Object)v);
        return branchSet == null ? 0 : branchSet.size();
    }

    static void getBytecodeStatistics() {
        if (Properties.TRACK_BOOLEAN_BRANCHES) {
            int gradientBranchCount = ExecutionTraceImpl.gradientBranches.size() * 2;
            ClientServices.track(RuntimeVariable.Gradient_Branches, gradientBranchCount);
        }
        if (Properties.TRACK_COVERED_GRADIENT_BRANCHES) {
            int coveredGradientBranchCount = ExecutionTraceImpl.gradientBranchesCoveredTrue.size() + ExecutionTraceImpl.gradientBranchesCoveredFalse.size();
            ClientServices.track(RuntimeVariable.Gradient_Branches_Covered, coveredGradientBranchCount);
        }
        if (Properties.BRANCH_COMPARISON_TYPES) {
            RuntimeVariable[] runtimeVariableArray;
            RuntimeVariable[] bytecodeVarsCovered;
            int cmp_intzero = 0;
            int cmp_intint = 0;
            int cmp_refref = 0;
            int cmp_refnull = 0;
            int bc_lcmp = 0;
            int bc_fcmpl = 0;
            int bc_fcmpg = 0;
            int bc_dcmpl = 0;
            int bc_dcmpg = 0;
            for (Branch branch : BranchPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).getAllBranches()) {
                int branchOpCode = branch.getInstruction().getASMNode().getOpcode();
                int previousOpcode = -2;
                if (branch.getInstruction().getASMNode().getPrevious() != null) {
                    previousOpcode = branch.getInstruction().getASMNode().getPrevious().getOpcode();
                }
                switch (previousOpcode) {
                    case 148: {
                        ++bc_lcmp;
                        break;
                    }
                    case 149: {
                        ++bc_fcmpl;
                        break;
                    }
                    case 150: {
                        ++bc_fcmpg;
                        break;
                    }
                    case 151: {
                        ++bc_dcmpl;
                        break;
                    }
                    case 152: {
                        ++bc_dcmpg;
                    }
                }
                switch (branchOpCode) {
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: {
                        ++cmp_intzero;
                        break;
                    }
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: {
                        ++cmp_intint;
                        break;
                    }
                    case 165: 
                    case 166: {
                        ++cmp_refref;
                        break;
                    }
                    case 198: 
                    case 199: {
                        ++cmp_refnull;
                    }
                }
            }
            ClientServices.track(RuntimeVariable.Cmp_IntZero, cmp_intzero);
            ClientServices.track(RuntimeVariable.Cmp_IntInt, cmp_intint);
            ClientServices.track(RuntimeVariable.Cmp_RefRef, cmp_refref);
            ClientServices.track(RuntimeVariable.Cmp_RefNull, cmp_refnull);
            ClientServices.track(RuntimeVariable.BC_lcmp, bc_lcmp);
            ClientServices.track(RuntimeVariable.BC_fcmpl, bc_fcmpl);
            ClientServices.track(RuntimeVariable.BC_fcmpg, bc_fcmpg);
            ClientServices.track(RuntimeVariable.BC_dcmpl, bc_dcmpl);
            ClientServices.track(RuntimeVariable.BC_dcmpg, bc_dcmpg);
            for (RuntimeVariable bcvar : bytecodeVarsCovered = new RuntimeVariable[]{RuntimeVariable.Covered_lcmp, RuntimeVariable.Covered_fcmpl, RuntimeVariable.Covered_fcmpg, RuntimeVariable.Covered_dcmpl, RuntimeVariable.Covered_dcmpg, RuntimeVariable.Covered_IntInt, RuntimeVariable.Covered_IntInt, RuntimeVariable.Covered_IntZero, RuntimeVariable.Covered_RefRef, RuntimeVariable.Covered_RefNull}) {
                ClientServices.track(bcvar, TestSuiteGeneratorHelper.getBytecodeCount(bcvar, ExecutionTraceImpl.bytecodeInstructionCoveredFalse) + TestSuiteGeneratorHelper.getBytecodeCount(bcvar, ExecutionTraceImpl.bytecodeInstructionCoveredTrue));
            }
            for (RuntimeVariable bcvar : runtimeVariableArray = new RuntimeVariable[]{RuntimeVariable.Reached_lcmp, RuntimeVariable.Reached_fcmpl, RuntimeVariable.Reached_fcmpg, RuntimeVariable.Reached_dcmpl, RuntimeVariable.Reached_dcmpg, RuntimeVariable.Reached_IntInt, RuntimeVariable.Reached_IntInt, RuntimeVariable.Reached_IntZero, RuntimeVariable.Reached_RefRef, RuntimeVariable.Reached_RefNull}) {
                ClientServices.track(bcvar, TestSuiteGeneratorHelper.getBytecodeCount(bcvar, ExecutionTraceImpl.bytecodeInstructionReached) * 2);
            }
        }
    }

    static void printTestCriterion() {
        if (Properties.CRITERION.length > 1) {
            LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Test criteria:");
        } else {
            LoggingUtils.getEvoLogger().info("* " + ClientProcess.getPrettyPrintIdentifier() + "Test criterion:");
        }
        for (int i = 0; i < Properties.CRITERION.length; ++i) {
            TestSuiteGeneratorHelper.printTestCriterion(Properties.CRITERION[i]);
        }
    }

    static TestGenerationStrategy getTestGenerationStrategy() {
        switch (Properties.STRATEGY) {
            case EVOSUITE: {
                return new WholeTestSuiteStrategy();
            }
            case RANDOM: {
                return new RandomTestStrategy();
            }
            case RANDOM_FIXED: {
                return new FixedNumRandomTestStrategy();
            }
            case ONEBRANCH: {
                return new IndividualTestStrategy();
            }
            case ENTBUG: {
                return new EntBugTestStrategy();
            }
            case MOSUITE: {
                return new MOSuiteStrategy();
            }
            case DSE: {
                return new DSEStrategy();
            }
            case NOVELTY: {
                return new NoveltyStrategy();
            }
            case MAP_ELITES: {
                return new MAPElitesStrategy();
            }
        }
        throw new RuntimeException("Unsupported strategy: " + (Object)((Object)Properties.STRATEGY));
    }

    public static void addAssertions(TestSuiteChromosome tests) {
        ContractChecker.setActive(false);
        AssertionGenerator asserter = Properties.ASSERTION_STRATEGY == Properties.AssertionStrategy.MUTATION ? new SimpleMutationAssertionGenerator() : (Properties.ASSERTION_STRATEGY == Properties.AssertionStrategy.ALL ? new CompleteAssertionGenerator() : new UnitAssertionGenerator());
        asserter.addAssertions(tests);
        if (Properties.FILTER_ASSERTIONS) {
            asserter.filterFailingAssertions(tests);
        }
    }
}

