/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.assertion.CheapPurityAnalyzer;
import org.evosuite.assertion.Inspector;
import org.evosuite.runtime.mock.MockList;
import org.evosuite.setup.TestUsageChecker;
import org.evosuite.shaded.org.apache.commons.lang3.ClassUtils;
import org.evosuite.utils.JdkPureMethodsList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectorManager {
    private static InspectorManager instance = null;
    private static final Logger logger = LoggerFactory.getLogger(InspectorManager.class);
    private final Map<Class<?>, List<Inspector>> inspectors = new HashMap();
    private final Map<String, List<String>> blackList = new HashMap<String, List<String>>();

    private InspectorManager() {
        this.initializeBlackList();
    }

    private void initializeBlackList() {
        this.blackList.put("java.io.File", Arrays.asList("getPath", "getAbsolutePath", "getCanonicalPath"));
        this.blackList.put("java.io.DataOutputStream", Arrays.asList("size"));
        this.blackList.put("java.util.Date", Arrays.asList("getLocaleString"));
        this.blackList.put("java.lang.Thread", Arrays.asList("activeCount", "getId", "getName", "getPriority", "toString", "getState", "isAlive"));
        this.blackList.put("java.lang.ThreadGroup", Arrays.asList("activeCount", "activeGroupCount", "getMaxPriority", "isDaemon", "isDestroyed", "toString"));
        this.blackList.put("java.util.EventObject", Arrays.asList("toString"));
        this.blackList.put(Locale.class.getCanonicalName(), Arrays.asList("getDisplay"));
        this.blackList.put("java.util.Hashtable", Arrays.asList("toString"));
        this.blackList.put("java.util.HashSet", Arrays.asList("toString"));
        this.blackList.put("java.util.HashMap", Arrays.asList("toString"));
        this.blackList.put("java.util.AbstractMap", Arrays.asList("toString"));
        this.blackList.put("java.util.AbstractCollection", Arrays.asList("toString"));
        this.blackList.put("java.util.logging.Logger", Arrays.asList("getUseParentHandlers"));
        this.blackList.put("java.awt.Panel", Arrays.asList("toString"));
        this.blackList.put("java.awt.event.ActionEvent", Arrays.asList("toString"));
        this.blackList.put("java.awt.Component", Arrays.asList("toString", "isVisible", "isForegroundSet", "isBackgroundSet", "isFontSet", "isCursorSet", "isDisplayable", "isEnabled", "isFocusable", "isFocusOwner", "isFocusTraversable", "isLightweight", "isMaximumSizeSet", "isMinimumSizeSet", "isPreferredSizeSet", "isShowing", "isValid", "isVisible"));
        this.blackList.put("java.awt.Container", Arrays.asList("countComponents", "getComponentCount", "isForegroundSet", "isBackgroundSet", "isFontSet"));
        this.blackList.put("java.awt.event.MouseWheelEvent", Arrays.asList("toString"));
        this.blackList.put("javax.swing.DefaultListSelectionModel", Arrays.asList("toString"));
        this.blackList.put("javax.swing.JPopupMenu", Arrays.asList("isFontSet", "getComponentCount", "isForegroundSet", "isBackgroundSet", "isFontSet"));
        this.blackList.put("javax.swing.JInternalFrame", Arrays.asList("getComponentCount", "countComponents", "isForegroundSet", "isBackgroundSet", "isFontSet"));
        this.blackList.put("javax.swing.text.StyleContext", Arrays.asList("toString"));
        this.blackList.put("java.rmi.server.ObjID", Arrays.asList("toString"));
        this.blackList.put("java.awt.event.InvocationEvent", Arrays.asList("getWhen"));
        this.blackList.put("java.lang.StringBuffer", Arrays.asList("capacity"));
    }

    public static InspectorManager getInstance() {
        if (instance == null) {
            instance = new InspectorManager();
        }
        return instance;
    }

    public static void resetSingleton() {
        instance = null;
    }

    private boolean isInspectorMethod(Method method) {
        if (!Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (!(method.getReturnType().isPrimitive() || method.getReturnType().equals(String.class) || method.getReturnType().isEnum() || ClassUtils.isPrimitiveWrapper(method.getReturnType()))) {
            return false;
        }
        if (method.getReturnType().equals(Void.TYPE)) {
            return false;
        }
        if (method.getParameterTypes().length != 0) {
            return false;
        }
        if (method.getName().equals("hashCode")) {
            return false;
        }
        if (method.getDeclaringClass().equals(Object.class)) {
            return false;
        }
        if (method.getDeclaringClass().equals(Enum.class)) {
            return false;
        }
        if (method.isSynthetic()) {
            return false;
        }
        if (method.isBridge()) {
            return false;
        }
        if (method.getName().equals("pop")) {
            return false;
        }
        if (this.isBlackListed(method)) {
            return false;
        }
        if (this.isImpureJDKMethod(method)) {
            return false;
        }
        if (this.isAWTToString(method)) {
            return false;
        }
        return !Properties.PURE_INSPECTORS || CheapPurityAnalyzer.getInstance().isPure(method);
    }

    private boolean isImpureJDKMethod(Method method) {
        String className = method.getDeclaringClass().getCanonicalName();
        if (!className.startsWith("java.")) {
            return false;
        }
        return !JdkPureMethodsList.instance.isPureJDKMethod(method);
    }

    private boolean isAWTToString(Method method) {
        String className = method.getDeclaringClass().getCanonicalName();
        return (className.startsWith("javax.") || className.startsWith("java.awt.")) && method.getName().equals("toString");
    }

    private boolean isBlackListed(Method method) {
        String className = method.getDeclaringClass().getCanonicalName();
        if (MockList.isAMockClass(className)) {
            className = method.getDeclaringClass().getSuperclass().getCanonicalName();
        }
        if (!this.blackList.containsKey(className)) {
            return false;
        }
        String methodName = method.getName();
        return this.blackList.get(className).contains(methodName);
    }

    private void determineInspectors(Class<?> clazz) {
        if (!TestUsageChecker.canUse(clazz)) {
            this.inspectors.put(clazz, Collections.emptyList());
        }
        if (!TestUsageChecker.canUse(clazz)) {
            return;
        }
        ArrayList<Inspector> inspectorList = new ArrayList<Inspector>();
        for (Method method : clazz.getMethods()) {
            if (this.isInspectorMethod(method)) {
                logger.debug("Inspector for class " + clazz.getSimpleName() + ": " + method.getName() + " defined in " + method.getDeclaringClass().getCanonicalName());
                inspectorList.add(new Inspector(clazz, method));
                continue;
            }
            logger.debug("Not an inspector: " + method.getName());
        }
        this.inspectors.put(clazz, inspectorList);
    }

    public List<Inspector> getInspectors(Class<?> clazz) {
        if (!this.inspectors.containsKey(clazz)) {
            this.determineInspectors(clazz);
        }
        return this.inspectors.get(clazz);
    }

    public void removeInspector(Class<?> clazz, Inspector inspector) {
        if (this.inspectors.containsKey(clazz)) {
            this.inspectors.get(clazz).remove(inspector);
        }
    }
}

