/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.classpath;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import org.evosuite.Properties;
import org.evosuite.runtime.agent.ToolsJarLocator;
import org.evosuite.shaded.org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathHacker {
    private static final Logger logger = LoggerFactory.getLogger(ClassPathHacker.class);
    private static final Class<?>[] parameters = new Class[]{URL.class};
    private static boolean junitCheckAvailable = true;
    private static String cause = "";

    public static void initializeToolJar() throws RuntimeException {
        Integer javaVersion = Integer.valueOf(SystemUtils.JAVA_VERSION.split("\\.")[0]);
        if (javaVersion >= 9) {
            return;
        }
        ToolsJarLocator locator = new ToolsJarLocator(Properties.TOOLS_JAR_LOCATION);
        locator.getLoaderForToolsJar();
        if (locator.getLocationNotOnClasspath() != null) {
            try {
                logger.info("Using JDK libraries at: " + locator.getLocationNotOnClasspath());
                ClassPathHacker.addFile(locator.getLocationNotOnClasspath());
            }
            catch (IOException e) {
                cause = "Failed to add " + locator.getLocationNotOnClasspath() + " to system classpath";
                junitCheckAvailable = false;
                return;
            }
        }
    }

    public static String getCause() {
        return cause;
    }

    public static boolean isJunitCheckAvailable() {
        return junitCheckAvailable;
    }

    public static void addFile(String s) throws IOException {
        File f = new File(s);
        ClassPathHacker.addFile(f);
    }

    public static void addFile(File f) throws IOException {
        ClassPathHacker.addURL(f.toURI().toURL());
    }

    public static void addURL(URL u) throws IOException {
        logger.info("Trying to add URL to class path:" + u.toString());
        ClassLoader sysloader = ClassLoader.getSystemClassLoader();
        if (sysloader instanceof URLClassLoader) {
            try {
                Class<URLClassLoader> sysclass = URLClassLoader.class;
                Method method = sysclass.getDeclaredMethod("addURL", parameters);
                method.setAccessible(true);
                method.invoke((Object)sysloader, u);
            }
            catch (Throwable t) {
                throw new IOException("Error, could not add URL to system classloader");
            }
            logger.info("Successfully added " + u + " to class path");
        } else {
            logger.info("Did not add " + u + ", because system class loader is no URLClassLoader");
        }
    }
}

