/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.persistency;

import com.opencsv.CSVReader;
import com.opencsv.exceptions.CsvException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.evosuite.Properties;
import org.evosuite.continuous.persistency.CsvJUnitData;
import org.evosuite.continuous.project.ProjectStaticData;
import org.evosuite.shaded.org.apache.commons.io.FileUtils;
import org.evosuite.shaded.org.apache.commons.lang3.time.DateFormatUtils;
import org.evosuite.utils.ArrayUtil;
import org.evosuite.utils.FileIOUtils;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.xsd.CUT;
import org.evosuite.xsd.CUTUtil;
import org.evosuite.xsd.Coverage;
import org.evosuite.xsd.Generation;
import org.evosuite.xsd.GenerationUtil;
import org.evosuite.xsd.Project;
import org.evosuite.xsd.ProjectUtil;
import org.evosuite.xsd.TestSuite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageManager {
    private static final Logger logger = LoggerFactory.getLogger(StorageManager.class);
    private static final String TMP_PREFIX = "tmp_";
    private File tmpLogs = null;
    private File tmpReports = null;
    private File tmpTests = null;
    private File tmpPools = null;
    private File tmpSeeds = null;
    private boolean isStorageOk = this.openForWriting();
    private DecimalFormat df = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);

    public StorageManager() {
        this.df.applyPattern("#0.00");
    }

    private boolean openForWriting() {
        File testsFolder;
        File root = new File(Properties.CTG_DIR);
        if (root.exists()) {
            if (root.isDirectory()) {
                if (!root.canWrite()) {
                    logger.error("Cannot write in " + root.getAbsolutePath());
                    return false;
                }
            } else {
                boolean deleted = root.delete();
                if (!deleted) {
                    logger.error("Folder " + root + " is a file, and failed to delete it");
                    return false;
                }
                if (!root.mkdirs()) {
                    logger.error("Failed to mkdir " + root.getAbsolutePath());
                    return false;
                }
            }
        } else if (!root.mkdirs()) {
            logger.error("Failed to mkdir " + root.getAbsolutePath());
            return false;
        }
        if (!(testsFolder = StorageManager.getBestTestFolder()).exists() && !testsFolder.mkdirs()) {
            logger.error("Failed to mkdir " + testsFolder.getAbsolutePath());
            return false;
        }
        File seedFolder = StorageManager.getSeedInFolder();
        if (!seedFolder.exists() && !seedFolder.mkdirs()) {
            logger.error("Failed to mkdir " + seedFolder.getAbsolutePath());
        }
        return true;
    }

    public static File getBestTestFolder() {
        return StorageManager.getBestTestFolder(null);
    }

    public static File getBestTestFolder(File baseDir) {
        String base = "";
        if (baseDir != null) {
            base = baseDir.getAbsolutePath() + File.separator;
        }
        return new File(base + Properties.CTG_DIR + File.separator + Properties.CTG_BESTS_DIR_NAME);
    }

    public static File getSeedInFolder() {
        return new File(new File(Properties.CTG_DIR), "evosuite-" + Properties.CTG_SEEDS_DIR_NAME);
    }

    public boolean createNewTmpFolders() {
        if (!this.isStorageOk) {
            return false;
        }
        String time = DateFormatUtils.format(new Date(), "yyyy_MM_dd_HH_mm_ss", Locale.getDefault());
        File tmp = null;
        tmp = Properties.CTG_GENERATION_DIR_PREFIX == null ? new File(Properties.CTG_DIR + File.separator + TMP_PREFIX + time) : new File(Properties.CTG_DIR + File.separator + TMP_PREFIX + Properties.CTG_GENERATION_DIR_PREFIX + "_" + time);
        if (!tmp.mkdirs()) {
            return false;
        }
        this.tmpLogs = new File(tmp.getAbsolutePath() + File.separator + Properties.CTG_TMP_LOGS_DIR_NAME);
        if (!this.tmpLogs.exists() && !this.tmpLogs.mkdirs()) {
            return false;
        }
        this.tmpReports = new File(tmp.getAbsolutePath() + File.separator + Properties.CTG_TMP_REPORTS_DIR_NAME);
        if (!this.tmpReports.exists() && !this.tmpReports.mkdirs()) {
            return false;
        }
        this.tmpTests = new File(tmp.getAbsolutePath() + File.separator + Properties.CTG_TMP_TESTS_DIR_NAME);
        if (!this.tmpTests.exists() && !this.tmpTests.mkdirs()) {
            return false;
        }
        this.tmpPools = new File(tmp.getAbsolutePath() + File.separator + Properties.CTG_TMP_POOLS_DIR_NAME);
        if (!this.tmpPools.exists() && !this.tmpPools.mkdirs()) {
            return false;
        }
        this.tmpSeeds = new File(tmp.getAbsolutePath() + File.separator + Properties.CTG_SEEDS_DIR_NAME);
        return this.tmpSeeds.exists() || this.tmpSeeds.mkdirs();
    }

    public void deleteAllOldTmpFolders() {
        File root = new File(Properties.CTG_DIR);
        for (File child : root.listFiles()) {
            if (!child.isDirectory() || !child.getName().startsWith(TMP_PREFIX)) continue;
            try {
                FileUtils.deleteDirectory(child);
            }
            catch (IOException e) {
                logger.error("Failed to delete tmp folder " + child.getAbsolutePath());
            }
        }
    }

    public boolean clean() {
        try {
            FileUtils.deleteDirectory(new File(Properties.CTG_DIR));
        }
        catch (IOException e) {
            logger.error("Cannot delete folder " + Properties.CTG_DIR + ": " + e, e);
            return false;
        }
        return true;
    }

    public String mergeAndCommitChanges(ProjectStaticData current, String[] cuts) throws NullPointerException {
        if (current == null) {
            throw new NullPointerException("ProjectStaticData 'current' cannot be null");
        }
        Project db = StorageManager.getDatabaseProject();
        String info = "\n\n=== CTG run results ===\n";
        info = info + this.removeNoMoreExistentData(db, current);
        List<TestsOnDisk> suites = this.gatherGeneratedTestsOnDisk();
        info = info + "\nNew test suites: " + suites.size();
        LinkedHashSet<String> missingCUTs = new LinkedHashSet<String>();
        db.setTotalNumberOfTestableClasses(BigInteger.valueOf(current.getTotalNumberOfTestableCUTs()));
        for (String cut : current.getClassNames()) {
            if (!current.getClassInfo(cut).isTestable()) continue;
            TestsOnDisk suite = suites.parallelStream().filter(s -> s.cut.equals(cut)).findFirst().orElse(null);
            if (suite == null && current.getClassInfo(cut).isToTest()) {
                missingCUTs.add(cut);
            }
            LoggingUtils.getEvoLogger().info("* Updating database to " + cut);
            this.updateDatabase(cut, suite, db, current);
        }
        if (!missingCUTs.isEmpty()) {
            if (missingCUTs.size() == 1) {
                info = info + "\n\nWARN: failed to generate tests for " + (String)missingCUTs.iterator().next();
            } else {
                info = info + "\n\nMissing classes:";
                for (String missingCUT : missingCUTs) {
                    info = info + "\n" + missingCUT;
                }
                String summary = "\n\nWARN: failed to generate tests for " + missingCUTs.size() + " classes out of " + current.getTotalNumberOfTestableCUTs();
                info = info + summary;
            }
        }
        this.commitDatabase(db);
        return info;
    }

    public List<TestsOnDisk> gatherGeneratedTestsOnDisk() {
        LinkedList<TestsOnDisk> list = new LinkedList<TestsOnDisk>();
        List<File> generatedTests = FileIOUtils.getRecursivelyAllFilesInAllSubfolders(this.tmpTests.getAbsolutePath(), ".java");
        List<File> generatedReports = FileIOUtils.getRecursivelyAllFilesInAllSubfolders(this.tmpReports.getAbsolutePath(), ".csv");
        List<File> generatedSerialized = FileIOUtils.getRecursivelyAllFilesInAllSubfolders(this.tmpSeeds.getAbsolutePath(), Properties.CTG_SEEDS_EXT);
        LinkedHashMap<String, CsvJUnitData> reports = new LinkedHashMap<String, CsvJUnitData>();
        for (File file : generatedReports) {
            CsvJUnitData data = CsvJUnitData.openFile(file);
            if (data == null) {
                logger.warn("Cannot process " + file.getAbsolutePath());
                continue;
            }
            reports.put(data.getTargetClass(), data);
        }
        LinkedHashMap<String, File> seeds = new LinkedHashMap<String, File>();
        for (File file : generatedSerialized) {
            String cut = file.getName().substring(0, file.getName().length() - (Properties.CTG_SEEDS_EXT.length() + 1));
            seeds.put(cut, file);
        }
        for (File test : generatedTests) {
            TestsOnDisk info;
            if (test.getAbsolutePath().contains(Properties.SCAFFOLDING_SUFFIX)) continue;
            String testName = this.extractClassName(this.tmpTests, test);
            String cut = "";
            for (String className : reports.keySet()) {
                if (!testName.startsWith(className) || className.length() <= cut.length()) continue;
                cut = className;
            }
            CsvJUnitData data = (CsvJUnitData)reports.get(cut);
            if (data == null) {
                logger.warn("No CSV file for CUT " + cut + " with test suite at " + test.getAbsolutePath());
                continue;
            }
            File seed = (File)seeds.get(cut);
            if (seed == null) {
                logger.debug("No '" + Properties.CTG_SEEDS_EXT + "' file was generated for CUT " + cut);
            }
            if ((info = new TestsOnDisk(test, data, seed)).isValid()) {
                list.add(info);
                continue;
            }
            logger.warn("Invalid info for " + test.getAbsolutePath());
        }
        return list;
    }

    protected String extractClassName(File base, File target) {
        int len = base.getAbsolutePath().length();
        String path = target.getAbsolutePath();
        String name = path.substring(len + 1, path.length() - ".java".length());
        if ((name = name.replaceAll("/", ".")).contains("\\")) {
            name = name.replaceAll("\\\\", ".");
        }
        return name;
    }

    private void commitDatabase(Project db) {
        StringWriter writer = null;
        try {
            writer = new StringWriter();
            JAXBContext context = JAXBContext.newInstance(Project.class);
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", true);
            m.marshal((Object)db, writer);
        }
        catch (Exception e) {
            logger.error("Failed to create XML representation: " + e.getMessage(), e);
        }
        File current = StorageManager.getProjectInfoFile();
        current.delete();
        try {
            FileUtils.write(current, writer.toString());
        }
        catch (IOException e) {
            logger.error("Failed to write to database: " + e.getMessage(), e);
        }
    }

    private static File getProjectInfoFile() {
        return new File(Properties.CTG_DIR + File.separator + Properties.CTG_PROJECT_INFO);
    }

    private void updateDatabase(String targetClass, TestsOnDisk ondisk, Project db, ProjectStaticData current) {
        String testName = targetClass + Properties.JUNIT_SUFFIX;
        CUT cut = ProjectUtil.getCUT(db, targetClass);
        if (cut == null) {
            cut = new CUT();
            cut.setFullNameOfTargetClass(targetClass);
            cut.setFullNameOfTestSuite(testName);
            db.getCut().add(cut);
        }
        Generation generation = new Generation();
        generation.setId(BigInteger.valueOf(cut.getGeneration().size()));
        generation.setFailed(false);
        generation.setModified(current.getClassInfo(targetClass).hasChanged());
        generation.setTimeBudgetInSeconds(BigInteger.valueOf(current.getClassInfo(targetClass).getTimeBudgetInSeconds()));
        generation.setMemoryInMB(BigInteger.valueOf(current.getClassInfo(targetClass).getMemoryInMB()));
        if (!current.getClassInfo(targetClass).isToTest()) {
            cut.getGeneration().add(generation);
            return;
        }
        File std_err_CLIENT = new File(this.tmpLogs + File.separator + targetClass + File.separator + "std_err_CLIENT.log");
        assert (std_err_CLIENT.exists());
        File std_out_CLIENT = new File(this.tmpLogs + File.separator + targetClass + File.separator + "std_out_CLIENT.log");
        assert (std_out_CLIENT.exists());
        File std_err_MASTER = new File(this.tmpLogs + File.separator + targetClass + File.separator + "std_err_MASTER.log");
        assert (std_err_MASTER.exists());
        File std_out_MASTER = new File(this.tmpLogs + File.separator + targetClass + File.separator + "std_out_MASTER.log");
        assert (std_out_MASTER.exists());
        generation.setStdErrCLIENT(std_err_CLIENT.getAbsolutePath());
        generation.setStdOutCLIENT(std_out_CLIENT.getAbsolutePath());
        generation.setStdErrMASTER(std_err_MASTER.getAbsolutePath());
        generation.setStdOutMASTER(std_out_MASTER.getAbsolutePath());
        cut.getGeneration().add(generation);
        if (ondisk == null) {
            if (current.getClassInfo(targetClass).isToTest()) {
                generation.setFailed(true);
            }
            return;
        }
        assert (ondisk.isValid());
        CsvJUnitData csv = ondisk.csvData;
        if (!this.isBetterThanAnyExistingTestSuite(db, current, ondisk)) {
            return;
        }
        TestSuite suite = new TestSuite();
        suite.setFullPathOfTestSuite(ondisk.testSuite.getAbsolutePath());
        suite.setNumberOfTests(BigInteger.valueOf(csv.getNumberOfTests()));
        suite.setTotalNumberOfStatements(BigInteger.valueOf(csv.getTotalNumberOfStatements()));
        suite.setTotalEffortInSeconds(BigInteger.valueOf(csv.getDurationInSeconds()));
        ArrayList<Coverage> coverageValues = new ArrayList<Coverage>();
        for (String criterion : csv.getCoverageVariables()) {
            Coverage coverage = new Coverage();
            coverage.setCriterion(criterion);
            coverage.setCoverageValue(Double.parseDouble(this.df.format(csv.getCoverage(criterion))));
            coverage.setCoverageBitString(csv.getCoverageBitString(criterion));
            coverageValues.add(coverage);
        }
        suite.getCoverage().addAll(coverageValues);
        generation.setSuite(suite);
        this.removeBestTestSuite(testName);
        this.addBestTestSuite(ondisk.testSuite);
        File scaffolding = this.getScaffoldingIfExists(ondisk.testSuite);
        if (scaffolding != null) {
            this.addBestTestSuite(scaffolding);
        }
        if (ondisk.serializedSuite != null) {
            File target = new File(StorageManager.getSeedInFolder(), ondisk.serializedSuite.getName());
            target.delete();
            try {
                FileUtils.copyFile(ondisk.serializedSuite, target);
            }
            catch (IOException e) {
                logger.error("Failed to copy over a new generated serialized test suite: " + e.getMessage(), e);
            }
        }
    }

    private File getScaffoldingIfExists(File testSuite) throws IllegalArgumentException {
        String java = ".java";
        if (testSuite == null || !testSuite.exists() || !testSuite.getName().endsWith(java)) {
            throw new IllegalArgumentException("Invalid test suite: " + testSuite);
        }
        String name = testSuite.getName();
        String scaffoldingName = name.substring(0, name.length() - java.length());
        scaffoldingName = scaffoldingName + "_" + Properties.SCAFFOLDING_SUFFIX;
        scaffoldingName = scaffoldingName + java;
        File scaffolding = new File(testSuite.getParentFile().getAbsolutePath() + File.separator + scaffoldingName);
        if (scaffolding.exists()) {
            return scaffolding;
        }
        return null;
    }

    private void addBestTestSuite(File newlyGeneratedTestSuite) {
        String testName = this.extractClassName(this.tmpTests, newlyGeneratedTestSuite);
        String path = testName.replace(".", File.separator) + ".java";
        File file = new File(StorageManager.getBestTestFolder() + File.separator + path);
        file.delete();
        try {
            FileUtils.copyFile(newlyGeneratedTestSuite, file);
        }
        catch (IOException e) {
            logger.error("Failed to copy new generated test suite into the current best set: " + e.getMessage(), e);
        }
    }

    private boolean isBetterThanAnyExistingTestSuite(Project db, ProjectStaticData current, TestsOnDisk suite) {
        if (suite.csvData == null) {
            return false;
        }
        if (current.getClassInfo(suite.cut).hasChanged()) {
            return true;
        }
        String statistics = Properties.REPORT_DIR + File.separator + "statistics.csv";
        File statistics_file = new File(statistics);
        if (!statistics_file.exists()) {
            return this.isBetterThanPreviousGeneration(db, current, suite);
        }
        List<String[]> rows = null;
        try {
            CSVReader reader = new CSVReader(new FileReader(statistics_file));
            rows = reader.readAll();
            reader.close();
        }
        catch (CsvException | IOException e) {
            logger.error(e.getMessage());
            return true;
        }
        ArrayList<String[]> rowCUT = new ArrayList<String[]>();
        rowCUT.add(rows.get(0));
        for (Object[] objectArray : rows) {
            if (!ArrayUtil.contains(objectArray, suite.cut)) continue;
            rowCUT.add((String[])objectArray);
            break;
        }
        if (rowCUT.size() == 1) {
            return this.isBetterThanPreviousGeneration(db, current, suite);
        }
        double existingOverallCoverage = 0.0;
        double generatedOverallCoverage = 0.0;
        for (String variable : suite.csvData.getCoverageVariables()) {
            String coverageVariable = CsvJUnitData.getValue(rowCUT, variable);
            if (coverageVariable == null) continue;
            generatedOverallCoverage += suite.csvData.getCoverage(variable);
            existingOverallCoverage += Double.valueOf(coverageVariable).doubleValue();
        }
        double covDif = (generatedOverallCoverage /= (double)suite.csvData.getNumberOfCoverageValues()) - (existingOverallCoverage /= (double)suite.csvData.getNumberOfCoverageValues());
        if (covDif > 1.0E-4) {
            return true;
        }
        for (String variable : suite.csvData.getCoverageBitStringVariables()) {
            String existingCoverage = CsvJUnitData.getValue(rowCUT, variable);
            if (existingCoverage == null) continue;
            String generatedCoverage = suite.csvData.getCoverageBitString(variable);
            if (generatedCoverage.length() != existingCoverage.length()) {
                return true;
            }
            for (int i = 0; i < generatedCoverage.length(); ++i) {
                if (existingCoverage.charAt(i) != '0' || generatedCoverage.charAt(i) != '1') continue;
                return true;
            }
        }
        return false;
    }

    private boolean isBetterThanPreviousGeneration(Project db, ProjectStaticData current, TestsOnDisk suite) {
        if (suite.csvData == null) {
            return false;
        }
        if (current.getClassInfo(suite.cut).hasChanged()) {
            return true;
        }
        CUT cut = ProjectUtil.getCUT(db, suite.cut);
        Generation latestSuccessfulGeneration = CUTUtil.getLatestSuccessfulGeneration(cut);
        if (latestSuccessfulGeneration == null) {
            return true;
        }
        TestSuite previousTestSuite = latestSuccessfulGeneration.getSuite();
        File oldFile = this.getFileForTargetBestTest(cut.getFullNameOfTestSuite());
        if (!oldFile.exists()) {
            return true;
        }
        double previousOverallCoverage = GenerationUtil.getOverallCoverage(latestSuccessfulGeneration);
        double generatedOverallCoverage = 0.0;
        for (Coverage coverage : previousTestSuite.getCoverage()) {
            if (!suite.csvData.hasCoverage(coverage.getCriterion())) continue;
            generatedOverallCoverage += suite.csvData.getCoverage(coverage.getCriterion());
        }
        double covDif = (generatedOverallCoverage /= (double)suite.csvData.getNumberOfCoverageValues()) - previousOverallCoverage;
        if (covDif > 0.01) {
            return true;
        }
        for (Coverage coverage : previousTestSuite.getCoverage()) {
            if (!suite.csvData.hasCoverage(coverage.getCriterion())) continue;
            String generatedCoverage = suite.csvData.getCoverageBitString(coverage.getCriterion());
            String previousCoverage = coverage.getCoverageBitString();
            if (generatedCoverage.length() != previousCoverage.length()) {
                return true;
            }
            for (int i = 0; i < generatedCoverage.length(); ++i) {
                if (previousCoverage.charAt(i) != '0' || generatedCoverage.charAt(i) != '1') continue;
                return true;
            }
        }
        if (covDif < 0.0) {
            return false;
        }
        int oldSize = previousTestSuite.getTotalNumberOfStatements().intValue();
        int newSize = suite.csvData.getTotalNumberOfStatements();
        if (newSize != oldSize) {
            return newSize < oldSize;
        }
        int oldNumTests = previousTestSuite.getNumberOfTests().intValue();
        int newNumTests = suite.csvData.getNumberOfTests();
        return newNumTests < oldNumTests;
    }

    private String removeNoMoreExistentData(Project db, ProjectStaticData current) {
        int removed = 0;
        Iterator<CUT> iter = db.getCut().iterator();
        while (iter.hasNext()) {
            CUT cut = iter.next();
            String cutName = cut.getFullNameOfTargetClass();
            if (current.containsClass(cutName)) continue;
            iter.remove();
            this.removeBestTestSuite(cut.getFullNameOfTestSuite());
            ++removed;
        }
        return "Removed test suites: " + removed;
    }

    private void removeBestTestSuite(String testName) {
        File file = this.getFileForTargetBestTest(testName);
        if (!file.exists()) {
            logger.debug("Nothing to delete, as following file does not exist: " + file.getAbsolutePath());
        } else {
            boolean deleted = file.delete();
            if (!deleted) {
                logger.warn("Failed to delete " + file.getAbsolutePath());
            }
        }
    }

    private File getFileForTargetBestTest(String testName) {
        String path = testName.replace(".", File.separator);
        path = path + ".java";
        return new File(StorageManager.getBestTestFolder() + File.separator + path);
    }

    public static Project getDatabaseProject() {
        File current = StorageManager.getProjectInfoFile();
        InputStream stream = null;
        if (!current.exists()) {
            stream = StorageManager.getDefaultXmlStream();
            return StorageManager.getProject(current, stream);
        }
        try {
            stream = StorageManager.getCurrentXmlStream(current);
            return StorageManager.getProject(current, stream);
        }
        catch (Exception e) {
            stream = StorageManager.getDefaultXmlStream();
            return StorageManager.getProject(current, stream);
        }
    }

    private static InputStream getCurrentXmlStream(File current) {
        FileInputStream stream;
        try {
            stream = new FileInputStream(current);
        }
        catch (FileNotFoundException e) {
            assert (false);
            throw new RuntimeException("Bug in EvoSuite framework: " + e.getMessage());
        }
        return stream;
    }

    private static InputStream getDefaultXmlStream() {
        InputStream stream;
        String empty = "/xsd/ctg_project_report_empty.xml";
        try {
            stream = StorageManager.class.getResourceAsStream(empty);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read resource " + empty + " , " + e.getMessage());
        }
        return stream;
    }

    private static Project getProject(File current, InputStream stream) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance(Project.class);
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(new StreamSource(StorageManager.class.getResourceAsStream("/xsd/ctg_project_report.xsd")));
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            jaxbUnmarshaller.setSchema(schema);
            return (Project)jaxbUnmarshaller.unmarshal(stream);
        }
        catch (Exception e) {
            String msg = "Error in reading " + current.getAbsolutePath() + " , " + e;
            logger.error(msg, e);
            throw new RuntimeException(msg);
        }
    }

    public File getTmpLogs() {
        return this.tmpLogs;
    }

    public File getTmpReports() {
        return this.tmpReports;
    }

    public File getTmpTests() {
        return this.tmpTests;
    }

    public File getTmpPools() {
        return this.tmpPools;
    }

    public File getTmpSeeds() {
        return this.tmpSeeds;
    }

    public boolean isStorageOk() {
        return this.isStorageOk;
    }

    public static class TestsOnDisk {
        public final File testSuite;
        public final String cut;
        public final CsvJUnitData csvData;
        public final File serializedSuite;

        public TestsOnDisk(File testSuite, CsvJUnitData csvData, File serializedSuite) {
            this.testSuite = testSuite;
            this.csvData = csvData;
            this.cut = csvData.getTargetClass();
            this.serializedSuite = serializedSuite;
        }

        public boolean isValid() {
            return this.testSuite != null && this.testSuite.exists() && this.cut != null && !this.cut.isEmpty() && this.csvData != null && this.cut.equals(this.csvData.getTargetClass()) && (this.serializedSuite == null || this.serializedSuite.getName().endsWith(Properties.CTG_SEEDS_EXT));
        }
    }
}

