/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.contracts;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.contracts.AssertionErrorContract;
import org.evosuite.contracts.Contract;
import org.evosuite.contracts.ContractViolation;
import org.evosuite.contracts.EqualsContract;
import org.evosuite.contracts.EqualsHashcodeContract;
import org.evosuite.contracts.EqualsNullContract;
import org.evosuite.contracts.EqualsSymmetricContract;
import org.evosuite.contracts.FailingTestSet;
import org.evosuite.contracts.HashCodeReturnsNormallyContract;
import org.evosuite.contracts.JCrasherExceptionContract;
import org.evosuite.contracts.JUnitTheoryContract;
import org.evosuite.contracts.NullPointerExceptionContract;
import org.evosuite.contracts.ToStringReturnsNormallyContract;
import org.evosuite.contracts.UndeclaredExceptionContract;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.ExecutionObserver;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.utils.generic.GenericMethod;
import org.junit.experimental.theories.Theory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContractChecker
extends ExecutionObserver {
    private static final Logger logger = LoggerFactory.getLogger(ContractChecker.class);
    private final Set<Contract> contracts = new HashSet<Contract>();
    private static Set<Contract> invalid = new HashSet<Contract>();
    private static boolean active = true;

    public ContractChecker() {
        this.contracts.add(new UndeclaredExceptionContract());
        this.contracts.add(new JCrasherExceptionContract());
        this.contracts.add(new NullPointerExceptionContract());
        this.contracts.add(new AssertionErrorContract());
        this.contracts.add(new EqualsContract());
        this.contracts.add(new ToStringReturnsNormallyContract());
        this.contracts.add(new HashCodeReturnsNormallyContract());
        this.contracts.add(new EqualsHashcodeContract());
        this.contracts.add(new EqualsNullContract());
        this.contracts.add(new EqualsSymmetricContract());
        this.loadJUnitTheories();
    }

    private void loadJUnitTheories() {
        if (Properties.JUNIT_THEORIES.isEmpty()) {
            return;
        }
        for (String theoryName : Properties.JUNIT_THEORIES.split(":")) {
            try {
                Class<?> theory = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(theoryName);
                Constructor<?> constructor = theory.getConstructor(new Class[0]);
                if (!Modifier.isPublic(constructor.getModifiers())) {
                    logger.info("Theory class does not have public default constructor");
                    continue;
                }
                for (Method method : theory.getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(Theory.class)) continue;
                    logger.info("Found theory method: " + method.getName());
                    if (method.getParameterTypes().length != 1) {
                        logger.info("Wrong number of arguments!");
                        continue;
                    }
                    try {
                        GenericMethod gm = new GenericMethod(method, theory);
                        JUnitTheoryContract contract = new JUnitTheoryContract(gm);
                        this.contracts.add(contract);
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (ClassNotFoundException e) {
                logger.warn("Could not load theory " + theoryName + ": " + e);
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
            }
            catch (SecurityException e1) {
                e1.printStackTrace();
            }
        }
    }

    public static void setActive(boolean isActive) {
        active = isActive;
    }

    @Override
    public void output(int position, String output) {
    }

    public static void currentTest(TestCase test) {
        currentTest = test;
        invalid.clear();
    }

    @Override
    public void afterStatement(Statement statement, Scope scope, Throwable exception) {
        if (!active) {
            return;
        }
        if (Properties.CHECK_CONTRACTS_END && statement.getPosition() < currentTest.size() - 1) {
            return;
        }
        for (Contract contract : this.contracts) {
            if (invalid.contains(contract)) continue;
            try {
                logger.debug("Checking contract {}", (Object)contract);
                ContractViolation violation = contract.check(statement, scope, exception);
                if (violation == null) continue;
                logger.debug("Contract failed: {} {}", (Object)contract, (Object)statement.getCode());
                FailingTestSet.addFailingTest(violation);
                invalid.add(contract);
            }
            catch (Throwable t) {
                logger.debug("Caught exception during contract checking: " + t);
                for (StackTraceElement e : t.getStackTrace()) {
                    logger.info(e.toString());
                }
            }
        }
    }

    @Override
    public void beforeStatement(Statement statement, Scope scope) {
    }

    @Override
    public void clear() {
        invalid.clear();
    }

    @Override
    public void testExecutionFinished(ExecutionResult r, Scope s) {
    }
}

