/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.ambiguity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.coverage.ambiguity.AmbiguityCoverageFactory;
import org.evosuite.coverage.line.LineCoverageTestFitness;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;

public class AmbiguityCoverageSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = -2721073655092419390L;
    private final Set<Integer> goals = new LinkedHashSet<Integer>();

    public AmbiguityCoverageSuiteFitness() {
        for (LineCoverageTestFitness goal : AmbiguityCoverageFactory.getGoals()) {
            this.goals.add(goal.getLine());
        }
    }

    @Override
    public double getFitness(TestSuiteChromosome suite) {
        ArrayList<StringBuilder> transposedMatrix = new ArrayList<StringBuilder>(AmbiguityCoverageFactory.getTransposedMatrix());
        ArrayList<Set<Integer>> coveredLines = new ArrayList<Set<Integer>>();
        List<ExecutionResult> results = this.runTestSuite(suite);
        for (ExecutionResult result : results) {
            coveredLines.add(result.getTrace().getCoveredLines());
        }
        HashMap<String, Integer> groups = new HashMap<String, Integer>();
        int g_i = 0;
        for (Integer goal : this.goals) {
            StringBuffer str = null;
            if (transposedMatrix.size() > g_i) {
                str = new StringBuffer(((StringBuilder)transposedMatrix.get(g_i)).length() + coveredLines.size());
                str.append((CharSequence)transposedMatrix.get(g_i));
            } else {
                str = new StringBuffer(coveredLines.size());
            }
            for (Set set : coveredLines) {
                str.append(set.contains(goal) ? "1" : "0");
            }
            if (!groups.containsKey(str.toString())) {
                groups.put(str.toString(), 1);
            } else {
                groups.put(str.toString(), (Integer)groups.get(str.toString()) + 1);
            }
            ++g_i;
        }
        double fitness = TestFitnessFunction.normalize(AmbiguityCoverageFactory.getAmbiguity(this.goals.size(), groups));
        this.updateIndividual(suite, fitness);
        return fitness;
    }
}

