/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.branch;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.branch.BranchCoverageFactory;
import org.evosuite.coverage.branch.BranchCoverageTestFitness;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.ga.archive.Archive;
import org.evosuite.graphs.cfg.CFGMethodAdapter;
import org.evosuite.shaded.org.objectweb.asm.Type;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BranchCoverageSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = 2991632394620406243L;
    private static final Logger logger = LoggerFactory.getLogger(BranchCoverageSuiteFitness.class);
    public int totalGoals;
    public int totalMethods;
    public int totalBranches;
    private final Set<String> branchlessMethods = new LinkedHashSet<String>();
    private final Set<String> methods = new LinkedHashSet<String>();
    protected final Set<Integer> branchesId = new LinkedHashSet<Integer>();
    public int maxCoveredBranches = 0;
    public int maxCoveredMethods = 0;
    public double bestFitness = Double.MAX_VALUE;
    protected transient Map<Integer, TestFitnessFunction> branchCoverageTrueMap = new LinkedHashMap<Integer, TestFitnessFunction>();
    protected transient Map<Integer, TestFitnessFunction> branchCoverageFalseMap = new LinkedHashMap<Integer, TestFitnessFunction>();
    private transient Map<String, TestFitnessFunction> branchlessMethodCoverageMap = new LinkedHashMap<String, TestFitnessFunction>();
    private final Set<Integer> toRemoveBranchesT = new LinkedHashSet<Integer>();
    private final Set<Integer> toRemoveBranchesF = new LinkedHashSet<Integer>();
    private final Set<String> toRemoveRootBranches = new LinkedHashSet<String>();
    private final Set<Integer> removedBranchesT = new LinkedHashSet<Integer>();
    private final Set<Integer> removedBranchesF = new LinkedHashSet<Integer>();
    private final Set<String> removedRootBranches = new LinkedHashSet<String>();

    public BranchCoverageSuiteFitness() {
        this(TestGenerationContext.getInstance().getClassLoaderForSUT());
    }

    public BranchCoverageSuiteFitness(ClassLoader classLoader) {
        String prefix = Properties.TARGET_CLASS_PREFIX;
        if (prefix.isEmpty()) {
            prefix = Properties.TARGET_CLASS;
        }
        this.totalMethods = CFGMethodAdapter.getNumMethodsPrefix(classLoader, prefix);
        this.totalBranches = BranchPool.getInstance(classLoader).getBranchCountForPrefix(prefix);
        this.branchlessMethods.addAll(BranchPool.getInstance(classLoader).getBranchlessMethodsPrefix(prefix));
        this.methods.addAll(CFGMethodAdapter.getMethodsPrefix(classLoader, prefix));
        this.determineCoverageGoals(true);
        this.totalGoals = this.branchCoverageTrueMap.size() + this.branchCoverageFalseMap.size() + this.branchlessMethodCoverageMap.size();
        logger.info("Total branch coverage goals: " + this.totalGoals);
        logger.info("Total branches: " + this.totalBranches);
        logger.info("Total branchless methods: " + this.branchlessMethodCoverageMap.size());
        logger.info("Total methods: " + this.totalMethods + ": " + this.methods);
    }

    protected void determineCoverageGoals(boolean updateArchive) {
        List<BranchCoverageTestFitness> goals = new BranchCoverageFactory().getCoverageGoals();
        for (BranchCoverageTestFitness goal : goals) {
            if (goal.getBranch() != null && goal.getBranch().isInstrumented()) continue;
            if (updateArchive && Properties.TEST_ARCHIVE) {
                Archive.getArchiveInstance().addTarget(goal);
            }
            if (goal.getBranch() == null) {
                this.branchlessMethodCoverageMap.put(goal.getClassName() + "." + goal.getMethod(), goal);
                continue;
            }
            this.branchesId.add(goal.getBranch().getActualBranchId());
            if (goal.getBranchExpressionValue()) {
                this.branchCoverageTrueMap.put(goal.getBranch().getActualBranchId(), goal);
                continue;
            }
            this.branchCoverageFalseMap.put(goal.getBranch().getActualBranchId(), goal);
        }
    }

    private void handleConstructorExceptions(TestChromosome test, ExecutionResult result, Map<String, Integer> callCount) {
        if (result.hasTimeout() || result.hasTestException() || result.noThrownExceptions()) {
            return;
        }
        Integer exceptionPosition = result.getFirstPositionOfThrownException();
        if (exceptionPosition >= result.test.size()) {
            return;
        }
        Statement statement = null;
        if (result.test.hasStatement(exceptionPosition)) {
            statement = result.test.getStatement(exceptionPosition);
        }
        if (statement instanceof ConstructorStatement) {
            ConstructorStatement c = (ConstructorStatement)statement;
            String className = c.getConstructor().getName();
            String methodName = "<init>" + Type.getConstructorDescriptor(c.getConstructor().getConstructor());
            String name = className + "." + methodName;
            if (!callCount.containsKey(name)) {
                callCount.put(name, 1);
                if (this.branchlessMethodCoverageMap.containsKey(name)) {
                    TestFitnessFunction goal = this.branchlessMethodCoverageMap.get(name);
                    test.getTestCase().addCoveredGoal(goal);
                    this.toRemoveRootBranches.add(name);
                    if (Properties.TEST_ARCHIVE) {
                        Archive.getArchiveInstance().updateArchive(goal, test, 0.0);
                    }
                }
            }
        }
    }

    protected void handleBranchlessMethods(TestChromosome test, ExecutionResult result, Map<String, Integer> callCount) {
        for (Map.Entry<String, Integer> entry : result.getTrace().getMethodExecutionCount().entrySet()) {
            if (entry.getKey() == null || !this.methods.contains(entry.getKey()) || this.removedRootBranches.contains(entry.getKey())) continue;
            if (!callCount.containsKey(entry.getKey())) {
                callCount.put(entry.getKey(), entry.getValue());
            } else {
                callCount.put(entry.getKey(), callCount.get(entry.getKey()) + entry.getValue());
            }
            if (!this.branchlessMethodCoverageMap.containsKey(entry.getKey())) continue;
            TestFitnessFunction goal = this.branchlessMethodCoverageMap.get(entry.getKey());
            test.getTestCase().addCoveredGoal(goal);
            this.toRemoveRootBranches.add(entry.getKey());
            if (!Properties.TEST_ARCHIVE) continue;
            Archive.getArchiveInstance().updateArchive(goal, test, 0.0);
        }
    }

    protected void handlePredicateCount(ExecutionResult result, Map<Integer, Integer> predicateCount) {
        for (Map.Entry<Integer, Integer> entry : result.getTrace().getPredicateExecutionCount().entrySet()) {
            if (!this.branchesId.contains(entry.getKey()) || this.removedBranchesT.contains(entry.getKey()) && this.removedBranchesF.contains(entry.getKey())) continue;
            if (!predicateCount.containsKey(entry.getKey())) {
                predicateCount.put(entry.getKey(), entry.getValue());
                continue;
            }
            predicateCount.put(entry.getKey(), predicateCount.get(entry.getKey()) + entry.getValue());
        }
    }

    protected void handleTrueDistances(TestChromosome test, ExecutionResult result, Map<Integer, Double> trueDistance) {
        for (Map.Entry<Integer, Double> entry : result.getTrace().getTrueDistances().entrySet()) {
            if (!this.branchesId.contains(entry.getKey()) || this.removedBranchesT.contains(entry.getKey())) continue;
            if (!trueDistance.containsKey(entry.getKey())) {
                trueDistance.put(entry.getKey(), entry.getValue());
            } else {
                trueDistance.put(entry.getKey(), Math.min(trueDistance.get(entry.getKey()), entry.getValue()));
            }
            BranchCoverageTestFitness goal = (BranchCoverageTestFitness)this.branchCoverageTrueMap.get(entry.getKey());
            assert (goal != null);
            if (Double.compare(entry.getValue(), 0.0) == 0) {
                test.getTestCase().addCoveredGoal(goal);
                this.toRemoveBranchesT.add(entry.getKey());
            }
            if (!Properties.TEST_ARCHIVE) continue;
            Archive.getArchiveInstance().updateArchive(goal, test, entry.getValue());
        }
    }

    protected void handleFalseDistances(TestChromosome test, ExecutionResult result, Map<Integer, Double> falseDistance) {
        for (Map.Entry<Integer, Double> entry : result.getTrace().getFalseDistances().entrySet()) {
            if (!this.branchesId.contains(entry.getKey()) || !this.branchCoverageFalseMap.containsKey(entry.getKey()) || this.removedBranchesF.contains(entry.getKey())) continue;
            if (!falseDistance.containsKey(entry.getKey())) {
                falseDistance.put(entry.getKey(), entry.getValue());
            } else {
                falseDistance.put(entry.getKey(), Math.min(falseDistance.get(entry.getKey()), entry.getValue()));
            }
            BranchCoverageTestFitness goal = (BranchCoverageTestFitness)this.branchCoverageFalseMap.get(entry.getKey());
            assert (goal != null);
            if (Double.compare(entry.getValue(), 0.0) == 0) {
                test.getTestCase().addCoveredGoal(goal);
                this.toRemoveBranchesF.add(entry.getKey());
            }
            if (!Properties.TEST_ARCHIVE) continue;
            Archive.getArchiveInstance().updateArchive(goal, test, entry.getValue());
        }
    }

    private boolean analyzeTraces(TestSuiteChromosome suite, List<ExecutionResult> results, Map<Integer, Integer> predicateCount, Map<String, Integer> callCount, Map<Integer, Double> trueDistance, Map<Integer, Double> falseDistance) {
        boolean hasTimeoutOrTestException = false;
        for (ExecutionResult result : results) {
            if (result.hasTimeout() || result.hasTestException()) {
                hasTimeoutOrTestException = true;
                continue;
            }
            TestChromosome test = new TestChromosome();
            test.setTestCase(result.test);
            test.setLastExecutionResult(result);
            test.setChanged(false);
            this.handleBranchlessMethods(test, result, callCount);
            this.handlePredicateCount(result, predicateCount);
            this.handleTrueDistances(test, result, trueDistance);
            this.handleFalseDistances(test, result, falseDistance);
            this.handleConstructorExceptions(test, result, callCount);
        }
        return hasTimeoutOrTestException;
    }

    @Override
    public boolean updateCoveredGoals() {
        if (!Properties.TEST_ARCHIVE) {
            return false;
        }
        for (String method : this.toRemoveRootBranches) {
            boolean removed = this.branchlessMethods.remove(method);
            TestFitnessFunction f = this.branchlessMethodCoverageMap.remove(method);
            if (removed && f != null) {
                --this.totalMethods;
                this.methods.remove(method);
                this.removedRootBranches.add(method);
                continue;
            }
            throw new IllegalStateException("goal to remove not found");
        }
        for (Integer branch : this.toRemoveBranchesT) {
            TestFitnessFunction f = this.branchCoverageTrueMap.remove(branch);
            if (f != null) {
                this.removedBranchesT.add(branch);
                if (!this.removedBranchesF.contains(branch)) continue;
                --this.totalBranches;
                continue;
            }
            throw new IllegalStateException("goal to remove not found");
        }
        for (Integer branch : this.toRemoveBranchesF) {
            TestFitnessFunction f = this.branchCoverageFalseMap.remove(branch);
            if (f != null) {
                this.removedBranchesF.add(branch);
                if (!this.removedBranchesT.contains(branch)) continue;
                --this.totalBranches;
                continue;
            }
            throw new IllegalStateException("goal to remove not found");
        }
        this.toRemoveRootBranches.clear();
        this.toRemoveBranchesF.clear();
        this.toRemoveBranchesT.clear();
        logger.info("Current state of archive: " + Archive.getArchiveInstance().toString());
        return true;
    }

    @Override
    public double getFitness(TestSuiteChromosome suite) {
        logger.trace("Calculating branch fitness");
        double fitness = 0.0;
        List<ExecutionResult> results = this.runTestSuite(suite);
        LinkedHashMap<Integer, Double> trueDistance = new LinkedHashMap<Integer, Double>();
        LinkedHashMap<Integer, Double> falseDistance = new LinkedHashMap<Integer, Double>();
        LinkedHashMap<Integer, Integer> predicateCount = new LinkedHashMap<Integer, Integer>();
        LinkedHashMap<String, Integer> callCount = new LinkedHashMap<String, Integer>();
        boolean hasTimeoutOrTestException = this.analyzeTraces(suite, results, predicateCount, callCount, trueDistance, falseDistance);
        int numCoveredBranches = 0;
        for (Object key : predicateCount.keySet()) {
            double df = 0.0;
            double dt = 0.0;
            int numExecuted = (Integer)predicateCount.get(key);
            if (this.removedBranchesT.contains(key)) {
                ++numExecuted;
            }
            if (this.removedBranchesF.contains(key)) {
                ++numExecuted;
            }
            if (trueDistance.containsKey(key)) {
                dt = (Double)trueDistance.get(key);
            }
            if (falseDistance.containsKey(key)) {
                df = (Double)falseDistance.get(key);
            }
            fitness = numExecuted == 1 ? (fitness += 1.0) : (fitness += BranchCoverageSuiteFitness.normalize(df) + BranchCoverageSuiteFitness.normalize(dt));
            if (falseDistance.containsKey(key) && Double.compare(df, 0.0) == 0) {
                ++numCoveredBranches;
            }
            if (!trueDistance.containsKey(key) || Double.compare(dt, 0.0) != 0) continue;
            ++numCoveredBranches;
        }
        fitness += (double)(2 * (this.totalBranches - predicateCount.size()));
        int missingMethods = 0;
        for (String e : this.methods) {
            if (callCount.containsKey(e)) continue;
            fitness += 1.0;
            ++missingMethods;
        }
        this.printStatusMessages(suite, numCoveredBranches, this.totalMethods - missingMethods, fitness);
        int coverage = numCoveredBranches;
        for (String e : this.branchlessMethodCoverageMap.keySet()) {
            if (!callCount.containsKey(e)) continue;
            ++coverage;
        }
        coverage += this.removedBranchesF.size();
        coverage += this.removedBranchesT.size();
        coverage += this.removedRootBranches.size();
        if (this.totalGoals > 0) {
            suite.setCoverage(this, (double)coverage / (double)this.totalGoals);
        } else {
            suite.setCoverage(this, 1.0);
        }
        suite.setNumOfCoveredGoals(this, coverage);
        suite.setNumOfNotCoveredGoals(this, this.totalGoals - coverage);
        if (hasTimeoutOrTestException) {
            logger.info("Test suite has timed out, setting fitness to max value " + (this.totalBranches * 2 + this.totalMethods));
            fitness = this.totalBranches * 2 + this.totalMethods;
        }
        this.updateIndividual(suite, fitness);
        assert (coverage <= this.totalGoals) : "Covered " + coverage + " vs total goals " + this.totalGoals;
        assert (fitness >= 0.0);
        assert (fitness != 0.0 || coverage == this.totalGoals) : "Fitness: " + fitness + ", coverage: " + coverage + "/" + this.totalGoals;
        assert (suite.getCoverage(this) <= 1.0 && suite.getCoverage(this) >= 0.0) : "Wrong coverage value " + suite.getCoverage(this);
        return fitness;
    }

    public int getMaxValue() {
        return this.totalBranches * 2 + this.totalMethods;
    }

    private void printStatusMessages(TestSuiteChromosome suite, int coveredBranches, int coveredMethods, double fitness) {
        if (coveredBranches > this.maxCoveredBranches) {
            this.maxCoveredBranches = coveredBranches;
            logger.info("(Branches) Best individual covers " + coveredBranches + "/" + this.totalBranches * 2 + " branches and " + coveredMethods + "/" + this.totalMethods + " methods");
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
        if (coveredMethods > this.maxCoveredMethods) {
            logger.info("(Methods) Best individual covers " + coveredBranches + "/" + this.totalBranches * 2 + " branches and " + coveredMethods + "/" + this.totalMethods + " methods");
            this.maxCoveredMethods = coveredMethods;
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
        if (fitness < this.bestFitness) {
            logger.info("(Fitness) Best individual covers " + coveredBranches + "/" + this.totalBranches * 2 + " branches and " + coveredMethods + "/" + this.totalMethods + " methods");
            this.bestFitness = fitness;
            logger.info("Fitness: " + fitness + ", size: " + suite.size() + ", length: " + suite.totalLengthOfTestCases());
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.branchCoverageTrueMap = new LinkedHashMap<Integer, TestFitnessFunction>();
        this.branchCoverageFalseMap = new LinkedHashMap<Integer, TestFitnessFunction>();
        this.branchlessMethodCoverageMap = new LinkedHashMap<String, TestFitnessFunction>();
        this.determineCoverageGoals(false);
    }
}

