/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.cbranch;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.evosuite.coverage.branch.BranchCoverageFactory;
import org.evosuite.coverage.branch.BranchCoverageTestFitness;
import org.evosuite.coverage.cbranch.CBranchTestFitness;
import org.evosuite.setup.CallContext;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.setup.callgraph.CallGraph;
import org.evosuite.testsuite.AbstractFitnessFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CBranchFitnessFactory
extends AbstractFitnessFactory<CBranchTestFitness> {
    private static final Logger logger = LoggerFactory.getLogger(CBranchFitnessFactory.class);

    @Override
    public List<CBranchTestFitness> getCoverageGoals() {
        HashSet<CBranchTestFitness> goals = new HashSet<CBranchTestFitness>();
        BranchCoverageFactory branchFactory = new BranchCoverageFactory();
        List<BranchCoverageTestFitness> branchGoals = branchFactory.getCoverageGoals();
        CallGraph callGraph = DependencyAnalysis.getCallGraph();
        for (BranchCoverageTestFitness branchGoal : branchGoals) {
            logger.info("Adding context branches for " + branchGoal.toString());
            for (CallContext context : callGraph.getMethodEntryPoint(branchGoal.getClassName(), branchGoal.getMethod())) {
                goals.add(new CBranchTestFitness(branchGoal.getBranchGoal(), context));
            }
        }
        logger.info("Created " + goals.size() + " goals");
        return new ArrayList<CBranchTestFitness>(goals);
    }
}

