/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.cbranch;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.cbranch.CBranchFitnessFactory;
import org.evosuite.coverage.cbranch.CBranchTestFitness;
import org.evosuite.ga.archive.Archive;
import org.evosuite.setup.CallContext;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;

public class CBranchSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = -4745892521350308986L;
    private final List<CBranchTestFitness> branchGoals;
    private final Map<Integer, Map<CallContext, Set<CBranchTestFitness>>> contextGoalsMap;
    private final Map<Integer, Set<CBranchTestFitness>> privateMethodsGoalsMap;
    private final Map<String, Map<CallContext, CBranchTestFitness>> methodsMap;
    private final Map<String, CBranchTestFitness> privateMethodsMethodsMap;
    private final Set<CBranchTestFitness> toRemoveGoals = new LinkedHashSet<CBranchTestFitness>();
    private final Set<CBranchTestFitness> removedGoals = new LinkedHashSet<CBranchTestFitness>();

    public CBranchSuiteFitness() {
        this.contextGoalsMap = new LinkedHashMap<Integer, Map<CallContext, Set<CBranchTestFitness>>>();
        this.privateMethodsGoalsMap = new LinkedHashMap<Integer, Set<CBranchTestFitness>>();
        this.methodsMap = new LinkedHashMap<String, Map<CallContext, CBranchTestFitness>>();
        this.privateMethodsMethodsMap = new LinkedHashMap<String, CBranchTestFitness>();
        CBranchFitnessFactory factory = new CBranchFitnessFactory();
        this.branchGoals = factory.getCoverageGoals();
        for (CBranchTestFitness goal : this.branchGoals) {
            Map<CallContext, Object> innermap;
            if (Properties.TEST_ARCHIVE) {
                Archive.getArchiveInstance().addTarget(goal);
            }
            if (goal.getBranchGoal() != null && goal.getBranchGoal().getBranch() != null) {
                int branchId = goal.getBranchGoal().getBranch().getActualBranchId();
                if (goal.getContext().isEmpty()) {
                    Set<CBranchTestFitness> tempInSet = this.privateMethodsGoalsMap.get(branchId);
                    if (tempInSet == null) {
                        tempInSet = new LinkedHashSet<CBranchTestFitness>();
                        this.privateMethodsGoalsMap.put(branchId, tempInSet);
                    }
                    tempInSet.add(goal);
                } else {
                    Set<CBranchTestFitness> tempInSet;
                    innermap = this.contextGoalsMap.get(branchId);
                    if (innermap == null) {
                        innermap = new LinkedHashMap();
                        this.contextGoalsMap.put(branchId, innermap);
                    }
                    if ((tempInSet = innermap.get(goal.getContext())) == null) {
                        tempInSet = new LinkedHashSet<CBranchTestFitness>();
                        innermap.put(goal.getContext(), tempInSet);
                    }
                    tempInSet.add(goal);
                }
            } else {
                String methodName = goal.getTargetClass() + "." + goal.getTargetMethod();
                if (goal.getContext().isEmpty()) {
                    this.privateMethodsMethodsMap.put(methodName, goal);
                } else {
                    innermap = this.methodsMap.get(methodName);
                    if (innermap == null) {
                        innermap = new LinkedHashMap();
                        this.methodsMap.put(methodName, innermap);
                    }
                    innermap.put(goal.getContext(), (Set<CBranchTestFitness>)((Object)goal));
                }
            }
            logger.info("Context goal: " + goal.toString());
        }
    }

    private CBranchTestFitness getContextGoal(String classAndMethodName, CallContext context) {
        if (this.privateMethodsMethodsMap.containsKey(classAndMethodName)) {
            return this.privateMethodsMethodsMap.get(classAndMethodName);
        }
        if (this.methodsMap.get(classAndMethodName) == null || this.methodsMap.get(classAndMethodName).get(context) == null) {
            return null;
        }
        return this.methodsMap.get(classAndMethodName).get(context);
    }

    private CBranchTestFitness getContextGoal(Integer branchId, CallContext context, boolean value) {
        if (this.privateMethodsGoalsMap.containsKey(branchId)) {
            for (CBranchTestFitness cBranchTestFitness : this.privateMethodsGoalsMap.get(branchId)) {
                if (cBranchTestFitness.getValue() != value) continue;
                return cBranchTestFitness;
            }
        } else {
            if (this.contextGoalsMap.get(branchId) == null || this.contextGoalsMap.get(branchId).get(context) == null) {
                return null;
            }
            for (CBranchTestFitness cBranchTestFitness : this.contextGoalsMap.get(branchId).get(context)) {
                if (cBranchTestFitness.getValue() != value) continue;
                return cBranchTestFitness;
            }
        }
        return null;
    }

    @Override
    public double getFitness(TestSuiteChromosome suite) {
        double fitness = 0.0;
        List<ExecutionResult> results = this.runTestSuite(suite);
        LinkedHashMap<CBranchTestFitness, Double> distanceMap = new LinkedHashMap<CBranchTestFitness, Double>();
        LinkedHashMap<Integer, Integer> callCounter = new LinkedHashMap<Integer, Integer>();
        LinkedHashMap<Integer, Integer> branchCounter = new LinkedHashMap<Integer, Integer>();
        for (ExecutionResult result : results) {
            CBranchTestFitness goalF;
            if (result.hasTimeout() || result.hasTestException()) continue;
            assert (result.getTrace().getTrueDistancesContext().keySet().size() == result.getTrace().getFalseDistancesContext().keySet().size());
            TestChromosome test = new TestChromosome();
            test.setTestCase(result.test);
            test.setLastExecutionResult(result);
            test.setChanged(false);
            for (Integer n : result.getTrace().getTrueDistancesContext().keySet()) {
                Map<CallContext, Double> trueMap = result.getTrace().getTrueDistancesContext().get(n);
                Map<CallContext, Double> falseMap = result.getTrace().getFalseDistancesContext().get(n);
                for (CallContext context : trueMap.keySet()) {
                    CBranchTestFitness goalT = this.getContextGoal(n, context, true);
                    if (goalT == null) continue;
                    double distanceT = CBranchSuiteFitness.normalize(trueMap.get(context));
                    if (distanceMap.get(goalT) == null || (Double)distanceMap.get(goalT) > distanceT) {
                        distanceMap.put(goalT, distanceT);
                    }
                    if (Double.compare(distanceT, 0.0) == 0) {
                        if (this.removedGoals.contains(goalT)) continue;
                        test.getTestCase().addCoveredGoal(goalT);
                        this.toRemoveGoals.add(goalT);
                    }
                    if (!Properties.TEST_ARCHIVE) continue;
                    Archive.getArchiveInstance().updateArchive(goalT, test, distanceT);
                }
                for (CallContext context : falseMap.keySet()) {
                    goalF = this.getContextGoal(n, context, false);
                    if (goalF == null) continue;
                    double distanceF = CBranchSuiteFitness.normalize(falseMap.get(context));
                    if (distanceMap.get(goalF) == null || (Double)distanceMap.get(goalF) > distanceF) {
                        distanceMap.put(goalF, distanceF);
                    }
                    if (Double.compare(distanceF, 0.0) == 0) {
                        if (this.removedGoals.contains(goalF)) continue;
                        test.getTestCase().addCoveredGoal(goalF);
                        this.toRemoveGoals.add(goalF);
                    }
                    if (!Properties.TEST_ARCHIVE) continue;
                    Archive.getArchiveInstance().updateArchive(goalF, test, distanceF);
                }
            }
            for (Map.Entry entry : result.getTrace().getPredicateContextExecutionCount().entrySet()) {
                for (Map.Entry value : ((Map)entry.getValue()).entrySet()) {
                    int count = (Integer)value.getValue();
                    CBranchTestFitness goalT = this.getContextGoal((Integer)entry.getKey(), (CallContext)value.getKey(), true);
                    if (goalT != null) {
                        if (branchCounter.get(goalT.getGenericContextBranchIdentifier()) != null && (Integer)branchCounter.get(goalT.getGenericContextBranchIdentifier()) >= count) continue;
                        branchCounter.put(goalT.getGenericContextBranchIdentifier(), count);
                        continue;
                    }
                    goalF = this.getContextGoal((Integer)entry.getKey(), (CallContext)value.getKey(), false);
                    if (goalF == null || branchCounter.get(goalF.getGenericContextBranchIdentifier()) != null && (Integer)branchCounter.get(goalF.getGenericContextBranchIdentifier()) >= count) continue;
                    branchCounter.put(goalF.getGenericContextBranchIdentifier(), count);
                }
            }
            for (Map.Entry entry : result.getTrace().getMethodContextCount().entrySet()) {
                for (Map.Entry value : ((Map)entry.getValue()).entrySet()) {
                    CBranchTestFitness goal = this.getContextGoal((String)entry.getKey(), (CallContext)value.getKey());
                    if (goal == null) continue;
                    int count = (Integer)value.getValue();
                    if (callCounter.get(goal.hashCode()) == null || (Integer)callCounter.get(goal.hashCode()) < count) {
                        callCounter.put(goal.hashCode(), count);
                    }
                    if (count > 0) {
                        if (this.removedGoals.contains(goal)) continue;
                        test.getTestCase().addCoveredGoal(goal);
                        this.toRemoveGoals.add(goal);
                    }
                    if (!Properties.TEST_ARCHIVE) continue;
                    Archive.getArchiveInstance().updateArchive(goal, test, count == 0 ? 1.0 : 0.0);
                }
            }
        }
        int numCoveredGoals = this.removedGoals.size();
        for (CBranchTestFitness goal : this.branchGoals) {
            if (this.removedGoals.contains(goal)) continue;
            Double distance = (Double)distanceMap.get(goal);
            if (distance == null) {
                distance = 1.0;
            }
            if (goal.getBranch() == null) {
                Integer n = (Integer)callCounter.get(goal.hashCode());
                if (n == null || n == 0) {
                    fitness += 1.0;
                    continue;
                }
                ++numCoveredGoals;
                continue;
            }
            Integer n = (Integer)branchCounter.get(goal.getGenericContextBranchIdentifier());
            if (n == null || n == 0) {
                fitness += 1.0;
                continue;
            }
            if (n == 1) {
                fitness += 0.5;
                continue;
            }
            if (Double.compare(distance, 0.0) == 0) {
                ++numCoveredGoals;
            }
            fitness += distance.doubleValue();
        }
        if (!this.branchGoals.isEmpty()) {
            suite.setCoverage(this, (double)numCoveredGoals / (double)this.branchGoals.size());
        } else {
            suite.setCoverage(this, 1.0);
        }
        suite.setNumOfCoveredGoals(this, numCoveredGoals);
        suite.setNumOfNotCoveredGoals(this, this.branchGoals.size() - numCoveredGoals);
        this.updateIndividual(suite, fitness);
        return fitness;
    }

    @Override
    public boolean updateCoveredGoals() {
        if (!Properties.TEST_ARCHIVE) {
            return false;
        }
        this.removedGoals.addAll(this.toRemoveGoals);
        this.toRemoveGoals.clear();
        logger.info("Current state of archive: " + Archive.getArchiveInstance().toString());
        return true;
    }
}

