/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.dataflow;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.dataflow.DefUse;
import org.evosuite.coverage.dataflow.DefUseCoverageTestFitness;
import org.evosuite.coverage.dataflow.DefUseExecutionTraceAnalyzer;
import org.evosuite.coverage.dataflow.DefUsePool;
import org.evosuite.coverage.dataflow.Definition;
import org.evosuite.coverage.dataflow.UnexpectedFitnessException;
import org.evosuite.coverage.dataflow.Use;
import org.evosuite.ga.Chromosome;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.ExecutionTrace;
import org.evosuite.utils.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefUseFitnessCalculator {
    public static long alternativeTime = 0L;
    private static final boolean DEBUG = Properties.DEFUSE_DEBUG_MODE;
    private static final Logger logger = LoggerFactory.getLogger(DefUseFitnessCalculator.class);
    private final DefUseCoverageTestFitness goal;
    private final TestChromosome individual;
    private final ExecutionResult result;
    private final Definition goalDefinition;
    private final Use goalUse;
    private final TestFitnessFunction goalDefinitionFitness;
    private final TestFitnessFunction goalUseFitness;
    private final String defVariable;
    private final String useVariable;

    public DefUseFitnessCalculator(DefUseCoverageTestFitness goal, TestChromosome individual, ExecutionResult result) {
        this.goal = goal;
        this.individual = individual;
        this.result = result;
        this.goalDefinition = goal.getGoalDefinition();
        this.goalUse = goal.getGoalUse();
        this.goalDefinitionFitness = goal.getGoalDefinitionFitness();
        this.goalUseFitness = goal.getGoalUseFitness();
        this.defVariable = this.goalDefinition == null ? this.goalUse.getVariableName() : this.goalDefinition.getVariableName();
        this.useVariable = this.goalUse.getVariableName();
    }

    public double calculateDUFitness() {
        if (DefUseFitnessCalculator.isSpecialDefinition(this.goalDefinition)) {
            return this.calculateUseFitnessForCompleteTrace();
        }
        double defFitness = this.calculateDefFitnessForCompleteTrace();
        if (defFitness != 0.0) {
            return 1.0 + defFitness;
        }
        return this.calculateFitnessForObjects();
    }

    public double calculateFitnessForObjects() {
        Set<Integer> objects = DefUseFitnessCalculator.determineConsiderableObjects(this.goal, this.result.getTrace());
        double fitness = 1.0;
        for (Integer object : objects) {
            logger.debug("current object: " + object);
            if (!DefUseFitnessCalculator.hasEntriesForId(this.result.getTrace().getPassedDefinitions(this.defVariable), object, this.goalDefinition.getDefId())) continue;
            double newFitness = this.calculateFitnessForObject(object);
            if (newFitness < fitness) {
                fitness = newFitness;
            }
            if (fitness != 0.0) continue;
            return 0.0;
        }
        return fitness;
    }

    private double calculateFitnessForObject(Integer objectId) {
        ExecutionTrace objectTrace = this.result.getTrace().getTraceForObject(objectId);
        double fitness = 1.0;
        if (DefUseFitnessCalculator.isSpecialDefinition(this.goalDefinition)) {
            double useFitness = this.callTestFitnessFunctionForTrace(objectTrace, this.goalUseFitness);
            fitness = DefUseFitnessCalculator.normalize(useFitness);
            if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.DEFUSE) && fitness == 0.0) {
                this.goal.setCovered(this.individual, objectTrace, objectId);
            }
            return fitness;
        }
        List<Integer> usePositions = DefUseExecutionTraceAnalyzer.getUsePositions(this.goalUse, objectTrace, objectId);
        List<Integer> goalDefinitionPositions = DefUseExecutionTraceAnalyzer.getDefinitionPositions(this.goalDefinition, objectTrace, objectId);
        if (!this.defVariable.equals(this.useVariable)) {
            logger.debug("Checking an aliasing case: " + this.goalDefinition + "\n" + this.goalUse);
        }
        for (Integer usePos : usePositions) {
            int activeDefId = DefUseExecutionTraceAnalyzer.getActiveDefinitionIdAt(this.defVariable, objectTrace, usePos, objectId);
            logger.debug("Activedef at position " + usePos + " is: " + DefUsePool.getDefinitionByDefId(activeDefId));
            if (activeDefId != this.goalDefinition.getDefId()) continue;
            if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.DEFUSE)) {
                this.goal.setCovered(this.individual, objectTrace, objectId);
            }
            if (!this.defVariable.equals(this.useVariable)) {
                Object definedObject = DefUseExecutionTraceAnalyzer.getActiveObjectAtDefinition(this.result.getTrace(), this.defVariable, objectId, usePos);
                Object usedObject = DefUseExecutionTraceAnalyzer.getActiveObjectAtUse(this.result.getTrace(), this.useVariable, objectId, usePos);
                logger.info(definedObject + ", " + usedObject);
                if (definedObject == usedObject) {
                    logger.debug("That's the target def we're looking for, and objects are equal!");
                    return 0.0;
                }
                logger.debug("That's the target def we're looking for, but objects are not equal!");
                continue;
            }
            return 0.0;
        }
        if (!this.goalUse.isRootBranchDependent()) {
            for (Integer goalDefinitionPos : goalDefinitionPositions) {
                double useFitness;
                try {
                    useFitness = this.calculateUseFitnessForDefinitionPos(objectTrace, objectId, goalDefinitionPos);
                }
                catch (UnexpectedFitnessException e) {
                    continue;
                }
                double newFitness = DefUseFitnessCalculator.normalize(useFitness);
                if (!(newFitness < fitness)) continue;
                fitness = newFitness;
            }
        }
        return fitness;
    }

    private double calculateDefFitnessForCompleteTrace() {
        if (DefUseFitnessCalculator.isSpecialDefinition(this.goalDefinition)) {
            return 0.0;
        }
        if (DefUseFitnessCalculator.hasEntriesForId(this.result.getTrace().getPassedDefinitions(this.goalDefinition.getVariableName()), this.goalDefinition.getDefId())) {
            return 0.0;
        }
        double fitness = this.goalDefinitionFitness.getFitness(this.individual, this.result);
        if (fitness == 0.0) {
            return 1.0;
        }
        return DefUseFitnessCalculator.normalize(fitness);
    }

    private double calculateUseFitnessForCompleteTrace() {
        if (DefUseFitnessCalculator.hasEntriesForId(this.result.getTrace().getPassedUses(this.goalUse.getVariableName()), this.goalUse.getUseId())) {
            return 0.0;
        }
        double fitness = this.goalUseFitness.getFitness(this.individual, this.result);
        if (fitness == 0.0) {
            return 1.0;
        }
        return DefUseFitnessCalculator.normalize(fitness);
    }

    private double calculateUseFitnessForDefinitionPos(ExecutionTrace targetTrace, Integer objectId, int goalDefinitionPos) throws UnexpectedFitnessException {
        int previousDefId = DefUseExecutionTraceAnalyzer.getPreviousDefinitionId(this.goalDefinition.getVariableName(), targetTrace, goalDefinitionPos, objectId);
        if (previousDefId == this.goalDefinition.getDefId()) {
            return 1.0;
        }
        int overwritingDefPos = DefUseExecutionTraceAnalyzer.getNextOverwritingDefinitionPosition(this.goalDefinition, targetTrace, goalDefinitionPos, objectId);
        try {
            return this.calculateFitnessForDURange(targetTrace, objectId, this.goalUseFitness, this.goalUse, true, goalDefinitionPos, overwritingDefPos, true);
        }
        catch (UnexpectedFitnessException e) {
            return 1.0;
        }
    }

    private double calculateFitnessForDURange(ExecutionTrace targetTrace, Integer objectId, TestFitnessFunction targetFitness, DefUse targetDU, boolean wantToCoverTargetDU, int duCounterStart, int duCounterEnd, boolean expectNotToBeZero) throws UnexpectedFitnessException {
        ExecutionTrace cutTrace = targetTrace.getTraceInDUCounterRange(targetDU, wantToCoverTargetDU, duCounterStart, duCounterEnd);
        double fitness = this.callTestFitnessFunctionForTrace(cutTrace, targetFitness);
        if (expectNotToBeZero && fitness == 0.0) {
            throw new UnexpectedFitnessException();
        }
        return fitness;
    }

    private double callTestFitnessFunctionForTrace(ExecutionTrace targetTrace, TestFitnessFunction targetFitness) {
        ExecutionTrace originalTrace = this.result.getTrace();
        this.result.setTrace(targetTrace);
        double fitness = targetFitness.getFitness(this.individual, this.result);
        this.result.setTrace(originalTrace);
        return fitness;
    }

    private static boolean isSpecialDefinition(Definition definition) {
        if (definition == null || definition.isStaticDefUse() && definition.getMethodName().startsWith("<clinit>")) {
            if (definition == null) {
                logger.debug("Assume Parameter-Definition to be covered if the Parameter-Use is covered");
            } else {
                logger.debug("Assume definition from <clinit> to always be covered");
            }
            return true;
        }
        return false;
    }

    private static Set<Integer> determineConsiderableObjects(DefUseCoverageTestFitness goal, ExecutionTrace trace) {
        String goalVariable = goal.getGoalVariable();
        Definition goalDefinition = goal.getGoalDefinition();
        HashSet<Integer> objectPool = new HashSet<Integer>();
        if (trace.getPassedUses(goalVariable) == null) {
            return objectPool;
        }
        if (trace.getPassedDefinitions(goalVariable) != null) {
            objectPool.addAll(trace.getPassedDefinitions(goalVariable).keySet());
        }
        if (goalDefinition == null || goalDefinition.isStaticDefUse()) {
            objectPool.addAll(trace.getPassedUses(goalVariable).keySet());
            if (DEBUG) {
                logger.debug("Static-goalVariable! Using all known Objects");
            }
        } else {
            int oldSize = objectPool.size();
            objectPool.retainAll(trace.getPassedUses(goalVariable).keySet());
            if (DEBUG) {
                logger.debug("NON-Static-goalVariable " + goalVariable);
                logger.debug("#unused objects: " + (oldSize - objectPool.size()));
                HashSet<Integer> discardedObjects = new HashSet<Integer>(trace.getPassedDefinitions(goalVariable).keySet());
                discardedObjects.removeAll(trace.getPassedUses(goalVariable).keySet());
                for (Integer id : discardedObjects) {
                    logger.debug("  discarded object " + id);
                }
            }
        }
        if (DEBUG) {
            logger.debug("#considered objects: " + objectPool.size());
            for (Integer id : objectPool) {
                logger.debug("  object " + id);
            }
        }
        return objectPool;
    }

    public static double normalize(double value) {
        return value / (1.0 + value);
    }

    public static boolean hasEntryLowerThan(List<Integer> list, Integer border) {
        for (Integer pos : list) {
            if (pos >= border) continue;
            return true;
        }
        return false;
    }

    public static boolean hasEntryInBetween(List<Integer> list, Integer start, Integer end) {
        for (Integer pos : list) {
            if (start >= pos || pos >= end) continue;
            return true;
        }
        return false;
    }

    public static Integer getMaxEntryLowerThan(List<Integer> list, Integer border) {
        int lastPos = -1;
        for (Integer defPos : list) {
            if (defPos >= border || defPos <= lastPos) continue;
            lastPos = defPos;
        }
        return lastPos;
    }

    public static boolean hasEntriesForId(Map<Integer, HashMap<Integer, Integer>> objectDUMap, int targetId) {
        if (objectDUMap == null) {
            return false;
        }
        for (Integer objectId : objectDUMap.keySet()) {
            if (!DefUseFitnessCalculator.hasEntriesForId(objectDUMap, objectId, targetId)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasEntriesForId(Map<Integer, HashMap<Integer, Integer>> objectDUMap, Integer objectId, int targetId) {
        if (objectDUMap == null) {
            return false;
        }
        if (objectDUMap.get(objectId) == null) {
            return false;
        }
        for (Integer defId : objectDUMap.get(objectId).values()) {
            if (defId != targetId) continue;
            return true;
        }
        return false;
    }

    public static boolean traceCoversGoal(DefUseCoverageTestFitness goal, Chromosome<?> individual, ExecutionTrace trace) {
        String goalVariable = goal.getGoalVariable();
        Use goalUse = goal.getGoalUse();
        Definition goalDefinition = goal.getGoalDefinition();
        if (trace.getPassedUses(goalVariable) == null) {
            return false;
        }
        Set<Integer> objectPool = DefUseFitnessCalculator.determineConsiderableObjects(goal, trace);
        for (Integer objectID : objectPool) {
            List<Integer> usePositions = DefUseExecutionTraceAnalyzer.getUsePositions(goalUse, trace, objectID);
            if (usePositions.size() == 0) continue;
            if (DefUseFitnessCalculator.isSpecialDefinition(goalDefinition)) {
                return true;
            }
            for (Integer usePos : usePositions) {
                if (DefUseExecutionTraceAnalyzer.getActiveDefinitionIdAt(goalVariable, trace, usePos, objectID) != goalDefinition.getDefId()) continue;
                return true;
            }
        }
        return false;
    }
}

