/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.dataflow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.coverage.dataflow.DefUse;
import org.evosuite.coverage.dataflow.DefUseCoverageFactory;
import org.evosuite.coverage.dataflow.DefUseFactory;
import org.evosuite.coverage.dataflow.Definition;
import org.evosuite.coverage.dataflow.Use;
import org.evosuite.graphs.cfg.BytecodeInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefUsePool {
    private static final Logger logger = LoggerFactory.getLogger(DefUsePool.class);
    private static Map<String, Map<String, Map<String, List<Definition>>>> defMap = new HashMap<String, Map<String, Map<String, List<Definition>>>>();
    private static Map<String, Map<String, Map<String, List<Use>>>> useMap = new HashMap<String, Map<String, Map<String, List<Use>>>>();
    private static Map<Integer, DefUse> defuseIdsToDefUses = new HashMap<Integer, DefUse>();
    private static Map<Integer, Definition> defuseIdsToDefs = new HashMap<Integer, Definition>();
    private static Map<Integer, Use> defuseIdsToUses = new HashMap<Integer, Use>();
    private static Map<BytecodeInstruction, Integer> registeredDUs = new HashMap<BytecodeInstruction, Integer>();
    private static Map<BytecodeInstruction, Integer> registeredDefs = new HashMap<BytecodeInstruction, Integer>();
    private static Map<BytecodeInstruction, Integer> registeredUses = new HashMap<BytecodeInstruction, Integer>();
    private static List<BytecodeInstruction> knownParameterUses = new ArrayList<BytecodeInstruction>();
    private static List<BytecodeInstruction> knownFieldMethodCalls = new ArrayList<BytecodeInstruction>();
    private static int defCounter = 0;
    private static int useCounter = 0;
    private static int duCounter = 0;

    public static boolean addAsDefinition(BytecodeInstruction d) {
        if (!d.isDefinition() && !d.isMethodCallOfField()) {
            logger.error("expect instruction of a definition");
            return false;
        }
        if (DefUsePool.isKnownAsDefinition(d)) {
            logger.error("each definition can be added at most once");
            return false;
        }
        if (!d.canBeInstrumented()) {
            return false;
        }
        boolean registeredAsDU = DefUsePool.registerAsDefUse(d);
        if (!(registeredAsDU || d.isIINC() || d.isMethodCallOfField())) {
            throw new IllegalStateException("expect registering to fail only on IINCs and field method calls");
        }
        DefUsePool.registerAsDefinition(d);
        return true;
    }

    public static boolean addAsUse(BytecodeInstruction u) {
        if (!u.isUse() && !u.isMethodCallOfField()) {
            return false;
        }
        if (DefUsePool.isKnownAsUse(u)) {
            return false;
        }
        if (!u.canBeInstrumented()) {
            return false;
        }
        boolean registeredAsDU = DefUsePool.registerAsDefUse(u);
        if (!registeredAsDU && !u.isMethodCallOfField()) {
            throw new IllegalStateException("expect registering to fail only on field method calls");
        }
        DefUsePool.registerAsUse(u);
        return true;
    }

    public static boolean addAsFieldMethodCall(BytecodeInstruction f) {
        if (!f.isMethodCallOfField()) {
            return false;
        }
        if (!f.canBeInstrumented()) {
            return false;
        }
        DefUsePool.registerAsDefUse(f);
        DefUsePool.registerAsFieldMethodCall(f);
        return true;
    }

    private static boolean registerAsDefUse(BytecodeInstruction d) {
        if (registeredDUs.containsKey(d)) {
            return false;
        }
        registeredDUs.put(d, ++duCounter);
        return true;
    }

    private static boolean registerAsDefinition(BytecodeInstruction d) {
        if (!registeredDUs.containsKey(d)) {
            throw new IllegalStateException("expect registerAsDefUse() to be called before registerAsDefinition()/Use()");
        }
        if (registeredDefs.containsKey(d)) {
            return false;
        }
        registeredDefs.put(d, ++defCounter);
        Definition def = DefUseFactory.makeDefinition(d);
        DefUsePool.fillDefinitionMaps(def);
        return true;
    }

    private static boolean registerAsUse(BytecodeInstruction d) {
        if (!registeredDUs.containsKey(d)) {
            throw new IllegalStateException("expect registerAsDefUse() to be called before registerAsDefinition()/Use()");
        }
        if (registeredUses.containsKey(d)) {
            return false;
        }
        registeredUses.put(d, ++useCounter);
        if (d.isLocalVariableUse() && !DefUsePool.knowsDefinitionForVariableOf(d)) {
            DefUsePool.registerParameterUse(d);
        }
        Use use = DefUseFactory.makeUse(d);
        DefUsePool.fillUseMaps(use);
        return true;
    }

    private static void registerParameterUse(BytecodeInstruction d) {
        if (!knownParameterUses.contains(d)) {
            knownParameterUses.add(d);
        }
    }

    private static void registerAsFieldMethodCall(BytecodeInstruction f) {
        if (!knownFieldMethodCalls.contains(f)) {
            knownFieldMethodCalls.add(f);
        }
    }

    private static void fillDefinitionMaps(Definition def) {
        DefUsePool.addToDefMap(def);
        defuseIdsToDefUses.put(def.getDefUseId(), def);
        defuseIdsToDefs.put(def.getDefUseId(), def);
        logger.debug("Added to DefUsePool as def: " + def.toString());
    }

    private static void fillUseMaps(Use use) {
        DefUsePool.addToUseMap(use);
        defuseIdsToDefUses.put(use.getDefUseId(), use);
        defuseIdsToUses.put(use.getDefUseId(), use);
        logger.debug("Added to DefUsePool as use: " + use.toString());
    }

    private static boolean addToDefMap(Definition d) {
        String className = d.getClassName();
        String methodName = d.getMethodName();
        String varName = d.getVariableName();
        DefUsePool.initMap(defMap, className, methodName, varName);
        return defMap.get(className).get(methodName).get(varName).add(d);
    }

    private static boolean addToUseMap(Use u) {
        String className = u.getClassName();
        String methodName = u.getMethodName();
        String varName = u.getVariableName();
        DefUsePool.initMap(useMap, className, methodName, varName);
        return useMap.get(className).get(methodName).get(varName).add(u);
    }

    private static <T> void initMap(Map<String, Map<String, Map<String, List<T>>>> map, String className, String methodName, String varName) {
        if (!map.containsKey(className)) {
            map.put(className, new HashMap());
        }
        if (!map.get(className).containsKey(methodName)) {
            map.get(className).put(methodName, new HashMap());
        }
        if (!map.get(className).get(methodName).containsKey(varName)) {
            map.get(className).get(methodName).put(varName, new ArrayList());
        }
    }

    public static boolean knowsDefinitionForVariableOf(BytecodeInstruction du) {
        if (!du.isDefUse()) {
            throw new IllegalArgumentException("defuse expected");
        }
        String className = du.getClassName();
        String methodName = du.getMethodName();
        String varName = du.getVariableName();
        try {
            return defMap.get(className).get(methodName).get(varName).size() > 0;
        }
        catch (NullPointerException nex) {
            return false;
        }
    }

    public static boolean isKnown(BytecodeInstruction instruction) {
        return DefUsePool.isKnownAsDefinition(instruction) || DefUsePool.isKnownAsUse(instruction);
    }

    public static boolean isKnownAsDefinition(BytecodeInstruction instruction) {
        return registeredDefs.containsKey(instruction);
    }

    public static boolean isKnownAsDefinition(int defuseId) {
        return defuseIdsToDefs.containsKey(defuseId);
    }

    public static boolean isKnownAsUse(int defuseId) {
        return defuseIdsToUses.containsKey(defuseId);
    }

    public static boolean isKnownAsUse(BytecodeInstruction instruction) {
        return registeredUses.containsKey(instruction);
    }

    public static boolean isKnownAsFieldMethodCall(BytecodeInstruction instruction) {
        return knownFieldMethodCalls.contains(instruction);
    }

    public static boolean isKnownAsParameterUse(BytecodeInstruction instruction) {
        return knownParameterUses.contains(instruction);
    }

    public static Set<Definition> retrieveRegisteredDefinitions() {
        HashSet<Definition> r = new HashSet<Definition>();
        for (Integer defId : registeredDefs.values()) {
            r.add(DefUsePool.getDefinitionByDefId(defId));
        }
        return r;
    }

    public static Set<Use> retrieveRegisteredUses() {
        HashSet<Use> r = new HashSet<Use>();
        for (Integer useId : registeredUses.values()) {
            r.add(DefUsePool.getUseByUseId(useId));
        }
        return r;
    }

    public static Set<BytecodeInstruction> retrieveFieldMethodCalls() {
        return new HashSet<BytecodeInstruction>(knownFieldMethodCalls);
    }

    public static Set<Use> retrieveRegisteredParameterUses() {
        HashSet<Use> r = new HashSet<Use>();
        for (BytecodeInstruction instruction : knownParameterUses) {
            r.add(DefUsePool.getUseByUseId(registeredUses.get(instruction)));
        }
        return r;
    }

    public static Definition getDefinitionByInstruction(BytecodeInstruction def) {
        if (!DefUsePool.isKnownAsDefinition(def)) {
            return null;
        }
        return DefUsePool.getDefinitionByDefId(DefUsePool.getRegisteredDefId(def));
    }

    public static Use getUseByInstruction(BytecodeInstruction use) {
        if (!DefUsePool.isKnownAsUse(use)) {
            return null;
        }
        return DefUsePool.getUseByUseId(DefUsePool.getRegisteredUseId(use));
    }

    public static Use getUseByDefUseId(int duId) {
        DefUse du = defuseIdsToUses.get(duId);
        if (du == null) {
            return null;
        }
        return (Use)du;
    }

    public static Definition getDefinitionByDefUseId(int duId) {
        DefUse du = defuseIdsToDefs.get(duId);
        if (du == null) {
            return null;
        }
        return (Definition)du;
    }

    public static Use getUseByUseId(int useId) {
        for (Use use : defuseIdsToUses.values()) {
            if (use.getUseId() != useId) continue;
            return use;
        }
        return null;
    }

    public static Definition getDefinitionByDefId(int defId) {
        for (Definition def : defuseIdsToDefs.values()) {
            if (def.getDefId() != defId) continue;
            return def;
        }
        return null;
    }

    public static int getRegisteredDefUseId(BytecodeInstruction instruction) {
        if (registeredDUs.containsKey(instruction)) {
            return registeredDUs.get(instruction);
        }
        return -1;
    }

    public static int getRegisteredDefId(BytecodeInstruction instruction) {
        if (registeredDefs.containsKey(instruction)) {
            return registeredDefs.get(instruction);
        }
        return -1;
    }

    public static int getRegisteredUseId(BytecodeInstruction instruction) {
        if (registeredUses.containsKey(instruction)) {
            return registeredUses.get(instruction);
        }
        return -1;
    }

    public static int getDefCounter() {
        return defCounter;
    }

    public static int getUseCounter() {
        return useCounter;
    }

    public static int getDefUseCounter() {
        return duCounter;
    }

    public static int getDefUseCounterForDef(Definition def) {
        int count = 0;
        if (def == null) {
            return 1;
        }
        for (Definition d : defuseIdsToDefs.values()) {
            if (d.getDefId() != def.getDefId()) continue;
            ++count;
        }
        return count;
    }

    public static void clear() {
        defMap.clear();
        useMap.clear();
        defuseIdsToDefUses.clear();
        defuseIdsToDefs.clear();
        defuseIdsToUses.clear();
        registeredDUs.clear();
        registeredDefs.clear();
        registeredUses.clear();
        knownParameterUses.clear();
        knownFieldMethodCalls.clear();
        defCounter = 0;
        useCounter = 0;
        duCounter = 0;
        DefUseCoverageFactory.clear();
    }
}

