/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.exception;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.coverage.MethodNameMatcher;
import org.evosuite.coverage.exception.ExceptionCoverageFactory;
import org.evosuite.coverage.exception.ExceptionCoverageHelper;
import org.evosuite.coverage.exception.ExceptionCoverageTestFitness;
import org.evosuite.ga.archive.Archive;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionCoverageSuiteFitness
extends TestSuiteFitnessFunction {
    private static final long serialVersionUID = 1565793073526627496L;
    private static final Logger logger = LoggerFactory.getLogger(ExceptionCoverageSuiteFitness.class);
    private static int maxExceptionsCovered = 0;

    public static int getMaxExceptionsCovered() {
        return maxExceptionsCovered;
    }

    @Override
    public double getFitness(TestSuiteChromosome suite) {
        logger.trace("Calculating exception fitness");
        HashMap implicitTypesOfExceptions = new HashMap();
        HashMap explicitTypesOfExceptions = new HashMap();
        HashMap declaredTypesOfExceptions = new HashMap();
        List<ExecutionResult> results = this.runTestSuite(suite);
        ExceptionCoverageSuiteFitness.calculateExceptionInfo(results, implicitTypesOfExceptions, explicitTypesOfExceptions, declaredTypesOfExceptions, this);
        if (Properties.TEST_ARCHIVE) {
            suite.setFitness(this, 0.0);
            suite.setCoverage(this, 1.0);
            maxExceptionsCovered = ExceptionCoverageFactory.getGoals().size();
            return 0.0;
        }
        int nExc = ExceptionCoverageSuiteFitness.getNumExceptions(implicitTypesOfExceptions) + ExceptionCoverageSuiteFitness.getNumExceptions(explicitTypesOfExceptions) + ExceptionCoverageSuiteFitness.getNumExceptions(declaredTypesOfExceptions);
        if (nExc > maxExceptionsCovered) {
            logger.info("(Exceptions) Best individual covers " + nExc + " exceptions");
            maxExceptionsCovered = nExc;
        }
        double exceptionFitness = 1.0 / (1.0 + (double)nExc);
        suite.setFitness(this, exceptionFitness);
        if (maxExceptionsCovered > 0) {
            suite.setCoverage(this, nExc / maxExceptionsCovered);
        } else {
            suite.setCoverage(this, 1.0);
        }
        return exceptionFitness;
    }

    public static void calculateExceptionInfo(List<ExecutionResult> results, Map<String, Set<Class<?>>> implicitTypesOfExceptions, Map<String, Set<Class<?>>> explicitTypesOfExceptions, Map<String, Set<Class<?>>> declaredTypesOfExceptions, ExceptionCoverageSuiteFitness contextFitness) throws IllegalArgumentException {
        MethodNameMatcher matcher = new MethodNameMatcher();
        if (!(results != null && implicitTypesOfExceptions != null && explicitTypesOfExceptions != null && implicitTypesOfExceptions.isEmpty() && explicitTypesOfExceptions.isEmpty() && declaredTypesOfExceptions != null && declaredTypesOfExceptions.isEmpty())) {
            throw new IllegalArgumentException();
        }
        for (ExecutionResult result : results) {
            if (result.hasTimeout() || result.hasTestException() || result.noThrownExceptions() || result.calledReflection()) continue;
            TestChromosome test = new TestChromosome();
            test.setTestCase(result.test);
            test.setLastExecutionResult(result);
            test.setChanged(false);
            for (Integer i : result.getPositionsWhereExceptionsWereThrown()) {
                boolean notDeclared;
                if (ExceptionCoverageHelper.shouldSkip(result, i)) continue;
                Class<?> exceptionClass = ExceptionCoverageHelper.getExceptionClass(result, i);
                String methodIdentifier = ExceptionCoverageHelper.getMethodIdentifier(result, i);
                if (!matcher.methodMatches(methodIdentifier)) {
                    logger.info("Method {} does not match criteria. ", (Object)methodIdentifier);
                    continue;
                }
                boolean sutException = ExceptionCoverageHelper.isSutException(result, i);
                if (!sutException) continue;
                boolean bl = notDeclared = !ExceptionCoverageHelper.isDeclared(result, i);
                if (notDeclared) {
                    boolean isExplicit = ExceptionCoverageHelper.isExplicit(result, i);
                    if (isExplicit) {
                        if (!explicitTypesOfExceptions.containsKey(methodIdentifier)) {
                            explicitTypesOfExceptions.put(methodIdentifier, new HashSet());
                        }
                        explicitTypesOfExceptions.get(methodIdentifier).add(exceptionClass);
                    } else {
                        if (!implicitTypesOfExceptions.containsKey(methodIdentifier)) {
                            implicitTypesOfExceptions.put(methodIdentifier, new HashSet());
                        }
                        implicitTypesOfExceptions.get(methodIdentifier).add(exceptionClass);
                    }
                } else {
                    if (!declaredTypesOfExceptions.containsKey(methodIdentifier)) {
                        declaredTypesOfExceptions.put(methodIdentifier, new HashSet());
                    }
                    declaredTypesOfExceptions.get(methodIdentifier).add(exceptionClass);
                }
                ExceptionCoverageTestFitness.ExceptionType type = ExceptionCoverageHelper.getType(result, i);
                ExceptionCoverageTestFitness goal = new ExceptionCoverageTestFitness(Properties.TARGET_CLASS, methodIdentifier, exceptionClass, type);
                String key = goal.getKey();
                if (ExceptionCoverageFactory.getGoals().containsKey(key)) continue;
                ExceptionCoverageFactory.getGoals().put(key, goal);
                test.getTestCase().addCoveredGoal(goal);
                if (!Properties.TEST_ARCHIVE || contextFitness == null) continue;
                Archive.getArchiveInstance().addTarget(goal);
                Archive.getArchiveInstance().updateArchive(goal, test, 0.0);
            }
        }
    }

    public static int getNumExceptions(Map<String, Set<Class<?>>> exceptions) {
        int total = 0;
        for (Set<Class<?>> exceptionSet : exceptions.values()) {
            total += exceptionSet.size();
        }
        return total;
    }

    public static int getNumClassExceptions(Map<String, Set<Class<?>>> exceptions) {
        HashSet classExceptions = new HashSet();
        for (Set<Class<?>> exceptionSet : exceptions.values()) {
            classExceptions.addAll(exceptionSet);
        }
        return classExceptions.size();
    }
}

