/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.exception;

import java.util.Objects;
import org.evosuite.Properties;
import org.evosuite.coverage.exception.ExceptionCoverageHelper;
import org.evosuite.ga.archive.Archive;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.utils.generic.GenericClass;

public class ExceptionCoverageTestFitness
extends TestFitnessFunction {
    private static final long serialVersionUID = 1221020001417476348L;
    protected final String className;
    protected final String methodIdentifier;
    protected final GenericClass exceptionClass;
    protected final ExceptionType type;

    public ExceptionCoverageTestFitness(String className, String methodIdentifier, Class<?> exceptionClass, ExceptionType type) {
        this.className = className;
        Objects.requireNonNull(exceptionClass, "exception class cannot be null");
        this.exceptionClass = new GenericClass(exceptionClass);
        this.methodIdentifier = Objects.requireNonNull(methodIdentifier, "method name cannot be null");
        this.type = Objects.requireNonNull(type, "exception type cannot be null");
    }

    public String getKey() {
        return this.methodIdentifier + "_" + this.exceptionClass.getClassName() + "_" + (Object)((Object)this.type);
    }

    public String getMethod() {
        return this.methodIdentifier;
    }

    public Class<?> getExceptionClass() {
        return this.exceptionClass.getRawClass();
    }

    @Override
    public double getFitness(TestChromosome individual, ExecutionResult result) {
        double fitness = 1.0;
        if (result.calledReflection()) {
            return fitness;
        }
        for (Integer i : result.getPositionsWhereExceptionsWereThrown()) {
            if (ExceptionCoverageHelper.shouldSkip(result, i)) continue;
            Class<?> exceptionClass = ExceptionCoverageHelper.getExceptionClass(result, i);
            String methodIdentifier = ExceptionCoverageHelper.getMethodIdentifier(result, i);
            boolean sutException = ExceptionCoverageHelper.isSutException(result, i);
            if (!sutException) continue;
            ExceptionType type = ExceptionCoverageHelper.getType(result, i);
            if (!this.methodIdentifier.equals(methodIdentifier) || !this.exceptionClass.getRawClass().equals(exceptionClass) || !this.type.equals((Object)type)) continue;
            fitness = 0.0;
            break;
        }
        if (fitness == 0.0) {
            individual.getTestCase().addCoveredGoal(this);
        }
        if (Properties.TEST_ARCHIVE) {
            Archive.getArchiveInstance().addTarget(this);
            Archive.getArchiveInstance().updateArchive(this, individual, fitness);
        }
        return fitness;
    }

    public String toString() {
        return this.getKey();
    }

    @Override
    public int hashCode() {
        int iConst = 17;
        return 53 * iConst + this.methodIdentifier.hashCode() * iConst + this.exceptionClass.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExceptionCoverageTestFitness other = (ExceptionCoverageTestFitness)obj;
        if (!this.methodIdentifier.equals(other.methodIdentifier)) {
            return false;
        }
        if (!this.exceptionClass.equals(other.exceptionClass)) {
            return false;
        }
        return this.type.equals((Object)other.type);
    }

    @Override
    public int compareTo(TestFitnessFunction other) {
        if (other instanceof ExceptionCoverageTestFitness) {
            ExceptionCoverageTestFitness otherMethodFitness = (ExceptionCoverageTestFitness)other;
            if (this.methodIdentifier.equals(otherMethodFitness.getMethod())) {
                if (this.exceptionClass.equals(((ExceptionCoverageTestFitness)other).exceptionClass)) {
                    return this.type.compareTo(((ExceptionCoverageTestFitness)other).type);
                }
                return this.exceptionClass.getClassName().compareTo(otherMethodFitness.exceptionClass.getClassName());
            }
            return this.methodIdentifier.compareTo(otherMethodFitness.getMethod());
        }
        return this.compareClassName(other);
    }

    @Override
    public String getTargetClass() {
        return this.className;
    }

    @Override
    public String getTargetMethod() {
        return this.methodIdentifier;
    }

    public static enum ExceptionType {
        EXPLICIT,
        IMPLICIT,
        DECLARED;

    }
}

