/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.coverage.exception;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.MethodNameMatcher;
import org.evosuite.coverage.branch.Branch;
import org.evosuite.coverage.branch.BranchCoverageGoal;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.coverage.exception.TryCatchCoverageTestFitness;
import org.evosuite.testsuite.AbstractFitnessFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TryCatchCoverageFactory
extends AbstractFitnessFactory<TryCatchCoverageTestFitness> {
    private static final Logger logger = LoggerFactory.getLogger(TryCatchCoverageFactory.class);

    @Override
    public List<TryCatchCoverageTestFitness> getCoverageGoals() {
        ArrayList<TryCatchCoverageTestFitness> goals = new ArrayList<TryCatchCoverageTestFitness>();
        for (String className : BranchPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).knownClasses()) {
            MethodNameMatcher matcher = new MethodNameMatcher();
            for (String methodName : BranchPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).knownMethods(className)) {
                if (!matcher.methodMatches(methodName)) {
                    logger.info("Method " + methodName + " does not match criteria. ");
                    continue;
                }
                for (Branch b : BranchPool.getInstance(TestGenerationContext.getInstance().getClassLoaderForSUT()).retrieveBranchesInMethod(className, methodName)) {
                    if (!b.isInstrumented()) continue;
                    goals.add(new TryCatchCoverageTestFitness(new BranchCoverageGoal(b, true, b.getClassName(), b.getMethodName())));
                    if (b.ignoreFalseBranch()) continue;
                    goals.add(new TryCatchCoverageTestFitness(new BranchCoverageGoal(b, false, b.getClassName(), b.getMethodName())));
                }
            }
        }
        return goals;
    }
}

